/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	cuseeme.c (CU-SeeMe proxy reflector)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	950527	created
//////////////////////////////////////////////////////////////////////#*/
#include "delegate.h"
extern char *_inet_ntoaV4I();

typedef unsigned long U_long;
typedef unsigned short U_short;
typedef unsigned char U_char;

#define kGroup			htonS(0)
#define kClient			htonS(1)
#define kReflector		htonS(2)

#define kControlType		htonS(100)
#define kConfigVideoType	htonS(101)
#define kPacketLossReport	htonS(102)
#define kAckType		htonS(103)
#define kOpenConnection		htonS(1)
#define kCloseConnection	htonS(6)

#define WANT_VERSION		0x20

#define INC_NL(v,i)	(v = htonL(ntohL(v)+i))

typedef struct addr {
	short	family;
	U_short	port;
	U_long	addr;
} Addr;
typedef struct Routing {
	Addr	dest;
	Addr	src;
} Routing;
typedef struct VideoPacketHeader {
	Routing	routing;
	U_long	seqNum;
	short	message;
	short	dataType;
	short	len;
} VideoPacketHeader;
typedef struct OpenContinuePacket {
	VideoPacketHeader	header;
	short	clientCount;
	U_long	seqNum;
	char	name[20];
	U_char	sendMode;
	U_char	recvMode;
	U_char	flags;
	U_char	version;
} OpenContinuePacket;

/*
 *	Reflector/DeleGate
 */
#define NUM_ROUTER	128
#define NUM_CLIENT	256
#define	CLIENT_TIMEOUT	10

typedef struct {
	Addr	addr;
	int	routerx;
	char	Rhost[17];
	int	Rport;
	int	clientID;
	int	confID;
	int	failed;
	int	lasttime;
	int	disable;
} Client;

typedef struct {
	char	ce_Serverhost[17];
	int	ce_Serverport;
	Client *ce__clients;
	Client *ce__routers;
	int	ce_Clientx;
	int	ce_ClientID;
	int	ce_Routerx;
	FILE   *ce_Save;
	OpenContinuePacket ce_Vctl;
	int	ce_SVsock;
	int	ce_openedReflector;
} CUSeeMeEnv;
static CUSeeMeEnv *cUSeeMeEnv;
#define Serverhost	cUSeeMeEnv->ce_Serverhost
#define Serverport	cUSeeMeEnv->ce_Serverport
#define _clients	cUSeeMeEnv->ce__clients
#define _routers	cUSeeMeEnv->ce__routers
#define Clientx		cUSeeMeEnv->ce_Clientx
#define ClientID	cUSeeMeEnv->ce_ClientID
#define Routerx		cUSeeMeEnv->ce_Routerx
#define Save		cUSeeMeEnv->ce_Save
#define Vctl		cUSeeMeEnv->ce_Vctl
#define SVsock		cUSeeMeEnv->ce_SVsock
#define openedReflector	cUSeeMeEnv->ce_openedReflector
minit_cuseeme()
{
	if( cUSeeMeEnv == 0 )
		cUSeeMeEnv = NewStruct(CUSeeMeEnv);
}

static Client *routerp(rx)
{
	if( _routers == NULL )
		_routers = (Client*)calloc(NUM_ROUTER,sizeof(Client));
	return &_routers[rx];
}
static Client *clientp(cx)
{
	if( _clients == NULL )
		_clients = (Client*)calloc(NUM_CLIENT,sizeof(Client));
	return &_routers[cx];
}

static getRouter(host,port)
	char *host;
{	int ri;
	Client *rp;

	for( ri = 1; ri <= Routerx; ri++ ){
		rp = routerp(ri);
		if( strcmp(rp->Rhost,host) == 0 && rp->Rport == port )
			return ri;
	}
	rp = routerp(++Routerx);
	sv1log("added route[%d] %s:%d\n",ri,host,port);
	strcpy(rp->Rhost,host);
	rp->Rport = port;
	return Routerx;
}
static addClient(curtime,host,port,caddr)
	char *host;
	Addr *caddr;
{	int ci;
	Client *ca;
	int routerx;

	routerx = getRouter(host,port);
	for( ci = 1; ci <= Clientx; ci++ ){
		ca = clientp(ci);
		if( ca->addr.addr==caddr->addr && ca->addr.port==caddr->port ){
			if( routerx != ca->routerx )
				sv1log("moved client#%d [%d/%d]%x:%d via [%d]%s:%d\n",
					ca->clientID,ci,Clientx,
					caddr->addr,ntohS(caddr->port),
					routerx,host,port);
			if( ca->disable )
				sv1log("enabled client#%d [%d/%d]\n",
					ca->clientID,ci,Clientx);

			ca->routerx = routerx;
			ca->failed = 0;
			ca->lasttime = curtime;
			ca->disable = 0;
			return;
		}
	}
	ca = clientp(++Clientx);
	ca->clientID = ++ClientID;

	ca->addr = *caddr;
	ca->routerx = routerx;
	ca->failed = 0;
	ca->lasttime = curtime;
	ca->disable = 0;

	sv1log("added client#%d [%d/%d]%s:%d via [%d]%s:%d\n",
		ca->clientID,ci,Clientx,
		_inet_ntoaV4I(caddr->addr),ntohS(caddr->port),routerx,host,port);
}
static delClient(why,ci)
	char *why;
{	Client *ca;
	int cj;

	ca = clientp(ci);
	sv1log("removed client#%d [%d/%d]: %x (%s)\n",
		ca->clientID,ci,Clientx,ca->addr.addr,why);
	for( cj = ci; cj <= Clientx; cj++ )
		*clientp(cj) = *clientp(cj+1);
	Clientx--;
}
static isClient(caddr)
	Addr *caddr;
{	int ci;
	Client *ca;

	for( ci = 1; ci <= Clientx; ci++ ){
		ca = clientp(ci);
		if( caddr->addr==ca->addr.addr && caddr->port==ca->addr.port )
			return ci;
	}
	return 0;
}
static activeClients()
{	int ci,nact;
	nact = 0;
	for( ci = 1; ci <= Clientx; ci++ )
		if( !clientp(ci)->disable )
			nact++;
	return nact;
}
static closeClient(caddr)
	Addr *caddr;
{	int ci;

	if( ci = isClient(caddr) )
		clientp(ci)->disable = 1;
}

static toClients(curtime,svsock,vp,len)
	VideoPacketHeader *vp;
{	int ci;
	int wcc;
	Client *ca;
	int timeout;
	Client *rp;

	timeout = curtime - CLIENT_TIMEOUT;

	if( Save != NULL )
		fwrite(vp,len,1,Save);

	for( ci = 1; ci <= Clientx; ci++ ){
		ca = clientp(ci);
		rp = routerp(ca->routerx);

		if( !ca->disable ){
			wcc = SendTo(svsock,vp,len,rp->Rhost,rp->Rport);
			if( wcc <= 0 ){
				if( 10 < ca->failed++ ){
					delClient("CANTSEND",ci);
					ci--;
				}
			}
		}
		if( ca->lasttime < timeout ){
			delClient("TIMEOUT",ci);
			ci--;
		}
	}
}
static dumpPacket(vp)
	VideoPacketHeader *vp;
{	char dhost[32],shost[32];

	strcpy(dhost,_inet_ntoaV4I(vp->routing.dest.addr)),
	strcpy(shost,_inet_ntoaV4I(vp->routing.src.addr)),
fprintf(stderr,
	"PACKET dst=[%d]%s:%d  src=[%d]%s:%d seq=%d msg=%d type=%d len=%d\n",
	ntohS(vp->routing.dest.family),dhost,ntohS(vp->routing.dest.port),
	ntohS(vp->routing.src.family), shost,ntohS(vp->routing.src.port),
	ntohL(vp->seqNum),
	ntohS(vp->message), ntohS(vp->dataType), ntohS(vp->len)
	);
}
static dumpPakect2(rcc,rhost,rport,vp)
	VideoPacketHeader *vp;
{
fprintf(stderr,"%d %x:%d  %d.%x:%d >> %d.%x:%d msg=%3d type=%3d len=%3d #%d\n",
	rcc,rhost,rport,
	vp->routing.src.family,
	vp->routing.src.addr,
	vp->routing.src.port,
	vp->routing.dest.family,
	vp->routing.dest.addr,
	vp->routing.dest.port,
	vp->message,
	vp->dataType,
	vp->len,
	vp->seqNum
	);
}

static dumpVctl(sh,sp)
	char *sh;
{	int i;
	unsigned char *vp;

	fprintf(stderr,"[%s:%d]\n",sh,sp);
	vp = (unsigned char*)&Vctl;
	for( i = 0; i < sizeof(Vctl); i++ ){
		if( i != 0 && i % 16 == 0 )
			fprintf(stderr,"\n");
		fprintf(stderr,"%2x ",vp[i]);
	}
	fprintf(stderr,"\n");
}

static closeServer(serverhost,serverport)
	char *serverhost;
{
	sv1log("CloseConnection: no client.\n");
	openedReflector = 0;
	INC_NL(Vctl.header.seqNum,1);
	Vctl.header.dataType = kConfigVideoType;
	Vctl.header.message = kCloseConnection;
	/*dumpVctl(serverhost,serverport);*/
	SendTo(SVsock,&Vctl,sizeof(Vctl),serverhost,serverport);
}
static openServer(serverhost,serverport,vp)
	char *serverhost;
	VideoPacketHeader *vp;
{
	for(;;){
		sv1log("OpenConnection: confid=%d\n",
			ntohS(vp->routing.dest.port));
		INC_NL(Vctl.header.seqNum,1);
		Vctl.header.dataType = kConfigVideoType;
		Vctl.header.message = kOpenConnection;
		Vctl.header.routing.dest.port = vp->routing.dest.port;
		SendTo(SVsock,&Vctl,sizeof(Vctl),serverhost,serverport);
		if( 0 < PollIn(SVsock,1000) ){
			sv1log("Opened.\n");
			openedReflector = 1;
			break;
		}
		sleep(1);
	}
}

static getServerAddr(myhost,myport)
	char *myhost;
{	int retry;
	int wcc,rcc;
	char rhost[17];
	int rport;
	int bgntime;
	VideoPacketHeader vpk;

	Vctl.header.routing.src.family = kClient;
	Vctl.header.routing.src.addr = _inet_addrV4(myhost);
	Vctl.header.routing.src.port = htonS(myport);

	Vctl.header.routing.dest.family = kReflector;
	Vctl.header.routing.dest.addr = _inet_addrV4(Serverhost);
	Vctl.header.routing.dest.port = htonS(Serverport);

	Vctl.header.seqNum = htonL(255);
	Vctl.header.message = kOpenConnection;
	Vctl.header.dataType = kConfigVideoType;
	Vctl.header.len = 0;

	if( logVERBOSE() ) dumpPacket(&Vctl);
	Vctl.flags = WANT_VERSION;

	bgntime = time(0);
	for( retry = 0; ;retry++ ){
		INC_NL(Vctl.header.seqNum,1);
		Vctl.seqNum = Vctl.header.seqNum;

		/*dumpVctl(serverhost,serverport);*/
		wcc = SendTo(SVsock,&Vctl,sizeof(Vctl),Serverhost,Serverport);
		if( PollIn(SVsock,1000) <= 0 ){
			if( 30 < time(0)-bgntime ){
				sv1log("give up ;-<\n");
				break;
			}
			sv1log("NO RESPONSE FROM %s:%d, retry...\n",
				Serverhost,Serverport);
			continue;
		}
		rcc = RecvFrom(SVsock,&vpk,sizeof(vpk),rhost,&rport);
		if( vpk.routing.src.family == kReflector )
		{
			if( logVERBOSE() ) dumpPacket(&vpk);
			sv1log("REFLECTOR: %s:%d -> %s:%d\n",
				Serverhost,Serverport,rhost,rport);
			strcpy(Serverhost,rhost);
			Serverport = rport;
			break;
		}
	}
	INC_NL(Vctl.header.seqNum,1);
	Vctl.header.message = kCloseConnection;
	SendTo(SVsock,&Vctl,sizeof(Vctl),Serverhost,Serverport);
	if( logVERBOSE() ) dumpPacket(&Vctl);
}

extern char *gethostaddr();

service_cuseeme(Conn,svsock,myport)
	Connection *Conn;
{	char buff[0x8000];
	int rcc;
	VideoPacketHeader *vp;
	char host[128];
	char myhost[17];
	char rhost[17];
	int rport;
	Addr client;
	int ucount,ubytes,dcount,dbytes;
	int bgntime,curtime,nexttime;
	char shost[128]; /* socket host if using */
	int sport;
	char *aaddr;

	minit_cuseeme();

	SVsock = svsock;
	if( (aaddr = gethostaddr(DST_HOST)) == NULL ){
		sv1log("#### ERROR: bad destination host [%s]\n",DST_HOST);
		return;
	}
	strcpy(Serverhost,aaddr);
	Serverport = DST_PORT;
	if( hostIFfor1(host,1,DST_PROTO,DST_HOST,DST_PORT) == 0 )
	if( hostIFfor(DST_HOST,host) == 0 )
		gethostname(host,sizeof(host));
	strcpy(myhost,gethostaddr(host));
	sv1log("myname=%s[%s]\n",host,myhost);

{
extern char *getenv();
char *file;

	if( file = getenv("CUIN") ){
		Save = fopen(file,"w");
		fprintf(stderr,"CUIN: %s : %x\n",file,Save);
	}
}

	if( 0 < socks_addservers() )
	if( SOCKS_udpassocsock(SVsock,myhost,myport,shost,&sport) == 0 ){
		sv1log("via SOCKS: %s:%d -> %s:%d\n",myhost,myport,shost,sport);
		strcpy(myhost,shost);
		myport = sport;
	}

	closeServer(Serverhost,Serverport);
	getServerAddr(myhost,myport);

	ucount = ubytes = 0;
	dcount = dbytes = 0;
	bgntime = time(0);
	nexttime = (bgntime/10+1) * 10;
	vp = (VideoPacketHeader *)buff;

	sv1log("REFLECTOR: %s:%d\n",Serverhost,Serverport);
	for(;;){
		rcc = RecvFrom(SVsock,buff,sizeof(buff),rhost,&rport);
		if( rcc < 0 )
			continue;
		/* dumpPacket2(vp); */

		if( vp->routing.src.family == kReflector )
		if( strcmp(Serverhost,rhost) != 0 || Serverport != rport )
		{
			sv1log("REFLECTOR: %s:%d -> %s:%d\n",
				Serverhost,Serverport,rhost,rport);
			strcpy(Serverhost,rhost);
			Serverport = rport;
		}

		curtime = time(0);
		if( strcmp(rhost,Serverhost) == 0 && rport == Serverport ){
			dcount++;
			dbytes += rcc;
			toClients(curtime,SVsock,vp,rcc);
		}else{
			ucount++;
			ubytes += rcc;

			if( vp->message == kCloseConnection ){
				closeClient(&vp->routing.src);
				SendTo(SVsock,vp,rcc,Serverhost,Serverport);

				if( openedReflector && activeClients() == 0 )
					closeServer(Serverhost,Serverport);
			}else{
				if( openedReflector == 0 )
					openServer(Serverhost,Serverport,vp);
				addClient(curtime,rhost,rport,&vp->routing.src);
				SendTo(SVsock,vp,rcc,Serverhost,Serverport);
			}
		}
		if( nexttime <= curtime ){
			double Bps;

			Bps = ((ubytes+dbytes)*8.0)/(curtime-bgntime);
			daemonlog("I","%d clnts, %d/%dup+%d/%ddown, %5.2fKbps\n",
				Clientx,ubytes,ucount,dbytes,dcount,Bps/1000);
			nexttime = (curtime/10+1) * 10;
		}
	}
}
