/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1999 Yutaka Sato
Copyright (c) 1994-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	access.c (Access Control)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:

  AUTH = what : authProto : valid-user@host-list

    AUTH=manager:*:user@host
    AUTH=anonftp:*:user@host
    AUTH=anonftp:smtp-vrfy:user@host
    AUTH=proxy:{auth,pauth}  ... authorization is done by RELIABLE/PREMIT

    AUTH=authgen:basic:authString
    AUTH=fromgen:fromString
    AUTH=forward:paramList
    AUTH=log:remoteHost:Ident:authUser

History:
	940303	created
//////////////////////////////////////////////////////////////////////#*/
#include "hostlist.h"
#include "vaddr.h"
#include "delegate.h"
#include "ystring.h"
#include <ctype.h>
#include <errno.h>

extern char *getClientHostPortUser();
extern char *getClientUserC();
#define Ident()	getClientUserC(Conn)

extern HostList *ReliableHosts();
extern HostList *ReachableHosts();

#define A_MANAGER	"manager"
#define A_ADMIN		"admin"
#define A_ANONFTP	"anonftp"
#define A_ORIGIN	"origin"
#define A_PROXY		"proxy"
#define A_LOG		"log"
#define A_FORWARD	"forward"
#define A_VIAGEN	"viagen"
#define A_FROMGEN	"fromgen"
#define A_AUTHGEN	"authgen"
#define A_PAUTHGEN	"pauthgen"

#define AP_SMTP_VERIFY	"smtp-vrfy"
#define AP_REQ_AUTH	"auth"	/* use auth. info. in request message */
#define AP_REQ_PAUTH	"pauth"	/* use proxy auth. info. in req. message */

typedef struct {
	char	a_authority[1024];
	char   *a_authp;
	char   *a_authv[32];
	int	a_authx;
} AuthEnv;
static AuthEnv *authEnv;
#define Auth	authEnv[0]
minit_access()
{
	if( authEnv == 0 )
		authEnv = NewStruct(AuthEnv);
}
#define Authority	Auth.a_authority
#define Authp		Auth.a_authp
#define Authv		Auth.a_authv
#define Authx		Auth.a_authx

scan_AUTH(Conn,auth)
	Connection *Conn;
	char *auth;
{
	if( Authp == 0 )
		Authp = Authority;
	Authv[Authx++] = Authp;
	strcpy(Authp,auth);
	Authp += strlen(Authp) + 1;
}
static char *find_auth(what,val)
	char *what,*val;
{	int ai;
	int len,vlen;
	char *auth1,*val1;

	len = strlen(what);
	if( val )
		vlen = strlen(val);
	else	vlen = 0;
	for( ai = 0; ai < Authx; ai++ ){
		auth1 = Authv[ai];
		if( strncmp(auth1,what,len) != 0 )
			continue;
		if( auth1[len] == 0 )
			val1 = &auth1[len];
		else
		if( auth1[len] == ':' )
			val1 = &auth1[len+1];
		else	continue;

		if( val == NULL )
			return val1;
		if( strncmp(val1,val,vlen) == 0 ){
			if( val1[vlen] == 0 )
				return &val1[vlen];
			if( val1[vlen] == ':' )
				return &val1[vlen+1];
		}
	}
	return 0;
}
static findAuth(Conn,what,proto,auth)
	Connection *Conn;
	char *what,*proto,*auth;
{	char xauth[1024];

	if( strcasecmp(proto,AP_SMTP_VERIFY) != 0 )
		proto = "*";

	sprintf(xauth,"%s:%s",proto,auth);
	if( find_auth(what,xauth) )
		return 1;

	sprintf(xauth,"%s:*",proto);
	if( find_auth(what,xauth) )
		return 1;

	return 0;
}
CTX_with_auth_admin(Conn)
	Connection *Conn;
{
	if( find_auth(A_ADMIN,NULL) )
		return 1;
	else	return 0;
}
CTX_auth_admin(Conn,what,proto,userhost)
	Connection *Conn;
	char *what,*proto,*userhost;
{
	if( findAuth(Conn,A_ADMIN,proto,userhost) )
		return 1;
	return findAuth(Conn,A_MANAGER,proto,userhost);
}
CTX_with_auth_anonftp(Conn)
	Connection *Conn;
{
	if( find_auth(A_ANONFTP,NULL) )
		return 1;
	else	return 0;
}
CTX_auth_anonftp(Conn,proto,user,pass)
	Connection *Conn;
	char *proto,*user,*pass;
{
	if( find_auth(A_ANONFTP,NULL) == 0 )
		return 1;

	if( is_anonymous(user) || user[0] == 0 )
		return 0;
	if( strchr(user,'@') == 0 )
		return 0;
	return findAuth(Conn,A_ANONFTP,proto,pass);
}
auth_origin_auth()
{
	if( find_auth(A_ORIGIN,AP_REQ_AUTH) )
		return 1;
	else	return 0;
}
auth_proxy_auth()
{
	if( find_auth(A_PROXY,AP_REQ_AUTH) )
		return 1;
	else	return 0;
}
auth_proxy_pauth()
{
	if( find_auth(A_PROXY,AP_REQ_PAUTH) )
		return 1;
	else	return 0;
}

extern HostList *NotifyPltfrmHosts();
NotifyPlatform(Conn,isreq)
	Connection *Conn;
{	char *host,hostb[256],*user;
	int port,match;
	HostList *notplat;

	notplat = NotifyPltfrmHosts();
	if( isreq ){
		host = DST_HOST;
		port = DST_PORT;
		user = "-";
	}else{
		host = hostb;
		port = getClientHostPort(Conn,hostb);
		user = "-";
	}
	match = hostIsinList(notplat,DST_PROTO,host,port,user);
	return match;
}
makeVia(Conn,via)
	Connection *Conn;
	char *via;
{	char *fmt;

	if( fmt = find_auth(A_VIAGEN,NULL) ){
		if( strcmp(fmt,"-") == 0 )
			*via = 0;
		else
		if( *fmt == 0 )
			ClientIF_HP(Conn,via);
		else	strfConn(Conn,fmt,via);
	}else{
		strcpy(via,"-");
	}
}
makeForwarded(Conn,forwarded)
	Connection *Conn;
	char *forwarded;
{	char myuri[256],client[256];
	char myhp[256];

	if( find_auth(A_FORWARD,NULL) ){
		ClientIF_HP(Conn,myhp);
		sprintf(myuri,"http://%s/",myhp);
		getClientHostPort(Conn,client);
	}else{
		return 0;
		/*
		strcpy(myuri,"-");
		strcpy(client,"-");
		*/
	}
	sprintf(forwarded,"by %s (DeleGate/%s) for %s",
		myuri,(char*)DELEGATE_ver(),client);

	return 1;
}

makeAuthorization(Conn,genauth,proxy)
	Connection *Conn;
	char *genauth;
{	char *fmt,atype[128],*afmt;
	char gauth[256],eauth[256],host[128];
	int port;
	char *dp;
	char authb[256],fmtb[256];

	authb[0] = 0;
	if( ClientAuth.i_stat == AUTH_SET ){
		sprintf(authb,"%s:%s",ClientAuth.i_user,ClientAuth.i_pass);
	}else
	if( proxy ){
		if( toProxy && streq(GatewayProto,"http") )
		get_MYAUTH(Conn,authb,"http-proxy",GatewayHost,GatewayPort);
	}else{
		get_MYAUTH(Conn,authb,"http",DST_HOST,DST_PORT);
	}
	if( authb[0] ){
		sprintf(fmtb,"basic:%s",authb);
		fmt = fmtb;
	}else{
	if( proxy ){
	if( (fmt = find_auth(A_PAUTHGEN,NULL)) == NULL )
		return 0;
	}else
	if( (fmt = find_auth(A_AUTHGEN,NULL)) == NULL )
		return 0;
	}
	strcpy(atype,fmt);
	if( afmt = strchr(atype,':') )
		*afmt++ = 0;
	else	afmt = "";
	atype[0] = toupper(atype[0]);

	strfConn(Conn,afmt,gauth);
	if( gauth[0] == 0 )
		return 0;

	if( authb[0] == 0 )
	if( !proxy ){
	gethostname(host,sizeof(host));
	strcat(gauth,"/");
	strcat(gauth,host);
	}

	str_to64(gauth,strlen(gauth),eauth,512,1);
	if( dp = strpbrk(eauth,"\r\n") )
		*dp = 0;

	sprintf(genauth,"%s %s",atype,eauth);
	return 1;
}

makeFrom(Conn,genfrom)
	Connection *Conn;
	char *genfrom;
{	char *fmt;

	genfrom[0] = 0;
	if( (fmt = find_auth(A_FROMGEN,NULL)) == NULL )
		return 0;

	if( *fmt == 0 )
		fmt = "%u@%h";
	strfConn(Conn,fmt,genfrom);
	return 1;
}

makeClientLog(Conn,clientlog)
	Connection *Conn;
	char *clientlog;
{	char host[256],iuser[256],auser[256];
	char *hfmt,*ifmt,*afmt;
	char xhfmt[128],xifmt[128],xafmt[128];
	char *fmt;

	hfmt = "%h";
	ifmt = "%u";
	afmt = "%U";
	if( fmt = find_auth(A_LOG,NULL) ){
		xhfmt[0] = xifmt[0] = xafmt[0] = 0;
		scan_Listlist(fmt,':',xhfmt,xifmt,xafmt,0);
		if( xhfmt[0] ) hfmt = xhfmt;
		if( xifmt[0] ) ifmt = xifmt;
		if( xafmt[0] ) afmt = xafmt;
	}

	strfConn(Conn,hfmt,host);  if(host[0] ==0) strcpy(host,"-");
	strfConn(Conn,ifmt,iuser); if(iuser[0]==0) strcpy(iuser,"-");
	strfConn(Conn,afmt,auser); if(auser[0]==0) strcpy(auser,"-");

	sprintf(clientlog,"%s %s %s",host,iuser,auser);
}

/*
 *	If no RELIABLE host is specified explicitly, then suppose that any
 *	hosts is relaible.  Typical case is that the DeleGate is running
 *	on the host which belongs to a secure network within a firewall.
 */
extern char *hostmatch_ignauth;
static RELIABLE_HOST(Conn,hostlist,srchost,srcport)
	Connection *Conn;
	HostList *hostlist;
	char *srchost;
{	char *suser;
	int ac;
	AuthInfo *av[4];

	if( hostlist->hl_cnt == 0 )
		return 1;

	suser = Ident();
	if( suser == 0 && Conn->no_authcheck )
		suser = hostmatch_ignauth;
	ac = getClientAuthList(Conn,4,av);
	return hostIsinListX(hostlist,DFLT_PROTO,srchost,srcport,suser,ac,av);
/*
{
char ohost[128];
getOriginator(ohost);
printf("ROUTE: %s [%s]\n",CTX_get_PATH(Conn),ohost);
}
*/
/*
		if( suser == NULL ){
			char qhost[128],quser[128];
			if( get_equiv_user(srchost,srcport,qhost,quser) ){
				suser = quser;
				srchost = qhost;
				srcport = 0;
			}
		}
*/
}
static REACHABLE_HOST(Conn,hostlist,proto,hostname,dstport)
	Connection *Conn;
	HostList *hostlist;
	char *proto;
	char *hostname;
{	char *duser = Conn ? DST_USER : NULL;

	if( hostlist->hl_cnt == 0 )
		return 1;
	if( Conn != NULL && Conn->no_dstcheck )
		return 1;

	return hostIsinList(hostlist,proto,hostname,dstport,duser);
}
source_permitted(Conn)
	Connection *Conn;
{	int ok;

	Conn->no_dstcheck = 1;
	ok = service_permitted2(Conn,DST_PROTO,1);
	Conn->no_dstcheck = 0;
	return ok;
}
source_permittedX(Conn)
	Connection *Conn;
{	int ok;

	Conn->no_authcheck = 1;
	ok = source_permitted(Conn);
	Conn->no_authcheck = 0;
	return ok;
}
service_permitted0(clhost,clport,svproto,svhost,svport)
	char *clhost,*svproto,*svhost;
{	Connection ConnBuf, *Conn = &ConnBuf;
	int ok;

	ConnInit(Conn);
	if( clhost ){
		strcpy(Client_Host,clhost);
	}else{
		Client_Host[0] = 0;
	}
	Client_Port = clport;
	set_realsite(Conn,svproto,svhost,svport);
	ok = service_permitted2(Conn,svproto,1);
	if( !ok ){
		daemonlog("E","No permission: %s:%d > %s://%s:%d\n",
			clhost,clport,svproto,svhost,svport);
	}
	return ok;
}
method_permitted0()
{
	return 1;
}

/*
 *	Not implemented yet
 *	(This is done in RELIABLE_HOST() ?)
 */
static PERMITTED_USER(Conn,hostlist,hostname,lport,stdport)
	Connection *Conn;
	HostList *hostlist;
	char *hostname;
{
	if( hostlist->hl_cnt == 0 )
		return 1;
	return 1;
}

static PERMITTED_PORT(Conn,proto,host,port)
	Connection *Conn;
	char *proto,*host;
{	int stdport;

	if( streq(proto,"telnet") ){
	    stdport = serviceport("telnet");

if( getenv("ANYPORT") == 0 )
	    if( port != 0 && port != stdport ){
		if( ImProxy )
			sv1log("Proxy telnet follows PERMIT parameter\n");
		else
		if( streq(iSERVER_PROTO,"telnet") && port==iSERVER_PORT )
			sv1log("TELNET to non-standard port: %d %d/%d\n",
				port,DFLT_PORT,iSERVER_PORT);
		else{
			Verbose("cannot TELNET to non-standard port %d\n",
				DFLT_PORT);
			return 0;
		}
	    }
	}
	if( port == 19 ){
		if( streq(proto,"http") || streq(proto,"gopher") ){
			sv1log("HTTP,Gopher to 19(chargen) is inhibited.\n");
			return 0;
		}
	}
	return 1;
}
static PERMITTED_PAIR(Conn,proto,dhost,dport,shost,sport)
	Connection *Conn;
	char *proto,*dhost,*shost;
{
	return DELEGATE_permitM(Conn,proto,NULL,dhost,dport,shost,sport);
}

PERMITTED_ACCESS(Conn,shost,sport,stdport)
	Connection *Conn;
	char *shost;
{	int permitted = 0;

	Conn->reject_reason[0] = 0;
	if(!RELIABLE_HOST(Conn,ReliableHosts(),shost,sport))
	{
		sprintf(Conn->reject_reason,"'%s' not RELIABLE",shost);
		Verbose("not RELIABLE\n");
	}
	else
	if(!PERMITTED_USER(Conn,ReliableHosts(),shost,sport,stdport))
	{
		sprintf(Conn->reject_reason,"not PERMITTED_USER");
		Verbose("not PERMITTED_USER\n");
	}
	else
	if(!REACHABLE_HOST(Conn,ReachableHosts(),DST_PROTO,DST_HOST,DST_PORT))
	{
		sprintf(Conn->reject_reason,"'%s' not REACHABLE",DST_HOST);
		Verbose("not REACHABLE\n");
	}
	else
	if(!PERMITTED_PORT(Conn,DST_PROTO,DST_HOST,DST_PORT))
	{
		sprintf(Conn->reject_reason,"not PERMITTED_PORT");
		Verbose("not PERMITTED_PORT\n");
	}
	else
	if( DELEGATE_rejectM(Conn,DST_PROTO,NULL,DST_HOST,DST_PORT,shost,sport) ){
		Verbose("REJECTED_PAIR\n");
		sprintf(Conn->reject_reason,"matched REJECT");
	}else
	if(!PERMITTED_PAIR(Conn,DST_PROTO,DST_HOST,DST_PORT,shost,sport))
	{
		Verbose("not PERMITTED_PAIR\n");
		if( Conn->reject_reason[0] == 0 )
		sprintf(Conn->reject_reason,"unmatch PERMIT");
	}
	else
		permitted = 1;

if(!permitted)
if(LOG_GENERIC){
char *user;
if( (user = getClientUserC(Conn)) == NULL )
	user = "-";
fputLog(Conn,"Reject","%s@%s:%d; to=%s://%s:%d\n",
user,shost,sport,
DST_PROTO,DST_HOST,DST_PORT);
}

	return permitted;
}

VA_setClientAddr(Conn,addr,port,remote)
	Connection *Conn;
	char *addr;
{
	VA_setVAddr(Client_VAddr,addr,port,remote);
}
VA_getClientAddr(Conn)
	Connection *Conn;
{
	if( 0 <= ClientSock )
	if( Client_Port == 0 ){
		VA_getpeerNAME(ClientSock,Client_VAddr);
	}
	return 0 < Client_Port;
}
getClientHostPortAddr(Conn,rhost,raddr)
	Connection *Conn;
	char *rhost,*raddr;
{
	VA_getClientAddr(Conn);

	if( Client_Port <= 0 ){
		if( rhost != NULL ) strcpy(rhost,"Cant-GetPeerName");
		if( raddr != NULL ) strcpy(raddr,"255.255.255.255");
		return 0;
	}

	if( rhost != NULL ) strcpy(rhost,Client_Host);
	if( raddr != NULL ) VA_inetNtoah(Client_VAddr,raddr);
	return Client_Port;
}
getClientHostPort(Conn,rhost)
	Connection *Conn;
	char *rhost;
{
	return getClientHostPortAddr(Conn,rhost,NULL);
}


/*
 *	PERMIT about RELAY function
 *	control accessibility of relay function
 */
static scan_relay1(r1,maskp)
	char *r1;
	int *maskp;
{
	if( streq(r1,"novhost")  ) *maskp &= ~RELAY_VHOST;
	if( streq(r1,"vhost")    ) *maskp |= RELAY_VHOST;
	if( streq(r1,"proxy")    ) *maskp |= RELAY_PROXY;
	if( streq(r1,"delegate") ) *maskp |= RELAY_DELEGATE;
	if( streq(r1,"noapplet") ) *maskp &= ~RELAY_APPLET;
	if( streq(r1,"nojava")   ) *maskp &= ~RELAY_JAVA;
	return 0;
}
static scan_relay(realm)
	char *realm;
{	int mask;

/*
	mask = RELAY_VHOST | RELAY_JAVA | RELAY_APPLET;
*/
	mask = RELAY_JAVA | RELAY_APPLET;
	scan_List(realm,',',0,scan_relay1,&mask);
	return mask;
}
scan_RELAY1(relay1,Conn)
	char *relay1;
	Connection *Conn;
{
	scan_CMAP2(Conn,"relay",relay1);
	return 0;
}
scan_RELAY(Conn,relay)
	Connection *Conn;
	char *relay;
{
	scan_List(relay,';',0,scan_RELAY1,Conn);
}
do_RELAY(Conn,what)
	Connection *Conn;
{	char realm[128];
	int found;
	int caps,relay;

	/* this function should be unified with service_permitted() ... */
	if( Conn->from_myself )
		return 1;

	CTX_pushClientInfo(Conn);
	relay = 0;
	for( found = 0;; found++){
		found = find_CMAPi(Conn,"relay",found,realm);
		if( found < 0 )
			break;
		caps = scan_relay(realm);
		if( (caps & what) == what ){
			relay = caps;
			break;
		}
	}
	HL_popClientInfo();
	return relay;
}

Connection *FORCE_REWRITE = (Connection*)-1;
/*
it's too heavy to be checked for each embedded URL in HTML...

isRELAYABLE(Conn,proto,hostport)
	Connection *Conn;
	char *proto,*hostport;
{
	if( Conn == FORCE_REWRITE )
		return 1;
	return do_RELAY(Conn,RELAY_DELEGATE);
}
*/

isREACHABLE(proto,hostport)
	char *proto,*hostport;
{	char host[512];
	int port;
	int svf,yes;

	port = scan_hostport(proto,hostport,host);
	svf = RES_CACHEONLY(1);
	yes = REACHABLE_HOST(NULL,ReachableHosts(),ANYP,host,port);
	RES_CACHEONLY(svf);
	return yes;
}

NotREACHABLE(Conn,proto,host,port)
	Connection *Conn;
	char*proto,*host;
{	int reach;

	if( Conn != NULL
	 && Conn->no_dstcheck_proto
	 && Conn->no_dstcheck_proto == serviceport(proto) )
		return 0;

	if( notREMITTABLE(proto,port) )
		return 1;

	CTX_pushClientInfo(Conn);
	reach = REACHABLE_HOST(NULL,ReachableHosts(),proto,host,port);
	HL_popClientInfo();
	if( !reach )
		return 1;

	return 0;
}

addRejectList(Conn,what,dpath,referer,auser,apass,reason)
	Connection *Conn;
	char *what,*dpath,*referer,*auser,*apass,*reason;
{	char src_host[256],*src_user;
	int src_port;

	src_user = getClientHostPortUser(Conn,src_host,&src_port);
	if( src_user == NULL )
		src_user = "-";

	if( *apass != 0 )
	if( !strcaseeq(auser,"anonymous") )
	if( !strcaseeq(auser,"ftp") || !strcaseeq(DST_PROTO,"ftp") )
		apass = "*";

	if( *referer == 0 )
		referer = "-";

	putRejectList(what,
		DST_PROTO, DST_HOST,DST_PORT, dpath, referer,
		DFLT_PROTO,src_host,src_port, src_user,
		auser,apass,reason);
}
static local_auth(path,uh,proto,user,host,port)
	char *path,*uh,*proto,*user,*host;
{	char uh_md5[64];

	if( host[0] == 0 ) strcpy(host,"localhost");
	if( port == 0 ) port = serviceport(proto);

	sprintf(uh,"%s://%s@%s:%d",proto,user,host,port);
	toMD5(uh,uh_md5);
	sprintf(path,"${ADMDIR}/authorizer/%s/%s",host,uh_md5);
	DELEGATE_substfile(path,"",NULL,NULL,NULL);
}
authedit_main(ac,av,ctx)
	char *av[];
	void *ctx;
{	char up[64],user[64],pass[64],hp[64],host[64],port[64],*dp;
	char path[1024],pw_md5[64],uh[128];
	int expire;
	int rcode;
	FILE *afp,*tc;

	tc = stdout;
	if( ac < 4 || av[1][0] != '-' ){
		fprintf(tc,
		"-USAGE: %s -{a|d|v} user[:pass] host[:port] [expire]\r\n",
			av[0]);
		return -1;
	}
	strcpy(up,av[2]);
	strcpy(hp,av[3]);
	scan_namebody(up,user,sizeof(user),":",pass,sizeof(pass),NULL);
	scan_namebody(hp,host,sizeof(host),":",port,sizeof(port),NULL);
	expire = 0;

	local_auth(path,uh,"ftp",user,host,atoi(port));

	switch( av[1][1] ){
	  case 'v':
	  default:
		if( File_is(path) ){
			fprintf(tc,"-OK current auth. for %s follows:\r\n",uh);
		}else{
			fprintf(tc,"-ERROR no auth. for %s\r\n",uh);
		}
		break;
	  case 'd':
		rcode = unlink(path);
		if( rcode == 0 )
			fprintf(tc,"-OK removed the auth.\r\n");
		else	fprintf(tc,"-ERROR could not remove the auth. (errno=%d)\r\n",errno);
		break;

	  case 'a':
		if( File_is(path) ){
			fprintf(tc,"-ERROR the auth. exists already, remove it first by `-d' option\r\n");
			break;
		}
		if( afp = dirfopen("AUTH",path,"w") ){
			if( pass[0] == 0 ){
				fprintf(tc,"Password (not hidden): ");
				fflush(tc);
				fgets(pass,sizeof(pass),stdin);
				if( dp = strpbrk(pass,"\r\n") )
					*dp = 0;
			}
			toMD5(pass,pw_md5);
			fprintf(afp,"%s\r\n%d\r\n",pw_md5,expire);
			fprintf(tc,"-OK added the auth.\r\n");
			fclose(afp);
		}else{
			fprintf(tc,"-ERROR could not add the auth. (errno=%d)\r\n",errno);
		}
		break;
	}
	fprintf(tc,"PATH: %s\r\n",path);
	fprintf(tc,"AUTH: %s\r\n",uh);
	if( afp = dirfopen("AUTH",path,"r") ){
		pw_md5[0] = 0;
		fgets(pw_md5,sizeof(pw_md5),afp);
		fprintf(tc,"PASS: %s",pw_md5);
		pw_md5[0] = 0;
		fgets(pw_md5,sizeof(pw_md5),afp);
		fprintf(tc,"EXPIRE: %s",atoi(pw_md5)==0?"never\r\n":pw_md5);
		fclose(afp);
	}
	fprintf(tc,"\r\n");
	return 0;
}
CTX_auth_cache(ctx,store,expire,proto,user,pass,host,port)
	void *ctx;
	char *proto,*user,*pass,*host;
{	char uh[128],uh_md5[128],pw_md5[128],rpath[1024],apath[1024],cpass[128];
	FILE *afp;

	sprintf(uh,"%s://%s@%s:%d",proto,user,host,port);
	Verbose("AUTH_CACHE %d %s\n",store,uh);

	toMD5(uh,uh_md5);
	toMD5(pass,pw_md5);
	sprintf(rpath,"%d/%s",SERVER_PORT(),uh_md5);
	CTX_cache_path(ctx,"delegate","auth",9999,rpath,apath);

	if( store ){
		if( afp = dirfopen("AUTH",apath,"w") ){
			fprintf(afp,"%s\n",pw_md5);
			fclose(afp);
			return 0;
		}else	return -1;
	}else{
		char lapath[1024];
		local_auth(lapath,uh,proto,user,host,port);
		if( afp = fopen(lapath,"r") )
			sv1log("persistent auth: %s %s\n",uh,lapath);
		else	afp = expfopen("AUTH",expire,apath,"r",NULL);
		if( afp ){
			Fgets(cpass,sizeof(cpass),afp);
			fclose(afp);
			if( strcmp(pw_md5,cpass) == 0 ){
				Verbose("cached auth OK: %s@%s\n",user,host);
				return 1;
			}
		}
		return 0;
	}
}

#define IDENTIFY_MAP	"Identifier"
#define AUTHORIZE_MAP	"Authorizer"
#define AUTHSERV_MAP	"AuthServer"

#define I_IDENT		"?"
#define I_FTP		"&"
#define I_ANY		"*"
#define AUTH_VDOM	"-AUTH"

scan_AUTHORIZER(Conn,authserv)
	Connection *Conn;
	char *authserv;
{	char vauthserv[256],aserv[256],proto[256],dhost[256];

/*
	if( !streq(authserv,I_IDENT) && !streq(authserv,I_FTP) ){
		if( num_ListElems(authserv,':') == 1 ){
			sprintf(vauthserv,"%s.%s",authserv,AUTH_VDOM);
			scan_RELIABLE(Conn,vauthserv);
		}else{
			scan_Listlist(authserv,':',aserv,proto,dhost,0);
			if( aserv[0] == 0 ) strcpy(aserv,"*");
			if( proto[0] == 0 ) strcpy(proto,"*");
			if( dhost[0] == 0 ) strcpy(dhost,"*");
			sprintf(vauthserv,"%s:%s:%s.%s",
				proto,dhost,aserv,AUTH_VDOM);
			scan_PERMIT(Conn,vauthserv);
		}
	}
*/
	scan_CMAP2(Conn,AUTHSERV_MAP,authserv);
}
static Identify(Conn,identonly,fc,tc,authserv,user,host,phost,func,arg)
	Connection *Conn;
	FILE *fc,*tc;
	char *authserv,*user,*host,*phost;
	int (*func)();
	char *arg;
{	int ci;
	char userhost[1024],pass[256];
	char aproto[64],ahost[256];
	int aport;
	char clhost[256];
	char *iuser;
	char userb[256];
	UTag Tuserhost,Tpass;

	Tuserhost.ut_addr = userhost;
	Tuserhost.ut_size = sizeof(userhost);
	Tpass.ut_addr = pass;
	Tpass.ut_size = sizeof(pass);

	if( strchr(user,':') ){
		scan_namebody(user,userb,128,":",pass,128,"\r\n");
		user = userb;
	}else	pass[0] = 0;

	getpeerNAME(FromC,clhost);

	if( wordIsinList(authserv,I_IDENT) )
	if( iuser = getClientHostPortUser(Conn,clhost,NULL) ){
		strcpy(user,iuser);
		strcpy(host,clhost);
		strcpy(phost,host);
		goto EXIT;
	}
if( fc != NULL ){
	if( strcmp(authserv,"&") == 0 )
	fprintf(tc,">>>>>>>> login with your account at <%s>\r\n",clhost);

	fprintf(tc,">>>>>>>> Username: ");
	fflush(tc);
	userhost[0] = user[0] = host[0] = 0;
/*
	ci = (*func)(1,fc,tc,userhost,arg);
*/
	ci = (*func)(1,fc,tc,&Tuserhost,arg);
	if( userhost[0]  == 0 )
		return 0;
	if( ci == EOF )
		return 0;

	scan_namebody(userhost,user,128,"@",host,128," \t\r\n");
}
	strcpy(phost,"******");

	if( host[0] ){
		if( wordIsinList(authserv,host) ){ 
			/* authorized */
		}else
		if( wordIsinList(authserv,I_FTP) && hostcmp(host,clhost) == 0 ){
			/* not authorized */
		}else
		if( wordIsinList(authserv,I_ANY) ){
			/* not authorized */
		}else{
			fprintf(tc,"!!!!!!!! %s: not authentiation server\r\n",
				host);
			fflush(tc);
			return 0;
		}
		strcpy(phost,host);
	}else{
		if( wordIsinList(authserv,I_FTP) ){
			/* authorized */
			strcpy(host,clhost);
			strcpy(phost,host);
		}else{
			/* authorized */
			sscanf(authserv,"%[^,]",host);
		}
	}
	if( streq(host,I_ANY) ){
		fprintf(tc,"!!!!!!!! enter user@yourAuthHost\r\n");
		fflush(tc);
		return 0;
	}
/*
	if( !identonly && !service_authorized(Conn,user,host) ){
		fprintf(tc,"<<<<<<<< No, <%s@%s> is not an authorized user\r\n",
			user,phost);
		fflush(tc);
		return 0;
	}
*/

if( fc != NULL ){
	fprintf(tc,">>>>>>>> Password: ");
/*
	ci = (*func)(0,fc,tc,pass,arg);
*/
	ci = (*func)(0,fc,tc,&Tpass,arg);
	if( ci == EOF )
		return 0;
	fflush(tc);
}

	if( Authenticate(Conn,host,user,pass,"/") < 0 ){
		if( user[0] || pass[0] )
		fprintf(tc,
		"!!!!!!!! USER <%s@%s> authentication failed\r\n",user,phost);
		fflush(tc);
		return 0;
	}

EXIT:
	return 1;
}

/*
setClientIdent(Conn,mbox)
	Connection *Conn;
	char *mbox;
{	char *dp;
}
*/
setServerCert(Conn,what,mbox)
	Connection *Conn;
	char *what,*mbox;
{	AuthInfo ident;
	char *dp;

/*
	ident.i_stat = IDENT_GOT;
	strcpy(ident.syst,"");
*/
	dp = wordscanY(mbox,ident.i_user,sizeof(ident.i_user),"^@");
	if( *dp == '@' )
		wordScan(dp+1,ident.i_Host);
	sv1log("##[%s] set ServerAuth [%s@%s]\n",what,ident.i_user,ident.i_Host);
	Conn->sv_certauth = ident;
}
setClientCert(Conn,what,mbox)
	Connection *Conn;
	char *what,*mbox;
{	AuthInfo ident;
	char *dp;

/*
	ident.i_stat = IDENT_GOT;
	strcpy(ident.syst,"");
*/
	dp = wordscanY(mbox,ident.i_user,sizeof(ident.i_user),"^@");
	if( *dp == '@' )
		wordScan(dp+1,ident.i_Host);
	else	ident.i_Host[0] = 0;

	if( dp = strchr(ident.i_Host,':') ){
		*dp++ = 0;
		ident.i_Port = atoi(dp);
	}else	ident.i_Port = 0;

	/*
	sv1log("##[%s] set ClientAuth [%s@%s]\n",what,ident.i_user,ident.i_Host);
	*/
	sv1log("##[%s] set ClientAuth [%s@%s]:%d\n",what,ident.i_user,
		ident.i_Host,ident.i_Port);
	Conn->cl_certauth = ident;
}
setClientAuth(Conn,what,auser,ahost)
	Connection *Conn;
	char *what,*auser,*ahost;
{	char *user,userb[64];

	if( strchr(auser,':') ){
		wordscanY(auser,userb,sizeof(userb),"^:");
		user = userb;
	}else	user = auser;
	sv1log("##[%s] set ClientAuth [%s@%s]\n",what,user,ahost);

	ClientAuth.i_stat = AUTH_SET;
	wordScan(auser,ClientAuthUser);
	wordScan(ahost,ClientAuthHost);
	ClientAuthPort = 0;
}
getClientAuthList(Conn,ax,av)
	Connection *Conn;
	AuthInfo *av[];
{	int ac;

	ac = 0;
	if( ClientAuthUser[0] ){
		av[ac++] = &ClientAuth;
	}
	if( Conn->cl_certauth.i_user[0] ){
		av[ac++] = &Conn->cl_certauth;
	}
	return ac;
}

service_authorized(Conn,user,host)
	Connection *Conn;
	char *user,*host;
{	int ok;
	AuthInfo sauth;
	char ahost[256];

	sauth = ClientAuth;
	sprintf(ahost,"%s.%s",host,AUTH_VDOM);
	wordScan(ahost,ClientAuthHost);
	wordScan(user, ClientAuthUser);

	Conn->auth_check = 1;
	ok = service_permitted2(Conn,DST_PROTO,1);
	Conn->auth_check = 0;

	ClientAuth = sauth;
	return ok;
}

CTX_auth(Conn,user,pass)
	Connection *Conn;
	char *user,*pass;
{	AuthInfo ident;

	bzero(&ident,sizeof(ident));
	if( user ) wordScan(user,ident.i_user);
	if( pass ) wordScan(pass,ident.i_pass);
	return doAuth(Conn,&ident);
}
char *getMountAuthorizer(Conn,authserv,size)
	Connection *Conn;
	char *authserv;
{	char *authopt;

	if( !IsMounted || MountOptions == 0 )
		return 0;

	if( *MO_Authorizer != 0 )
		goto EXIT;

	if( authopt = strcasestr(MountOptions,"AUTHORIZER=") )
		wordscanY(authopt+11,MO_Authorizer,sizeof(MO_Authorizer),"^,");
	if( *MO_Authorizer == 0 )
		*MO_Authorizer = '-';

EXIT:
	if( *MO_Authorizer == '-' )
		return 0;
	if( authserv )
		wordscanX(MO_Authorizer,authserv,size);
	return MO_Authorizer;
}
doAuth(Conn,ident)
	Connection *Conn;
	AuthInfo *ident;
{	int rcode;
	char authserv[256],userpass[256];

	if( getMountAuthorizer(Conn,authserv,sizeof(authserv)) ){
	}else
	if( find_CMAP(Conn,AUTHSERV_MAP,authserv) < 0 )
		return 0;
	sprintf(userpass,"%s:%s",ident->i_user,ident->i_pass);
	rcode = doAUTH(Conn,NULL,NULLFP(),DST_PROTO,DST_HOST,0,
			userpass,ident->i_Host,NULL,NULL);
	if( strcmp(userpass,":") != 0 )
	sv1log("AUTHORIZER=%s host=[%s] user=[%s] -> %s\n",
		authserv,ident->i_Host,ident->i_user,rcode==0?"OK":"NO");
	if( rcode == 0 )
		return 1;
	else	return -1;
}
doAUTH(Conn,fc,tc,dstproto,dsthost,dstport,auser,ahost,func,arg)
	Connection *Conn;
	FILE *fc,*tc;
	char *dstproto,*dsthost,*auser,*ahost;
	int (*func)();
	char *arg;
{	int da;
	Port dflt;

	dflt = Conn->sv_dflt;
	da = doAUTH0(Conn,fc,tc,dstproto,dsthost,dstport,auser,ahost,func,arg);
	Conn->sv_dflt = dflt;
	return da;
}
doAUTH0(Conn,fc,tc,dstproto,dsthost,dstport,auser,ahost,func,arg)
	Connection *Conn;
	FILE *fc,*tc;
	char *dstproto,*dsthost,*auser,*ahost;
	int (*func)();
	char *arg;
{	char authserv[1024],phost[256];
	int identonly;
	int authorized;

/*
	if( ClientAuthUser[0] != 0 )
	if( source_permitted(Conn) )
*/
	if( streq(DST_PROTO,dstproto) )
	if( streq(DST_HOST,dsthost) )
	if( DST_PORT == dstport )
	{
		sv1log("#### already authorized\n");
		return 0;
	}
	set_SERVER(Conn,dstproto,dsthost,dstport);

	if( getMountAuthorizer(Conn,authserv,sizeof(authserv)) ){
		identonly = 0;
	}else
	if( 0 <= find_CMAP(Conn,IDENTIFY_MAP,authserv) ){
		identonly = 1;
	}else
	if( 0 <= find_CMAP(Conn,AUTHSERV_MAP,authserv) ){
		identonly = 0;
	}else{
		sv1log("#### no authorization required\n");
		return 0;
	}

	fprintf(tc,
		"<<<<<<<< Authorization for this proxy required.\r\n");

	for(;;){
		if( Identify(Conn,identonly,fc,tc,authserv,auser,ahost,phost,func,arg) )
			break;
		if( auser[0] == 0 )
			return EOF;
		if( fc == NULL )
			return EOF;
	}

	if( identonly ){
		fprintf(tc,
		"<<<<<<<< Ok, You are identified as <%s@%s>\r\n",auser,phost);
		authorized = service_authorized(Conn,auser,ahost);
	}else	authorized = 1;

	if( authorized ){
		fprintf(tc,
		"<<<<<<<< Ok, you <%s@%s> are an authorized user :-)\r\n",
			auser,phost);

		setClientAuth(Conn,"doAUTH",auser,ahost);
		return 0;
	}else{
		fprintf(tc,
		"!!!!!!!! USER <%s@%s> not permitted by DeleGate.\r\n",
			auser,phost);
		fflush(tc);
		return EOF;
	}
}

static connect_auth(OrigConn,proto,host,port,user,pass,path,svfp)
	Connection *OrigConn;
	char *proto,*host,*user,*pass,*path;
	FILE *svfp[];
{	int svsock,io[2];
	Connection ConnBuf,*Conn = &ConnBuf;
	char *dp,hostb[256];
	int xport;

	if( strchr(host,'/') ){
		wordScan(host,hostb);
		dp = strchr(hostb,'/');
		*dp++ = 0;
		if( 0 < (xport = atoi(dp)) ){
			sv1log("Authorizer: ftp://%s:%d -> xxx://%s:%d\n",
				host,port,hostb,xport);
			host = hostb;
			port = xport;
		}
	}

	if( CTX_auth_cache(OrigConn,0,180,proto,user,pass,host,port) )
		return 1;

	if( host[0] == '-' ){
		/* virtual auth host */
		return -1;
	}

	ConnInit(Conn);
	Conn->from_myself = 1;
	Conn->co_mask |= CONN_NOPROXY;

	set_realserver(Conn,proto,host,port);
	Socketpair(io);

	svsock = connect_to_servX(Conn,io[0],io[1],0,0);
	close(io[0]);
	close(io[1]);
	if( svsock < 0 ){
		sv1tlog("cannot connect: %s://%s@%s/\n",proto,user,host);
		return -1;
	}

	svfp[0] = fdopen(svsock,"r");
	svfp[1] = fdopen(svsock,"w");
	return 0;
}

authenticate_by_FTP(Conn,host,user,pass,path)
	Connection *Conn;
	char *host,*user,*pass,*path;
{	FILE *svfp[2];
	char resp[1024];
	int rcode;

	if( rcode = connect_auth(Conn,"ftp", host,21,user,pass,path,svfp) )
		return rcode;

	rcode = ftp_auth(svfp[1],svfp[0],resp,sizeof(resp),user,pass);
	fclose(svfp[0]);
	fclose(svfp[1]);

	if( rcode == EOF )
		return -1;
	else{
		CTX_auth_cache(Conn,1,180,"ftp",user,pass,host,21);
		return 0;
	}
}

extern char *HTTP_AUTHBASE;

authenticate_by_HTTP(Conn,host,user,pass,path)
	Connection *Conn;
	char *host,*user,*pass,*path;
{	FILE *svfp[2];
	int rcode;
	char buff[1024],authBASIC[1024],authMD5[1024],resp[1024],*dp;
	char me[256];
	int scode;
	char authpath[1024];

	sprintf(buff,"%s:%s",user,pass);
	toMD5(buff,authMD5);
	str_to64(buff,strlen(buff),authBASIC,sizeof(authBASIC),1);
	if( dp = strpbrk(authBASIC,"\r\n") )
		*dp = 0;
	ClientIF_name(Conn,ClientSock,me);

	if( rcode = connect_auth(Conn,"http",host,80,user,pass,path,svfp) )
		return rcode;
sprintf(authpath,"%s/%s/%s",HTTP_AUTHBASE,me,authMD5);
	fprintf(svfp[1],"HEAD %s HTTP/1.0\r\n",authpath);
	fprintf(svfp[1],"\r\n");
	fflush(svfp[1]);
	sv1log("HTTP-AUTH << path=%s user=%s\n",authpath,user);
	rcode = -1;
	if( fgets(resp,sizeof(resp),svfp[0]) != NULL ){
		sv1log("HTTP-AUTH >> %s",resp);
		if( sscanf(resp,"HTTP/%*s %d",&scode) )
			if( scode == 200 ){
				rcode = 0;
				goto EXIT;
			}
	}

	fclose(svfp[0]);
	fclose(svfp[1]);
	if( rcode = connect_auth(Conn,"http",host,80,user,pass,path,svfp) )
		return rcode;

sprintf(authpath,"%s/%s/%s",HTTP_AUTHBASE,me,user);
	fprintf(svfp[1],"HEAD %s HTTP/1.0\r\n",authpath);
	fprintf(svfp[1],"Authorization: Basic %s\r\n",authBASIC);
	fprintf(svfp[1],"\r\n");
	fflush(svfp[1]);
	sv1log("HTTP-AUTH << path=%s user=%s\n",authpath,user);
	rcode = -1;
	if( fgets(resp,sizeof(resp),svfp[0]) != NULL ){
		sv1log("HTTP-AUTH >> %s",resp);
		if( sscanf(resp,"HTTP/%*s %d",&scode) )
			if( scode == 200 ){
				rcode = 0;
				goto EXIT;
			}
	}

EXIT:
	fclose(svfp[0]);
	fclose(svfp[1]);
	return rcode;
}

typedef int (*IFUNC)();
typedef struct {
	char	*a_name;
	IFUNC	 a_func;
} AuthServ;
static AuthServ authenticators[] = {
	{"FTP",  authenticate_by_FTP	},
	/*{"HTTP", authenticate_by_HTTP	},*/
	/*{"RADIUS", authenticate_by_RADIUS },*/
	0
};

Authenticate(Conn,host,user,pass,path)
	Connection *Conn;
	char *host,*user,*pass,*path;
{	int rcode;
	int ai;
	int (*afunc)();

	rcode = -1;
	for( ai = 0; afunc = authenticators[ai].a_func; ai++ ){
		if( *user == 0 && *pass == 0 )
			continue;
		rcode = (*afunc)(Conn,host,user,pass,path);
		sv1log("## Auth/%s = %d\n",authenticators[ai].a_name,rcode);
		if( 0 <= rcode )
			return rcode;
	}
	return rcode;
}

CTX_preset_loginX(Conn,method,vurl,ident,path)
	Connection *Conn;
	char *method,*vurl;
	AuthInfo *ident;
	char *path;
{	char proto[128],site[1024];
	char pb[1024];

	if( CTX_mount_url_to(Conn,NULL,method,vurl) ){
		decomp_absurl(vurl,proto,site,pb,sizeof(pb));
		if( strchr(site,'@') ){
			/* with USER:PASS@SERVER */
			if( ident ) decomp_siteX("ftp",site,ident);
			if( path ) strcpy(path,pb);
			return 1;
		}
	}
	return 0;
}

unescape_user_at_host(email)
	char *email;
{	char *dp;

	if( strchr(email,'@') == 0 )
	if( dp = strrpbrk(email,"%") ){
		*dp = '@';
		return 1;
	}
	return 0;
}

extern double Time();
CTX_pushClientInfo(Conn)
	Connection *Conn;
{	VAddr sockhost;

	if( ClientSock < 0 ){
		bzero(&sockhost,sizeof(sockhost));
		/* maybe in UDP, thus it should be given in another way...
		 * as ClientIF_VAddr for example similarly to Client_VAddr.
		 */
	}else
	VA_HostPortIFclnt(Conn,ClientSock,NULL,NULL,&sockhost);
	VA_HL_pushClientInfo(Time(),Client_VAddr,&sockhost);
}

/*
 * MYAUTH=username:password[:proto[:dst[:src]]]
 * generating my (DeleGate's) authorization as a client of server/proxy
 */
scan_MYAUTH(Conn,myauth)
	Connection *Conn;
	char *myauth;
{	char myauthx[256],user[256],pass[256],proto[256],dst[256],src[256];

	user[0] = pass[0] = 0;
	strcpy(proto,"*");
	strcpy(dst,"*");
	strcpy(src,"*");
	scan_Listlist(myauth,':',user,pass,proto,dst,src,0);
	InitLog("MYAUTH=%s:****:%s:%s:%s\n",user,proto,dst,src);
	sprintf(myauthx,"{%s:%s}:%s:%s:%s",user,pass,proto,dst,src);
	scan_CMAP2(Conn,"MyAuth",myauthx);
}
get_MYAUTH(Conn,myauth,proto,dhost,dport)
	Connection *Conn;
	char *myauth,*proto,*dhost;
{	char xproto[256],xhost[256],user[256];
	Port sv;
	int xport;
	int mx;

	if( proto ){
		getREALPort(Conn,&sv);
		setREALPortl(Conn,proto,dhost,dport);
	}

	if( 0 <= (mx = find_CMAP(Conn,"MyAuth",myauth)) ){
		nonxalpha_unescape(myauth,myauth,1);
		wordscanY(myauth,user,sizeof(user),"^:");
		sv1log("MYAUTH=%s:**** for %s:%s:%d\n",user,
			REAL_PROTO,REAL_HOST,REAL_PORT);
	}

	if( proto )
		setREALPort(Conn,&sv);
	return 0 <= mx;
}

cpyPort(dst,src)
	Port *dst,*src;
{
	strcpy(dst->p_proto,src->p_proto);
	strcpy(dst->p_host, src->p_host);
	dst->p_port = src->p_port;
}
getREALPort(Conn,dst)
	Connection *Conn;
	Port *dst;
{
	cpyPort(dst,&Conn->sv);
}
setREALPort(Conn,src)
	Connection *Conn;
	Port *src;
{
	cpyPort(&Conn->sv,src);
}
setPort(dst,proto,host,port)
	Port *dst;
	char *proto,*host;
{
	wordScan(proto,dst->p_proto);
	wordScan(host,dst->p_host);
	dst->p_port = port;
}
setREALPortl(Conn,proto,host,port)
	Connection *Conn;
	char *proto,*host;
{
	setPort(&Conn->sv,proto,host,port);
}
