/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	ntod.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	Nov1994	created
ToDo:
	sort address list and binary search...
//////////////////////////////////////////////////////////////////////#*/

#include <stdio.h>
#include <ctype.h>
#include "ystring.h"

static scan4num(addr,av)
	char *addr;
	int *av;
{	char *ap,ch;
	int ai,ac,num;

	ap = addr;
	for( ac = 0; *ap && ac < 4; ac++ ){
		num = 0;
		while( ch = *ap ){
			ap++;
			if( ch == '.' )
				break;
			if( !isdigit(ch) )
				goto EXIT;
			num = num * 10 + (ch - '0');
		}
		av[ac] = num;
	}
EXIT:
	for( ai = ac; ai < 4; ai++ )
		av[ai] = 0;
	return ac;
}
static inetADDR(addr)
	char *addr;
{	int av[4];
	char ac,*ap;

	for( ap = addr; ac = *ap; ap++ )
		if( ac != '.' && (ac < '0' || '9' < ac) )
			return 0;

	scan4num(addr,av);
	return (av[0] << 24) | (av[1] << 16) | (av[2] << 8) | av[3];
}
static unsigned long inet_addr(addr)
	char *addr;
{	int av[4];

	if( scan4num(addr,av) == 4 )
	return (av[0] << 24) | (av[1] << 16) | (av[2] << 8) | av[3];
	return -1;
}

static getMASK(iaddr)
	unsigned int iaddr;
{	int a1,mask;

	a1 = (iaddr >> 24) & 0xFF;
	if( a1 < 128       ) mask = 0xFF000000; else
	if( a1 < 128+64    ) mask = 0xFFFF0000; else
	if( a1 < 128+64+32 ) mask = 0xFFFFFF00; else
			     mask = 0xFFFFFF00;
	return mask;
}

typedef struct {
	int	full;
	int	maskedL;
	int	maskedH;
	char	*name;
} DName;

static DName DnTab[0x10000];
static int DnTabX;

static load_dn1(addrL,addrH,name)
	char *addrL,*addrH,*name;
{	int addri;
	char *np;
	DName *dnp;

	dnp = &DnTab[DnTabX++];
	if( inet_addr(addrL) != -1 ){
		dnp->full = 1;
		dnp->maskedL = inet_addr(addrL);
		dnp->maskedH = inet_addr(addrH);
	}else{
		fprintf(stderr,"NOT FULL %s %s %s\n",addrL,addrH,name);
		addri = inetADDR(addrL);
		dnp->maskedL = addri & getMASK(addri);
		addri = inetADDR(addrH);
		dnp->maskedH = addri & getMASK(addri);
	}
	dnp->name = stralloc(name);
	for( np = dnp->name; *np; np++ )
		*np = tolower(*np);
}

static inet_range(addr)
	char *addr;
{	char addr0[128],addrx[128],*ap;
	int masklen,mask,addr1,addr2,mx,a1,a2;
	
	if( sscanf(addr,"%[^/]/%d",addr0,&masklen) != 2 )
		return;
	if( masklen < 24 )
		fprintf(stderr,"Warning: too long mask ? %s\n",addr);

	addr1 = inetADDR(addr0);
	mask = 0;
	for( mx = 0; mx < (32-masklen); mx++ )
		mask |= (1 << mx);
	addr2 = addr1 + mask;

	ap = addrx;
	*ap = 0;

	for( mx = 0; mx < 4; mx++ ){
		if( mx != 0 ){
			*ap++ = '.';
			*ap = 0;
		}
		a1 = (addr1 >> (8*(3 - mx))) & 0xFF;
		a2 = (addr2 >> (8*(3 - mx))) & 0xFF;

		if( a1 == a2 ){
			sprintf(ap,"%d",a1);
			ap += strlen(ap);
		}else{
			sprintf(ap,"[%d-%d]",a1,a2);
			break;
		}
	}
	strcpy(addr,addrx);
}

static fill(net,host,mask)
	char *net,*host;
{	char ch,*sp,*dp;
	int ndot;

	ndot = 0;
	dp = host;
	for( sp = net; ch = *sp; sp++ ){
		if( ch == '.' ){
			if( sp[1] == 0 )
				break;
			ndot++;
		}
		*dp++ = ch;
	}
	*dp = 0;
	for(; ndot < 3; ndot++ ){
		sprintf(dp,".%d",mask);
		dp += strlen(dp);
	}
}

static char dbfile0[1024];
static load_dntab(dbfile)
	char *dbfile;
{	FILE *dntab;
	char line[256];
	char *dp,addr[128],name[128];
	char min[128],max[128];
	int tabx;

	if( File_cmp(dbfile0,dbfile) == 0 )
		return;
	strcpy(dbfile0,dbfile);

	dntab = fopen(dbfile,"r");
	if( dntab == NULL )
		return;

	tabx = DnTabX;
	while( fgets(line,sizeof(line),dntab) != NULL ){
		if( dp = strchr(line,'#') )
			*dp = 0;
		if( line[0] == 0 )
			continue;

		dp = wordScan(line,addr);
		wordScan(dp,name);
		if( addr[0] == 0 || name[0] == 0 ){
			fprintf(stderr,"? %s",line);
			continue;
		}

		if( dp = strchr(addr,'/') )
			inet_range(addr);

		if( dp = strchr(addr,'[') ){
			char addrC[128],addrL[128],addrH[128];
			int aH,aL;

			strcpy(addrC,addr);
			*strchr(addrC,'[') = 0;
			sscanf(dp+1,"%d-%d",&aL,&aH);
			sprintf(addrL,"%s%d",addrC,aL);
			sprintf(addrH,"%s%d",addrC,aH);
			fill(addrL,min,0);
			fill(addrH,max,255);
			load_dn1(min,max,name);
		}else{
			fill(addr,min,0);
			fill(addr,max,255);
			load_dn1(min,max,name);
		}
	}
	fclose(dntab);
	fprintf(stderr,"LOADED %s [%d]\n",dbfile,DnTabX-tabx);
}

static char *getdomainbyaddr(iaddr)
{	int ma,ai;
	DName *dnp;

	ma = iaddr & getMASK(iaddr);
	for( ai = 0; ai < DnTabX; ai++ ){
		dnp = &DnTab[ai];
		if( dnp->full ){
			if( dnp->maskedL <= iaddr && iaddr <= dnp->maskedH )
				return dnp->name;
		}else{
			if( dnp->maskedL <= ma && ma <= dnp->maskedH )
				return dnp->name;
		}
	}
	return 0;
}

static is_inetaddr(addr)
	char *addr;
{	char *ap,ch;

	for( ap = addr; ch = *ap; ap++ ){
		if( ch != '.' && !isdigit(ch) )
			return 0;
		if( strchr(" \t\r\n",ch) )
			break;
	}
	return 1;
}
static strip_inaddr(host)
	char *host;
{	char *sp,*psp;
	int a1,a2,a3,a4;

	if( (sp = strstr(host,".IN-ADDR.ARPA"))
	 || (sp = strstr(host,".in-addr.arpa")) ){
		psp = NULL;
		for( sp--; host < sp; sp-- ){
			if( *sp == '.' ){
				if( sp[1] < '0' || '9' < sp[1] ){
					*psp = 0;
					break;
				}
				psp = sp;
			}
		}
		if( sscanf(host,"%d.%d.%d.%d",&a1,&a2,&a3,&a4) == 4 )
			sprintf(host,"%d.%d.%d.%d",a4,a3,a2,a1);
	}
}

static char *hostsfile;
extern char *getenv();

ntod_main(ac,av)
	char *av[];
{	char iline[4096],*sp,sc,*dp,class;
	char hostaddr[1024],*hp,prefix[1024],*remain;
	int a1;
	int ina;
	char *dom;
	char *dbfile;
	char *aliases,aliasb[1024];
	char hostsdb[1024];
	int ai,add_host;

	if( strstr(av[0],"uinc") )
		return uinc_main(ac,av);

	add_host = getenv("ADDHOST") != NULL;
	for( ai = 1; ai < ac; ai++ ){
		if( av[ai][0] == '+' )
			add_host = 1;
	}
	if( add_host )
		RES_verify("");

	dbfile = getenv("NETDOMDB");
	if( dbfile == NULL )
		dbfile = "./netdom";

	aliases = getenv("DOMALIAS");
	if( aliases == NULL ){
		strcpy(aliasb,dbfile);
		strcat(aliasb,".alias");
		aliases = aliasb;
	}

	hostsfile = getenv("HOSTSDB");
	if( hostsfile == NULL ){
		strcpy(hostsdb,dbfile);
		strcat(hostsdb,".hosts");
		hostsfile = hostsdb;
	}

	load_dntab(hostsfile);
	load_dntab(dbfile);

	RES_order("D",NULL);

	while( fgets(iline,sizeof(iline),stdin) != NULL ){
		if( dp = strpbrk(iline,"\r\n") )
			*dp = 0;

		hp = hostaddr;
		prefix[0] = 0;
		for( sp = iline; sc = *sp; sp++ ){
			if( sc == '@' ){
				*sp = 0;
				strcpy(prefix,iline);
				hp = hostaddr;
				continue;
			}
			if( sc==' '||sc=='\t'||sc=='\r'||sc=='\n' )
				break;
			if( isupper(sc) )
				*hp++ = tolower(sc);
			else	*hp++ = sc;
		}
		*hp = 0;
		remain = sp;

		if( dp = strstr(hostaddr,".-.") ) /* RIDENT forwarded */
			strcpy(hostaddr,dp+3);
		strip_inaddr(hostaddr);

		if( *hostaddr == 0 )
			goto PUT;

		if( ina = inetADDR(hostaddr) )
		if( dom = getdomainbyaddr(ina) ){
			strcpy(hostaddr,dom);
		}else
		if( add_host ){
			char addr_host[1024],addr[128],host[256];
			FILE *hostsdb_fp;

			if( RES_1s(hostaddr,addr_host) ){
				sscanf(addr_host,"%s %s",addr,host);
				strip_inaddr(host);
				load_dn1(addr,addr,host);

				if( hostsdb_fp = fopen(hostsfile,"a") ){
					fprintf(stderr,"++ %s",addr_host);
					fputs(addr_host,hostsdb_fp);
					fclose(hostsdb_fp);
				}
				strcpy(hostaddr,host);
			}
		}

		if( is_inetaddr(hostaddr) ){
			fprintf(stderr,"?? %s\n",hostaddr);
			a1 = atoi(hostaddr);
			if( a1 < 128       ) class = 'A'; else
			if( a1 < 128+64    ) class = 'B'; else
			if( a1 < 128+64+32 ) class = 'C'; else
					     class = 'D';
			dp = hostaddr;
			dp = strchr(dp+1,'.');
			if( dp == NULL )
				goto PUT;
			if( class != 'A' ){
				if( dp == NULL )
					goto PUT;
				dp = strchr(dp+1,'.');
				if( dp == NULL )
					goto PUT;
				if( class != 'B' ){
					dp = strchr(dp+1,'.');
					if( dp == NULL )
						goto PUT;
				}
			}
			*dp = 0;
			printf("%c:",class);
		}else{
			generic_domain(hostaddr);
		}
	PUT:
		fseek(stdout,0,2);
		if( prefix[0] != 0 )
			fprintf(stdout,"%s@",prefix);
		fputs(hostaddr,stdout);
		fputs(remain,stdout);
		fputs("\n",stdout);
		fflush(stdout);
	}
}


static reverse(line,rline)
	char *line,*rline;
{	char *p,*r;

	if( *line == 0 ){
		*rline = 0;
		return;
	}
	r = rline;
	for( p = line; *p; p++ )
		;
	if( line < p )
		p--;
	do *r++ = *p--; while( line <= p );
	*r = 0;
}

static struct {
	int	 d_lev;
	char	*d_name;
	char	*d_rev;
} domlev[] = {
	{2,     "kek.jp"},
	{2,     "ntt.jp"},
	{2, "nttdata.jp"},
	{3,       "=.jp"},
	{3,  "city.*.jp"},
	{3,  "pref.*.jp"},
	{4,         "aichi.jp"},
	{4,         "akita.jp"},
	{4,         "aomori.jp"},
	{4,         "chiba.jp"},
	{4,         "ehime.jp"},
	{4,         "fukui.jp"},
	{4,         "fukuoka.jp"},
	{4,         "fukushima.jp"},
	{4,         "gifu.jp"},
	{4,         "gunma.jp"},
	{4,         "hiroshima.jp"},
	{4,         "hokkaido.jp"},
	{4,         "hyogo.jp"},
	{4,         "ibaraki.jp"},
	{4,         "ishikawa.jp"},
	{4,         "iwate.jp"},
	{4,         "kagawa.jp"},
	{4,         "kagoshima.jp"},
	{4,         "kanagawa.jp"},
	{4,         "kochi.jp"},
	{4,         "kumamoto.jp"},
	{4,         "kyoto.jp"},
	{4,         "mie.jp"},
	{4,         "miyagi.jp"},
	{4,         "miyazaki.jp"},
	{4,         "nagano.jp"},
	{4,         "nagasaki.jp"},
	{4,         "nara.jp"},
	{4,         "niigata.jp"},
	{4,         "oita.jp"},
	{4,         "okayama.jp"},
	{4,         "okinawa.jp"},
	{4,         "osaka.jp"},
	{4,         "saga.jp"},
	{4,         "saitama.jp"},
	{4,         "shimane.jp"},
	{4,         "shizuoka.jp"},
	{4,         "shiga.jp"},
	{4,         "tochigi.jp"},
	{4,         "tokushima.jp"},
	{4,         "tokyo.jp"},
	{4,         "tottori.jp"},
	{4,         "toyama.jp"},
	{4,         "wakayama.jp"},
	{4,         "yamagata.jp"},
	{4,         "yamaguchi.jp"},
	{4,         "yamanashi.jp"},

	{4,         "kawasaki.jp"},
	{4,         "kitakyushu.jp"},
	{4,         "kobe.jp"},
	{4,         "nagoya.jp"},
	{4,         "sapporo.jp"},
	{4,         "sendai.jp"},
	{4,         "yokohama.jp"},

	{2,         "jp"},
	{3,       "=.ae"},
	{3,       "=.ar"},
	{3,       "=.at"},
	{3,       "=.au"},
	{3,      "oz.au"},
	{3,       "=.ba"},
	{3,       "=.be"},
	{3,       "=.bh"},
	{3,       "=.bo"},
	{3,       "=.bt"},
	{3,       "=.by"},
	{3,   "minsk.by"},
	{3,       "=.ca"},
	{3,       "ab.ca"},
	{3,       "bc.ca"},
	{3,       "mb.ca"},
	{3,       "nb.ca"},
	{3,       "ns.ca"},
	{3,       "nt.ca"},
	{3,       "on.ca"},
	{3,       "qc.ca"},
	{3,       "sk.ca"},
	{3,       "=.ci"},
	{3,       "=.co"},
	{3,       "=.cn"},
	{3,      "cq.cn"},
	{3,      "gd.cn"},
	{3,      "gx.cn"},
	{3,      "fj.cn"},
	{3,      "hb.cn"},
	{3,      "js.cn"},
	{3,      "jx.cn"},
	{3,      "ln.cn"},
	{3,      "sh.cn"},
	{3,      "sn.cn"},
	{3,      "zj.cn"},
	{3,       "=.cr"},
	{3,       "=.cu"},
	{3,       "=.cy"},
	{3,       "=.do"},
	{3,       "=.ec"},
	{3,       "=.ee"},
	{3,       "=.eg"},
	{3,    "asso.fr"},
	{3,    "gouv.fr"},
	{3,      "tm.fr"},
	{3,       "=.ge"},
	{3,       "=.gh"},
	{3,       "=.gr"},
	{3,       "=.gt"},
	{3,       "=.hk"},
	{3,       "=.id"},
	{3,       "=.il"},
	{3,       "=.in"},
	{3,   "ernet.in"},
	{3,       "=.ir"},
	{3,      "fe.it"},
	{3,       "=.jo"},
	{3,       "=.ke"},
	{3,       "=.kr"},
	{3,       "nm.kr"},
	{3,       "re.kr"},
	{3,       "=.kw"},
	{3,       "=.lb"},
	{3,       "=.lv"},
	{3,       "=.ma"},
	{3,     "af.mil"},
	{3,   "army.mil"},
	{3,   "navy.mil"},
	{3,   "disa.mil"},
	{3,       "=.mt"},
	{2,  "jaring.my"},
	{3,       "=.my"},
	{3,       "=.mx"},
	{3,     "uu.net"},
	{3,       "=.ng"},
	{3,       "=.ni"},
	{3,       "=.np"},
	{3,       "=.nz"},
	{3,       "=.om"},
	{3,       "=.pa"},
	{3,       "=.pe"},
	{3,       "=.pg"},
	{3,       "=.pk"},
	{3,       "=.pl"},
	{3,       "=.ph"},
	{3,       "=.py"},
	{3,       "=.qa"},
	{3,       "=.ro"},
	{3,       "=.ru"},
	{3,     "irk.ru"},
	{3,     "khv.ru"},
	{3,     "msk.ru"},
	{3,     "msk.su"},
	{3,     "nov.ru"},
	{3,     "nsc.ru"},
	{3,     "nsk.ru"},
	{3,     "nsk.su"},
	{3,     "spb.ru"},
	{3,     "spb.su"},
	{3,     "udm.ru"},
	{3,     "vrn.ru"},
	{3,   "tomsk.ru"},
	{3,"sakhalin.ru"},
	{3,       "=.sa"},
	{3,       "=.sg"},
	{3,       "=.sk"},
	{3,       "=.sv"},
	{3,       "=.th"},
	{3,       "=.tr"},
	{3,       "=.tt"},
	{3,       "=.tw"},
	{3,       "=.uk"},
	{3,       "=.ua"},
	{3,      "cn.ua"},
	{3,      "cv.ua"},
	{3,      "dp.ua"},
	{3,      "km.ua"},
	{3,      "lg.ua"},
	{3,      "te.ua"},
	{3,      "zp.ua"},
	{3,    "kiev.ua"},
	{3,"uzhgorod.ua"},
	{3,       "=.us"},
	{3,       "al.us"},
	{3,       "ar.us"},
	{3,       "az.us"},
	{3,       "ca.us"},
	{3,       "de.us"},
	{3,       "fl.us"},
	{3,       "ga.us"},
	{3,       "hi.us"},
	{3,       "ia.us"},
	{3,       "il.us"},
	{3,       "in.us"},
	{3,       "la.us"},
	{3,       "ks.us"},
	{3,       "ma.us"},
	{3,       "md.us"},
	{3,       "me.us"},
	{3,       "mi.us"},
	{3,       "mn.us"},
	{3,       "mo.us"},
	{3,       "ms.us"},
	{3,       "mt.us"},
	{3,       "nc.us"},
	{3,       "nj.us"},
	{3,       "nv.us"},
	{3,       "ny.us"},
	{3,       "oh.us"},
	{3,       "pa.us"},
	{3,       "tn.us"},
	{3,       "tx.us"},
	{3,       "ut.us"},
	{3,       "va.us"},
	{3,       "vt.us"},
	{3,       "wa.us"},
	{3,       "wi.us"},
	{3,       "=.uy"},
	{3,       "=.ve"},
	{3,       "=.vn"},
	{3,       "=.ws"},
	{3,       "=.ye"},
	{3,       "=.yu"},
	{3,       "=.za"},
	{3,       "=.zw"},
	{3,       "=.br"},
	0,
};
static char *attrs[16] = {
	"ac",
	"ad",
	"co",
	"ed",
	"go",
	"gr",
	"or",
	"ne",
	"com",
	"edu",
	"gov",
	"org",
	"net",
	0,
};
static char *rattrs[16];
static isattr(dom)
	char *dom;
{	char *ap,*dn,ac,pc,rattr[16];
	int ai,alen;

	if( rattrs[0] == NULL ){
		for( ai = 0; ap = attrs[ai]; ai++ ){
			reverse(ap,rattr);
			rattrs[ai] = stralloc(rattr);
		}
	}
	for( ai = 0; ap = rattrs[ai]; ai++ ){
		dn = dom;
		for( alen = 0;;alen++ ){
			pc = *ap++;
			ac = *dn++;
			if( pc == 0 && (ac == 0 || ac == '.') )
				return alen;
			if( pc != ac )
				break;
		}
	}
	return 0;
}

static domain_level(rfqdn)
	char *rfqdn;
{	int hi,hc;
	int alen;
	char *qn,qc,sqc;
	char *dn,rdn[128];

	if( domlev[0].d_rev == NULL ){
		for( hi = 0; dn = domlev[hi].d_name; hi++ ){
			reverse(dn,rdn);
			domlev[hi].d_rev = stralloc(rdn);
		}
	}
	for( hi = 0; dn = domlev[hi].d_rev; hi++ ){
		qn = rfqdn;
		for(;;){
			hc = *dn++;
			qc = *qn++;
			if( hc == '*' ){
				sqc = *dn; /* may be "." */
				while( qc != 0 && qc != sqc )
					qc = *qn++;
				if( qc == 0 )
					return domlev[hi].d_lev;
				dn++;
				continue;
			}
			if( hc == '=' ){
				if( alen = isattr(qn-1) ){
					qn += alen-1;
					continue;
				}
			}
			if( hc == 0 && qc == '.' )
				return domlev[hi].d_lev;
			if( hc == '?' )
				continue;
			if( hc != qc )
				break;
		}
	}
	return 0;
}

static generic_domain(hostaddr)
	char *hostaddr;
{	char rhostaddr[4096],*dp,dc;
	int lev,li;

	if( hostaddr[0] == 0 )
		return;

	reverse(hostaddr,rhostaddr);
	if( (lev = domain_level(rhostaddr)) == 0 )
		lev = 2;

	dp = rhostaddr;
	for( li = 0; li < lev; li++ ){
		for( dp++; dc = *dp; dp++ )
			if( dc == '.' )
				break;
		if( dc == 0 )
			return;
	}
	*dp = 0;
	reverse(rhostaddr,hostaddr);
}

/*
	 || strncmp(rhostaddr,"ee.",3) == 0
br??
*/

static uinc_main(ac,av)
	char *av[];
{	int ai;
	char *arg;
	char line[1024],*dp,date[128],host[128];
	FILE *in,*out;
	int hostid,serno;
	int REV,rev;
	int all;

	in = stdin;
	out = stdout;

	serno = 0;
	all = 0;
	REV = 0;

	for( ai = 1; ai < ac; ai++ ){
		arg = av[ai];
		if( strcmp(arg,"-a") == 0 )
			all = 1;
		else
		if( strcmp(arg,"-r") == 0 )
			REV = 1;
	}

	hostid = strid_create(0x10000);

	while( fgets(line,sizeof(line),in) != NULL ){
		if( sscanf(line,"%s %*s %*s %[^,]",date,host) == 2 ){
			rev = 1;
		}else
		if( sscanf(line,"%s %s",host,date) == 2 ){
			rev = 0;
		}else{
			printf("????\n%s\n",line);
			break;
		}
		if( all || !host_isisn(hostid,host,&serno) ){
			if( !REV && rev )
				fprintf(out,"%s %s\n",host,date);
			else	fprintf(out,"%s %s\n",date,host);
		}
	}
	return 0;
}
static host_isisn(hostid,host,sernop)
	char *host;
	int *sernop;
{	int len;
	char *dp,*suff,alias[128];

	if( strid(hostid,host,-1) != -1 )
		return 1;

	len = strlen(host);
	if( 6 < len ){
		dp = &host[len-6];
		suff = 0;
		if( strncasecmp(dp,".or.jp",6) == 0 ) suff = ".ne.jp"; else
		if( strncasecmp(dp,".ne.jp",6) == 0 ) suff = ".or.jp";
		if( suff ){
			strcpy(alias,host);
			strcpy(&alias[len-6],suff);
			if( strid(hostid,alias,-1) != -1 )
				return 1;
		}
	}

	*sernop += 1;
	strid(hostid,host,*sernop);
	return 0;
}

main(ac,av)
	char *av[];
{
	minit_resconf();
	minit_timer();
	ntod_main(ac,av);
}
VSocket(){ return -1; }
GetViaSocks(){ return 0; }
CTX_auth(){ return 0; }
bindViaSocks(){ return -1; }
acceptViaSocks(){ return -1; }
/*
Finish(code){ exit(code); }
setBinaryIO(){ }
*/

