/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1997-1999 Yutaka Sato
Copyright (c) 1997-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	windows0.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	970211	extracted from windows.c
//////////////////////////////////////////////////////////////////////#*/

#include <errno.h>
#ifndef LE
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#ifdef _MSC_VER
#include <sys/stat.h> /* S_IREAD,S_IWRITE */
#endif
#include <fcntl.h>

#define LE 1?0:
#define LT 1?0:
#define LV 1?0:
#define LW 1?0:
#endif

#ifdef _MSC_VER
/* ######## PIPE ######## */
int pipe(sv)
	int sv[2];
{	int rcode;

	rcode = _pipe(sv,4096,O_BINARY);
	LW("pipe() = %d [%d,%d]",rcode,sv[0],sv[1]);
	return rcode;
}
FILE *popen(command,mode)
	char *command,*mode;
{
	LV("popen(%s,%s)",command,mode);
	return _popen(command,mode);
}
pclose(fp)
	FILE *fp;
{
	LV("pclose(%x)",fp);
	return _pclose(fp);
}
/*
fcntl(fd){
	LE("fcntl(%d) NOT SUPPORTED",fd);
	return -1;
}
*/
ftruncate(fd,size)
{	int rcode;

	rcode = chsize(fd,size);
	LV("ftruncate(%d,%d) = %d",fd,size,rcode);
	return rcode;
}
/* stat() of Windows95 does not recognize "/dir/" as "/dir" */
stat(path,stp)
	char *path;
	struct stat *stp;
{	int rcode;
	char pathb[1024];

	if( rcode = _stat(path,stp) )
	if( path[0] && path[1] && strtailchr(path) == '/' ){
		Strncpy(pathb,path,strlen(path));
		rcode = _stat(pathb,stp);
	}
	return rcode;
}
#endif

#ifdef _MSC_VER
#define O_TEMPBIN	(O_TEMPORARY|O_BINARY)
/*
#define newtmp(path)	_open(path,O_CREAT|O_RDWR|O_TEMPBIN,S_IREAD|S_IWRITE)
*/
#define ACT_UNLINKABLE	0
#define FOPEN_RWB	"w+b"
#define closetmpf1(fd)	(0 < _get_osfhandle(fd) ? _close(fd) : -1)
#define fdopen		_fdopen
#else
#ifdef __EMX__
#define newtmp(path)	open(path,O_CREAT|O_RDWR,0600)
#define ACT_UNLINKABLE	0
#define FOPEN_RWB	"w+b"
#define closetmpf1(fd)	close(fd)
FILE *tmpfile(void){ return TMPFILEX(tmpnam(NULL)); }
#else
#define newtmp(path)	open(path,O_CREAT|O_RDWR,0600)
#define ACT_UNLINKABLE	1
#define FOPEN_RWB	"w+"
#define closetmpf1(fd)	close(fd)
#endif
#endif

#define MAXFD_SETSIZE 512 /* should be FD_SETSIZE ... */
typedef struct {
	char   *te_tmpfiles[MAXFD_SETSIZE];
} TmpfileEnv;
static TmpfileEnv *tmpfileEnv;
#define TE	tmpfileEnv[0]
#define tmpfiles	TE.te_tmpfiles
minit_tmpfile()
{
	if( tmpfileEnv == 0 )
		tmpfileEnv = (TmpfileEnv*)StructAlloc(sizeof(TmpfileEnv));
}

static deltmpfiles()
{	int ti;
	char *path;
	int rcode;
	int fd;

	for( fd = 3; fd < 256; fd++ )
		if( closetmpf1(fd) == 0 )
			LW("exit: close(%d) = 0",fd);

	/*
	for( ti = 0;  path = tmpfiles[ti]; ti++ ){
	*/
	for( ti = 0;  ti < MAXFD_SETSIZE; ti++ ){
	    if( path = tmpfiles[ti] ){
		errno = 0;
		rcode = unlink(path);
		LV("unlink(%s) = %d, errno=%d",path,rcode,errno);
	    }
	}
}

static addtmp(fd,npath)
	char *npath;
{	int rcode;
	char *opath;

	if( opath = tmpfiles[fd] ){
		rcode = unlink(opath);
		strfree(opath);
	}
	tmpfiles[fd] = stralloc(npath);
}

FILE *fopentmpfile(path,remove)
	char *path;
{	FILE *fp;
	int fd;

	if( ACT_UNLINKABLE ){
		if( fp = fopen(path,FOPEN_RWB) )
			if( remove )
				unlink(path);
	}else{
		fd = newtmp(path);
		if( 0 <= fd ){
			if( fp = fdopen(fd,FOPEN_RWB) ){
				addtmp(fd,path);
				/*
				tmpfiles[tmpfilex++] = stralloc(path);
				*/
				LV("fopentmpfile(%s) %x/%d",path,fp,fileno(fp));
			}else	LE("cannot fdopen(%d) %s",fd,path);
		}else{
			LE("cannot open tmpfile(%s)",path);
			fp = NULL;
		}
	}
	return fp;
}


#if !defined(O_NDELAY) && defined(FNDELAY)
#define O_NDELAY FNDELAY
#endif

#if !defined(O_NDELAY) && defined(O_NONBLOCK)
#define O_NDELAY O_NONBLOCK
#endif

#if !defined(O_NDELAY)
#define O_NDELAY -1
#endif

#if !defined(F_SETFD)
#define F_SETFD  -1
#endif
#if !defined(F_SETFL)
#define F_SETFL  -1
#define F_GETFL  -1
#endif

getNonblockingIO(fd)
{
	if( F_GETFL == -1 || O_NDELAY == -1 )
		return -1;

	return (fcntl(fd,F_GETFL,0) & O_NDELAY) != 0;
}
setCloseOnExec(fd)
{
	if( F_SETFD == -1 ){
		syslog_DEBUG("Close-On-Exec not supported\n");
		return -1;
	}

	return fcntl(fd,F_SETFD,1);
}
clearCloseOnExec(fd)
{
	if( F_SETFD == -1 )
		return -1;
	return fcntl(fd,F_SETFD,0);
}
