/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	urlesc.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	950421	extracted from url.c
//////////////////////////////////////////////////////////////////////#*/
#include <ctype.h>
#include <string.h>

#define ishex(ch)	(ch && strchr("0123456789abcdefABCDEF",ch))

unescape_specials(str,set,succ)
	char *str,*set,*succ;
{	char *ep,sx[3];
	int len,x;

	len = strlen(succ);
	if( ep = strchr(str,'%') ){
	    if( ishex(ep[1]) && ishex(ep[2]) && strncmp(&ep[3],succ,len)==0 ){
		sx[0] = ep[1];
		sx[1] = ep[2];
		sx[2] = 0;
		sscanf(sx,"%x",&x);
		if( strchr(set,x) ){
			ep[0] = x;
			ovstrcpy(&ep[1],&ep[3]);
		}
	    }
	}
}
#define tonum(hc) (\
	('0' <= hc && hc <= '9')?(hc - '0') : \
	('a' <= hc && hc <= 'f')?(hc - 'a') + 10 : \
	('A' <= hc && hc <= 'F')?(hc - 'A') + 10 : -1)

url_unescape(url,dst,siz,set)
	char *url,*dst,*set;
{	char *sp,*dp,*xp,ch;
	unsigned char x1,x2;
	int unesc;

	dp = url;
	xp = dst + siz - 1;
	unesc = 0;
	for( sp = url; ch = *sp; sp++ ){
		if( xp <= dp )
			break;
		x1 = sp[1];
		x2 = sp[2];
		if( ch == '%' && ishex(x1) && ishex(x2) ){
			*dp++ = (tonum(x1) << 4) | tonum(x2);
			sp += 2;
			unesc++;
		}else{
			if( dp == sp )
				dp++;
			else	*dp++ = ch;
		}
	}
	if( dp != sp )
		*dp = 0;
	return unesc;
}
nonxalpha_unescape(src,dst,spacealso)
	char *src,*dst;
{	char ch,*cp,sx[3];
	int num;
	int x;

	if( src != dst )
		strcpy(dst,src);

	num = 0;
	for( cp = dst; ch = *cp; cp++ )
		if( ch == '%' && ishex(cp[1]) && ishex(cp[2]) ){
			sx[0] = cp[1];
			sx[1] = cp[2];
			sx[2] = 0;
			sscanf(sx,"%x",&x);
			if( spacealso || !strchr(" \t\r\n",x) ){
				cp[0] = x;
				ovstrcpy(&cp[1],&cp[3]);
				num++;
			}
		}
	return num;
}
url_escapeY(src,dst,siz,escs,sbrk)
	char *src,*dst,*escs,*sbrk;
{	char ch,*sp,*dp;
	int in2byte,nesc;
	int nodflt,escspc,escbin,eschtm,escdel;
	int escctl;
	char *xp,buf[32];
	int len;

	nodflt = 0; /* turn ON when the url is already escaped */
	escctl = 0;
	escbin = 0;
	escspc = 0;
	eschtm = 0;
	escdel = 0;
	while( *escs == '%' ){
		if( escs[1] == '%' ){ nodflt = !nodflt; escs += 2; }else
		if( escs[1] == 'C' ){ escctl = 1; escs += 2; }else
		if( escs[1] == 'H' ){ escbin = 1; escs += 2; }else
		if( escs[1] == 'S' ){ escspc = 1; escs += 2; }else
		if( escs[1] == '&' ){ eschtm = 1; escs += 2; }else
		if( escs[1] == '#' ){ escdel = 1; escs += 2; }else
			break;
	}
	in2byte = 0;
	nesc = 0;
	dp = 0;
	xp = dst + (siz-1);

	for( sp = src; ch = *sp; sp++ ){
		if( sbrk && strchr(sbrk,ch) ){
			if( dp ){
				Strncpy(dp,sp,xp-dp);
				dp += strlen(dp);
			}
			break;
		}
		if( dp != 0 && 0 < siz && siz-1 <= dp-dst ){
			goto OVERFLOW;
		}
		if( ch == 033 ){
			switch( sp[1] ){
				case '$': in2byte = 1; break;
				case '(': in2byte = 0; break;
			}
		}
		if( !nodflt && ((ch & 0x80) || iscntrl(ch) || ch == '%')
		 || escctl && iscntrl(ch)
		 || escbin && (ch & 0x80)
		 || escspc && isspace(ch)
		 || in2byte == 0 && strchr(escs,ch) != 0
		){
			if( dp == 0 ){
				len = sp - src;
				if( siz <= len ){
					Strncpy(dst,src,siz);
					goto OVERFLOW;
				}
				bcopy(src,dst,len);
				dp = dst + len;
			}

			buf[0] = 0;
			if( escdel ){
				/* ignore the character */
			}else
			if( eschtm ){
				if( ch == '"' )
					sprintf(buf,"%%26quot%%3B");
				else	sprintf(buf,"%%26%%23%d%%3B",ch & 0xFF);
			}else{
				sprintf(buf,"%%%02x",ch & 0xFF);
			}
			if( buf[0] ){
				len = strlen(buf);
				if( xp <= dp+len ){
					goto OVERFLOW;
				}
				strcpy(dp,buf);
				dp += len;
			}
			nesc++;
		}else{
			if( dp != 0 )
				*dp++ = ch;
		}
	}
	if( dp != 0 && *dp != 0 )
		*dp = 0;

	return nesc;

OVERFLOW:
	if( dp && dp <= xp )
		*dp = 0;
	else	dst[siz-1] = 0;
	syslog_ERROR("## url_escapeX: buffer overrun(%d) %s\n",siz,dst);
	return nesc;
}
url_escapeX(src,dst,siz,escs,sbrk)
	char *src,*dst,*escs,*sbrk;
{	int nesc;
	char *xdst,escaped[4*1024];

	if( src == dst ){
		xdst = escaped;
		if( sizeof(escaped) < siz )
			siz = sizeof(escaped);
		xdst[0] = 0;
	}else{
		xdst = dst;
	}
	nesc = url_escapeY(src,xdst,siz,escs,sbrk);

	if( nesc == 0 && src != dst ){
		strcpy(dst,src);
	}else
	if( nesc != 0 && src == dst ){
		strcpy(dst,escaped);
	}
	return nesc;
}
/*
url_escape(src,dst,escs)
	char *src,*dst,*escs;
{
	url_escapeX(src,dst,0,escs,(char*)0);
}
*/

logurl_escapeX(src,dst,siz)
	char *src,*dst;
{
	url_escapeX(src,dst,siz," \t\r\n%\"<>",(char*)0);
}
nonxalpha_escapeX(src,dst,siz)
	char *src,*dst;
{
	url_escapeX(src,dst,siz," \t\n%?#",(char*)0);
}
safe_escapeX(src,dst,siz)
	char *src,*dst;
{
	url_escapeX(src,dst,siz," \t\n\"#%&'/<>?",(char*)0);
}

h2toi(h2)
	char *h2;
{	char hb[3];
	int i = -1;

	if( ishex(h2[0]) && ishex(h2[1]) ){
		hb[0] = h2[0]; hb[1] = h2[1]; hb[2] = 0;
		sscanf(hb,"%x",&i);
	}
	return i;
}
url_strstr(url,pat)
	unsigned char *url,*pat;
{	int plen,ulen,pch,uch,xuch,xpch;

	ulen = 0;
	for( plen = 0; pch = pat[plen]; plen++ ){
		uch = url[ulen++];
		if( uch == pch && uch != '%' )
			continue;
		if( uch == '%' ){
			xuch = h2toi(url+ulen);
			if( xuch == pch ){
				ulen += 2;
				continue;
			}
		}
		if( pch == '%' ){
			xpch = h2toi(pat+plen+1);
			if( xpch == uch ){
				plen += 2;
				continue;
			}
		}
		if( uch == '%' && pch == '%' ){
			if( xuch == xpch ){
				ulen += 2;
				plen += 2;
				continue;
			}
		}
		break;
	}
	if( pch == 0 )
		return ulen;
	else	return 0;
}
