/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	signal.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	960616	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "vsignal.h"

#if defined(SA_RESTART) || defined(sun)

#ifdef sun
/* an executalbe compiled on SunOS may be executed on Solaris,
 * therefore SA_RESTART given by preprocessor cannot be used.
 */
#undef SA_RESTART
#define SA_RESTART (IsSolaris() ? 4 : 0)
#endif

vfuncp BSDsignal(sig,func)
	void (*func)();
{	int rcode;
	struct sigaction sa;
	void (*ofunc)();

	rcode = sigaction(SIGHUP,NULL,&sa);
	if( rcode != 0 )
		return (vfuncp)-1;

	ofunc = sa.sa_handler;
	sa.sa_handler = func;
	sa.sa_flags = SA_RESTART;
	rcode = sigaction(SIGHUP,&sa,NULL);

	syslog_DEBUG("#### SIGACTION(%d)=%d handler:%x mask:%x flags: %x\n",
		sig,rcode,sa.sa_handler,sa.sa_mask,sa.sa_flags);

	if( rcode != 0 )
		return (vfuncp)-1;

	return ofunc;
}

#else
vfuncp BSDsignal(sig,func)
	void (*func)();
{
	return Vsignal(sig,func);
}
#endif

char *sigsym(sig)
{
	switch( sig ){
		case SIGHUP:	return "HUP";
		case SIGINT:	return "INT";
		case SIGPIPE:	return "PIPE";
		case SIGTERM:	return "TERM";
		case SIGSEGV:	return "SEGV";
		case SIGBUS:	return "BUS";
		case SIGTRAP:	return "TRAP";
		case SIGALRM:	return "ALRM";
		case SIGKILL:	return "KILL";
		case SIGCHLD:	return "CHLD";
		case SIGILL:	return "ILL";
		case SIGEMT:	return "EMT";
		case SIGFPE:	return "FPE";
		default:	return "???";
	}
}

static jmp_buf ps_env;
static void sigSEGV(){
	longjmp(ps_env,-1);
}
blockSEGVBUS(func,a1,a2,a3,a4)
	int (*func)();
	char *a1,*a2,*a3;
{	int rcode;

	void (*sSEGV)(),(*sBUS);
	sSEGV = Vsignal(SIGSEGV,sigSEGV);
	sBUS = Vsignal(SIGBUS,sigSEGV);

	if( setjmp(ps_env) == 0 )
		rcode = (*func)(a1,a2,a3,a4);
	else	rcode = -1;

	signal(SIGSEGV,sSEGV);
	signal(SIGBUS,sBUS);
	return rcode;
}
