/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1999 Yutaka Sato
Copyright (c) 1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	randstack.c (randomize stack base)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	020216	extracted from randstack.c and String.c
//////////////////////////////////////////////////////////////////////#*/
#include "ystring.h"

stackcopy(av,ac,asT,esT,areap,lengp,sizep)
	char *av[];
	char *asT,*esT;
	char **areap;
	int *lengp,*sizep;
{	char *a0T,*as,*es;
	int ai,offs;

	if( ac <= 1 ){
		a0T = esT;
	}else{
		/* move ex-argv[1-] to the end of ex-environ area */
		for( as = asT,es = esT; as && av[1] <= as; )
			*es-- = *as--;
		a0T = es + 1;

		/* adjust ex-argv[1-] pointers */
		offs = esT - asT;
		for( ai = 1; ai < ac; ai++ )
			av[ai] += offs;

		/* clear ex-argv[1-] buffers (might be optional) */
		{
			for( ai = 1; ai < ac; ai++ )
				for( as = av[ai]; *as; as++ )
					*as = ' ';
		}
	}

	/*
	 * clear extended argv[0] area
	 */
	for( as = &av[0][strlen(av[0])]+1; as < a0T; as++ )
		*as = ' ';

	if( areap ){
		*areap = av[0];
		*lengp = asT - av[0];
		*sizep = a0T - av[0];
	}
}

char *raw_Strncpy(s1,s2,n)
	char *s1,*s2;
	int n;
{	char *sp;

	sp = s1;
	while( 1 < n-- )
		if( (*sp++ = *s2++) == 0 )
			break;
	*sp = 0;
	return s1;
}

Strrplc(str,lendel,ins)
	char *str,*ins;
{	int lenstr,lenins;

	lenins = strlen(ins);
	lenstr = strlen(str);
	if( lendel != lenins )
		bcopy(str+lendel,str+lenins,lenstr-lendel+1);
	if( lenins != 0 )
		bcopy(ins,str,lenins);
}

uvinit(tagv,tagvb,nelem)
	UTag *tagv[],tagvb[];
{	int ui;

	for( ui = 0; ui < nelem; ui++ ){
		tagv[ui] = &tagvb[ui];
		bzero(tagv[ui],sizeof(UTag));
	}
	tagv[ui] = 0;
}
