/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	file.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	951029	extracted from DelaGate
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
extern FILE *tmpfile();
#include "ystring.h"
#include <ctype.h>
#include <errno.h>
extern char *getenv();

#ifdef S_ISUID /* set UID on execution */
#define IS_UNIX_FS
FS_maybeUnix(){ return 1; }
FS_withSetuid(){ return 1; }
#else
FS_maybeUnix(){ return 0; }
FS_withSetuid(){ return 0; }
#endif

#if defined(_MSC_VER) || defined(__CYGWIN__) || defined(__EMX__)
int FS_dosPath = 1;
#else
int FS_dosPath = 0;
#endif

#ifdef S_IFLNK
FS_withSymlink(){ return 1; }
#else
FS_withSymlink(){ return 0; }
#endif

#ifndef S_ISREG
#define S_ISREG(m)  (((m)&S_IFMT) == S_IFREG)
#endif

#ifndef S_ISDIR
#define S_ISDIR(m)  (((m)&S_IFMT) == S_IFDIR)
#endif

int File_stats(path,link,mode,uid,gid,size,mtime)
	char *path;
	int *mode,*uid,*gid,*size,*mtime;
{	struct stat st;
	int code;

	if( link )
		code = lstat(path,&st);
	else	code = stat(path,&st);
	if( code == 0 ){
		*mode = st.st_mode;
		*uid = st.st_uid;
		*gid = st.st_gid;
		*size = st.st_size;
		*mtime = st.st_mtime;
	}
	return code;
}
int File_ident(path,ident)
	char *path;
	char *ident;
{	struct stat st;

	if( stat(path,&st) == 0 ){
		sprintf(ident,"%x:%x:%x",st.st_dev,st.st_ino,st.st_ctime);
		return 0;
	}
	*ident = 0;
	return -1;
}
int File_is(path)
	char *path;
{	struct stat st;

	if( stat(path,&st) == 0 )
		return 1;
	else	return 0;
}
int File_isreg(path)
	char *path;
{	struct stat st;

	if( stat(path,&st) == 0 )
		return S_ISREG(st.st_mode);
	else	return 0;
}
int File_ctime(path)
	char *path;
{	struct stat st;

	if( stat(path,&st) == 0 )
		return st.st_ctime;
	else	return -1;
}
int File_mtime(path)
	char *path;
{	struct stat st;

	if( stat(path,&st) == 0 )
		return st.st_mtime;
	else	return -1;
}
int File_size(path)
	char *path;
{	struct stat st;

	if( stat(path,&st) == 0 )
		return st.st_size;
	else	return -1;
}
int File_uid(path)
	char *path;
{	struct stat st;

	if( stat(path,&st) == 0 )
		return st.st_uid;
	else	return 0;
}
int File_ino(path)
	char *path;
{	struct stat st;

	if( stat(path,&st) == 0 )
		return st.st_ino;
	else	return 0;
}
File_cmp(path1,path2)
	char *path1,*path2;
{	struct stat st1,st2;

	bzero(&st1,sizeof(st1));
	bzero(&st2,sizeof(st2));
	if( stat(path1,&st1) != 0 ) return -1;
	if( stat(path2,&st2) != 0 ) return -1;

/* st_dev will differ from each other for NFS files mounted by
 * different host name (even when they are same in IP address)
 * (/net/host/path != /net/alias/path)
 */
	if( st1.st_dev == st2.st_dev &&
	    st1.st_mtime == st2.st_mtime &&
	    st1.st_size == st2.st_size &&
	    st1.st_ino == st2.st_ino )
		return 0;
	else	return 1;
/*
return bcmp(&st1,&st2,sizeof(struct stat));
*/
}

fcompare(fp1,fp2)
	FILE *fp1,*fp2;
{	char buf1[1024],buf2[1024];
	int off1,off2;
	int rc1,rc2,ri;
	int diff;

	off1 = ftell(fp1);
	off2 = ftell(fp2);
	diff = 0;
	for(;;){
		rc1 = fread(buf1,1,1024,fp1);
		rc2 = fread(buf2,1,1024,fp2);
		if( rc1 != rc2 ){
			diff = 1;
			break;
		}
		if( rc1 == 0 )
			break;
		for( ri = 0; ri < rc1; ri++ )
			if( buf1[ri] != buf2[ri] ){
				diff = 1;
				break;
			}
	}
	fseek(fp1,off1,0);
	fseek(fp2,off2,0);
	return diff;
}

Ftruncate(fp,offset,whence)
	FILE *fp;
{	long savoff;
	int rcode;

	savoff = ftell(fp);
	fseek(fp,offset,whence);
	rcode = ftruncate(fileno(fp),(off_t)ftell(fp));
	fseek(fp,savoff,0);
	return rcode;
}

extern char *getcwd();
static char *_pathsep;
static char *_PATHSEP(){
	char cwd[1024];
	if( _pathsep == NULL ){
		getcwd(cwd,sizeof(cwd));
		if( strchr(cwd,'\\') )
			_pathsep = "\\";
		else	_pathsep = "/";
	}
	return _pathsep;
}

FullpathOfExe(path)
	char *path;
{	char xpath[1024];

	if( isFullpath(path) )
		return 1;

	if( getcwd(xpath,sizeof(xpath)) == NULL )
		return 0;

	strcat(xpath,_PATHSEP());
	strcat(xpath,path);

	if( File_mtime(xpath) != -1 ){
		strcpy(path,xpath);
		return 1;
	}

	/* should scan getenv("PATHEXT") ... */
	strcat(xpath,".exe");
	if( File_mtime(xpath) != -1 ){
		strcpy(path,xpath);
		return 1;
	}
	return 0;
}

static int colonForDrive;
ColonForDrive()
{	FILE *fp;
	char path[1024];

	if( colonForDrive == 0 ){
		/* cannot use ':' in a file name if on Windows */

		getcwd(path,sizeof(path));
		if( isalpha(path[0]) && path[1] == ':' )
			colonForDrive =  1;
		else{
			sprintf(path,"/tmp/%d:%d",time(0),getpid());
			if( fp = fopen(path,"w") ){
				fclose(fp);
				unlink(path);
				colonForDrive = -1;
			}else	colonForDrive =  1;
		}
	}
	return 0 < colonForDrive;
}

char *fullPath(path,buff)
	char *path,*buff;
{
#ifndef IS_UNIX_FS
	/*
	 * //X/path -- OpenNT -- X:/path
	 */ 
	if( path[0] == '/' && path[1] == '/'
	 && 'A' <= path[2] && path[2] <= 'Z'
	 && path[3] == '/' )
	{
		buff[0] = path[2];
		buff[1] = ':';
		strcpy(&buff[2],&path[3]);
		path = buff;
	}
#endif
	return path;
}
isFullpath(path)
	char *path;
{
	if( FS_dosPath || *_PATHSEP() == '\\' ){
		if( isalpha(path[0]) && path[1] == ':' ){
			if( path[2] == '\\' || path[2] == '/' )
				return 3;
			else	return 2;
		}
		if( path[0] == '\\' )
			return 1;
	}
	if( path[0] == '/' )
		return 1;
	return 0;
}
isBoundpath(path)
	char *path;
{
	if( isFullpath(path) )
		return 1;
	if( path[0] == '.' ){
		if( path[1] == 0 )
			return 1;
		if( path[1] == *_PATHSEP() )
			return 1;
		if( path[1] == '/' )
			return 1;
	}
	return 0;
}
chdir_cwd(cwd, go, userdir)
	char *cwd,*go;
{	char *tp,*cp;
	int uplen,len;

	for( tp = cwd; *tp; tp++ ){}
	if( len = isFullpath(go) ){
		tp = cwd;
		while( 0 < len-- )
			*tp++ = *go++;
	}else
	if( userdir && go[0] == '~' ){
		if( go[1] == 0   ){ tp = cwd; go += 1; }else
		if( go[1] == '/' ){ tp = cwd; go += 2; }
	}

	while( *go ){
		uplen = 0;
		if( go[0] == '.' ){
			if( go[1] == 0   ){ go += 1; break; }
			if( go[1] == '/' ){ go += 2; continue; }
			if( go[1] == '.' ){
				if( go[2] == 0   ){ uplen = 2; } else
				if( go[2] == '/' ){ uplen = 3; }
			}
		}
		if( uplen ){
			if( cwd < tp ){
				while( cwd+1 < tp ){
					if( tp[-1] == '/' )
						tp--;
					else	break;
				}
				*tp = 0;
				if( cp = strrchr(cwd,'/') ){
					if( cp == cwd  )
						tp = cp + 1;
					else	tp = cp;
				}else	tp = cwd;
			}
			go += uplen;
		}else{
			if( cp = strchr(go,'/') )
				len = (cp - go) + 1;
			else	len = strlen(go);

			if( cwd < tp && tp[-1] != '/' )
				*tp++ = '/';
			strncpy(tp,go,len);
			tp += len;
			go += len;
		}
	}
	while( cwd+1 < tp ){
		if( tp[-1] == '/' )
			tp--;
		else	break;
	}
	*tp = 0;
}

static int _TMPSEQ;
static int _TMPDIR_set;
#ifdef IS_UNIX_FS
static char *_TMPDIR;
#else
static char *_TMPDIR = "\\tmp";
#endif

char *getTMPDIR(){ return _TMPDIR; }

static void *shared_frex;
extern void *frex_append();

static normpath(src,dst)
	char *src,*dst;
{	char *dp,*sp;

	dp = dst;
	for( sp = src; *dp++ = *sp; sp++ ){
		if( *sp == '/' && sp[1] == '/' )
			sp++;
	}
	*dp++ = 0;
}

setSHARE(pathpat)
	char *pathpat;
{	char xpathpat[1024];

	normpath(pathpat,xpathpat);
	shared_frex = frex_append(shared_frex,xpathpat);
	return 0;
}
static beshared(path,isdir)
	char *path;
{	int match;
	char xpath[1024];

	if( shared_frex == 0 )
		return 0;

	normpath(path,xpath);
	if( isdir && strtailchr(xpath) != '/' )
		strcat(xpath,"/");

	match = frex_match(shared_frex,xpath);
	return match;
}

static char *OWNER_DIR;
static int OWNER_UID = -1;
static int OWNER_GID = -1;

setOWNER(dir,uid,gid)
	char *dir;
{
	OWNER_DIR = stralloc(dir); 
	OWNER_UID = uid;
	OWNER_GID = gid;
}
static bemine(path,uidp,gidp)
	char *path;
	int *uidp,*gidp;
{
	if( OWNER_DIR == 0 || OWNER_UID < 0 )
		return 0;
	/*if( strstr(path,OWNER_DIR) )*/
	{
		*uidp = OWNER_UID;
		*gidp = OWNER_GID;
		return 1;
	}
	return 0;
}
chmodShared(path)
	char *path;
{	int uid,gid,isdir;

	if( bemine(path,&uid,&gid) )
		chown(path,uid,gid);
	isdir = fileIsdir(path);
	if( beshared(path,isdir) ){
		if( isdir )
			chmod(path,0777);
		else	chmod(path,0666);
	}
}
FILE *fopenShared(path,mode)
	char *path,*mode;
{	FILE *fp;
	int uid,gid;
	int mine;

	fp = fopen(path,mode);
	mine = bemine(path,&uid,&gid);
	if( fp == NULL &&  mine ){
		if( getuid() == 0 && uid != 0 ){
			seteuid(uid);
			fp = fopen(path,mode);
			seteuid(0);
		}
	}
	if( fp != NULL )
		chmodShared(path);
	return fp;
}
extern FILE *fopentmpfile();
FILE *fopentmpfileShared(path,remove)
	char *path;
{	FILE *fp;
	int mine,uid,gid;

	mine = bemine(path,&uid,&gid);
	fp = fopentmpfile(path,remove);
	if( fp == NULL && mine ){
		if( getuid() == 0 && uid != 0 ){
			seteuid(uid);
			fp = fopentmpfile(path,remove);
			seteuid(0);
		}
	}
	return fp;
}
mkdirShared(dir,mode)
	char *dir;
{	int uid,gid,rcode;
	int share,mine;

	if( mode == 0 )
		mode = 0755;
	share = beshared(dir,1);
	mine = bemine(dir,&uid,&gid);
	rcode = mkdir(dir,mode);
	if( rcode != 0 && mine ){
		if( getuid() == 0 && uid != 0 ){
			seteuid(uid);
			rcode = mkdir(dir,mode);
			seteuid(0);
		}
	}
	if( mine )
		chown(dir,uid,gid);
	if( share )
		chmod(dir,0777);
	return rcode;
}
chmodIfShared(file,mode)
	char *file;
{	int uid,gid;

	if( bemine(file,&uid,&gid) )
		chown(file,uid,gid);
	if( !beshared(file,0) )
		return -1;
	return chmod(file,mode);
}

setTMPDIR(dir)
	char *dir;
{	char buff[1024];

	if( dir ){
		if( _TMPDIR && _TMPDIR_set )
			free(_TMPDIR);
		_TMPDIR = stralloc(fullPath(dir,buff));
		_TMPDIR_set = 1;
	}
}

FILE *TMPFILEXX(what,path)
	char *what,*path;
{	char *tmpdir,pathb[1024],buff[1024];
	FILE *fp;

	tmpdir = _TMPDIR;
	if( tmpdir == NULL ){
		if( path == NULL )
			return NULL;
		if( (tmpdir = getenv("TMPDIR")) == NULL )
			tmpdir = "/tmp";
	}
	if( !fileIsdir(tmpdir) )
		mkdirShared(tmpdir,0);

	if( path == NULL )
		path = pathb;
	sprintf(path,"%s/dg%d.%d.%d",tmpdir,getpid(),++_TMPSEQ,time(0));

	errno = 0;
	fp = fopentmpfileShared(fullPath(path,buff),path==pathb);

	if( fp != NULL )
		syslog_DEBUG("TMPFILE(%s) = (%d) %s\n",what,fileno(fp),path);
	else	syslog_ERROR("TMPFILE(%s): cannot create (%d) = %s\n",what,errno,path);
	return fp;
}
FILE *TMPFILEX(path)
	char *path;
{
	return TMPFILEXX("*",path);
}

#ifndef EMFILE
#define EMFILE -1
#endif

FILE *TMPFILE(what)
	char *what;
{	FILE *fp;
	int besilent;
	char *tmpdir;

	fp = TMPFILEXX(what,NULL);
	if( fp == NULL )
		fp = tmpfile();

	besilent = what[0] == '-';

	if( fp != NULL ){
		setCloseOnExec(fileno(fp));
		if( !besilent )
		syslog_DEBUG(">>>TMPFILE(%s)>>>%x[%d]\n",what,fp,fileno(fp));
	}else{
		tmpdir = _TMPDIR;
		if( tmpdir == NULL )
			tmpdir = "(system default, may be /tmp or /usr/tmp)";
		syslog_ERROR(">>>TMPFILE(%s)>>> cannot create.\n",what);
		if( errno == EMFILE ){
			syslog_ERROR(">>> Too many open files.\n");
		}else{
			syslog_ERROR(">>> You MUST have the WRITE permission\n");
			syslog_ERROR(">>> to the TMPDIR=%s\n",tmpdir);
		}
		exit(0);
	}
	return fp;
}

static int tmpfiles[1] = {-1};
static int tmpfilepids[1];
FILE *reusableTMPFILE(what,where)
	char *what;
	int (*where)();
{	FILE *tmp;
	int tx,fd,pid;

	tx = 0;
	fd = tmpfiles[tx];
	pid = getpid();

	if( 0 <= fd && tmpfilepids[0] == pid ){
		lseek(fd,0,0);
		tmp = fdopen(dup(fd),"w+");
		Ftruncate(tmp,0,0);
		syslog_DEBUG(">>>TMPFILE(%s) reused [%d]->[%d]\n",what,
			fd,fileno(tmp));
	}else{
		tmp = TMPFILE(what);
		tmpfiles[tx] = dup(fileno(tmp));
		tmpfilepids[tx] = pid;
	}
	return tmp;
}


FILE *Tmpfile()
{
	return TMPFILE("Tmpfile");
}

#ifdef NULLFP
#undef NULLFP /* defined in <sys/file.h> of Solaris */
#endif

FILE *NULLFP(){
	static FILE *NULLFP;
	FILE *tmp;

	if( NULLFP == NULL ){
		tmp = TMPFILE("NULLFP");
		/*close(fileno(NULLFP)); should hold to avoid reuse */
		NULLFP = fdopen(fileno(tmp),"r");
	}
	return NULLFP;
}

openNull(rw){
	int xfd;
	FILE *xfp;

	xfd = open("/dev/null",rw);
	if( 0 <= xfd )
		return xfd;

	xfp = TMPFILE("openNull");
	if( xfp != NULL ){
		xfd = dup(fileno(xfp));
		fclose(xfp);
		clearCloseOnExec(xfd);
		return xfd;
	}
	return -1;
}

copyfile2(sfp,dfp,doflush)
	FILE *sfp,*dfp;
{	char buff[8*1024];
	int totalc,rcc;

	totalc = 0;
	for(;;){
		rcc = fread(buff,1,sizeof(buff),sfp);
		if( rcc == 0 )
			break;
		totalc += rcc;
		if( fwrite(buff,1,rcc,dfp) == 0 )
			break;
	}
	if( doflush )
		fflush(dfp);
	return totalc;
}

copyfile1(sfp,dfp)
	FILE *sfp,*dfp;
{
	return copyfile2(sfp,dfp,1);
}


path_escchar(path)
	char *path;
{	char sc,*sp,*dp;
	char *buff;

	if( !ColonForDrive() )
		return;

	if( isalpha(path[0]) && path[1] == ':' )
		path += 2;

	if( strpbrk(path,":") == NULL && strstr(path+2,"./") == NULL )
		return;

	buff = stralloc(path);
	dp = path;
	for( sp = buff; sc = *sp; sp++ ){
		if( sc == '.' && sp[1] == '/' ){
			*dp++ = '%';
			*dp++ = '2';
			*dp++ = 'E';
		}else
		if( sc == ':' ){
			if( sp[1] == '/' ){
				*dp++ = '%';
				*dp++ = '3';
				*dp++ = 'A';
			}else{
				*dp++ = '.';
				*dp++ = '.';
			}
		}else	*dp++ = sc;
	}
	*dp = 0;
	free(buff);
}

int file_isreg(fd)
{	struct stat status;

	if( fstat(fd,&status) == 0 )
		return S_ISREG(status.st_mode);
	return 0;
}
int file_isregular(fd)
{	struct stat st;

	if( fstat(fd,&st) == 0 )
		return S_ISREG(st.st_mode) || S_ISDIR(st.st_mode);
	else	return 0;
}
int file_isdir(fd)
{	struct stat stat;

	if( fstat(fd,&stat) == 0 )
		return S_ISDIR(stat.st_mode);
	return 0;
}
int fileIsdir(path)
	char *path;
{	struct stat status;

	if( stat(path,&status) == 0 )
		return S_ISDIR(status.st_mode);
	return 0;
}
int fileIsflat(path)
	char *path;
{	struct stat status;

	if( stat(path,&status) == 0 )
		return S_ISDIR(status.st_mode) == 0;
	return 0;
}

extern char *malloc();
char *freadfile(fp,sizep)
	FILE *fp;
	int *sizep;
{	FILE *tmp;
	char *data;
	int size,rcc;

	if( size = *sizep ){
		data = malloc(size+1);
		rcc = fread(data,1,size,fp);
	}else{
		tmp = TMPFILE("freadfile");
		size = copyfile1(fp,tmp);
		fflush(tmp);
		fseek(tmp,0,0);
		data = malloc(size+1);
		rcc = fread(data,1,size,tmp);
		fclose(tmp);
	}
	data[rcc] = 0;
	*sizep = rcc;
	return data;
}

ftouch(fp,time)
	FILE *fp;
{	int off;

	off = ftell(fp);
	fseek(fp,0,2);
	fwrite("",1,1,fp);
	fflush(fp);
	fseek(fp,-1,2);
	Ftruncate(fp,0,1);
	fseek(fp,off,0);
}
File_touch(path,clock)
	char *path;
{	FILE *fp;

	if( fp = fopen(path,"a") ){
		ftouch(fp,clock);
		fclose(fp);
	}
}
char *Fgets(str,size,fp)
	char *str;
	FILE *fp;
{	char *rstr;
	char *dp;

	rstr = fgets(str,size,fp);
	if( rstr != NULL )
		if( dp = strpbrk(str,"\r\n") )
			*dp = 0;
	return rstr;
}
Fputs(str,fp)
	char *str;
	FILE *fp;
{	char *dp;
	int rcode;

	/* signal(SIGPIPE,... */

	if( strchr(str,'\r') == 0 ){
		if( dp = strchr(str,'\n') )
			strcpy(dp,"\r\n");
		else	strcat(str,"\r\n");
	}

	rcode = fputs(str,fp);
	fflush(fp);
	return rcode;
}
Write(fd,buf,len)
	char *buf;
{	int nw,wcc,wc1;

	nw = 0;
	for(wcc = 0; wcc < len; wcc += wc1 ){
		nw++;
		wc1 = write(fd,buf+wcc,len-wcc);
		if( wc1 <= 0 )
			break;
	}
	return wcc;
}
Fwrite(buf,esize,ecount,fp)
	char *buf;
	FILE *fp;
{	int re,we;
	int fd;

	re = ecount;
	fd = fileno(fp);
	do {
		we = fwrite(buf,esize,re,fp);
		if( we != re )
		syslog_ERROR("Fwrite(%d): partial (%d/%d/%d) NBIO=%d errno=%d\n",
			fd,we,re,ecount,getNonblockingIO(fd),errno);

		if( we <= 0 )
			break;
		else	re -= we;
	} while( 0 < re );
	return ecount - re;
}


static int tmpFileFd = -1;
static int tmpFilePid = -1;
static char *tmpFileWhat = "";

freeTmpFile(what)
	char *what;
{
	if( 0 <= tmpFileFd ){
		close(tmpFileFd);
		tmpFileFd = -1;
		tmpFilePid = -1;
		tmpFileWhat = "";
	}
}
FILE *getTmpFile(what)
	char *what;
{	FILE *fp;
	int pid;
	char msg[1024];

	pid = getpid();
	sprintf(msg,"getTmpFile: fd=%d [%d]%s->[%d]%s",
		tmpFileFd,tmpFilePid,tmpFileWhat,pid,what);

	if( 0 < tmpFileFd ){
		if( tmpFilePid != pid || tmpFileWhat != what ){
			syslog_ERROR("#### %s\n",msg);
			tmpFileFd = -1;
			freeTmpFile(what);
		}
	}
	syslog_DEBUG("%s\n",msg);
	if( tmpFileFd < 0 ){
		fp = TMPFILE(what);
		tmpFileFd = dup(fileno(fp));
		tmpFilePid = pid;
		tmpFileWhat = what;
	}else{
		fp = fdopen(dup(tmpFileFd),"r+");
		fseek(fp,0,0);
	}
	return fp;
}

extern char **dupv();
char **vect_PATH(path)
	char *path;
{	char pathb[2048],del;
	char *pathv[16];
	char **ppv;
	int lc;

	strcpy(pathb,path);
	if( strchr(pathb,';') ) /* Windows */
		del = ';';
	else	del = ':';
	lc = list2vect(pathb,del,15,pathv);
	pathv[lc] = 0;
	ppv = dupv(pathv,0);
	return ppv;
}
/*
 * "/" in PATH like "/Program Files/DeleGate/lib/"
 * should be replaced with "\" (_PATHSEP())
 */
FILE *fopen_PATH(pathv,file,mode,xpath)
	char *pathv[];
	char *file,*mode,*xpath;
{	int li;
	char *dir1,path1[1024];
	FILE *fp;

	for( li = 0; dir1 = pathv[li]; li++ ){
		if( *dir1 == 0 || strcmp(dir1,".") == 0 )
			strcpy(path1,file);
		else
		if( strtailstr(dir1,_PATHSEP()) )
			sprintf(path1,"%s%s",dir1,file);
		else	sprintf(path1,"%s%s%s",dir1,_PATHSEP(),file);
		if( *mode == 'x' )
			fp = fopen(path1,"r");
		else	fp = fopen(path1,mode);

		if( errno == EACCES && fileIsdir(path1) ){
			syslog_ERROR("WARNING: fopen_PATH(%s):isdir %s\n",
				mode,path1);
			fp = TMPFILE("fopen_PATH-DIR");/* dummy for Win32 */
		}

		syslog_DEBUG("### [%d] %s %x\n",li,path1,fp);
		if( fp != NULL ){
			if( xpath ){
				if( *dir1 == 0 || strcmp(dir1,".") == 0 ){
					getcwd(xpath,256);
					strcat(xpath,_PATHSEP());
					strcat(xpath,path1);
				}
				else
				strcpy(xpath,path1);
			}
			return fp;
		}
	}
	return NULL;
}
FILE *fopen_PATHLIST(pathlist,file,mode,xpath)
	char *pathlist,*file,*mode,*xpath;
{	char **lpathv;
	FILE *fp;

	lpathv = vect_PATH(pathlist);
	fp = fopen_PATH(lpathv,file,mode,xpath);
	free(lpathv);
	return fp;
}
FILE *fopen_LIBPATH(file,mode,xpath)
	char *file,*mode,*xpath;
{	FILE *fp;
	char *libpath;

	if( isFullpath(file) ){
		if( fp = fopen(file,mode) )
			strcpy(xpath,file);
		else	xpath[0] = 0;
	}else
	if( libpath = getenv("LIBPATH") )
		fp = fopen_PATHLIST(libpath,file,mode,xpath);
	else	fp = 0;
	return fp;
}
LIBFILE_IS(file,rxfile)
	char *file,*rxfile;
{	FILE *fp;
	char afile[1024],*xfile,xfileb[1024];

	if( rxfile )
		rxfile[0] = 0;
	if( file == NULL )
		return 0;

	if( rxfile )
		xfile = rxfile;
	else	xfile = xfileb;

	if( fp = fopen_LIBPATH(file,"r",xfile) ){
		fclose(fp);
		if( rxfile && rxfile[0] == 0 )
			strcpy(rxfile,file);
		return 1;
	}
	return 0;
}
