/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	strings.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	940821	extracted from DeleGate/src/misc.c
//////////////////////////////////////////////////////////////////////#*/
#include <errno.h>
#include <ctype.h>
#include "ystring.h"
extern char *malloc();
extern char *realloc();

isdigits(str)
	char *str;
{	char *sp,ch;

	if( *str == 0 )
		return 0;

	for( sp = str; ch = *sp; sp++ )
		if( !isdigit(ch) )
			return 0;
	return 1;
}
isdigit2(str)
	char *str;
{
	return isdigit(str[0]) && isdigit(str[1]);
}
Isalnum(ch)
{
	return isalnum(ch);
}
char *Isnumber(str)
	char *str;
{
	if( (*str == '-' || *str == '+') && isdigit(str[1]) )
		str++;

	if( isdigit(*str) ){
		while( isdigit(*str) )
			str++;
		return str;
	}
	return 0;
}
kmxatoi(ai)
	char *ai;
{	char *dp;
	int n;

	if( dp = Isnumber(ai) ){
		n = atoi(ai);
		switch( *dp ){
			case 'k': case 'K': n *= 1024; break;
			case 'm': case 'M': n *= 1024 * 1024; break;
		}
		return n;
	}
	return 0;
}


int strcaseeq(a,b)
	char *a,*b;
{
	if( a == b )
		return 1;
	if( toupper(*a) != toupper(*b) )
		return 0;
	return strcasecmp(a,b) == 0;
}
int strncaseeq(a,b,n)
	char *a,*b;
{
	return strncasecmp(a,b,n) == 0;
}

char *strtoupper(s1,s2)
	char *s1,*s2;
{	unsigned char ch;

	while( ch = *s1++ )
		*s2++ = islower(ch) ? toupper(ch) : ch;
	*s2++ = 0;
	return s2;
}
char *strtolower(s1,s2)
	char *s1,*s2;
{	unsigned char ch;

	while( ch = *s1++ )
		*s2++ = isupper(ch) ? tolower(ch) : ch;
	*s2++ = 0;
	return s2;
}
char *skipspaces(str)
	char *str;
{	char *sp,sc;

	for( sp = str; sc = *sp; sp++ )
		if( !isspace(sc) )
			break;
	return sp;
}
char *nextword(str)
	char *str;
{	char *sp,sc;

	for( sp = str; sc = *sp; sp++ )
		if( isspace(sc) )
			break;
	return skipspaces(sp);
}
delspaces(dst,src)
	char *dst,*src;
{	char *dp,*sp,sc;

	dp = dst;
	for( sp = src; sc = *sp; sp++ ){
		if( !isspace(sc) ){
			if( dp != sp )
				*dp = sc;
			dp++;
		}
	}
	if( dp != sp )
		*dp = 0;
	return sp - dp;
}
del8bits(dst,src)
	char *dst,*src;
{	char *dp,*sp,sc;

	dp = dst;
	for( sp = src; sc = *sp; sp++ ){
		if( (sc & 0x80) == 0 ){
			if( dp != sp )
				*dp = sc;
			dp++;
		}
	}
	if( dp != sp )
		*dp = 0;
	return sp - dp;
}
strdelchr(src,dst,del)
	char *src,*dst,*del;
{	char *sp,sc,*dp;

	dp = dst;
	for( sp = src; sc = *sp; sp++ ){
		if( strchr(del,sc) == 0 ){
			if( dp == sp )
				dp++;
			else	*dp++ = sc;
		}
	}
	if( dp != sp )
		*dp = 0;
}

int rexpmatch(rexp,str)
	char *rexp,*str;
{	int topx;
	char *sp,sc,*tp,tc,*rp,rc;

	if( *rexp == '*' ){
		if( rexp[1] == 0 ) /* any string */
			return 1;
		rexp++;
		topx = 1;
	}else	topx = 0;

	sp = str;
	for(;;){
		tp = sp++; sc = *tp++;
		rp = rexp; rc = *rp++;
		while( sc == rc ){
			if( rc == 0 ) /* exactly matched to the end */
				return 1;
			sc = *tp++;
			rc = *rp++;
		}
		if( rc == '*' ) /* remaining string matches with *  */
			return 1;
		if( sc == 0 ) /* pattern is longer than string */
			return 0;
		if( !topx )
			break;
	}
	return 0;
}

RexpMatch(str,rexp)
	unsigned char *str,*rexp;
{	unsigned char *rp,*sp,rch1,rch2,sch;
	int negate,match;

	sp = str;
	match = 1;
	for( rp = rexp; match && (rch1 = *rp); rp++ ){
		sch = *sp++;
		if( rch1 == '[' ){
			rch1 = *++rp;
			if( rch1 == '^' ){
				rp++;
				negate = 1;
				match = 1;
			}else{
				negate = 0;
				match = 0;
			}
			for(; rch1 = *rp; rp++ ){
				if( negate && match || !negate && !match ){
					if( rp[1] == '-' && rp[2] != 0 ){
						rp += 2;
						rch2 = *rp;
					}else	rch2 = rch1;
					match = (rch1 <= sch && sch <= rch2);
					if( negate )
						match = !match;
				}
				if( rch1 == ']' )
					break;
			}
		}else{
			match = (rch1 == sch);
		}
	}
	return match;
}


int vtos(av,abuf)
	char *av[];
	char *abuf;
{	int ac;
	char *ap,*a1;

	ap = abuf;
	for(ac = 0; a1 = av[ac]; ac++){
		if( ac == 0 )
			strcpy(ap,a1);
		else{
			ap[0] = ',';
			strcpy(ap+1,a1);
		}
		ap += strlen(ap);
	}
	*ap = 0;
	return ac;
}
int stoV(abuf,mac,av,sep)
	char *abuf;
	char *av[],sep;
{	char *ap,*np;
	int ac;

	ac = 0;
	for( ap = abuf; *ap; ap = np+1 ){
		av[ac++] = ap;
		if( mac <= ac )
			break;
		if( (np = strchr(ap,sep)) == 0 )
			break;
		*np = 0;
	}
	av[ac] = 0;
	return ac;
}
char **dupv(sv,length)
	char **sv;
{	int na,ai;
	char **dv;
	int len,lx;

	for( na = 0; sv[na]; na++)
		;
	dv = (char**)malloc(sizeof(char*)*(na+1));

	for( ai = 0; ai < na; ai++ ){
		if( length )
			len = length;
		else	len = strlen(sv[ai]) + 1;
		dv[ai] = malloc(len);
		for( lx = 0; lx < len; lx++ ) dv[ai][lx] = sv[ai][lx];
	}
	dv[ai] = 0;
	return dv;
}
void freev(sv)
	char *sv[];
{	int vx;

	for( vx = 0; sv[vx]; vx++ )
		free(sv[vx]);
	free(sv);
}
int cmpv(v1,v2,len)
	char *v1[],*v2[];
{	int vx;
	char *v1s,*v2s;

	for( vx = 0; ; vx++ ){
		v1s = v1[vx];
		v2s = v2[vx];

		if( v1s == 0 && v2s == 0 ) return 0;
		if( v1s == 0 || v2s == 0 ) return 1;
		if( len ){
			if( bcmp(v1s,v2s,len) != 0 )
				return 1;
		}else{
			if( strcmp(v1s,v2s) != 0 )
				return 1;
		}
	}
}
char *getv(av,name)
	char *av[];
	char *name;
{	char *val,*rval;
	int ai;
	int nlen;

	if( av == 0 || name == 0 )
		return 0;

	nlen = strlen(name);
	rval = 0;
	for(ai = 0; val = av[ai]; ai++)
		if( *name == *val && strncmp(name,val,nlen) == 0 )
		if( val[nlen] == '=' )
			rval = val+nlen+1;
	return rval;
}
scanv(av,name,func,arg1)
	char *av[];
	char *name;
	int (*func)();
	char *arg1;
{	int ai;
	int nlen;
	char *val;
	int nhit;

	nhit = 0;
	nlen = strlen(name);
	for( ai = 0; val = av[ai]; ai++ ){
		if( *name == *val && strncmp(name,val,nlen) == 0 )
		if( val[nlen] == '=' ){
			(*func)(arg1,val+nlen+1);
			nhit++;
		}
	}
	return nhit;
}

/*######DEBUG########*/
#include <stdio.h>
extern char *getenv();
int StrBufDebug;

typedef struct strBuffer {
	struct strBuffer *sb_next;
	int	sb_size;
	int	sb_last;
	char   *sb_buff;
} StrBuffer;
static StrBuffer *STRBUFFST[8];

/*
 * buff address will be randmized by alloca() for randstack ...
 */
addStrBuffer(lev,buff,size)
	char *buff;
{	StrBuffer *nsb;

	if( StrBufDebug == 0 ){
		char *env;
		if( env = getenv("STRBUFDEBUG") ){
			StrBufDebug = atoi(env);
			if( StrBufDebug == 0 )
				StrBufDebug = 1;
		}else	StrBufDebug = -1;
	}
	nsb = (StrBuffer*)calloc(1,sizeof(StrBuffer));
	nsb->sb_size = size;
	nsb->sb_buff = buff;
	nsb->sb_last = 0;
	nsb->sb_next = STRBUFFST[lev];
	STRBUFFST[lev] = nsb;
	if( 0 < StrBufDebug ){
		fprintf(stderr,"#SB# [%d] bank=%X %X %d added.\n",
			lev,nsb,buff,size);
	}
}
delStrBuffer(lev)
{	StrBuffer *sb;

	if( 0 < StrBufDebug ){
		sb = STRBUFFST[lev];
		fprintf(stderr,"#SB# [%d] bank=%X freed.\n",lev,sb);
		free(sb);
	}
	STRBUFFST[lev] = NULL;
}
char *getStrBuffer(lev,size,al)
{	StrBuffer *sb;
	char *sp;
	int last,rem,odd;
	unsigned int top;

	for( sb = STRBUFFST[lev]; sb; sb = sb->sb_next ){
		last = sb->sb_last;
		top = (unsigned int)&sb->sb_buff[last];
		if( odd = top % al )
			last += al - odd;
		rem = sb->sb_size - last;
		if( rem <= size )
			continue;

		sp = &sb->sb_buff[last];
		sb->sb_last = last + size;
		if( 1 < StrBufDebug ){
			fprintf(stderr,
				"#SS# [%d] bank=%X %X %X size=%4d last=%d/%d\n",
				lev,
				sb,sb->sb_buff,sp,size,sb->sb_last,sb->sb_size);
		}
		return sp;
	}
	return NULL;
}
#define PTRALIGN	(sizeof(char*) < 8 ? 8 : sizeof(char*))
int *StructAlloc(size)
{	char *sp;

	if( sp = getStrBuffer(1,size,PTRALIGN) ){
		bzero(sp,size);
		return (int*)sp;
	}else	return (int*)calloc(1,size);
}
PutEnv(name,value)
	char *name,*value;
{	int len;
	char *ep;

	len = strlen(name) + 1 + strlen(value) + 1;
	if( ep = getStrBuffer(1,len,1) ){

	}else	ep = malloc(len);
	sprintf(ep,"%s=%s",name,value);
	putenv(ep);
}
char *StrAlloc(str)
	char *str;
{	char *sp;

	if( *str == 0 )
		return "";
	if( sp = getStrBuffer(1,strlen(str)+1,1) )
		return strcpy(sp,str);
	return stralloc(str);
}
char *stralloc(str)
	char *str;
{	char *dp;

	dp = strdup(str);
	if( dp == NULL ){
		syslog_ERROR("strdup(%d) failed,errno=%d\n",strlen(str),errno);
		exit(1);
	}
	if( 2 < StrBufDebug )
		fprintf(stderr,"## %X strdup(%s)\n",dp,str);
	return dp;
}
strfree(str)
	char *str;
{
	free(str);
}
char *Strdup(dst,src)
	char **dst,*src;
{
	if( *dst == src )
		return *dst;
	if( *dst != (char*)0 )
		free(*dst);
	return *dst = stralloc(src);
}
char *Malloc(ptr,size)
	char *ptr;
{	char *nptr;

	if( ptr == NULL )
		nptr = malloc(size);
	else	nptr = realloc(ptr,size);
	if( nptr == NULL ){
		fprintf(stderr,"[%d] DeleGate: Malloc() failed\n",getpid());
		syslog_ERROR("Malloc(%d) failed,errno=%d\n",size,errno);
		exit(1);
	}
	return nptr;
}



char *strncpy0(d,s,len)
	char *d,*s;
{
	strncpy(d,s,len);
	d[len] = 0;
	return d;
}
strtailchr(str)
	char *str;
{
	if( *str == 0 )
		return 0;
	else	return str[strlen(str)-1];
}

char *strtailstr(str1,str2)
	char *str1,*str2;
{	char *s1,*s2;

	for( s1 = str1; *s1 && s1[1]; s1++ );
	for( s2 = str2; *s2 && s2[1]; s2++ );

	if( *s2 == 0 ){
		if( *s1 == 0 )
			return s1;
		else	return s1 + 1;
	}

	for(;;){
		if( *s1 != *s2  ) return 0;
		if( s2 == str2 )
			return s1;
		s2--;
		if( s1 == str1 ) return 0;
		s1--;
	}
}

char *awordscanX(str,word,size)
	char *str,*word;
{	char *sp,*wp;
	unsigned char ch;
	char *ox;

	wp = word;
	ox = word + (size - 1);
	for(sp = str; wp < ox && (ch = *sp); sp++){
		if( !isalpha(ch) )
			break;
		*wp++ = ch;
	}
	*wp = 0;
	return sp;
}
char *anwordscan(str,word)
	char *str,*word;
{	char *sp,*wp;
	unsigned char ch;

	wp = word;
	for(sp = str; ch = *sp; sp++){
		if( !isalnum(ch) )
			break;
		*wp++ = ch;
	}
	*wp = 0;
	return sp;
}

char *scanint(str,valp)
	char *str;
	int *valp;
{	char *sp,*vp,valb[256];
	unsigned char ch;

	vp = valb;
	for( sp = str; ch = *sp; sp++ ){
		if( !isdigit(ch) )
			break;
		*vp++ = ch;
	}
	*vp = 0;
	if( vp == valb )
		return 0;

	*valp = atoi(valb);
	return sp;
}
char *wordscanX(s,d,size)
	char *s,*d;
{	int cc,ch;

	for(; ch = *s; s++){
		if( ch!=' ' && ch!='\t' && ch!='\r' && ch!='\n' && ch!='\f' )
			break;
	}
	for(cc = 1; (size == 0 || cc < size) && (ch = *s); cc++,s++){
		if( ch==' ' || ch=='\t' || ch=='\r' || ch=='\n' || ch=='\f' )
			break;
		*d++ = ch;
	} 
	*d = 0;
	return s;
}
/*
char *wordscan(s,d)
	char *s,*d;
{
	return wordscanX(s,d,0);
}
*/
char *linescanX(s,d,size)
	char *s,*d;
{	int cc,ch;

	for(; ch = *s; s++){
		/* if( ch!=' ' && ch!='\t' && ch!='\r' && ch!='\n' && ch!='\f' ) */
		if( ch!=' ' && ch!='\t' )
			break;
	}
	for(cc = 1; (cc < size) && (ch = *s); cc++,s++){
		if( ch=='\n' || ch=='\r' && (s[1]=='\n' || s[1]==0) )
			break;
		*d++ = ch;
	} 
	*d = 0;
	return s;
}

char *wordscanY(str,val,siz,pat)
	char *str,*val,*pat;
{	char *sp,*vp,*xp,ch;
	int not = 0;

	if( pat && *pat == '^' ){
		pat++;
		not = 1;
	}
	vp = val;
	xp = val + (siz - 1);
	for( sp = str; vp < xp && (ch = *sp); sp++ ){
		if( pat ){
			if( !not ){
				if( strchr(pat,ch) == NULL )
					break;
			}else{
				if( strchr(pat,ch) != NULL )
					break;
			}
		}
		*vp++ = ch;
	}
	*vp = 0;
	return sp;
}
char *valuescanX(str,val,siz)
	char *str,*val;
{
	if( *str == '"' )
		return wordscanY(str+1,val,siz,"^\"");
	else	return wordscanY(str,val,siz,"^; \t\r\n>\"");
}
char *numscanX(str,val,siz)
	char *str,*val;
{
	if( *str == '-' ){
		*val++ = *str++;
		siz--;
	}
	return wordscanY(str,val,siz,".0123456789");
}

scanwords(sp,wc,words)
	char *sp;
	char *words[];
{	int wi;
	unsigned char ch;

	for( wi = 0; wi < wc; wi++ ){
		for(; ch = *sp; sp++ )
			if( !isspace(ch) )
				break;
		words[wi] = sp;

		for(; ch = *sp; sp++ ){
			if( isspace(ch) ){
				*sp++ = 0;
				break;
			}
		}
	}
}

#define STR_VOLA        0
#define STR_ALLOC       1
#define STR_OVWR        2
typedef int (*IFUNC)();

scan_List(list,sep,allocm,func,a1,a2,a3,a4)
	char *list;
	IFUNC func;
	char *a1,*a2,*a3,*a4;
{	char *alist,*lp,*np;
	int rcode;
	int lev;
	int cch,nch,pch;
	int nelm;

	if( list == 0 || *list == 0 )
		return 0;

	nelm = 0;
	alist = list;
	if( allocm != STR_OVWR )
		list = stralloc(list);

	for( lp = list; *lp; lp = np ){
		int npa;
		npa = 0;
		lev = 0;
		nch = 0;
		for( np = lp; cch = *np; ){
			if( cch == '\\' ){
				nch = np[1];
				if( nch == sep || nch == '{' || nch == '}' )
					ovstrcpy(np,np+1);
				np++;
			}else
			if( cch == '{' ){
				np++;
				lev++;
			}else
			if( cch == '}' ){
				lev--;
				if( lev == 0 && *lp == '{'
				 && npa++ == 0 /* not {L1}@{L2} */
				 && (np[1] == sep || np[1] == 0) ){
					lp++;
					*np++ = 0;
				}else	np++;
			}else
			if( lev == 0 && cch == sep ){
				*np++ = 0;
				break;
			}else{
				np++;
			}
		}
		nelm++;
		if( func != 0 )
		if( rcode = (*func)(lp,a1,a2,a3,a4) )
			return rcode;

		if( np == 0 )
			break;
	}
	if( list != alist && allocm != STR_ALLOC )
		free(list);
	if( func == 0 )
		return nelm;
	return 0;
}
#ifdef MAIN
static pr1(s) char *s; { printf("[%s] ",s); return 0; }
static prs(s) char *s; {
	printf("##[ %-25s] ",s);
	scan_commaList(s,0,pr1);
	printf("\n");
}
main(){
	prs("a,b,c,d");
	prs("{a,b,c,d}");
	prs("{{a,b,c}}");
	prs("{a,b},{c,d}");
	prs("a@{c,d}");
	prs("{a,b}@c");
	prs("{a,b}@{c,d}");
	prs("{a,b}@{c,d},e,f");
	prs("{a,b}@{c,d},{e,f},g,h");
}
#endif

num_ListElems(list,sep)
	char *list,sep;
{
	return scan_List(list,sep,0,(IFUNC)0);
}
scan_ListL(list,sep,allocm,func,a1,a2,a3,a4)
	char *list;
	int (*func)();
	char *a1,*a2,*a3,*a4;
{	int rcode;
	char *tp;

	if( *list == '{' && (tp = strchr(list,'}')) && tp[1] == 0 ){
		*tp = 0;
		rcode = scan_List(list+1,sep,allocm,func,a1,a2,a3,a4);
		*tp = '}';
		return rcode;
	}
	return scan_List(list,sep,allocm,func,a1,a2,a3,a4);
}
static list1(l1,ac,av,mac)
	char *l1;
	int *ac;
	char *av[];
{
	if( mac <= *ac )
		return -1;

	strcpy(av[*ac],l1);
	*ac += 1;
	return 0;
}
scan_Listlist(list,sep,a0,a1,a2,a3,a4,a5,a6,a7)
	char *list;
	char *a0,*a1,*a2,*a3,*a4,*a5,*a6,*a7;
{	char *av[8];
	int mac,ac;

	av[0] = a0; av[1] = a1; av[2] = a2; av[3] = a3;
	av[4] = a4; av[5] = a5; av[6] = a6; av[7] = a7;
	for( mac = 0; av[mac]; mac++ )
		;
	ac = 0;
	scan_List(list,sep,0,list1,&ac,av,mac);
	return ac;
}
scan_commaList(list,allocm,func,a1,a2,a3,a4)
	char *list;
	int (*func)();
	char *a1,*a2,*a3,*a4;
{
	return scan_List(list,',',allocm,func,a1,a2,a3,a4);
}
scan_commaListL(list,allocm,func,a1,a2,a3,a4)
	char *list;
	int (*func)();
	char *a1,*a2,*a3,*a4;
{
	return scan_ListL(list,',',allocm,func,a1,a2,a3,a4);
}
strsubst(str,pat,subs)
	char *str,*pat,*subs;
{	char *dp,tmp[1024];
	char *sp;

	sp = str;
	while( dp = strstr(sp,pat) ){
		strcpy(tmp,dp+strlen(pat));
		strcpy(dp,subs); dp += strlen(dp); strcpy(dp,tmp);
		sp = dp;
	}
}
onoff_flags(flags,delta,on)
	char *flags,*delta;
{	char map[256];
	char *fp;
	int mi;

	for( mi = 1; mi < 256; mi++ )
		map[mi] = 0;

	for( fp = flags; *fp; fp++ )
		map[*fp] = on;
	for( fp = delta; *fp; fp++ )
		map[*fp] = on;

	fp = flags;
	for( mi = 1; mi < 256; mi++ )
		if( map[mi] )
			*fp++ = mi;
	*fp = 0;
}

numscan(spp)
	char **spp;
{	char *sp,sc;
	int sign,width;

	sp = *spp;
	sc = *sp;
	if( sc == '-' ){
		sign = -1;
		sc = *++sp;
	}else	sign = 1;

	width = 0;
	while( '0' <= sc && sc <= '9' ){
		width = (width * 10) + (sc - '0');
		sc = *++sp;
	}

	*spp = sp;
	return sign*width;
}

#ifdef hpux
char *strncpy(s1, s2, n)
	char *s1,*s2;
	int n;
{	char *sp;

	sp = s1;
	while( 0 < n-- ){
		if( (*sp++ = *s2++) == 0 ){
			while( 0 < n-- )
				*sp++ = 0;
			break;
		}
	}
	return s1;
}
#endif

char *ovstrcpy(s1,s2)
	char *s1,*s2;
{	char *sp;

	sp = s1;
	while( 1 )
		if( (*sp++ = *s2++) == 0 )
			break;
	*sp = 0;
	return s1;
}

/*
 *	s1 will be zero terminated, without padded, with max. length n-1.
 */
char *Strncpy(s1,s2,n)
	char *s1,*s2;
	int n;
{	char *sp;

	sp = s1;
	while( 1 < n-- )
		if( (*sp++ = *s2++) == 0 )
			break;
	*sp = 0;
	return s1;
}

Strins(str,ins)
	char *str,*ins;
{
	Strrplc(str,0,ins);
}

FQDN_hash(key)
        unsigned char *key;
{       unsigned char *ks;
        unsigned int kc,kx,ky;

        kx = 0;
        for( ks = key; kc = *ks++; ){
		ky = (kx >> 27) & 0x1F;
                kx = ((kx << 5) | ky) ^ kc;
	}
        return kx;
}

double Scan_period(period,dfltunit,dflt)
	char *period;
	double dflt;
{	double num,clock;
	char unit;

	if( period == 0 || period[0] == 0 )
		return dflt;
	num = 0;
	unit = dfltunit;
	sscanf(period,"%lf%c",&num,&unit);

	switch( unit ){
		default:
		case 'd': clock = num*24*60*60; break;
		case 'h': clock = num*60*60; break;
		case 'm': clock = num*60; break;
		case 's': clock = num; break;
	}
	if( clock < 0 ) clock = 0;
	return clock;
}
scan_period(period,dfltunit,dflt)
	char *period;
{
	return Scan_period(period,dfltunit,(double)dflt);
}

char *strrpbrk(str,brk)
	char *str,*brk;
{	char ch,*dp,*tp;

	if( brk[0] == 0 )
		return str;
	if( str[0] == 0 )
		return 0;

	tp = 0;
	for( dp = str; ch = *dp; dp++ )
		if( strchr(brk,ch) )
			tp = dp;
	return tp; /* the last match */
}

char *strip_spaces(value)
	char *value;
{	char *vp,*tp;

	for( vp = value; *vp == ' ' || *vp == '\t'; vp++)
		;
	for( tp = vp; *tp; tp++ )
		;
	while( vp < tp && tp[-1] == ' ' )
		tp--;
	*tp = 0;
	return vp;
}

/*
 *	case sensitive when a capital character is in "elem"
 */
typedef struct {
	void   (*l_logfunc)();
	void	*l_logfile;
	int	 l_top;
	int	 l_bottom;
	int	 l_nextch;
	int	 l_negate;
	int	 l_seecase;
} LMarg;

static strmatch1(pattern,target,matches,lma)
	char *pattern;
	char *target;
	int *matches;
	LMarg *lma;
{	int negate,seecase,top,btm,nextch;
	char *match;
	char *pat0,pat1[256],*sp,sc,*pp;
	int plen;

	negate  = lma->l_negate;
	seecase = lma->l_seecase;
	top     = lma->l_top;
	btm     = lma->l_bottom;
	nextch  = lma->l_nextch;

	pp = pat1;
	for( sp = pat0 = strip_spaces(pattern); sc = *sp; sp++ ){
		if( sc == '!' && sp == pat0 ){ negate = 1; }else
		if( sc == '*' && pp == pat1 ){ top = 0; }else
		if( sc == '^' && pp == pat1 ){ top = 1; }else
		if( sc == '*' && sp[1] == 0 ){ btm = 0; nextch = 0; }else
		if( sc == '$' && sp[1] == 0 ){ btm = 1; }else
			*pp++ = sc;
	}
	*pp = 0;
	plen = pp - pat1;

	for( pp = pat1; *pp; pp++ ){
		if( isupper(*pp) ){
			seecase = 1;
			break;
		}
	}

	if( seecase )
		match = strstr(target,pat1);
	else	match = strcasestr(target,pat1);

	if( match ){
		if( top && match != target )
			match = 0;
		if( btm && target[plen] != 0 )
			match = 0;
		if( nextch && target[plen] != nextch )
			match = 0;
	}

	if( match ){
		if( negate )
			*matches = 0;
		else	*matches = 1;
	}

EXIT:
	if( lma->l_logfunc )
		(*lma->l_logfunc)(lma->l_logfile,
			"allow = %d <-- [%s] / [%s] \r\n",*matches,target,pat0);
	return 0;
}
strmatch_list(str,list,cntrl,lfunc,lfile)
	char *str,*list,*cntrl;
	void *lfile;
	void (*lfunc)();
{	int matches;
	char buff[1024];
	LMarg lma;
	char tch;

	lma.l_logfunc = lfunc;
	lma.l_logfile = lfile;
	lma.l_negate = 0;
	lma.l_seecase = 0;
	lma.l_top = cntrl[0] == '^';
	tch = strtailchr(cntrl);
	lma.l_bottom = tch == '$';
	lma.l_nextch = tch != '^' ? tch : 0;

	strcpy(buff,list);
	if( *buff == '!' )
		matches = 1;
	else	matches = 0;
	scan_commaList(buff,0,strmatch1,str,&matches,&lma);
	return matches;
}

char *strcats3(dst,s0,s1,s2)
	char *dst,*s0,*s1,*s2;
{	char *sv[4],*sp,sc,*dp;
	int si;

	sv[0] = s0;
	sv[1] = s1;
	sv[2] = s2;
	sv[3] = 0;

	for( dp = dst; *dp; dp++ )
		;

	for( si = 0; sp = sv[si]; si++ ){
		while( sc = *sp++ )
			*dp++ = sc;
	}
	*dp = 0;
	return dp;
}


static subSetList2(s1,s2)
	char *s1,*s2;
{
	return strcmp(s1,s2) == 0;
}
static subSetList1(s1,s2,sbp)
	char *s1,*s2,**sbp;
{
	if( scan_commaListL(s2,STR_VOLA,subSetList2,s1) == 0 ){
		strcpy(*sbp,s1);
		strcat(*sbp,",");
		*sbp += strlen(s1) + 1;
	}
	return 0;
}
subSetList(s1,s2,sb)
	char *s1,*s2,*sb;
{
	*sb = 0;
	scan_commaListL(s1,STR_VOLA,subSetList1,s2,&sb);
	if( *sb )
		sb[strlen(sb)-1] = 0;
}

static strmatch(s1,s2) char *s1,*s2; { return strcmp(s1,s2) == 0; }
wordIsinList(list,word)
	char *list,*word;
{
	if( scan_commaListL(list,0,strmatch,word) )
		return 1;
	return 0;
}

static strmatch2(s1,s2,nth)
	char *s1,*s2;
	int *nth;
{
	*nth += 1;
	if( *s2 != ' ' && *s2 != '\t' ){
		while( *s1 == ' ' || *s1 == '\t' )
			s1++;
	}
	return strcmp(s1,s2) == 0;
}
isinList(list,word)
	char *list,*word;
{	int nth;

	nth = 0;
	if( scan_commaListL(list,0,strmatch2,word,&nth) )
		return nth;
	return 0;
}


decomp_args(av,mac,args,argb)
	char *av[],*args,*argb;
{	char *sp,*dp,ch;
	int arglen;
	int quoting;
	int ac;

	ac = 0;
	quoting = 0;
	arglen = 0;
	dp = argb;

	for( sp = args; ch = *sp; sp++ ){
		switch( ch ){
			case '"':
			case '\'':
				if( quoting == 0 )
					quoting = ch;
				else
				if( quoting == ch )
					quoting = 0;
				break;

			case ' ':
			case '\t':
				if( quoting )
					goto ARGCH1;
				else
				if( arglen ){
					*dp++ = 0;
					arglen = 0;
				}
				break;

			case '\\':
				if( sp[1] == '"' )
					ch = *++sp;

			ARGCH1:
			default:
				if( arglen == 0 ){
					av[ac++] = dp;
					if( mac <= ac ){
						while( *dp++ = *sp++ ); 
						goto EXIT;
					}
				}
				*dp++ = ch;
				arglen++;
				break;
		}
	}
EXIT:
	*dp = 0;
	av[ac] = 0;

/*
	{
	int ai;
	for( ai = 0; ai < ac; ai++ )
	printf("[%d] [%s]\n",ai,av[ai]);
	}
*/
	return ac;
}

static addelem(elem,ac,av,aip,tail)
	char *elem;
	int ac;
	char *av[];
	int *aip;
	char *tail;
{	int ai;

	ai = *aip;
	av[ai++] = elem;
	(*aip) = ai;
	if( ac <= ai+1 ){
		/* the last element must contain whole of the rest if exists
		 * after the delimiter character following to this element.
		 */
		if( elem+strlen(elem)+1 < tail ){
			av[ai] = elem+strlen(elem)+1;
			(*aip) += 1;
		}
		return 1;
	}else	return 0;
}
list2vect(list,del,ac,av)
	char *list,*av[];
{	int cc,ci;

	if( ac <= 1 ){
		av[0] = list;
		return cc;
	}
	cc = 0;
	scan_ListL(list,del,STR_OVWR,addelem,ac,av,&cc,list+strlen(list));
	return cc;
}

int streq(a,b)
	char *a,*b;
{
	if( a == b )
		return 1;
	if( a == 0 || b == 0 )
		return 0;

	if( *a != *b )
		return 0;
	return strcmp(a,b) == 0;
}
int strneq(a,b,n)
	char *a,*b;
{
	if( a == b )
		return 1;
	if( a == 0 || b == 0 )
		return 0;

	if( *a != *b )
		return 0;
	return strncmp(a,b,n) == 0;
}
char *strtail(s)
	char *s;
{
	if( s[0] ){
		while( s[1] )
			s++;
	}
	return s;
}

char *Sprintf(s,fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n)
	char *s;
	char *fmt,*a,*b,*c,*d,*e,*f,*g,*h,*i,*j,*k,*l,*m,*n;
{
	if( fmt[0]=='%' && fmt[1]=='s' && fmt[2]==0 ){
		while( *s = *a++ ){ s++; }
		return s;
	}else{
		sprintf(s,fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
		return s+strlen(s);
	}
}

#define isSP(ch)  (ch==0||ch==' '||ch=='\t'||ch=='\r'||ch=='\n')

char *Str2vstr(sstr,slen,vstr,vlen)
	char *sstr,*vstr;
{	char *sp,*sx,sc,*vp,*vx;
	int in2bytes;

	in2bytes = 0;
	sp = sstr;
	sx = sstr+slen;
	vp = vstr;
	vx = vstr+vlen;

	while( sp < sx ){
		if( vx <= vp+1 )
			break;
		sc = *sp++;
		/* now, sp points to next character */

		if( sc & 0x80 ){
		}else
		switch( sc ){
			case '\0':
			case 'G'-0x40:
			case 'N'-0x40:
			case 'O'-0x40:
			case '\t':
			case '\r':
				if( vx <= vp+2 )
					break;
				*vp++ = '^';
				*vp++ = sc+0x40;
				break;

			case 033:
				if( !isSP(sp[1]) ){
					if( sp[0] == '$' ) in2bytes = 1; else
					if( sp[0] == '(' ) in2bytes = 0;
				}

			default:
				*vp++ = sc;
				break;
		}
		if( in2bytes && isSP(*sp) ){
			if( vx <= vp+3 )
				break;
			strcpy(vp,"\033(B");
			vp += strlen(vp);
			in2bytes = 0;
		}
	}
	*vp = 0;
	return vp;
}

SVinit(Sv,what,ev,ecmax,eb,ebsiz)
	StrVec *Sv;
	char *what;
	char **ev;
	char *eb;
{
	strncpy(Sv->sv_id,what,sizeof(Sv->sv_id)-1);
	Sv->sv_id[sizeof(Sv->sv_id)-1] = 0;
	Sv->sv_ev = ev;
	Sv->sv_ecmax = ecmax;
	Sv->sv_ec = 0;
	str_sopen(Sv->sv_MemF,what,eb,ebsiz,0,"w");
}
extern char *str_sptell();
char *SPrintf(MemF,fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n)
	void *MemF;
	char *fmt,*a,*b,*c,*d,*e,*f,*g,*h,*i,*j,*k,*l,*m,*n;
{	char *top;

	top = str_sptell(MemF);
	str_sprintf(MemF,fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
	str_sputc(0,MemF);
	return top;
}
char *SVaddEnvf(Evp,fmt,a,b,c,d)
	StrVec *Evp;
	char *a,*b,*c,*d;
{	char *top,*dp,**ev;
	int en,ec,ei,len;

	top = SPrintf(Evp->sv_MemF,fmt,a,b,c,d);
	en = -1;
	if( top && (dp = strchr(top,'=')) ){
		len = dp - top;
		ev = Evp->sv_ev;
		ec = Evp->sv_ec;
		for( ei = 0; ei < ec; ei++ )
			if( strncmp(ev[ei],top,len) == 0
			 && ev[ei][len] == '=' ){
				en = ei;
				break;
			}
	}
	if( 0 <= en ){
		if( strcmp(top,Evp->sv_ev[en]) != 0 )
		syslog_ERROR("addEnvf:overwrite %s[%d][%s][%s]\n",
			Evp->sv_id,en,Evp->sv_ev[en],top);
		Evp->sv_ev[en] = top;
	}else
	if( Evp->sv_ec+1 < Evp->sv_ecmax )
		Evp->sv_ev[Evp->sv_ec++] = top;
	else{
		syslog_ERROR("ERROR: addEnvf overflow %s[%d]\n",
			Evp->sv_id,Evp->sv_ecmax);
	}
	return top;
}

char *paramscanX(src,brk,dst,size)
	char *src,*brk,*dst;
{	char *sp,sc,*bp,bc,*dp,*xp;

	dp = dst;
	xp = dst + (size - 1);
	for( sp = src; sc = *sp; sp++ ){
		if( sc == '\r' || sc == '\n' )
			break;
		if( xp <= dp )
			break;
		for( bp = brk; bc = *bp; bp++ ){
			if( sc == bc )
				goto EXIT;
		}
		*dp++ = sc;
	}
EXIT:
	*dp = 0;
	return sp;
}
scan_namebody(namebody,name,nsiz,nbrk,body,bsiz,bbrk)
	char *namebody,*name,*nbrk,*body,*bbrk;
{	char *dp;

	if( name != NULL )
		dp = paramscanX(namebody,nbrk,name,nsiz);
	else	dp = paramscanX(namebody,nbrk,body,bsiz); /* skip name */
	if( *dp && strchr(nbrk,*dp) ){
		dp++;
		if( bbrk )
			paramscanX(dp,bbrk,body,bsiz);
		else	wordscanX(dp,body,bsiz);
	}else	*body = 0;
	if( *body != 0 )
		return 2;
	else	return 0;
}
scan_field1(field,name,nsiz,body,bsiz)
	char *field,*name,*body;
{	char *dp;

	dp = paramscanX(field,":",name,nsiz);
	if( *dp == ':' ){
		dp++;
		while( *dp == ' ' || *dp == '\t' )
			dp++;
		linescanX(dp,body,bsiz);
	}else	*body = 0;
}

ustrcmp(tag,str)
	UTag *tag;
	char *str;
{
	return strncmp(tag->ut_addr,str,tag->ut_leng);
}
utosX(tag,str,siz)
	UTag *tag;
	char *str;
{	int len;

	if( tag == NULL || tag->ut_addr == 0 ){
		str[0] = 0;
		return -1;
	}else{
		len = siz - 1;
		if( tag->ut_leng < len )
			len = tag->ut_leng;
		bcopy(tag->ut_addr,str,len);
		str[len] = 0;
		return len;
	}
}
utoi(tag)
	UTag *tag;
{
	if( tag == NULL || tag->ut_addr == 0 )
		return 0;
	else	return atoi(tag->ut_addr);
}
static fmtlen(fmt)
	char *fmt;
{	char *fp,fx;

	fp = fmt;
	if( *fp != '%' )
		return 0;

	fp++;
	if( *fp == '-' )
		fp++;
	while( isdigit(*fp) || *fp =='.' )
		fp++;

	switch( *fp ){
		case '[': fx = ']'; break;
		case '(': fx = ')'; break;
		default: fx = 0;
	}
	if( fx ){
		for(; *fp; fp++ ){
			if( *fp == fx ){
				fp++;
				break;
			}
		}
	}else{
		fp++;
	}
	return fp-fmt;
}
static fmtvec(fmt,sv,lv)
	char *fmt,*sv[];
	int lv[];
{	char *fp;
	int fn,flen;

	fn = 0;
	for( fp = fmt; *fp; fp++ ){
		if( *fp == '%' && (flen = fmtlen(fp)) ){
			if( fp[flen-1] == '%' ){
				fp++;
			}else{
				sv[fn] = fp;
				lv[fn] = flen;
				fn++;
			}
		}
	}
	return fn;
}
uvfmtreverse(src,dst,rsrc,rdst)
	char *src,*dst,**rsrc,**rdst;
{	char *sv[32],*dv[32],*fp,*ip,ic,*op,buf[1024],*ox;
	int ov[32],on,oi,ii;
	int sl[32],dl[32];
	int fi,sn,dn,num,flen,xlen,subst,ti;

	sn = fmtvec(src,sv,sl);
	dn = fmtvec(dst,dv,dl);

	/*
	 * convert output generation format to input matching pattern
	 */
	ox = buf + sizeof(buf) -1;
	op = buf;
	on = 0;
	ti = 0;

	for( ip = dst; ic = *ip; ){
		if( ic == '%' && (flen = fmtlen(ip)) ){
			switch( ip[flen-1] ){
				case 'S': num = ti++; break;
				case ')': num = atoi(&ip[2]); break;
				 default: num = -1; break;
			}
			if( 0 <= num ){
				ov[on++] = num;
				xlen = sl[num];
				bcopy(sv[num],op,xlen);
				if( op[xlen-1] == 's' ){
					sprintf(&op[xlen-1],"[^%c]",
						ip[flen]?ip[flen]:' ');
					op += strlen(op);
				}else{
					op += xlen;
				}
			}else{
				bcopy(ip,op,flen);
				op += flen;
			}
			ip += flen;
		}else{
			*op++ = ic;
			ip += 1;
		}
		if( ox <= op ){
			op = ox;
			break;
		}
	}
	*op = 0;
	*rdst = strdup(buf);

	/*
	 * convert input matching pattern to output generation format
	 */
	ox = buf + sizeof(buf) -1;
	op = buf;
	ii = 0;
	for( ip = src; ic = *ip; ){
		if( ic == '%' && (flen = fmtlen(ip)) ){
			subst = 0;
			if( ip[flen-1] != '%' ){
				for( oi = 0; oi < on; oi++ ){
					if( ov[oi] == ii ){
						sprintf(op,"%%(%d)",oi);
						op += strlen(op);
						ii++;
						subst = 1;
						break;
					}
				}
			}
			if( subst == 0 ){
				bcopy(ip,op,flen);
				op += flen;
			}
			ip += flen;
		}else{
			*op++ = ic;
			ip += 1;
		}
		if( ox <= op ){
			op = ox;
			break;
		}
	}
	*op = 0;
	*rsrc = strdup(buf);

	syslog_ERROR("#### %s >> %s ####\n",src,dst);
	syslog_ERROR("#### %s << %s ####\n",*rsrc,*rdst);
}
uvtosf(str,siz,fmt,tagv)
	char *str,*fmt;
	UTag *tagv[];
{	int ti,tj,tj1,tj2,tjinc,tx;
	char *dp,*fp,fc,*xp,sep[32],*sp;

	dp = str;
	xp = str + (siz - 1);
	ti = 0;
	for( tx = 0; tagv[tx] && tagv[tx]->ut_addr; tx++ );

	for( fp = fmt; fc = *fp; fp++ ){
		if( xp <= dp )
			break;

		if( fc != '%' ){
			*dp++ = fc;
		}else{
			fp++;
			switch( *fp ){
				case 0:	goto EXIT;
				case '%':
					*dp++ = '%';
					break;
				case 'S':
				case 's':
					if( tagv[ti] == 0 ){
						/* error */
					}else	dp += utosX(tagv[ti++],dp,xp-dp);
					break;
				case '(':
					fc = *++fp;
					if( !isdigit(fc) )
						break;

					tj1 = tj2 = fc - '0';
					fc = *++fp;
					if( fc == '-' ){
						fc = *++fp;
						if( isdigit(fc) ){
							tj2 = fc - '0';
							fc = *++fp;
						}else	tj2 = tx - 1;
					}
					sep[0] = 0;
					while( fc != ')' ){
						sp = sep;
						for(;;){
							*sp++ = fc;
							if( fp[1] == 0 )
								break;
							fc = *++fp;
							if( fc==0 || fc==')')
								break;
						}
						*sp = 0;
					}
					if( tj1 <= tj2 )
						tjinc = 1;
					else{
						tj = tj2;
						tj2 = tj1;
						tj1 = tj;
						tjinc = -1;
					}
					for( tj = tj1; tj < tx; tj += tjinc ){ 
						if( sep[0] && tj != tj1 ){
							strcat(dp,sep);
							dp += strlen(dp);
						}
						dp += utosX(tagv[tj],dp,xp-dp);
						if( tj == tj2 )
							break;
					}
					break;
				default:
					break;
			}
		}
	}
EXIT:
	*dp = 0;
	return dp - str;
}
int ufromsf(str,siz,fmt,tagp)
	char *str,*fmt;
	UTag *tagp;
{	UTag *tagv[2];

	uvinit(tagv,tagp,1);
	return uvfromsf(str,siz,fmt,tagv);
}
int uvfromsf(str,siz,fmt,tagv)
	char *str,*fmt;
	UTag *tagv[];
{
	return uvfromsfX(str,siz,fmt,tagv,NULL,NULL);
}
int uvfromsfX(str,siz,fmt,tagv,rsp,rfp)
	char *str,*fmt;
	UTag *tagv[];
	char **rsp,**rfp;
{	int ti,neg,supp,isin,width;
	char *sp,sc,*sx,*tp,*fp,fc,*xp,*st,*s1;
	char ec,*ep,*ex,estr[32];
	int elen,match;
	char *osp,*ofp;

	sp = str;
	if( siz )
		xp = str + siz;
	else	xp = NULL;
	ti = 0;
	
	for( fp = fmt;;){
		fc = *fp;
		if( xp == 0 ){
			if( fc == 0 )
				break;
		}else{
			if( xp <= sp )
				break;
		}

		if( tagv[ti] == 0 )
			break;
		if( fc == ' ' || fc == '\t' ){
			while( *fp == ' ' || *fp == '\t' ) fp++;
			while( *sp == ' ' || *sp == '\t' ) sp++;
		}else
		if( fc != '%' ){
			if( *sp != fc ){
				goto EXIT;
			}else{
				fp++;
				sp++;
			}
		}else{
			ofp = fp;
			osp = sp;
			supp = 0;
			width = 0;
			for( fp++; fc = *fp; fp++ ){
				if( fc == '*' ){
					supp = 1;
				}else
				if( '1' <= fc && fc < '9' ){
					width = width*10 + (fc-'0');
				}else	break;
			}

			switch( fc ){
			default: /* error */
			goto EXIT;

			case 'd': /* decimal integer */
			while( *sp && isspace(*sp) ) sp++;
			tagv[ti]->ut_addr = st = sp;
			if( *sp == '+' || *sp == '-' )
				sp++;
			if( !isdigit(*sp) ){
				tagv[ti]->ut_addr = 0;
				goto EXIT; /* unmatch */
			}
			while( isdigit(*sp) ) sp++;
			tagv[ti]->ut_leng = sp - st;
			if( !supp ) ti++;
			fp++;
			break;

			case 'c':
				if( width == 0 )
					width = 1;
				sx = sp + width;
				tagv[ti]->ut_addr = st = sp;
				while( sp < sx && *sp ) sp++;
				tagv[ti]->ut_leng = sp - st;
				if( !supp ) ti++;
				fp++;
				break;

			case 'S': /* %Sx means %[^x]x, or eq. %s if x is NULL  */
				ep = estr;
				ex = estr + (sizeof(estr) - 1);
				for( fp++; ec = *fp; fp++ ){
					if( ec == '%' )
						break;
					*ep++ = ec;
					if( ex <= ep )
						break;
				}
				*ep = 0;
				elen = ep - estr;

				tagv[ti]->ut_addr = st = sp;
				if( elen == 0 ){
				    for(; *sp; sp++ ){
					if( isspace(*sp) )
						break;
				    }
				}else{
				    match = 0;
				    for(; *sp; sp++ ){
					if( *sp == *estr )
					if( strncmp(sp,estr,elen) == 0 ){
						match = 1;
						break;
					}
				    }
				    if( match == 0 ){
					fp = ofp;
					sp = osp;
					goto EXIT;
				    }
				}
				tagv[ti]->ut_leng = sp - st;
				if( !supp ) ti++;
				sp += elen;
				break;

			case 's': /* non-white-space string */
			while( *sp && isspace(*sp) ) sp++;
			if( *sp == 0 ){
				goto EXIT; /* unmatch */
			}
			tagv[ti]->ut_addr = st = sp;
			while( *sp && !isspace(*sp) ) sp++;
			tagv[ti]->ut_leng = sp - st;
			if( !supp ) ti++;
			fp++;
			break;

			case '[': /* character set */
			fp++;
			if( neg = *fp == '^' )
				fp++;
			tp = fp;
			while( *fp && *fp != ']' )
				fp++;
			tagv[ti]->ut_addr = st = sp;
			while( sc = *sp ){
				isin = 0;
				for( s1 = tp; s1 < fp; s1++ ){
					if( *s1 == sc ){
						isin = 1;
						break;
					}
					if( s1+1 < fp && s1[1] == '-' ){
						if( fp <= s1+2 ){ /* error */
							s1++;
							break;
						}
						if( *s1 <= sc && sc <= s1[2] ){
							isin = 1;
							break; 
						}
						s1 += 2;
					}
				}
				if( neg && isin || !neg && !isin )
					break;
				sp++;
				if( width && st+width <= sp )
					break;
			}
			tagv[ti]->ut_leng = sp - st;
			if( !supp ) ti++;
			if( *fp == ']' )
				fp++;
			break;
			}
		}
	}
EXIT:
	if( tagv[ti] ){
		tagv[ti]->ut_addr = 0;
	}
	if( rsp ) *rsp = sp;
	if( rfp ) *rfp = fp;
	return ti;
}

UTag UTalloc(lev,size,algn){
	UTag ut;
	char *bp;

	ut.ut_size = size;
	if( bp = getStrBuffer(lev,size,algn) )
		ut.ut_strg = 0;
	else{
		bp = malloc(ut.ut_size);
		ut.ut_strg = 1;
	}
	ut.ut_addr = bp;
	return ut;
}
UTfree(up)
	UTag *up;
{
	if( up->ut_strg && up->ut_addr )
		free(up->ut_addr);
	bzero(up,sizeof(UTag));
}

int copyiv(di,si,ni)
	int di[],si[];
{	int ii;

	for( ii = 0; ii < ni; ii++ )
		di[ii] = si[ii];
}
int setiv(di,ni,iv)
	int di[];
{	int ii;

	for( ii = 0; ii < ni; ii++ )
		di[ii] = iv;
}
char *htoniv(bp,bsiz,what,ic,iv)
	char *bp,*what;
	int iv[];
{	int si;

	sprintf(bp,"(%s %d",what,ic);
	bp += strlen(bp);
	for( si = 0; si < ic; si++ ){
		sprintf(bp," %d",iv[si]);
		bp += strlen(bp);
	}
	sprintf(bp,")");
	bp += strlen(bp);
	return bp;
}
char *ntohiv(buf,bp,blen,what,ic,iv,np)
	char *buf,*bp,*what;
	int iv[],*np;
{	char iwhat[32],tag[32],*ap;
	int si,iic;

	sprintf(tag,"(%s ",what);
	if( strncmp(bp,tag,strlen(tag)) != 0 ){
		ap = strstr(buf,tag);
		if( ap == 0 ){
			*np = 0;
			return bp;
		}
		bp = ap;
	}
	sscanf(bp,"(%s %d",iwhat,&iic);
	*np = iic;
	bp = strchr(bp,' ') + 1;
	bp = strpbrk(bp," )") + 1;
	if( iic == 0 )
		return bp;
	for( si = 0; si < iic && si < ic; si++ ){
		iv[si] = atoi(bp);
		bp = strpbrk(bp," )") + 1;
	}
	if( *bp == ')' )
		bp++;
	return bp;
}

reverseDomainX(dom,rdom,dlm,sep)
	char *dom,*rdom,*sep;
{	char dombuf[1024],*dp;

	lineScan(dom,dombuf);
	*rdom = 0;
	while( dp = strrchr(dombuf,dlm) ){
		strcat(rdom,dp+1);
		strcat(rdom,sep);
		*dp = 0;
	}
	strcat(rdom,dombuf);
}
reverseDomain(dom,rdom)
	char *dom,*rdom;
{
	reverseDomainX(dom,rdom,'.',".");
}
