/*
 *	@select.c: this file will be loaded in systems with select()
 */
#include <stdio.h>
#include "vsocket.h"
#include "yselect.h" /* FD_SETSIZE and FD_SET(),etc. */

connRESETbypeer(){ return -1; }
connHUP(){ return -1; }
PollIn_HUP(on){ return -1; }

PollOut(fd,timeout)
{	struct timeval tv;
	FdSet mask;
	int nready;

	if( fd < 0 )
		return -1;
	fd = SocketOf(fd);

	if( timeout ){
		tv.tv_sec  = timeout / 1000;
		tv.tv_usec = (timeout % 1000) * 1000;
	}
	FD_ZERO(&mask);
	FD_SET(fd,&mask);
	nready = select(FD_SETSIZE,NULL,&mask,NULL,timeout?&tv:NULL);
	if( nready <= 0 )
		return nready;
	return FD_ISSET(fd,&mask) ? 1 : 0;
}

PollIn1(fd,timeout)
{	struct timeval tv;
	FdSet Rmask,Xmask;
	int nready;

	if( fd < 0 )
		return -1;
	fd = SocketOf(fd);

	if( timeout ){
		tv.tv_sec  = timeout / 1000;
		tv.tv_usec = (timeout % 1000) * 1000;
	}
	FD_ZERO(&Rmask);
	FD_SET(fd,&Rmask);
	Xmask = Rmask;
	nready = select(FD_SETSIZE,&Rmask,NULL,&Xmask,timeout?&tv:NULL);
	if( nready <= 0 )
		return nready;
	return FD_ISSET(fd,&Rmask) ? 1 : 0;
}

PollIns(timeout,size,mask,rmask)
	int *mask,*rmask;
{	struct timeval tvbuf,*tv;
	int fi,fd,maxfd;
	FdSet Rmask,Xmask;
	int nready,rready;

	if( timeout ){
		tv = &tvbuf;
		tv->tv_sec  = timeout / 1000;
		tv->tv_usec = (timeout % 1000) * 1000;
	}else	tv = NULL;

	maxfd = -1;
	FD_ZERO(&Rmask);
	for(fi = 0; fi < size; fi++){
		fd = mask[fi];
		fd = SocketOf(fd);

		if( 0 <= fd ){
			FD_SET(fd,&Rmask);
			if( maxfd < fd )
				maxfd = fd;
		}
		rmask[fi] = 0;
	}
	Xmask = Rmask;
	nready = select(SELECT_WIDTH(maxfd),&Rmask,NULL,&Xmask,tv);
	if( nready <= 0 )
		return nready;

	rready = 0;
	for(fi = 0; fi < size; fi++){
		fd = mask[fi];
		fd = SocketOf(fd);

		if( 0 <= fd ){
			if( FD_ISSET(fd,&Rmask) ){
				rready++;
				rmask[fi] = 1;
			}else	rmask[fi] = 0;
		}else	rmask[fi] = 0;
	}
	return rready;
}


PollInsOuts(timeout,nfds,fdv,ev,rev)
	int fdv[],ev[],rev[];
{	fd_set rfds,wfds,xfds;
	int fi,fd,ev1,ev2;
	int width;
	struct timeval tv;
	struct timeval *tvp;
	int nready;

	FD_ZERO(&rfds);
	FD_ZERO(&wfds);
	FD_ZERO(&xfds);

	width = 0;
	for( fi = 0; fi < nfds; fi++ ){
		fd = fdv[fi];
		fd = SocketOf(fd);
		if( width < fd )
			width = fd;
		ev1 = ev[fi];
		if( ev1 & PS_IN  ) FD_SET(fd,&rfds);
		if( ev1 & PS_OUT ) FD_SET(fd,&wfds);
		if( ev1 & PS_PRI ) FD_SET(fd,&xfds);
	}
	/*
	if( timeout ){
		tv.tv_sec = timeout / 1000;
		tv.tv_usec = (timeout % 1000) * 1000;
	}
	nready = select(SELECT_WIDTH(width),&rfds,&wfds,&xfds,timeout?&tv:NULL);
	*/
	if( timeout < 0 ){ /* spec. of timeout of poll() */
		tvp = NULL;
	}else{
		tvp = &tv;
		tv.tv_sec = timeout / 1000;
		tv.tv_usec = (timeout % 1000) * 1000;
	}
	nready = select(SELECT_WIDTH(width),&rfds,&wfds,&xfds,tvp);
	for( fi = 0; fi < nfds; fi++ ){
		fd = fdv[fi];
		fd = SocketOf(fd);
		ev2 = 0;
		if( FD_ISSET(fd,&rfds) ) ev2 |= PS_IN;
		if( FD_ISSET(fd,&wfds) ) ev2 |= PS_OUT;
		if( FD_ISSET(fd,&xfds) ) ev2 |= PS_PRI;
		rev[fi] = ev2;
	}
	return nready;
}
