#ifndef _YSTRING_H
#define _YSTRING_H

#include <string.h>

#ifndef NULL
#define NULL 0L
#endif

/*
 * standard but not supported in ancient UNIX. (substituted by libsubst.a)
 */
#ifndef __GNU_LIBRARY__
extern char *strdup();
extern char *strstr();
#endif

/*
 * non-standard
 */
extern char *ovstrcpy();
extern char *strcasestr();
extern char *strrpbrk();
extern char *stralloc();
extern char *strtail();
extern char *strtailstr();
extern char *scanint();
extern char *linescanX();
#define lineScan(s,l)	linescanX(s,l,sizeof(l))
#define textScan(s,l)	wordscanY(s,l,sizeof(l),"^\r\n");

extern char *wordscanX();
#define wordScan(s,w)	wordscanX(s,w,sizeof(w))

extern char *wordscanY();
extern char *valuescanX();
#define wordScanY(s,w,p) wordscanY(s,w,sizeof(w),p)
extern char *awordscanX();
#define awordscan(s,w)   awordscanX(s,w,sizeof(w))
extern char *numscanX();

#define fieldScan(f,n,v) scan_field1(f,n,sizeof(n),v,sizeof(v))
#define majorminorScan(s,j,n) scan_namebody(s,j,sizeof(j),"/",n,sizeof(n),NULL)

typedef int MemFile[16];

typedef struct {
	char	sv_id[16];
	char  **sv_ev;
	int	sv_ec;
	int	sv_ecmax;
	MemFile	sv_MemF;
} StrVec;

extern char *SPrintf();
extern char *SVaddEnvf();

typedef struct {
	char	ut_strg;
	char	ut_dmmy;
	short	ut_type;
	int	ut_size;
	int	ut_leng;
	char   *ut_addr;
} UTag;
#define Utos(u,s)	utosX(u,s,sizeof(s))

extern UTag UTalloc();
extern char *StrAlloc();
extern char *StrBufAlloc();
extern int  *StructAlloc();
#define NewStruct(t)	(t*)StructAlloc(sizeof(t))

extern char *getStrBuffer();
#define SB_STAT	0 /* static environment */
#define SB_PROC	1
#define SB_CONN	2
#define SB_SERV	3 /* environment for each request */

#endif /* _YSTRING_H */
