# -*- coding: EUC-JP -*-
# Tamito KAJIYAMA <21 April 2002>
# $Id: satori.py,v 1.33 2003/12/17 02:18:07 shy Exp $

# TODO:
# - եס ü쵭̵, replace̵ʤ
# - ٥Ȥñ췲Ǥ褦
# - ʸñ췲νʣ
# - 
# - ߥ˥
# - ƤӽФ: ñɲ, sync
# - ƤӽФ, SAORIƤӽФΰ׻
# - ȡΤʤǤȿ
# - BalloonOffset0, BalloonOffset1
# - ޥ饯

import os
import string
import sys
import re
import time
import whrandom
import StringIO

import kanjilib

builtin_open = open

NODE_TEXT       = 1
NODE_REF        = 2
NODE_SIDE       = 3
NODE_ASSIGNMENT = 4
NODE_JUMP       = 5
NODE_SEARCH     = 6
NODE_CHOICE     = 7
NODE_CALL       = 8
NODE_SAORI      = 9
NODE_OR_EXPR    = 20
NODE_AND_EXPR   = 21
NODE_COMP_EXPR  = 22
NODE_ADD_EXPR   = 23
NODE_MUL_EXPR   = 24
NODE_POW_EXPR   = 25
NODE_UNARY_EXPR = 26

def encrypt(s):
    buffer = []
    t = len(s)
    p = (t + 1) / 2
    for n in range(p):
        buffer.append(s[n])
        if len(s[p:]) > n:
            buffer.append(s[-n-1])
    return buffer

def decrypt(s):
    buffer = []
    t = len(s)
    for n in range(0, t, 2):
        buffer.append(s[n])
    if t % 2 == 0:
        p = 1
    else:
        p = 2
    for n in range(p, t, 2):
        buffer.append(s[-n])
    return buffer

def list_dict(dir):
    buffer = []
    try:
        list = os.listdir(dir)
    except OSError:
        list = []
    for filename in list:
        if filename[:3] == "dic" and filename[-4:] in [".txt", ".sat"] or \
           filename in ["replace.txt", "replace_after.txt",
                        "satori_conf.txt", "satori_conf.sat"]:
            buffer.append(os.path.join(dir, filename))
    return buffer

class Filter:
    def __init__(self, rules):
        self.rules = []
        for pat, rep in rules:
            self.rules.append((self._split(pat), self._split(rep)))
    def _split(self, text):
        buffer = []
        i, j = 0, len(text)
        while i < j:
            if text[i] < "\x80":
                buffer.append(text[i])
                i = i + 1
            else:
                buffer.append(text[i:i+2])
                i = i + 2
        return buffer
    # an implementation of the Boyer-Moore text searching algorithm
    def _find(self, text, pat, start=None, end=None):
        if start is None:
            start = 0
        elif start < 0:
            start = max(0, start + len(text))
        if end is None:
            end = len(text)
        elif end < 0:
            end = max(0, end + len(text))
        m = len(pat)
        n = len(text)
        if m > n - start:
            return -1
        if n > end:
            n = end
        skip = {}
        for k in range(m - 1):
            skip[pat[k]] = m - k - 1
        k = m - 1 + start
        while k < n:
            i = k
            j = m - 1
            while j >= 0 and text[i] == pat[j]:
                i = i - 1
                j = j - 1
            if j == -1:
                return i + 1
            k = k + skip.get(text[k], m)
        return -1
    def _replace(self, text, pat, rep):
        start = 0
        while start < len(text):
            pos = self._find(text, pat, start)
            if pos < 0:
                break
            text[pos:pos+len(pat)] = rep
            start = pos+len(rep)
        return text
    def apply(self, text):
        text = self._split(text)
        for pat, rep in self.rules:
            text = self._replace(text, pat, rep)
        return string.join(text, "")

###   PARSER   ###

def read_tab_file(path, encrypted=0, debug=0):
    file = builtin_open(path)
    lineno = 0
    buffer = []
    while 1:
        line = file.readline()
        if not line:
            break
        lineno = lineno + 1
        if line[-2:] == "\r\n":
            line = line[:-2]
        elif line[-1] in "\r\n":
            line = line[:-1]
        if encrypted:
            line = string.join(decrypt(decrypt(line)), "")
        try:
            line = kanjilib.sjis2euc(line)
        except kanjilib.error, e:
            if debug & 4:
                print "satori.py: %s in %s (line %d)" % (e, path, lineno)
            continue
        try:
            old, new = string.split(line, "\t")
        except ValueError:
            if debug & 4:
                print "satori.py: invalid line in %s (line %d)" % (path, lineno)
            continue
        buffer.append((old, new))
    file.close()
    return buffer

class Parser:
    def __init__(self, debug=0):
        self.debug = debug
        self.talk = {}
        self.word = {}
        self.variable = []
        self.parenthesis = 0
        self.replace_filter = Filter([])
        self.anchor_list = []
        self.anchor_filter = Filter(self.anchor_list)
        self.is_anchor = 0
        self.saori = []
        self.count = {'Talk':        0,
                      'NoNameTalk':  0,
                      'EventTalk':   0,
                      'OtherTalk':   0,
                      'Words':       0,
                      'Word':        0,
                      'Variable':    0,
                      'Anchor':      0,
                      'Parenthesis': 0,
                      'Parentheres': 0, ## XXX
                      'Line':        0,}
    def set_saori(self, list):
        self.saori = list
    def get_count(self, name):
        if self.count.has_key(name):
            return self.count[name]
        else:
            return 0
    def load_replace_file(self, path):
        self.replace_filter = Filter(read_tab_file(path, debug=self.debug))
    def get_dict(self):
        return self.talk, self.word
    def read(self, path):
        if path[-4:] == ".sat":
            encrypted = 1
        else:
            encrypted = 0
        filename = os.path.basename(path)
        if filename[:9] == "dicanchor":
            self.is_anchor = 1
        else:
            self.is_anchor = 0
        file = builtin_open(path)
        self.read_file(file, path, encrypted)
        file.close()
        if self.is_anchor:
            self.anchor_filter = Filter(self.anchor_list)
    def read_file(self, file, path=None, encrypted=0):
        lineno = 0
        linelist = None
        while 1:
            line = file.readline()
            if not line:
                break
            lineno = lineno + 1
            if line[-2:] == "\r\n":
                line = line[:-2]
            elif line[-1] in "\r\n":
                line = line[:-1]
            if encrypted:
                line = string.join(decrypt(decrypt(line)), "")
            try:
                line = kanjilib.sjis2euc(line)
            except kanjilib.error, e:
                if self.debug & 4:
                    if path is None:
                        print "satori.py: %s (line %d)" % (e, lineno)
                    else:
                        print "satori.py: %s in %s (line %d)" % (e, path, lineno)
                continue
            if line[:2] == "":
                continue
            ### FIXME: զզ...ա
            pos = string.find(line, "")
            if pos > 0:
                line = line[:pos]
            if line[:2] == "":
                if linelist:
                    parser(linelist)
                parser = self.parse_talk
                linelist = [lineno, line]
            elif line[:2] == "":
                if linelist:
                    parser(linelist)
                parser = self.parse_word_group
                linelist = [lineno, line]
            elif linelist:
                # apply replace.txt
                line = self.replace_filter.apply(line)
                linelist.append(line)
        if linelist:
            parser(linelist)
        self.count['Line'] = self.count['Line'] + lineno
        talk = 0
        eventtalk = 0
        for key in self.talk.keys():
            number = len(self.talk[key])
            talk = talk + number
            if key[:2] == 'On':
                eventtalk = eventtalk + number
        self.count['Talk'] = talk
        self.count['EventTalk'] = eventtalk
        if self.talk.has_key(''):
            self.count['NoNameTalk'] = len(self.talk[''])
        self.count['OtherTalk'] = self.count['Talk'] \
                                  - self.count['NoNameTalk'] \
                                  - self.count['EventTalk']
        self.count['Words'] = len(self.word)
        word = 0
        for key in self.word.keys():
            word = word + len(self.word[key])
        self.count['Word'] = word
        self.count['Anchor'] = len(self.anchor_list)
        self.count['Variable'] = len(self.variable)
        self.count['Parenthesis'] = self.count['Parentheres'] = self.parenthesis
    def split(self, line):
        i, j = 0, len(line)
        buffer = []
        while i < j:
            if line[i] < "\x80":
                buffer.append(line[i])
                i = i + 1
            else:
                buffer.append(line[i:i+2])
                i = i + 2
        return buffer
    def parse_talk(self, linelist):
        lineno = linelist[0]
        buffer = []
        line = linelist[1]
        assert line[:2] == ""
        name = line[2:]
        while len(linelist) > 3 and not linelist[-1]:
            del linelist[-1]
        prev = ""
        open = 0
        close = 0
        for n in range(2, len(linelist)):
            line = self.split(linelist[n])
            open = open + line.count("")
            close = close + line.count("")
            if open > 0 and open != close:
                if n == len(linelist) - 1:
                    print "satori.py: syntax error (unbalanced parens)"
                else:
                    prev = prev + linelist[n]
                    continue 
            else:
                open = 0
                close = 0
            line = self.split(prev + linelist[n])
            prev = ""
            if line and line[0] == "":
                node = self.parse_assignment(line)
                if node is not None:
                    buffer.append(node)
            elif line and line[0] == "":
                node = self.parse_jump(line)
                if node is not None:
                    buffer.append(node)
            elif line and line[0] == "":
                node = self.parse_search(line)
                if node is not None:
                    buffer.append(node)
            elif line and line[0] == "":
                node = self.parse_choice(line)
                if node is not None:
                    buffer.append(node)
            else:
                nodelist = self.parse_talk_word(line)
                if nodelist is not None:
                    buffer.extend(nodelist)
        if buffer:
            try:
                list = self.talk[name]
            except KeyError:
                list = self.talk[name] = []
            list.append(buffer)
            if self.is_anchor:
                self.anchor_list.append([name, "\\_a[%s]%s\\_a" % (name, name)])
    def parse_word_group(self, linelist):
        lineno = linelist[0]
        buffer = []
        line = linelist[1]
        assert line[:2] == ""
        name = line[2:]
        prev = ""
        open = 0
        close = 0
        for n in range(2, len(linelist)):
            line = self.split(linelist[n])
            open = open + line.count("")
            close = close + line.count("")
            if open > 0 and open != close:
                if n == len(linelist) - 1:
                    print "satori.py: syntax error (unbalanced parens)"
                else:
                    prev = prev + linelist[n]
                    continue 
            else:
                open = 0
                close = 0
            line = self.split(prev + linelist[n])
            prev = ""
            if not line:
                continue
            word = self.parse_word(line)
            if word:
                buffer.append(word)
        if buffer:
            try:
                list = self.word[name]
            except KeyError:
                list = self.word[name] = []
            list.extend(buffer)
    def parse_assignment(self, line):
        assert line[0] == ""
        for n in range(1, len(line)):
            if line[n] in ["\t", " ", "", ""]:
                break
        else:
            if self.debug & 4:
                print "satori.py: syntax error (expected a tab or equal)"
            return None
        name = self.parse_word(line[1:n])
        if line[n] == "":
            n = n + 1
        else:
            sep = line[n]
            while n < len(line) and line[n] == sep:
                n = n + 1
        value = self.parse_expression(line[n:])
        if not name in self.variable:
            self.variable.append(name)
        return [NODE_ASSIGNMENT, name, value]
    def parse_jump(self, line):
        assert line[0] == ""
        for n in range(1, len(line)):
            if line[n] == "\t":
                break
        else:
            n = len(line)
        target = self.parse_word(line[1:n])
        while n < len(line) and line[n] == "\t":
            n = n + 1
        if n < len(line):
            condition = self.parse_expression(line[n:])
        else:
            condition = None
        return [NODE_JUMP, target, condition]
    def parse_search(self, line):
        return [NODE_SEARCH]
    def parse_choice(self, line):
        assert line[0] == ""
        for n in range(1, len(line)):
            if line[n] == "\t":
                break
        else:
            n = len(line)
        label = self.parse_word(line[1:n])
        while n < len(line) and line[n] == "\t":
            n = n + 1
        if n < len(line):
            id = self.parse_word(line[n:])
        else:
            id = None
        return [NODE_CHOICE, label, id]
    def parse_talk_word(self, line):
        buffer = self.parse_word(line)
        buffer.append([NODE_TEXT, [r"\n"]])
        return buffer
    def parse_word(self, line, depth=0, partial=0):
        buffer = []
        text = []
        while line:
            if line[0] == "" and depth == 0:
                if text:
                    buffer.append([NODE_TEXT, text])
                    text = []
                buffer.append([NODE_SIDE, [line.pop(0)]])
            elif line[0] == "":
                self.parenthesis = self.parenthesis + 1
                if text:
                    buffer.append([NODE_TEXT, text])
                    text = []
                nodelist = [[NODE_TEXT, [line.pop(0)]]]
                nodelist.extend(self.parse_word(line, depth+1))
                if line and line[0] == "":
                    nodelist.append([NODE_TEXT, [line.pop(0)]])
                    if nodelist[1][0] == NODE_TEXT:
                        list = [string.join(nodelist[1][1], "")]
                        for sep in ['\1', ',', '', '']:
                            buf = []
                            for item in list:
                                buf.extend(string.split(item, sep))
                            list = buf
                        if list[0] in ['ñɲ', 'sync', 'loop', 'call', 'set', 'remember']:
                            function = list[0]
                            nodelist[1][1] = nodelist[1][1][len(function)+1:]
                            args = self.parse_argument(nodelist[1:-1])
                            buffer.append([NODE_CALL, function, args])
                        elif list[0] in self.saori:
                            function = list[0]
                            nodelist[1][1] = nodelist[1][1][len(function)+1:]
                            args = self.parse_argument(nodelist[1:-1])
                            buffer.append([NODE_SAORI, function, args])
                        else:
                            buffer.append([NODE_REF, nodelist])
                    else:
                        buffer.append([NODE_REF, nodelist])
                else: # unbalanced parens
                    buffer.extend(nodelist)
                if partial:
                    break
            elif line[0] == "" and depth > 0:
                break
            else:
                text.append(line.pop(0))
        if text:
            buffer.append([NODE_TEXT, text])
        return buffer
    def parse_argument(self, nodelist):
        args = []
        buffer = []
        for node in nodelist:
            if node[0] == NODE_TEXT:
                text = []
                for c in node[1]:
                    if c in ['\1', ',', '', '']:
                        if len(text) > 0:
                            buffer.append([NODE_TEXT, text])
                        args.append(buffer)
                        buffer = []
                        text = []
                    else:
                        text.append(c)  
                else:
                    if len(text) > 0:
                        buffer.append([NODE_TEXT, text])
            else:
                buffer.append(node)  
        else:
            args.append(buffer)
        return args
    def parse_expression(self, line):
        default = [[NODE_TEXT, line[:]]]
        try:
            buffer = self.get_or_expr(line)
        except ValueError, e:
            return default
        if line:
            return default
        return buffer
    def get_or_expr(self, line):
        buffer = [NODE_OR_EXPR, self.get_and_expr(line)]
        while line and line[0] in ["|", ""]:
            line.pop(0)
            if line and line[0] in ["|", ""]:
                line.pop(0)
            else:
                raise ValueError, "broken OR operator"
            buffer.append(self.get_and_expr(line))
        if len(buffer) == 2:
            return buffer[1]
        return [buffer]
    def get_and_expr(self, line):
        buffer = [NODE_AND_EXPR, self.get_comp_expr(line)]
        while line and line[0] in ["&", ""]:
            line.pop(0)
            if line and line[0] in ["&", ""]:
                line.pop(0)
            else:
                raise ValueError, "broken AND operator"
            buffer.append(self.get_comp_expr(line))
        if len(buffer) == 2:
            return buffer[1]
        return [buffer]
    def get_comp_expr(self, line):
        buffer = self.get_add_expr(line)
        if line and line[0] in ["<", ""]:
            line.pop(0)
            op = "<"
            if line and line[0] in ["=", ""]:
                line.pop(0)
                op = "<="
            return [[NODE_COMP_EXPR, buffer, op, self.get_add_expr(line)]]
        elif line and line[0] in [">", ""]:
            line.pop(0)
            op = ">"
            if line and line[0] in ["=", ""]:
                line.pop(0)
                op = ">="
            return [[NODE_COMP_EXPR, buffer, op, self.get_add_expr(line)]]
        elif line and line[0] in ["=", ""]:
            line.pop(0)
            if line and line[0] in ["=", ""]:
                line.pop(0)
            else:
                raise ValueError, "broken EQUAL operator"
            return [[NODE_COMP_EXPR, buffer, "==", self.get_add_expr(line)]]
        elif line and line[0] in ["!", ""]:
            line.pop(0)
            if line and line[0] in ["=", ""]:
                line.pop(0)
            else:
                raise ValueError, "broken NOT EQUAL operator"
            return [[NODE_COMP_EXPR, buffer, "!=", self.get_add_expr(line)]]
        return buffer
    def get_add_expr(self, line):
        buffer = [NODE_ADD_EXPR, self.get_mul_expr(line)]
        while line and line[0] in ["+", "", "-", ""]:
            if line[0] in ["+", ""]:
                buffer.append("+")
            else:
                buffer.append("-")
            line.pop(0)
            buffer.append(self.get_mul_expr(line))
        if len(buffer) == 2:
            return buffer[1]
        return [buffer]
    def get_mul_expr(self, line):
        buffer = [NODE_MUL_EXPR, self.get_pow_expr(line)]
        while line and \
              line[0] in ["*", "", "", "/", "", "", "%", ""]:
            if line[0] in ["*", "", ""]:
                buffer.append("*")
            elif line[0] in ["/", "", ""]:
                buffer.append("/")
            else:
                buffer.append("%")
            line.pop(0)
            buffer.append(self.get_pow_expr(line))
        if len(buffer) == 2:
            return buffer[1]
        return [buffer]
    def get_pow_expr(self, line):
        buffer = [NODE_POW_EXPR, self.get_unary_expr(line)]
        while line and line[0] in ["^", ""]:
            line.pop(0)
            buffer.append(self.get_unary_expr(line))
        if len(buffer) == 2:
            return buffer[1]
        return [buffer]
    def get_unary_expr(self, line):
        if line and line[0] in ["-", ""]:
            line.pop(0)
            return [[NODE_UNARY_EXPR, "-", self.get_unary_expr(line)]]
        if line and line[0] in ["!", ""]:
            line.pop(0)
            return [[NODE_UNARY_EXPR, "!", self.get_unary_expr(line)]]
        if line and line[0] == "(":
            line.pop(0)
            buffer = self.get_or_expr(line)
            if line and line[0] == ")":
                line.pop(0)
            else:
                raise ValueError, "expected a close paren"
            return buffer
        return self.get_factor(line)
    operators = [
        "|", "", "&", "", "<", "", ">", "", "=", "", "!", "",
        "+", "", "-", "", "*", "", "", "/", "", "", "%", "",
        "^", "", "(", ")"]
    def get_factor(self, line):
        buffer = []
        while line and line[0] not in self.operators:
            if line and line[0] == "":
                buffer.extend(self.parse_word(line, partial=1))
                continue
            text = []
            while line and line[0] not in self.operators and line[0] != "":
                text.append(line.pop(0))
            if text:
                buffer.append([NODE_TEXT, text])
        if not buffer:
            raise ValueError, "expected a constant"
        return buffer
    def print_nodelist(self, list, depth=0):
        for node in list:
            indent = "  " * depth
            if node[0] == NODE_TEXT:
                print indent + 'NODE_TEXT "%s"' % string.join(node[1], "")
            elif node[0] == NODE_REF:
                print indent + "NODE_REF"
                self.print_nodelist(node[1], depth+1)
            elif node[0] == NODE_CALL:
                print indent + "NODE_CALL"
                for i in range(len(node[2])):
                    self.print_nodelist(node[2][i], depth+1)
            elif node[0] == NODE_SAORI:
                print indent + "NODE_SAORI"
                for i in range(len(node[2])):
                    self.print_nodelist(node[2][i], depth+1)
            elif node[0] == NODE_SIDE:
                print indent + "NODE_SIDE"
            elif node[0] == NODE_ASSIGNMENT:
                print indent + "NODE_ASSIGNMENT"
                print indent + "variable"
                self.print_nodelist(node[1], depth+1)
                print indent + "value"
                self.print_nodelist(node[2], depth+1)
            elif node[0] == NODE_JUMP:
                print indent + "NODE_JUMP"
                print indent + "name"
                self.print_nodelist(node[1], depth+1)
                if node[2] is not None:
                    print indent + "condition"
                    self.print_nodelist(node[2], depth+1)
            elif node[0] == NODE_SEARCH:
                print indent + "NODE_SEARCH"
            elif node[0] == NODE_CHOICE:
                print indent + "NODE_CHOICE"
                print indent + "label"
                self.print_nodelist(node[1], depth+1)
                if node[2] is not None:
                    print indent + "id"
                    self.print_nodelist(node[2], depth+1)
            elif node[0] == NODE_OR_EXPR:
                print indent + "NODE_OR_EXPR"
                self.print_nodelist(node[1], depth+1)
                for i in range(2, len(node)):
                    print indent + "op ||"
                    self.print_nodelist(node[i], depth+1)
            elif node[0] == NODE_AND_EXPR:
                print indent + "NODE_ADD_EXPR"
                self.print_nodelist(node[1], depth+1)
                for i in range(2, len(node)):
                    print indent + "op &&"
                    self.print_nodelist(node[i], depth+1)
            elif node[0] == NODE_COMP_EXPR:
                print indent + "NODE_COMP_EXPR"
                self.print_nodelist(node[1], depth+1)
                print indent + "op", node[2]
                self.print_nodelist(node[3], depth+1)
            elif node[0] == NODE_ADD_EXPR:
                print indent + "NODE_ADD_EXPR"
                self.print_nodelist(node[1], depth+1)
                for i in range(2, len(node), 2):
                    print indent + "op", node[i]
                    self.print_nodelist(node[i+1], depth+1)
            elif node[0] == NODE_MUL_EXPR:
                print indent + "NODE_MUL_EXPR"
                self.print_nodelist(node[1], depth+1)
                for i in range(2, len(node), 2):
                    print indent + "op", node[i]
                    self.print_nodelist(node[i+1], depth+1)
            elif node[0] == NODE_POW_EXPR:
                print indent + "NODE_POW_EXPR"
                self.print_nodelist(node[1], depth+1)
                for i in range(2, len(node)):
                    print indent + "op ^"
                    self.print_nodelist(node[i], depth+1)
            elif node[0] == NODE_UNARY_EXPR:
                print indent + "NODE_UNARY_EXPR"
                print indent + "op", node[1]
                self.print_nodelist(node[2], depth+1)
            else:
                raise RuntimeError, "should not reach here"

# expression := or_expr
# or_expr    := and_expr ( op_op and_expr )*
# or_op      := "á"
# and_expr   := comp_expr ( and_op comp_expr )*
# and_op     := ""
# comp_expr  := add_expr ( comp_op add_expr )?
# comp_op    := "" | "" | "" | "" | "" | ""
# add_expr   := mul_expr ( add_op mul_expr )*
# add_op     := "" | ""
# mul_expr   := pow_expr ( mul_op pow_expr )*
# mul_op     := "" | "" | "" | "" | ""
# pow_expr   := unary_expr ( pow_op unary_expr )*
# pow_op     := ""
# unary_expr := unary_op unary_expr | "(" or_expr ")" | factor
# unary_op   := "" | ""
# factor     := ( constant | reference )*

###   INTERPRETER   ###

class Satori:
    DBNAME = "satori_savedata.txt"
    EDBNAME = "satori_savedata.sat"
    def __init__(self, satori_dir=os.curdir, debug=0):
        self.satori_dir = satori_dir
        self.dbpath = os.path.join(satori_dir, self.DBNAME)
        self.debug = debug
        self.saori_function = {}
        self.parser = Parser()
        self.reset()
    def reset(self):
        self.word = {}
        self.talk = {}
        self.variable = {}
        self.replace_filter = Filter([])
        self.reset_surface = 1
        self.mouse_move_count = {}
        self.mouse_wheel_count = {}
        self.touch_threshold = 60
        self.touch_timeout = 2
        self.current_surface = [0, 10]
        self.default_surface = [0, 10]
        self.add_to_surface = [0, 0]
        self.newline = r"\n[half]"
        self.newline_script = ""
        self.save_interval = 0
        self.save_timer = 0
        self.url_list = {}
        self.boot_script = None
        self.script_history = [None] * 64
        self.wait_percent = 100
        self.random_talk = -1
        self.reserved_talk = {}
        self.silent_time = 0
        self.choice_id = None
        self.choice_label = None
        self.choice_number = None
        self.timer = {}
        self.time_start = None
        self.runtime = 0 # accumulative
        self.runcount = 1 # accumulative
        self.folder_change = 0
    def load(self):
        buffer = []
        for path in list_dict(self.satori_dir):
            filename = os.path.basename(path)
            if filename == "replace.txt":
                self.parser.load_replace_file(path)
            elif filename == "replace_after.txt":
                self.load_replace_file(path)
            elif filename in ["satori_conf.txt", "satori_conf.sat"]:
                self.load_config_file(path)
            else:
                buffer.append(path)
        for path in buffer:
            self.parser.read(path)
        self.talk, self.word = self.parser.get_dict()
        self.load_database()
        self.time_start = time.time()
        self.get_event_response("OnSatoriLoad")
        self.boot_script = self.get_event_response("OnSatoriBoot")
    def load_config_file(self, path):
        parser = Parser()
        parser.read(path)
        talk, word = parser.get_dict()
        for nodelist in talk.get("", []):
            self.expand(nodelist)
    def load_replace_file(self, path):
        self.replace_filter = Filter(read_tab_file(path, debug=self.debug))
    def load_database(self):
        if  self.variable.get("֥ǡŹ沽") == "ͭ":
            encrypted = 1
            self.dbpath = os.path.join(self.satori_dir, self.EDBNAME)
        else:
            encrypted = 0
            self.dbpath = os.path.join(self.satori_dir, self.DBNAME)
        try:
            database = read_tab_file(self.dbpath, encrypted, self.debug)
        except IOError:
            database = []
        for name, value in database:
            self.assign(name, value)
    def save_database(self):
        if  self.variable.get("֥ǡŹ沽") == "ͭ":
            encrypted = 1
            self.dbpath = os.path.join(self.satori_dir, self.EDBNAME)
        else:
            encrypted = 0
            self.dbpath = os.path.join(self.satori_dir, self.DBNAME)
        try:
            file = builtin_open(self.dbpath, "w")
        except IOError:
            if self.debug & 4:
                print "satori.py: cannot write", self.dbpath
            return
        for name, value in self.variable.items():
            if name in ["λե0", "λե1",
                        "ǥեȥե0", "ǥեȥե1"]:
                continue
            line = "%s\t%s" % (kanjilib.euc2sjis(name), kanjilib.euc2sjis(value))
            if encrypted:
                line = string.join(encrypt(encrypt(line)), "")
            file.write(line)
            file.write("\r\n")
        for side in [0, 1]:
            name = "ǥեȥե%d" % side
            value = self.to_zenkaku("%d" % self.default_surface[side])
            line = "%s\t%s" % (kanjilib.euc2sjis(name), kanjilib.euc2sjis(value))
            if encrypted:
                line = string.join(encrypt(encrypt(line)), "")
            file.write(line)
            file.write("\r\n")
        for side in [0, 1]:
            name = "λե%d" % side
            value = self.to_zenkaku("%d" % self.current_surface[side])
            line = "%s\t%s" % (kanjilib.euc2sjis(name), kanjilib.euc2sjis(value))
            if encrypted:
                line = string.join(encrypt(encrypt(line)), "")
            file.write(line)
            file.write("\r\n")
        name = "ư"
        value = self.to_zenkaku("%d" % self.runcount)
        line = "%s\t%s" % (kanjilib.euc2sjis(name), kanjilib.euc2sjis(value))
        if encrypted:
            line = string.join(encrypt(encrypt(line)), "")
        file.write(line)
        file.write("\r\n")
        for name in self.timer.keys():
            value = self.to_zenkaku(self.timer[name])
            line = "%s\t%s" % (kanjilib.euc2sjis(name), kanjilib.euc2sjis(value))
            if encrypted:
                line = string.join(encrypt(encrypt(line)), "")
            file.write(line)
            file.write("\r\n")
        for name in self.reserved_talk.keys():
            value = self.to_zenkaku(self.reserved_talk[name])
            line = "%s\t%s" % (kanjilib.euc2sjis("" + value + "ܤΥȡ"), kanjilib.euc2sjis(name))
            if encrypted:
                line = string.join(encrypt(encrypt(line)), "")
            file.write(line)
            file.write("\r\n")
        file.close()
    def finalize(self):
        self.get_event_response("OnSatoriUnload")
        accumulative_runtime = self.runtime + self.get_runtime()
        self.assign("ñ߷", self.to_zenkaku(accumulative_runtime))
        self.save_database()
    # SHIORI/1.0 API
    def getaistringrandom(self):
        return self.get_script("")
    def getaistringfromtargetword(self, word):
        return ""
    def getdms(self):
        return ""
    def getword(self, type):
        return ""
    # SHIORI/2.2 API
    EVENT_MAP = {
        "OnFirstBoot":         "",
        "OnBoot":              "ư",
        "OnClose":             "λ",
        "OnGhostChanging":     "¾ΥȤѹ",
        "OnGhostChanged":      "¾ΥȤѹ",
        "OnVanishSelecting":   "ǻؼ",
        "OnVanishCancel":      "ű",
        "OnVanishSelected":    "Ƿ",
        "OnVanishButtonHold":  "",
        }
    def get_event_response(self, event,
                           ref0=None, ref1=None, ref2=None, ref3=None,
                           ref4=None, ref5=None, ref6=None, ref7=None):
        self.event = event
        self.reference = [ref0, ref1, ref2, ref3, ref4, ref5, ref6, ref7]
        if event == "OnUpdateReady":
            try:
                ref0 = str(int(ref0) + 1)
                self.reference[0] = ref0
            except:
                pass
        elif event == "OnMouseMove":
            key = (ref3, ref4) # side, part
            count, timestamp = self.mouse_move_count.get(key, (0, 0))
            if int(time.time() - timestamp) > self.touch_timeout:
                count = 0
            count = count + 1
            if count >= self.touch_threshold:
                event = "%s%sʤǤ" % (str(ref3), str(ref4))
                count = 0
            self.mouse_move_count[key] = (count, time.time())
        elif event == "OnMouseWheel":
            key = (ref3, ref4) # side, part
            count, timestamp = self.mouse_wheel_count.get(key, (0, 0))
            if int(time.time() - timestamp) > 2:
                count = 0
            count = count + 1
            if count >= 2:
                event = "%s%s" % (str(ref3), str(ref4))
                count = 0
            self.mouse_wheel_count[key] = (count, time.time())
        elif event == "OnSecondChange":
            self.silent_time = self.silent_time + 1
            if self.save_interval > 0:
               self.save_timer = self.save_timer - 1
               if self.save_timer <= 0:
                   self.save_database()
                   self.save_timer = self.save_interval
            if ref3 != '0': # cantalk
                # check random talk timer
                if self.random_talk == 0:
                    self.reset_random_talk_interval()
                elif self.random_talk > 0:
                    self.random_talk = self.random_talk - 1
                    if self.random_talk == 0:
                        event = self.get_reserved_talk()
                        if event:
                            self.reference[0] = self.to_zenkaku(1)
                        else:
                            self.reference[0] = self.to_zenkaku(0)
                        self.reference[1] = event
                        script = self.get_script("OnTalk")
                        if script:
                            self.script_history.pop(0)
                            self.script_history.append(script)
                            return script
                        self.reference[0] = ref0
                        self.reference[1] = ref1
            # check user-defined timers
            for name in self.timer.keys():
                count = self.timer[name] - 1
                if count > 0:
                    self.timer[name] = count
                elif ref3 != '0': # cantalk
                    del self.timer[name]
                    event = name[:-6]
                    break
        elif event == "OnSurfaceChange":
            self.current_surface[0] = ref0
            self.current_surface[1] = ref1
        elif event == "OnChoiceSelect":
            self.choice_id = ref0
            self.choice_label = ref1
            self.choice_number = ref2
            if not self.talk.has_key("OnChoiceSelect"):
                event = ref0
        elif event == "OnChoiceEnter":
            self.choice_id = ref1
            self.choice_label = ref0
            self.choice_number = ref2
        elif event == "OnAnchorSelect":
            if self.talk.has_key(ref0):
                event = ref0
        elif event in ["sakura.recommendsites", "sakura.portalsites",
                       "kero.recommendsites"]:
            return self.get_url_list(event)
        elif event == "OnRecommandedSiteChoice":
            script = self.get_url_script(ref0, ref1)
            if script:
                self.script_history.pop(0)
                self.script_history.append(script)
            return script
        elif self.EVENT_MAP.has_key(event):
            if event in ["OnBoot", "OnGhostChanged"]:
                if self.boot_script:
                    script = self.boot_script
                    self.boot_script = None
                    self.script_history.pop(0)
                    self.script_history.append(script)
                    return script
            if event in ["OnClose", "OnGhostChanging"]:
                script = self.get_script("OnSatoriClose")
                if script:
                    self.get_script(event)
                    self.script_history.pop(0)
                    self.script_history.append(script)
                    return script
            if not self.talk.has_key(event):
                event = self.EVENT_MAP[event]
        script = self.get_script(event)
        if script:
            self.script_history.pop(0)
            self.script_history.append(script)
        return script
    # SHIORI/2.4 API
    def teach(self, word):
        name = self.variable.get("뤳")
        if name is not None:
            self.variable[name] = word
            script = self.get_script(name + "򶵤Ƥä")
            self.script_history.pop(0)
            self.script_history.append(script)
            return script
        return None
    # SHIORI/2.5 API
    def getstring(self, name):
        word = self.word.get(name)
        if word is not None:
            return self.expand(whrandom.choice(word))
        return None
    # internal
    def get_reserved_talk(self):
        reserved = None
        for key in self.reserved_talk.keys():
            timer = self.reserved_talk[key]
            self.reserved_talk[key] = timer - 1
            if self.reserved_talk[key] <= 0:
                reserved = key
        if reserved is not None:
            del self.reserved_talk[reserved]
        else:
            reserved = ""
        return reserved
    re_reservation = re.compile("((||||||||||[0-9])+)(((||||||||||[0-9])+))?ܤΥȡ")
    def assign(self, name, value):
        if name[-6:] == "":
            if self.talk.has_key(name[:-6]):
                self.add_timer(name, value)
        elif name == "޲":
            if value == "¹":
                self.delete_all_timers()
        elif name == "":
            if value == "¹":
                self.reload()
        elif name == "ư":
            if value == "¹":
                self.save_database()
        elif self.re_reservation.match(name):
            if not value:
                return None
            match = self.re_reservation.match(name)
            number = self.to_integer(match.group(1))
            if match.group(4) is not None:
                number = whrandom.randint(number, self.to_integer(match.group(4)))
            while 1:
                for key in self.reserved_talk:
                    if self.reserved_talk[key] == number:
                        number = number + 1
                        break
                else:
                    break
            self.reserved_talk[value] = number
        elif name ==  "Υȡ":
            if not value:
                return None
            number = 1
            while 1:
                for key in self.reserved_talk:
                    if self.reserved_talk[key] == number:
                        number = number + 1
                        break
                else:
                    break
            self.reserved_talk[value] = number
        elif name == "ȡͽΥ󥻥":
            if value == "":
                self.reserved_talk = {}
            elif self.reserved_talk.has_key(value):
                del self.reserved_talk[value]
        elif name == "ư":
            self.runcount = self.to_integer(value) + 1
        elif not value:
            if self.variable.has_key(name):
                del self.variable[name]
        else:
            self.variable[name] = value
            if name in ["ֳ", "ֳָ"]:
                self.reset_random_talk_interval()
            elif name == "뤳":
                return r"\![open,teachbox]"
            elif name == "ûեᤷ":
                if value == "ͭ":
                    self.reset_surface = 1
                elif value == "̵":
                    self.reset_surface = 0
            elif name == "ǥեȥե0":
                value = self.to_integer(value)
                if value is not None:
                    self.default_surface[0] = value
            elif name == "ǥեȥե1":
                value = self.to_integer(value)
                if value is not None:
                    self.default_surface[1] = value
            elif name == "եû0":
                value = self.to_integer(value)
                if value is not None:
                    self.default_surface[0] = value
                    self.add_to_surface[0] = value
            elif name == "եû1":
                value = self.to_integer(value)
                if value is not None:
                    self.default_surface[1] = value
                    self.add_to_surface[1] = value
            elif name == "ñ߷":
                self.runtime = self.to_integer(value)
            elif name == "ʤǤȿ":
                self.touch_threshold = self.to_integer(value)
            elif name == "ʤǤ³ÿ":
                self.touch_timeout = self.to_integer(value)
            elif name == "ڤ괹":
                self.newline = value
            elif name == "饹ץȤˤ륹ڤ괹":
                self.newline_script = value
            elif name == "ưȤΨ":
                if value[-1] == '%':
                    value = value[:-1]
                elif value[-2:] == '':
                    value = value[:-2]
                value = self.to_integer(value)
                if value is not None and value >= 0 and value <= 1000:
                    self.wait_percent = value
            elif name == "ưֳִ":
                self.save_interval = self.to_integer(value)
                self.save_timer = self.save_interval
            elif name == "ե":
                self.folder_change = 1
        return None
    def change_folder(self):
        value = self.variable.get("ե")
        list = string.split(value, ',')
        self.parser = Parser()
        self.parser.set_saori(self.saori_function.keys())
        buffer = []
        for dir in list:
            dict_dir = os.path.join(self.satori_dir, string.lower(dir))
            if not os.path.isdir(dict_dir):
                print "satori.py: cannot read", dict_dir
                continue
            for path in list_dict(dict_dir):
                filename = os.path.basename(path)
                if filename == "replace.txt":
                    self.parser.load_replace_file(path)
                elif filename == "replace_after.txt":
                    self.load_replace_file(path)
                elif filename in ["satori_conf.txt", "satori_conf.sat"]:
                    pass
                else:
                    buffer.append(path)
        for path in buffer:
            self.parser.read(path)
        self.talk, self.word = self.parser.get_dict()
    def reload(self):
        self.finalize()
        self.reset()
        self.load()
    def reset_random_talk_interval(self):
        interval = self.get_integer("ֳ", "ignore")
        if interval is None or interval == 0:
            self.random_talk = -1
            return
        rate = self.get_integer("ֳָ", "ignore")
        if rate is None:
            rate = 0.1
        else:
            rate = min(max(rate, 1), 100) / 100.0
        diff = int(interval * rate)
        self.random_talk = whrandom.randint(interval - diff, interval + diff)
    def add_timer(self, name, value):
        count = self.to_integer(value)
        if count is None or count == 0:
            if self.timer.has_key(name):
                del self.timer[name]
        else:
            self.timer[name] = count
    def delete_all_timers(self):
        self.timer = {}
    def get_script(self, name):
        script = self.get(name, default=None)
        if script is not None and script and script != "\\n":
            ##print 'make("%s")' % script
            return self.make(r"\1" + script + r"\e")
        return None
    def get_url_list(self, name):
        self.url_list[name] = []
        list = self.talk.get(name)
        if list is None:
            return None
        url_list = ""
        for i in range(len(list)-1,-1,-1):
            nodelist = list[i]
            title = ""
            j = 0
            while j < len(nodelist):
                node = nodelist[j]
                j = j + 1
                if node[0] == NODE_TEXT:
                    if node[1] == ['\\n']:
                        break
                    else:
                        title = title + string.join(node[1], "")
                else:
                   pass
            if not title:
                continue
            if title == '-':
                if url_list:
                    url_list = url_list + chr(2)
                url_list = url_list + title + chr(1)
                continue
            url = ""
            while j < len(nodelist):
                node = nodelist[j]
                j = j + 1
                if node[0] == NODE_TEXT:
                    if node[1] == ['\\n']:
                        break
                    else:
                        url = url + string.join(node[1], "")
                else:
                   pass
            if not url:
                continue
            bannar = ""
            while j < len(nodelist):
                node = nodelist[j]
                j = j + 1
                if node[0] == NODE_TEXT:
                    if node[1] == ['\\n']:
                        break
                    else:
                        bannar = bannar + string.join(node[1], "")
                else:
                   pass
            if len(nodelist[j:]) > 0:
                script = nodelist[j:]
            else:
                script = None
            self.url_list[name].append([title, url, bannar, script])
            if url_list:
                url_list = url_list + chr(2)
            url_list = url_list + title + chr(1) + url + chr(1) + bannar
        if not url_list:
            url_list = None
        return url_list
    def get_url_script(self, title, url):
        script = None
        for key in self.url_list.keys():
            for item in self.url_list[key]:
                if item[0] == title and item[1] == url:
                    if item[3] is not None:
                        script = self.expand(item[3], top=1)
                        if script is not None and script and script != "\\n":
                            script = self.make(r"\1" + script + r"\e")
                            break
        return script
    redundant_tags = [
        (re.compile(r"(\\[01hu])+(\\[01hu])"),   lambda m: m.group(2)),
        (re.compile(r"(\\n)+(\\e|$)"),           lambda m: m.group(2)),
        (re.compile(r"(\\e)+"),                  lambda m: m.group(1)),
        (re.compile(r"((\\[01huc]|\\_e|\\b\[-1\]|\\_l\[[^]]+\])"
                    r"(\\[45xt*v]|\\[sbw][0-9]|\\_[qsVn]|\\__[ct]|"
                    r"\\[sbjmi!]\[[^]]+\]|\\_[wv]\[[^]]+\])+)"
                    r"\\n(?!\[half\])"),         lambda m: m.group(1)),
        ]
    re_newline = re.compile(r"((\\n)*)(\\e)")
    re_0 = re.compile(r"\\[0h]")
    re_1 = re.compile(r"\\[1u]")
    re_wait_after = re.compile(r"|||")
    re_wait_before = re.compile(r"\\[01hunce]")
    re_tag = re.compile(r"\\[ehunjcxtqzy*v0123456789fmia!&+---]|"
                        r"\\[sb][0-9]?|\\w[0-9]|\\_[wqslvVbe+cumna]|"
                        r"\\__[ct]|\\URL")
    def make(self, script):
        if script is None:
            return None
        # make anchor
        buffer = []
        i = 0
        while 1:
            match = self.re_tag.match(script, i)
            if match:
                start = match.start()
                end = match.end()
                buffer.append(self.parser.anchor_filter.apply(script[i:start]))
                buffer.append(script[start:end])
                i = end
            else:
                buffer.append(self.parser.anchor_filter.apply(script[i:]))
                break
        script = string.join(buffer, "")
        # apply replace_after.txt
        script = self.replace_filter.apply(script)
        # remove redundant tags
        for pattern, replace in self.redundant_tags:
            script, count = pattern.subn(replace, script)
        # remove redundant newline tags
        match = self.re_newline.search(script)
        if match:
            tag = match.group(3)
            if tag == r"\e":
                script = script[:match.start()] + tag + script[match.end():]
            else:
                raise RuntimeError, "should not reach here"
        # insert newline
        i = 1
        while 1:
            match = self.re_0.search(script, i)
            if match:
                end = match.end()
                match = self.re_0.search(script, end)
                if match:
                    start = match.start()
                    if start < len(self.newline) or \
                       script[start-len(self.newline):start] != self.newline:
                       script = r"%s%s%s" % (
                        script[:match.end()], self.newline_script, script[match.end():])
                else:
                    break
                i = end
            else:
                break
        i = 1
        while 1:
            match = self.re_1.search(script, i)
            if match:
                end = match.end()
                match = self.re_1.search(script, end)
                if match:
                    start = match.start()
                    if start < len(self.newline) or \
                       script[start-len(self.newline):start] != self.newline:
                       script = r"%s%s%s" % (
                        script[:match.end()], self.newline_script, script[match.end():])
                else:
                    break
                i = end
            else:
                break
        # insert waits
        buffer = []
        n = 0
        i, j = 0, len(script)
        while i < j:
            match = self.re_wait_after.match(script, i)
            if match:
                buffer.append(match.group())
                buffer.extend(self.make_wait(n))
                n = 0
                i = match.end()
                continue
            match = self.re_wait_before.match(script, i)
            if match:
                buffer.extend(self.make_wait(n))
                buffer.append(match.group())
                n = 0
                i = match.end()
                continue
            if script[i] == "[":
                pos = string.find(script, "]", i)
                if pos > i:
                    buffer.append(script[i:pos+1])
                    i = pos + 1
                    continue
            match = self.re_tag.match(script, i)
            if match:
                buffer.append(script[i:match.end()])
                i = match.end()
            elif script[i] < "\x80":
                buffer.append(script[i])
                n = n + 3
                i = i + 1
            else:
                buffer.append(script[i:i+2])
                n = n + 6
                i = i + 2
        return string.join(buffer, "")
    def make_wait(self, ms):
        buffer = []
        n = (ms + 25) * self.wait_percent / 100 / 50
        while n > 0:
            buffer.append(r"\w%d" % min(n, 9))
            n = n - 9
        return buffer
    def get(self, name, default=""):
        list = self.talk.get(name)
        if list is None:
            return default
        return self.expand(whrandom.choice(list), top=1)
    def expand(self, nodelist, caller_history=None, top=0):
        if nodelist is None:
            return ""
        buffer = []
        history = []
        side = 1
        talk = 0
        newline = [None, None]
        if top and self.reset_surface:
            reset_surface = [1, 1]
        else:
            reset_surface = [0, 0]
        for node in nodelist:
            if node[0] == NODE_REF:
                if caller_history is not None:
                    value = self.get_reference(node[1], caller_history, side)
                else:
                    value = self.get_reference(node[1], history, side)
                if value:
                    talk = 1
                    buffer.append(value)
                    history.append(value)
                    if caller_history is not None:
                        caller_history.append(value)
            elif node[0] == NODE_CALL:
                if caller_history is not None:
                    value = self.call_function(node[1], node[2], caller_history, side)
                else:
                    value = self.call_function(node[1], node[2], history, side)
                if value:
                    talk = 1
                    buffer.append(value)
                    history.append(value)
                    if caller_history is not None:
                        caller_history.append(value)
            elif node[0] == NODE_SAORI:
                if caller_history is not None:
                    value = self.call_saori(node[1], node[2], caller_history, side)
                else:
                    value = self.call_saori(node[1], node[2], history, side)
                if value:
                    talk = 1
                    buffer.append(value)
                    history.append(value)
                    if caller_history is not None:
                        caller_history.append(value)
            elif node[0] == NODE_TEXT:
                buffer.extend(node[1])
                talk = 1
            elif node[0] == NODE_SIDE:
                if talk:
                    newline[side] = self.newline
                else:
                    newline[side] = None
                talk = 0
                if side == 0:
                    side = 1
                else:
                    side = 0
                buffer.append(r"\%d" % side)
                if reset_surface[side]:
                    buffer.append(r"\s[%d]" % self.default_surface[side])
                    reset_surface[side] = 0
                if newline[side] is not None:
                    buffer.append(r"%s" % newline[side])
            elif node[0] == NODE_ASSIGNMENT:
                value = self.expand(node[2])
                result = self.assign(self.expand(node[1]), value)
                if result is not None:
                    buffer.append(result)
            elif node[0] == NODE_JUMP:
                if node[2] is None or self.expand(node[2]) not in ["", "0", "False"]:
                    target = self.expand(node[1])
                    if target == "OnTalk":
                        self.reference[1] = self.get_reserved_talk()
                        if self.reference[1]:
                            self.reference[0] = self.to_zenkaku(1)
                        else:
                            self.reference[0] = self.to_zenkaku(0)
                    script = self.get(target, default=None)
                    if script is not None and script and script != '\\n':
                        buffer.append(r"\1" + script)
                        break
            elif node[0] == NODE_SEARCH: ## FIXME
                buffer.append("")
            elif node[0] == NODE_CHOICE:
                label = self.expand(node[1])
                if node[2] is None:
                    id = label
                else:
                    id = self.expand(node[2])
                buffer.append(r"\q[%s,%s]\n" % (label, id))
                talk = 1
            elif node[0] == NODE_OR_EXPR:
                for i in range(1, len(node)):
                    if self.expand(node[i]) not in ["", "0", "False"]:
                        buffer.append("")
                        break
                else:
                    buffer.append("")
            elif node[0] == NODE_AND_EXPR:
                for i in range(1, len(node)):
                    if self.expand(node[i]) in ["", "0", "False"]:
                        buffer.append("")
                        break
                else:
                    buffer.append("")
            elif node[0] == NODE_COMP_EXPR:
                operand1 = self.expand(node[1])
                operand2 = self.expand(node[3])
                n1 = self.to_integer(operand1)
                n2 = self.to_integer(operand2)
                if not (n1 is None or n2 is None):
                    operand1 = n1
                    operand2 = n2
                elif n1 is None and n2 is None and node[2] in ["<", ">", "<=", ">="]:
                    operand1 = len(operand1)
                    operand2 = len(operand2)
                if node[2] == "==":
                    buffer.append(self.to_zenkaku(operand1 == operand2))
                elif node[2] == "!=":
                    buffer.append(self.to_zenkaku(operand1 != operand2))
                elif node[2] == "<":
                    buffer.append(self.to_zenkaku(operand1 < operand2))
                elif node[2] == ">":
                    buffer.append(self.to_zenkaku(operand1 > operand2))
                elif node[2] == "<=":
                    buffer.append(self.to_zenkaku(operand1 <= operand2))
                elif node[2] == ">=":
                    buffer.append(self.to_zenkaku(operand1 >= operand2))
                else:
                    raise RuntimeError, "should not reach here"
            elif node[0] == NODE_ADD_EXPR:
                value_str = self.expand(node[1])
                value = self.to_integer(value_str)
                for i in range(2, len(node), 2):
                    operand_str = self.expand(node[i+1])
                    operand = self.to_integer(operand_str)
                    if node[i] == "-":
                        if value is None or operand is None:
                            value_str = string.replace(value_str, operand_str, "")
                            value = None
                        else:
                            value = value - operand
                            value_str = self.to_zenkaku(value)
                        continue
                    if value is None:
                        value = 0
                    if operand is None:
                        operand = 0
                    if node[i] == "+":
                        value = value + operand
                    else:
                        raise RuntimeError, "should not reach here"
                if value is None:
                    buffer.append(value_str)
                else:
                    buffer.append(self.to_zenkaku(value))
            elif node[0] == NODE_MUL_EXPR:
                value_str = self.expand(node[1])
                value = self.to_integer(value_str)
                for i in range(2, len(node), 2):
                    operand_str = self.expand(node[i+1])
                    operand = self.to_integer(operand_str)
                    if node[i] == "*":
                        if value is None and operand is None:
                            value_str = ""
                            value = None
                        elif value is None:
                            value_str = value_str * operand
                            value = None
                        elif operand is None:
                            value_str = value * operand_str
                            value = None
                        else:
                            value = value * operand
                        continue
                    if value is None:
                        value = 0
                    if operand is None:
                        operand = 0
                    if node[i] == "/":
                        value = value / operand
                    elif node[i] == "%":
                        value = value % operand
                    else:
                        raise RuntimeError, "should not reach here"
                if value is None:
                    buffer.append(value_str)
                else:
                    buffer.append(self.to_zenkaku(value))
            elif node[0] == NODE_POW_EXPR:
                value = self.to_integer(self.expand(node[1]))
                if value is None:
                    value = 0
                for i in range(2, len(node)):
                    operand = self.to_integer(self.expand(node[i]))
                    if operand is None:
                        operand = 0
                    value = value ** operand
                buffer.append(self.to_zenkaku(value))
            elif node[0] == NODE_UNARY_EXPR:
                value = self.expand(node[2])
                if node[1] == "-":
                    value = self.to_integer(value)
                    if value is None:
                        value = 0
                    value = -value
                elif node[1] == "!":
                    value = (value in ["", "0", "False"])
                else:
                    raise RuntimeError, "should not reach here"
                buffer.append(self.to_zenkaku(value))
            else:
                raise RuntimeError, "should not reach here"
        return string.join(buffer, "")
    re_random = re.compile("((||[-+])?(||||||||||[0-9])+)((||[-+])?(||||||||||[0-9])+)")
    re_is_empty = re.compile("(ѿ|ʸ|ñ췲)(.*)פ¸")
    re_n_reserved = re.compile("((||||||||||[0-9])+)ܤΥȡ")
    re_is_reserved = re.compile("ȡ(.*)פͽ̵ͭ")
    def get_reference(self, nodelist, history, side):
        key = self.expand(nodelist[1:-1], history)
        if self.word.has_key(key):
            return self.expand(whrandom.choice(self.word[key]), history)
        elif self.talk.has_key(key):
            return self.expand(whrandom.choice(self.talk[key]))
        elif self.variable.has_key(key):
            return self.variable[key]
        elif self.timer.has_key(key):
            return self.to_zenkaku(self.timer[key])
        elif self.is_reserved(key):
            return self.get_reserved(key)
        elif self.re_random.match(key):
            match = self.re_random.match(key)
            i = self.to_integer(match.group(1))
            j = self.to_integer(match.group(4))
            if i < j:
                return self.to_zenkaku(whrandom.randint(i, j))
            else:
                return self.to_zenkaku(whrandom.randint(j, i))
        elif self.re_n_reserved.match(key):
            match = self.re_n_reserved.match(key)
            number = self.to_integer(match.group(1))
            for key in self.reserved_talk.keys():
                if self.reserved_talk[key] == number:
                    return key
            else:
                return ""
        elif self.re_is_reserved.match(key):
            match = self.re_is_reserved.match(key)
            name = match.group(1)
            if self.reserved_talk.has_key(name):
                return self.to_zenkaku(1)
            else:
                return self.to_zenkaku(0)
        elif self.re_is_empty.match(key):
            match = self.re_is_empty.match(key)
            type = match.group(1)
            name = match.group(2)
            if type == "ѿ":
                if self.variable.has_key(name):
                    return self.to_zenkaku(1)
                else:
                    return self.to_zenkaku(0)
            elif type == "ʸ":
                if self.talk.has_key(name):
                    return self.to_zenkaku(1)
                else:
                    return self.to_zenkaku(0)
            elif type == "ñ췲":
                if self.word.has_key(name):
                    return self.to_zenkaku(1)
                else:
                    return self.to_zenkaku(0)
        buffer = self.parser.split(key)
        if buffer[0] in ["", "R"]:
            n = self.to_integer(buffer[1:])
            if n is not None and n >= 0 and n < len(self.reference):
                if self.reference[n] is None:
                    return ""
                return str(self.reference[n])
        elif buffer[0] in ["", "H"]:
            ##print '["' + string.join(history, '", "') + '"]'
            n = self.to_integer(buffer[1:])
            if n is not None and  n >= 1 and n < len(history) + 1:
                return history[n-1]
        n = self.to_integer(buffer)
        if n is not None:
            return r"\s[%d]" % (n + self.add_to_surface[side])
        return "%s" % key
    def call_function(self, name, args, history, side):
        if name == 'ñɲ': ## FIXME
            pass
        elif name == 'call':
            ref = self.expand(args[0], history)
            args = args[1:]
            for i in range(len(args)):
                name = '' + self.to_zenkaku(i)
                self.variable[name] = self.expand(args[i], history)
            result = self.get_reference([[NODE_TEXT, ''], [NODE_TEXT, ref], [NODE_TEXT, '']], history, side)
            for i in range(len(args)):
                name = '' + self.to_zenkaku(i)
                del self.variable[name]
            return result
        elif name == 'remember':
            number = self.to_integer(self.expand(args[0]))
            if number > 0 and number <= 64 and self.script_history[-number]:
                return self.script_history[-number] 
            else:
                return ""
        elif name == 'loop':
            ref = self.expand(args[0])
            if len(args) < 2:
                return ""
            elif len(args) == 2:
                start = 1
                end = self.to_integer(self.expand(args[1])) + 1
                step = 1
            elif len(args) == 3:
                start = self.to_integer(self.expand(args[1]))
                end = self.to_integer(self.expand(args[2])) + 1
                step = 1
            elif len(args) >= 4:
                start = self.to_integer(self.expand(args[1]))
                end = self.to_integer(self.expand(args[2]))
                step = self.to_integer(self.expand(args[3]))
                if step > 0:
                    end = end + 1
                elif step < 0:
                    end = end - 1
                else:
                    return "" # infinite loop
            name = ref + ''
            buffer = []
            for i in range(start, end, step):
                self.variable[name] = self.to_zenkaku(i)
                buffer.append(self.get_reference([[NODE_TEXT, ''], [NODE_TEXT, ref], [NODE_TEXT, '']], history, side))
            del self.variable[name]
            return string.join(buffer, "")
        elif name == 'sync': ## FIXME
            pass
        elif name == 'set':
            if len(args) < 1:
                name = ""
            else:
                name = self.expand(args[0])
            if len(args) < 2:
                value = ""
            else:
                value = self.expand(args[1])
            if name:
                if not value:
                    if self.variable.has_key(name):
                        del self.variable[name]
                else:
                    self.variable[name] = value
            return ""
        else:
            raise RuntimeError, "should not reach here"
        return ""
    def call_saori(self, name, args, history, side):
        return ""
    def get_runtime(self):
        return int(time.time() - self.time_start)
    def get_integer(self, name, error="strict"):
        value = self.variable.get(name)
        if value is None:
            return None
        return self.to_integer(value, error)
    NUMBER = {
        "": "0", "0": "0",
        "": "1", "1": "1",
        "": "2", "2": "2",
        "": "3", "3": "3",
        "": "4", "4": "4",
        "": "5", "5": "5",
        "": "6", "6": "6",
        "": "7", "7": "7",
        "": "8", "8": "8",
        "": "9", "9": "9",
        "": "+", "+": "+",
        "": "-", "-": "-",
        }
    def to_integer(self, line, error="strict"):
        if type(line) == type(""):
            line = self.parser.split(line)
        buffer = []
        for char in line:
            try:
                buffer.append(self.NUMBER[char])
            except KeyError:
                if error == "strict":
                    return None
        try:
            return int(string.join(buffer, ""))
        except ValueError:
            return None
    def is_number(self, line):
        return self.to_integer(line) is not None
    ZENKAKU = {
        "0": "", "1": "", "2": "", "3": "", "4": "",
        "5": "", "6": "", "7": "", "8": "", "9": "",
        "+": "",  "-": "",
        }
    def to_zenkaku(self, s):
        buffer = list(str(s))
        for i in range(len(buffer)):
            buffer[i] = self.ZENKAKU.get(buffer[i], buffer[i])
        return string.join(buffer, "")
    RESERVED = [
        "ǯ", "߷", "", "",
        "߻", "ʬ", "",
        "ư", "ưʬ", "ư",
        "߷׻", "߷ʬ", "߷",
        "ϣӵư", "ϣӵưʬ", "ϣӵư",
        "ñ㵯ưʬ", "ñ㵯ư",
        "ñ߷ʬ", "ñ߷",
        "ñϣӵưʬ", "ñϣӵư",
        "ǽȡηв",
        "ե0", "ե1",
        "ɣ", "٥", "ֹ",
        "ͽȡ",
        "ư",
        "Sender", "Event", "Charset",
        "Reference0", "Reference1", "Reference2", "Reference3",
        "Reference4", "Reference5", "Reference6", "Reference7",
        "countTalk", "countNoNameTalk", "countEventTalk", "countOtherTalk",
        "countWords", "countWord", "countVariable", "countAnchor",
        "countParenthesis", "countParentheres", "countLine",
        ]
    def is_reserved(self, s):
        return s in self.RESERVED
    DAYOFWEEK = ["", "", "", "", "", "", ""]
    def get_reserved(self, s):
        now = time.localtime(time.time())
        if s == "ǯ":
            return self.to_zenkaku(now[0])
        elif s == "߷":
            return self.to_zenkaku(now[1])
        elif s == "":
            return self.to_zenkaku(now[2])
        elif s == "߻":
            return self.to_zenkaku(now[3])
        elif s == "ʬ":
            return self.to_zenkaku(now[4])
        elif s == "":
            return self.to_zenkaku(now[5])
        elif s == "":
            return self.DAYOFWEEK[now[6]]
        runtime = self.get_runtime()
        if s == "ư":
            return self.to_zenkaku(runtime / 3600)
        elif s == "ưʬ":
            return self.to_zenkaku(runtime / 60 % 60)
        elif s == "ư":
            return self.to_zenkaku(runtime % 60)
        elif s == "ñ㵯ưʬ":
            return self.to_zenkaku(runtime / 60)
        elif s == "ñ㵯ư":
            return self.to_zenkaku(runtime)
        accumulative_runtime = self.runtime + self.get_runtime()
        if s == "߷׻":
            return self.to_zenkaku(accumulative_runtime / 3600)
        elif s == "߷ʬ":
            return self.to_zenkaku(accumulative_runtime / 60 % 60)
        elif s == "߷":
            return self.to_zenkaku(accumulative_runtime % 60)
        elif s == "ñ߷ʬ":
            return self.to_zenkaku(accumulative_runtime / 60)
        elif s == "ñ߷":
            return self.to_zenkaku(accumulative_runtime)
        elif s == "ư":
            return self.to_zenkaku(self.runcount)
        elif s == "ǽȡηв":
            return self.to_zenkaku(self.silent_time)
        elif s == "ե0":
            return str(self.current_surface[0])
        elif s == "ե1":
            return str(self.current_surface[1])
        elif s == "ɣ":
            if self.choice_id is None:
                return ""
            else:
                return self.choice_id
        elif s == "٥":
            if self.choice_label is None:
                return ""
            else:
                return self.choice_label
        elif s == "ֹ":
            if self.choice_number is None:
                return ""
            else:
                return self.to_zenkaku(self.choice_number)
        elif s == "ͽȡ":
            return self.to_zenkaku(len(self.reserved_talk))
        elif s == "Sender":
            return "ninix"
        elif s == "Event":
            return self.event
        elif s == "Charset":
            return "EUC-JP"
        elif s[:9] == "Reference":
            n = int(s[9:])
            if self.reference[n] is None:
                return ""
            return str(self.reference[n])
        elif s[:5] == "count":
            return self.to_zenkaku(self.parser.get_count(s[5:]))
        return ""

class Shiori(Satori):
    def __init__(self, dll_name, debug=0):
        self.debug = debug
        self.dll_name = dll_name
        self.saori = None
        self.saori_function = {}
    def use_saori(self, saori):
        self.saori = saori
    def load(self, satori_dir):
        Satori.__init__(self, satori_dir, self.debug)
        self.saori_library = SatoriSaoriLibrary(self.saori, self)
        Satori.load(self)
        return 1
    def load_config_file(self, path):
        parser = Parser()
        parser.read(path)
        talk, word = parser.get_dict()
        for nodelist in talk.get("", []):
            self.expand(nodelist)
        self.saori_function = {}
        for nodelist in word.get("SAORI", []):
            if nodelist[0][0] == NODE_TEXT:
                list = string.split(string.join(nodelist[0][1], ''), ',')
                if len(list) >= 2 and list[0] and list[1]:
                    head, tail = os.path.split(list[1])
                    dir = os.path.join(self.satori_dir, head)
                    result =  self.saori_library.load(list[1], dir)
                    if result:
                        self.saori_function[list[0]] = list[1:]
                    else:
                        self.saori_function[list[0]] = None
                        ##print "satori.py: cannot load %s" % list[1]
        self.parser.set_saori(self.saori_function.keys())
    def reload(self):
        self.finalize()
        self.reset()
        self.load(self.satori_dir)
    def unload(self):
        Satori.finalize(self)
        self.saori_library.unload()
    def find(self, dir, dll_name):
        result = 0
        if list_dict(dir):
            result = 100
        return result
    def show_description(self):
        sys.stdout.write('Shiori: SATORI compatible module for ninix\n'
                         '        Copyright (C) 2002 by Tamito KAJIYAMA\n')
    def request(self, req_string):
        if self.folder_change:
            self.change_folder()
            self.folder_change = 0
        header = StringIO.StringIO(req_string)
        req_header = {}
        line = header.readline()
        if line:
            line = string.strip(line)
            list = string.split(line)
            if len(list) >= 2:
                command = string.strip(list[0])
                protocol = string.strip(list[1])
            while 1:
                line = header.readline()
                if not line:
                    break # EOF
                line = string.strip(line)
                if not line:
                    continue
                colon = string.find(line, ':')
                if colon >= 0:
                    key = string.strip(line[:colon])
                    value = string.strip(line[colon+1:])
                    try:
                        value = int(value)
                    except:
                        value = str(value)
                    req_header[key] = value
                else:
                    continue
        result = ''
        to = None
        if req_header.has_key('ID'):
            if req_header['ID'] == 'charset':
                result = 'EUC-JP'
            elif req_header['ID'] == 'dms':
                result = self.getdms()
            elif req_header['ID'] == 'OnAITalk':
                result = self.getaistringrandom()
            elif req_header['ID'] in ["ms", "mz", "ml", "mc", "mh", \
                                      "mt", "me", "mp", "m?"]:
                result = self.getword(req_header['ID'])
            elif req_header['ID'] == 'otherghostname': ## FIXME
                ##otherghost = []
                ##for n in range(128):
                ##    if req_header.has_key('Reference'+str(n)):
                ##        otherghost.append(req_header['Reference'+str(n)])
                ##result = self.otherghostname(otherghost)
                pass
            elif req_header['ID'] == 'OnTeach':
                if req_header.has_key('Reference0'):
                    self.teach(req_header['Reference0'])
            else:
                result = self.getstring(req_header['ID'])
                if result == None:
                    ref = []
                    for n in range(8):
                        if req_header.has_key('Reference'+str(n)):
                            ref.append(req_header['Reference'+str(n)])
                        else:
                            ref.append(None)
                    ref0, ref1, ref2, ref3, ref4, ref5, ref6, ref7 = ref
                    result = self.get_event_response(
                        req_header['ID'], ref0, ref1, ref2, ref3, ref4, ref5, ref6, ref7)
            if result == None:
                result = ''
            to = None ##self.communicate_to() ## FIXME
        if result != '':
            self.silent_time = 0
        result = 'SHIORI/3.0 200 OK\r\n' \
                 'Sender: Satori\r\n' \
                 'Value: %s\r\n' % result
        if to != None:
            result = result + 'Reference0: %s\r\n' % to
        result = result + '\r\n'
        return result
    def call_saori(self, name, args, history, side):
        if not self.saori_function.has_key(name) or \
           self.saori_function[name] is None:
            return ''
        saori_statuscode = ''
        saori_header = []
        saori_value = {}
        saori_protocol = ''
        req = 'EXECUTE SAORI/1.0\r\n' \
              'Sender: Satori\r\n' \
              'SecurityLevel: local\r\n' \
              'Charset: Shift_JIS\r\n'
        default_args = self.saori_function[name][1:]
        n = len(default_args)
        for i in range(len(default_args)):
              req = req + 'Argument%s: %s\r\n' % (i, default_args[i])
        for i in range(len(args)):
              argument = self.expand(args[i], history)
              if argument:
                  req = req + 'Argument%s: %s\r\n' % (i + n, argument)
        req = req + '\r\n'
        ##print 'SAORI(0):', name, self.saori_function[name][0]
        ##print 'SAORI(1):', req
        response = self.saori_library.request(self.saori_function[name][0], kanjilib.euc2sjis(req, 'ignore'))
        ##print 'SAORI(2):', response
        header = StringIO.StringIO(response)
        line = header.readline()
        if line:
            if line[-1] == '\n':
                line = line[:-1]
            line = string.strip(line)
            pos_space = string.find(line, ' ')
            if pos_space >= 0:
                saori_protocol = string.strip(line[:pos_space])
                saori_statuscode = string.strip(line[pos_space:])
            while 1:
                line = header.readline()
                if not line:
                    break # EOF
                if line[-1] == '\n':
                    line = line[:-1]
                line = string.strip(line)
                if not line:
                    continue
                colon = string.find(line, ':')
                if colon >= 0:
                    key = string.strip(line[:colon])
                    value = string.strip(line[colon+1:])
                    if key:
                        saori_header.append(key)
                        saori_value[key] = value
        if saori_value.has_key('Result'):
            ##print 'SAORI(3):', saori_value['Result']
            return kanjilib.sjis2euc(saori_value['Result'], 'ignore')
        else:
            return ''

class SatoriSaoriLibrary:
    def __init__(self, saori, satori):
        self.saori_list = {}
        self.saori = saori
        self.satori = satori
    def load(self, name, dir):
        result = 0
        if self.saori and not self.saori_list.has_key(name):
            module = self.saori.request(name)
            if module:
                self.saori_list[name] = module
        if self.saori_list.has_key(name):
            result = self.saori_list[name].load(dir)
        return result
    def unload(self):
        for key in self.saori_list.keys():
            self.saori_list[key].unload()
        return None
    def request(self, name, req):
        result = '' # FIXME
        if name and self.saori_list.has_key(name):
            result = self.saori_list[name].request(req)
        return result

def open(dir, debug=0):
    satori = Satori(dir, debug)
    satori.load()
    return satori

###   TEST   ###

def test():
    if sys.argv[1] == "ini":
        test_ini(sys.argv[2])
    elif sys.argv[1] == "parser":
        test_parser(sys.argv[2])
    elif sys.argv[1] == "interp":
        test_interp(sys.argv[2])

def test_ini(dir):
    list = list_dict(dir)
    print "number of files =", len(list)
    for dict in list:
        print dict

def test_parser(path):
    parser = Parser()
    parser.read(path)
    for name, talk in parser.talk.items():
        for list in talk:
            print "", name
            parser.print_nodelist(list)
            print
    for name, word in parser.word.items():
        print "", name
        for list in word:
            print ">>>", test_expand(list)
            parser.print_nodelist(list, 2)
        print

def test_expand(list):
    buffer = []
    for node in list:
        if node[0] == NODE_TEXT:
            buffer.extend(node[1])
        elif node[0] == NODE_REF:
            buffer.extend(test_expand(node[1]))
        else:
            raise RuntimeError, "should not reach here"
    return string.join(buffer, "")

def test_interp(dir):
    import readline
    satori = Satori(dir)
    satori.load()
    while 1:
        try:
            name = raw_input(">>> ")
        except:
            break
        if name[:2] == "":
            print satori.getstring(name[2:])
        elif name[:2] == "":
            print satori.get_event_response(name[2:])
        else:
            print satori.get_event_response(name)

if __name__ == "__main__":
    test()
