#
#  saori_cpuid.py - a fake saori_cpuid compatible Saori module for ninix
#  Copyright (C) 2003 by Shyouzou Sugitani <shy@debian.or.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

import os
import string
import StringIO
import codecs
import whrandom

class Saori:
    entry = {'cpu.num': ["1", "2", "3", "5", "7", "11", "13"],
             'cpu.vender': ["Inte1", "AM0", 'VlA'],
             'cpu.ptype': ["Lazy"],
             'cpu.family': ["780", "Bentium", "A+hlon"],
             'cpu.model': ["Unknown"],
             'cpu.stepping': ["Not Genuine"],
             'cpu.mmx': ["Ready", "Not Ready"],
             'cpu.sse': ["Ready", "Not Ready"],
             'cpu.sse2': ["Ready", "Not Ready"],
             'cpu.tdn': ["Ready", "Not Ready"],
             'cpu.mmx+': ["Ready", "Not Ready"],
             'cpu.tdn+': ["Ready", "Not Ready"],
             'cpu.clock': ["0", "1000000"],
             'cpu.clockex': ["0.001", "1.001"],
             'mem.os': ["100", "10", "44", "50", "77", "99"],
             'mem.phyt': ["0.1", "200000000"],
             'mem.phya': ["0.00000001"],
             'mem.pagt': ["1", "4"],
             'mem.paga': ["1", "4"],
             'mem.virt': ["0"],
             'mem.vira': ["0"],
             'os.name': ["Doors", "BSE", "WAX"],
             'os.version': ["3.14159265358979"],
             'os.build': ["Tomorrow"],
             'platform': ["Caffeine"],
            }
    def __init__(self):
	self.loaded = 0
    def load(self, dir=os.curdir):
        self.dir = dir
        result = 0
        if self.loaded:
	    result = 2
        else:
            self.loaded = 1
            result = 1
	return result
    def unload(self):
        self.loaded = 0
        return 1
    def request(self, req):
        type, argument, charset = self.evaluate_request(req)
        if not type:
            return 'SAORI/1.0 400 Bad Request\r\n\r\n'
        elif type == 'GET Version':
            return 'SAORI/1.0 204 No Content\r\n\r\n'
        elif type == 'EXECUTE':
            if len(argument) == 0:
                return 'SAORI/1.0 400 Bad Request\r\n\r\n'
            if len(argument) > 1 and argument[1] == 0:
                return 'SAORI/1.0 204 No Content\r\n\r\n'
            if self.entry.has_key(argument[0]):
                value = whrandom.choice(self.entry[argument[0]])
                return 'SAORI/1.0 200 OK\r\nResult: %s\r\n\r\n' % value
            else:
                return 'SAORI/1.0 204 No Content\r\n\r\n'
    def evaluate_request(self, req):
        type = None
        argument = []
        charset = 'Shift_JIS' # default
        header = StringIO.StringIO(req)
        line = header.readline()
        if not line:
            return type, argument
        if line[-1] == '\n':
            line = line[:-1]
        line = string.strip(line)
        if not line:
            return type, argument
        for request in ['EXECUTE', 'GET Version']:
            if line[:len(request)] == request:
                type = request
                break
        while 1:
            line = header.readline()
            if not line:
                break # EOF
            if line[-1] == '\n':
                line = line[:-1]
            line = string.strip(line)
            if not line:
                continue
            colon = string.find(line, ':')
            if colon >= 0:
                key = string.strip(line[:colon])
                value = string.strip(line[colon+1:])
                if key == 'Charset':
                    charset = value
                    try:
                        codecs.lookup(charset)
                    except:
                        sys.stderr.write("Unsupported charset %s" % repr(charset))
                if key[:8] == 'Argument':
                    argument.append(value)
                else:
                    continue
        return type, argument, charset
