#!/usr/bin/perl -w

use strict;
use File::Find;
use File::Spec::Functions ();
use FindBin;
use lib "$FindBin::Bin/../lib";
use bric_upgrade;
use Bric::Config qw(BURN_COMP_ROOT);
use Bric::Util::Trans::FS;

my $fs = Bric::Util::Trans::FS->new;

find(\&rm_dhandler, BURN_COMP_ROOT);

sub rm_dhandler {
    return unless $_ eq 'dhandler';
    print "Deleting $File::Find::name\n";
    $fs->del($File::Find::name);
}

__END__

This script will delete all the dhandlers in the Template root. This is
necessary because these files, which are auto-generated by Bricolage, have
changed format with the release of Bricolage 1.2.0.
