#
# unix/Common.mk.in  --
#
# Common macro definitions used by all include files.
#------------------------------------------------------------------------------
# Copyright 1995-1997 Karl Lehenbauer and Mark Diekhans.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies.  Karl Lehenbauer and
# Mark Diekhans make no representations about the suitability of this
# software for any purpose.  It is provided "as is" without express or
# implied warranty.
#------------------------------------------------------------------------------
# $Id: Common.mk.in,v 8.7.2.3 1998/12/04 02:51:56 suresh Exp $
#------------------------------------------------------------------------------
#

SHELL = /bin/sh

#------------------------------------------------------------------------------
# Tcl and Tk versions
#
TCL_VERSION      = 8.0jp
TK_VERSION       = 8.0jp

#------------------------------------------------------------------------------
# TclX version information extracted from tclExtend.h.
#
TCLX_VERSION       = 8.0.4
TCLX_FULL_VERSION  = 8.0.4

TKX_VERSION        = 8.0.4
TKX_FULL_VERSION   = 8.0.4

#------------------------------------------------------------------------------
# Autoconfig defines that can be overridden in Config.mk.
#
CC           = cc -pipe -Wall
CFLAGS       = -g -O2 
SYSCFLAGS    = 
RANLIB       = ranlib
LN_S         = ln -s
srcbasedir   = /usr/local/src/lang/tcl/tclX8.0.4
bldbasedir   = /usr/local/src/lang/tcl/tclX8.0.4
prefix       = /usr
exec_prefix  = /usr

#------------------------------------------------------------------------------
# TclX configuration information determined by configure.
#
BUILD_SHARED = YES
TKX_BUILD    = YES
TCLX_DEFS    =  -DSTDC_HEADERS=1 -DRETSIGTYPE=void 
TCLX_LIBS    = 

#------------------------------------------------------------------------------
# Library names.
#
TCL_STLIB_NAME  = libtcl8.0jp.a
TK_STLIB_NAME   = libtk8.0jp.a

TCLX_SHLIB_NAME = libtclx8.0.4.so
TCLX_STLIB_NAME = libtclx8.0.4.a
TCLX_LIB_NAME   = libtclx8.0.4.so

TKX_SHLIB_NAME       = libtkx8.0.4.so
TKX_STLIB_NAME       = libtkx8.0.4.a
TKX_LIB_NAME         = libtkx8.0.4.so

#------------------------------------------------------------------------------
# Compiler flag to use when generating shared object files.  Unixware cc will
# only output the name of the .c file, so we hack it.

CC_SHOBJ_FLAG = -o $@

#------------------------------------------------------------------------------
# Linker arguments to pick up TclX libraries.
#
TCLX_BUILD_LIB_SPEC  = -L/usr/local/src/lang/tcl/tclX8.0.4/tcl/unix -ltclx8.0.4
TKX_BUILD_LIB_SPEC   = -L/usr/local/src/lang/tcl/tclX8.0.4/tk/unix -ltkx8.0.4
TCLX_LD_SEARCH_FLAGS = 
TCLX_CC_SEARCH_FLAGS = 
TKX_LD_SEARCH_FLAGS  = 
TKX_CC_SEARCH_FLAGS  = 

#------------------------------------------------------------------------------
# Configuration information from tclConfig.sh and tkConfig.sh.
#
KANJI_FLAGS = -DKANJI -DBUGFIX -DHANDLE_KANJI_PATHNAME
TCL_DEFS             =  -DHAVE_GETCWD=1 -DHAVE_OPENDIR=1 -DHAVE_STRSTR=1 -DHAVE_STRTOL=1 -DHAVE_TMPNAM=1 -DHAVE_WAITPID=1 -DHAVE_UNISTD_H=1 -DUSE_TERMIOS=1 -DHAVE_SYS_TIME_H=1 -DTIME_WITH_SYS_TIME=1 -DHAVE_TM_ZONE=1 -DHAVE_TM_GMTOFF=1 -DHAVE_TIMEZONE_VAR=1 -DHAVE_ST_BLKSIZE=1 -DSTDC_HEADERS=1 -DNEED_MATHERR=1 -DRETSIGTYPE=void -DHAVE_SIGNED_CHAR=1 -DHAVE_SYS_IOCTL_H=1  -DKANJI -DBUGFIX -DHANDLE_KANJI_PATHNAME $(KANJI_FLAGS)
TCL_LIBS             = -ldl  -lieee -lm
TCL_EXEC_PREFIX      = /usr
TCL_SHLIB_CFLAGS     = -fpic
TCL_LD_FLAGS         = -rdynamic
TCL_DL_LIBS          = -ldl
TCL_SHLIB_LD         = cc -shared
TCL_SHLIB_LD_LIBS    = ${LIBS}
TCL_DBGX             = 
TCL_BUILD_LIB_SPEC   = -L/usr/local/src/lang/tcl/tcl8.0.5jp/unix -ltcl8.0jp${TCL_DBGX}
TCL_LIB_SPEC         = -L/usr/lib -ltcl8.0jp${TCL_DBGX}
TCL_LD_SEARCH_FLAGS  = 

TK_KANJI_FLAGS = -DKANJI -DBUGFIX -DHANDLE_KANJI_PATHNAME -DKINPUT2 -DXIM_IMPROVE -DCHECK_XLFD
TK_DEFS              =  -DHAVE_UNISTD_H=1 -DHAVE_LIMITS_H=1 -DSTDC_HEADERS=1 -DHAVE_SYS_TIME_H=1 -DTIME_WITH_SYS_TIME=1  -DHAVE_XIMREGINSTCB  -Dlinux -D__i386__ -D_POSIX_C_SOURCE=199309L -D_POSIX_SOURCE -D_XOPEN_SOURCE=500L -D_BSD_SOURCE -D_SVID_SOURCE -DFUNCPROTO=15 -DNARROWPROTO -DKANJI -DBUGFIX -DHANDLE_KANJI_PATHNAME -DKINPUT2 -DXIM_IMPROVE -DCHECK_XLFD $(TK_KANJI_FLAGS)
TK_LIBS              = -L/usr/X11R6/lib -lX11 -ldl  -lieee -lm
TK_EXEC_PREFIX       = /usr
TK_XINCLUDES         = -I/usr/X11R6/include
TK_XLIBSW            = -L/usr/X11R6/lib -lX11
TK_DBGX              = 
TK_BUILD_LIB_SPEC    = -L/usr/local/src/lang/tcl/tk8.0.5jp/unix -ltk8.0jp${TK_DBGX}
TK_LIB_SPEC          = -L/usr/lib -ltk8.0jp${TK_DBGX}
TK_LD_SEARCH_FLAGS   = 

#------------------------------------------------------------------------------
# Location of directories.
#
TCL_GENERIC_DIR    = ${TCL_SRC}/generic
TCL_UNIX_DIR       = ${TCL_SRC}/unix
TCL_LIBRARY_DIR    = ${TCL_SRC}/library
TK_GENERIC_DIR     = ${TK_SRC}/generic
TK_UNIX_DIR        = ${TK_SRC}/unix

TCLX_GENERIC_DIR   = ${srcbasedir}/tcl/generic
TCLX_UNIX_SRC_DIR  = ${srcbasedir}/tcl/unix
TCLX_UNIX_BLD_DIR  = ${bldbasedir}/tcl/unix
TKX_GENERIC_DIR    = ${srcbasedir}/tk/generic
TKX_UNIX_SRC_DIR   = ${srcbasedir}/tk/unix
TKX_UNIX_BLD_DIR   = ${bldbasedir}/tk/unix
COMPAT_DIR         = ${srcbasedir}/tcl/compat

#------------------------------------------------------------------------------
# Programs run during the build.
#
TCLX_TMP_RUNTIME   = ${bldbasedir}/tcl/unix
TKX_TMP_RUNTIME    = ${bldbasedir}/tk/unix

RUNTCL             = ${bldbasedir}/unix/runtcl
RUNWISHX           = ${bldbasedir}/unix/runwishx
GENTNDX            = ${RUNTCL} ${srcbasedir}/unix/tools/genindex.tcl
BLDMANHELP         = ${RUNTCL} ${bldbasedir}/unix/tools/bldmanhelp
CONVERTLIB         = ${RUNTCL} ${srcbasedir}/unix/tools/libconvert.tcl
INSTCOPY           = ${RUNTCL} ${bldbasedir}/unix/tools/instcopy
CPMANPAGES         = ${RUNTCL} ${bldbasedir}/unix/tools/cpmanpages

  
#------------------------------------------------------------------------------
# For conversion of a tcl-script into C-strings.  Used in standalone binaries.
# Requires Tcl PlusPatch.
#
.SUFFIXES: .tcl $(SUFFIXES)

.tcl.c:
	${TCL2C} -o $@ -a -n $@ $<
