/* this file was generated by the MCOP idl compiler - DO NOT EDIT */

#ifndef ARTSMIDI_H
#define ARTSMIDI_H

#include "common.h"

// includes of other idl definitions
#include "artsflow.h"

namespace Arts {
enum MidiCommandStatus {mcsCommandMask = 240, mcsChannelMask = 15, mcsNoteOff = 128, mcsNoteOn = 144, mcsKeyPressure = 160, mcsParameter = 176, mcsProgram = 192, mcsChannelPressure = 208, mcsPitchWheel = 224};
enum MidiCommandParameter {mcpSustain = 64, mcpAllNotesOff = 123};
enum MidiClientDirection {mcdPlay = 0, mcdRecord = 1};
enum MidiClientType {mctDestination = 0, mctApplication = 1};
};
namespace Arts {
class TimeStamp : public Arts::Type {
public:
	TimeStamp();
	TimeStamp(long _a_sec, long _a_usec);
	TimeStamp(Arts::Buffer& stream);
	TimeStamp(const TimeStamp& copyType);
	TimeStamp& operator=(const TimeStamp& assignType);
	long sec;
	long usec;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
	std::string _typeName() const;
};

class MidiCommand : public Arts::Type {
public:
	MidiCommand();
	MidiCommand(Arts::mcopbyte _a_status, Arts::mcopbyte _a_data1, Arts::mcopbyte _a_data2);
	MidiCommand(Arts::Buffer& stream);
	MidiCommand(const MidiCommand& copyType);
	MidiCommand& operator=(const MidiCommand& assignType);
	Arts::mcopbyte status;
	Arts::mcopbyte data1;
	Arts::mcopbyte data2;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
	std::string _typeName() const;
};

class MidiEvent : public Arts::Type {
public:
	MidiEvent();
	MidiEvent(const Arts::TimeStamp& _a_time, const Arts::MidiCommand& _a_command);
	MidiEvent(Arts::Buffer& stream);
	MidiEvent(const MidiEvent& copyType);
	MidiEvent& operator=(const MidiEvent& assignType);
	Arts::TimeStamp time;
	Arts::MidiCommand command;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
	std::string _typeName() const;
};

class MidiClientInfo : public Arts::Type {
public:
	MidiClientInfo();
	MidiClientInfo(long _a_ID, const std::vector<long>& _a_connections, Arts::MidiClientDirection _a_direction, Arts::MidiClientType _a_type, const std::string& _a_title, const std::string& _a_autoRestoreID);
	MidiClientInfo(Arts::Buffer& stream);
	MidiClientInfo(const MidiClientInfo& copyType);
	MidiClientInfo& operator=(const MidiClientInfo& assignType);
	long ID;
	std::vector<long> connections;
	Arts::MidiClientDirection direction;
	Arts::MidiClientType type;
	std::string title;
	std::string autoRestoreID;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
	std::string _typeName() const;
};

};
namespace Arts {
class MidiPort;
class MidiClient;
class MidiSyncGroup;
class MidiManager;
class MidiTest;
class RawMidiPort;
class AlsaMidiGateway;
class AlsaMidiPort;
class AudioSync;
class MidiTimer;
class SystemMidiTimer;
class AudioMidiTimer;

class MidiPort_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static MidiPort_base *_create(const std::string& subClass = "Arts::MidiPort");
	static MidiPort_base *_fromString(const std::string& objectref);
	static MidiPort_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static MidiPort_base *_fromDynamicCast(const Arts::Object& object);
	inline MidiPort_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::TimeStamp time() = 0;
	virtual Arts::TimeStamp playTime() = 0;
	virtual void processCommand(const Arts::MidiCommand& command) = 0;
	virtual void processEvent(const Arts::MidiEvent& event) = 0;
};

class MidiPort_stub : virtual public MidiPort_base, virtual public Arts::Object_stub {
protected:
	MidiPort_stub();

public:
	MidiPort_stub(Arts::Connection *connection, long objectID);

	Arts::TimeStamp time();
	Arts::TimeStamp playTime();
	void processCommand(const Arts::MidiCommand& command);
	void processEvent(const Arts::MidiEvent& event);
};

class MidiPort_skel : virtual public MidiPort_base, virtual public Arts::Object_skel {
public:
	MidiPort_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class MidiPort : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	MidiPort_base *_cache;
	inline MidiPort_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(MidiPort_base *)_pool->base->_cast(MidiPort_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline MidiPort(MidiPort_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef MidiPort_base _base_class;

	inline MidiPort() : Arts::Object(_Creator), _cache(0) {}
	inline MidiPort(const Arts::SubClass& s) :
		Arts::Object(MidiPort_base::_create(s.string())), _cache(0) {}
	inline MidiPort(const Arts::Reference &r) :
		Arts::Object(r.isString()?(MidiPort_base::_fromString(r.string())):(MidiPort_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline MidiPort(const Arts::DynamicCast& c) : Arts::Object(MidiPort_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline MidiPort(const MidiPort& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline MidiPort(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static MidiPort null() {return MidiPort((MidiPort_base*)0);}
	inline static MidiPort _from_base(MidiPort_base* b) {return MidiPort(b);}
	inline MidiPort& operator=(const MidiPort& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline MidiPort_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::TimeStamp time();
	inline Arts::TimeStamp playTime();
	inline void processCommand(const Arts::MidiCommand& command);
	inline void processEvent(const Arts::MidiEvent& event);
};

class MidiClient_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static MidiClient_base *_create(const std::string& subClass = "Arts::MidiClient");
	static MidiClient_base *_fromString(const std::string& objectref);
	static MidiClient_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static MidiClient_base *_fromDynamicCast(const Arts::Object& object);
	inline MidiClient_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::MidiClientInfo info() = 0;
	virtual std::string title() = 0;
	virtual void title(const std::string& newValue) = 0;
	virtual void addInputPort(Arts::MidiPort port) = 0;
	virtual Arts::MidiPort addOutputPort() = 0;
	virtual void removePort(Arts::MidiPort port) = 0;
};

class MidiClient_stub : virtual public MidiClient_base, virtual public Arts::Object_stub {
protected:
	MidiClient_stub();

public:
	MidiClient_stub(Arts::Connection *connection, long objectID);

	Arts::MidiClientInfo info();
	std::string title();
	void title(const std::string& newValue);
	void addInputPort(Arts::MidiPort port);
	Arts::MidiPort addOutputPort();
	void removePort(Arts::MidiPort port);
};

class MidiClient_skel : virtual public MidiClient_base, virtual public Arts::Object_skel {
protected:
	// emitters for change notifications
	inline void title_changed(const std::string& newValue) {
		_emit_changed("title_changed",newValue);
	}

public:
	MidiClient_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class MidiClient : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	MidiClient_base *_cache;
	inline MidiClient_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(MidiClient_base *)_pool->base->_cast(MidiClient_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline MidiClient(MidiClient_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef MidiClient_base _base_class;

	inline MidiClient() : Arts::Object(_Creator), _cache(0) {}
	inline MidiClient(const Arts::SubClass& s) :
		Arts::Object(MidiClient_base::_create(s.string())), _cache(0) {}
	inline MidiClient(const Arts::Reference &r) :
		Arts::Object(r.isString()?(MidiClient_base::_fromString(r.string())):(MidiClient_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline MidiClient(const Arts::DynamicCast& c) : Arts::Object(MidiClient_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline MidiClient(const MidiClient& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline MidiClient(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static MidiClient null() {return MidiClient((MidiClient_base*)0);}
	inline static MidiClient _from_base(MidiClient_base* b) {return MidiClient(b);}
	inline MidiClient& operator=(const MidiClient& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline MidiClient_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::MidiClientInfo info();
	inline std::string title();
	inline void title(const std::string& _newValue);
	inline void addInputPort(Arts::MidiPort port);
	inline Arts::MidiPort addOutputPort();
	inline void removePort(Arts::MidiPort port);
};

class MidiSyncGroup_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static MidiSyncGroup_base *_create(const std::string& subClass = "Arts::MidiSyncGroup");
	static MidiSyncGroup_base *_fromString(const std::string& objectref);
	static MidiSyncGroup_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static MidiSyncGroup_base *_fromDynamicCast(const Arts::Object& object);
	inline MidiSyncGroup_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual void addClient(Arts::MidiClient client) = 0;
	virtual void removeClient(Arts::MidiClient client) = 0;
	virtual void addAudioSync(Arts::AudioSync audioSync) = 0;
	virtual void removeAudioSync(Arts::AudioSync audioSync) = 0;
};

class MidiSyncGroup_stub : virtual public MidiSyncGroup_base, virtual public Arts::Object_stub {
protected:
	MidiSyncGroup_stub();

public:
	MidiSyncGroup_stub(Arts::Connection *connection, long objectID);

	void addClient(Arts::MidiClient client);
	void removeClient(Arts::MidiClient client);
	void addAudioSync(Arts::AudioSync audioSync);
	void removeAudioSync(Arts::AudioSync audioSync);
};

class MidiSyncGroup_skel : virtual public MidiSyncGroup_base, virtual public Arts::Object_skel {
public:
	MidiSyncGroup_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class MidiSyncGroup : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	MidiSyncGroup_base *_cache;
	inline MidiSyncGroup_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(MidiSyncGroup_base *)_pool->base->_cast(MidiSyncGroup_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline MidiSyncGroup(MidiSyncGroup_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef MidiSyncGroup_base _base_class;

	inline MidiSyncGroup() : Arts::Object(_Creator), _cache(0) {}
	inline MidiSyncGroup(const Arts::SubClass& s) :
		Arts::Object(MidiSyncGroup_base::_create(s.string())), _cache(0) {}
	inline MidiSyncGroup(const Arts::Reference &r) :
		Arts::Object(r.isString()?(MidiSyncGroup_base::_fromString(r.string())):(MidiSyncGroup_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline MidiSyncGroup(const Arts::DynamicCast& c) : Arts::Object(MidiSyncGroup_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline MidiSyncGroup(const MidiSyncGroup& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline MidiSyncGroup(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static MidiSyncGroup null() {return MidiSyncGroup((MidiSyncGroup_base*)0);}
	inline static MidiSyncGroup _from_base(MidiSyncGroup_base* b) {return MidiSyncGroup(b);}
	inline MidiSyncGroup& operator=(const MidiSyncGroup& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline MidiSyncGroup_base* _base() {return _cache?_cache:_method_call();}

	inline void addClient(Arts::MidiClient client);
	inline void removeClient(Arts::MidiClient client);
	inline void addAudioSync(Arts::AudioSync audioSync);
	inline void removeAudioSync(Arts::AudioSync audioSync);
};

class MidiManager_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static MidiManager_base *_create(const std::string& subClass = "Arts::MidiManager");
	static MidiManager_base *_fromString(const std::string& objectref);
	static MidiManager_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static MidiManager_base *_fromDynamicCast(const Arts::Object& object);
	inline MidiManager_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::vector<Arts::MidiClientInfo> * clients() = 0;
	virtual Arts::MidiClient addClient(Arts::MidiClientDirection direction, Arts::MidiClientType type, const std::string& title, const std::string& autoRestoreID) = 0;
	virtual void connect(long clientID, long destinationID) = 0;
	virtual void disconnect(long clientID, long destinationID) = 0;
	virtual Arts::MidiSyncGroup addSyncGroup() = 0;
};

class MidiManager_stub : virtual public MidiManager_base, virtual public Arts::Object_stub {
protected:
	MidiManager_stub();

public:
	MidiManager_stub(Arts::Connection *connection, long objectID);

	std::vector<Arts::MidiClientInfo> * clients();
	Arts::MidiClient addClient(Arts::MidiClientDirection direction, Arts::MidiClientType type, const std::string& title, const std::string& autoRestoreID);
	void connect(long clientID, long destinationID);
	void disconnect(long clientID, long destinationID);
	Arts::MidiSyncGroup addSyncGroup();
};

class MidiManager_skel : virtual public MidiManager_base, virtual public Arts::Object_skel {
public:
	MidiManager_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class MidiManager : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	MidiManager_base *_cache;
	inline MidiManager_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(MidiManager_base *)_pool->base->_cast(MidiManager_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline MidiManager(MidiManager_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef MidiManager_base _base_class;

	inline MidiManager() : Arts::Object(_Creator), _cache(0) {}
	inline MidiManager(const Arts::SubClass& s) :
		Arts::Object(MidiManager_base::_create(s.string())), _cache(0) {}
	inline MidiManager(const Arts::Reference &r) :
		Arts::Object(r.isString()?(MidiManager_base::_fromString(r.string())):(MidiManager_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline MidiManager(const Arts::DynamicCast& c) : Arts::Object(MidiManager_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline MidiManager(const MidiManager& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline MidiManager(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static MidiManager null() {return MidiManager((MidiManager_base*)0);}
	inline static MidiManager _from_base(MidiManager_base* b) {return MidiManager(b);}
	inline MidiManager& operator=(const MidiManager& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline MidiManager_base* _base() {return _cache?_cache:_method_call();}

	inline std::vector<Arts::MidiClientInfo> * clients();
	inline Arts::MidiClient addClient(Arts::MidiClientDirection direction, Arts::MidiClientType type, const std::string& title, const std::string& autoRestoreID);
	inline void connect(long clientID, long destinationID);
	inline void disconnect(long clientID, long destinationID);
	inline Arts::MidiSyncGroup addSyncGroup();
};

class MidiTest_base : virtual public Arts::MidiPort_base {
public:
	static unsigned long _IID; // interface ID

	static MidiTest_base *_create(const std::string& subClass = "Arts::MidiTest");
	static MidiTest_base *_fromString(const std::string& objectref);
	static MidiTest_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static MidiTest_base *_fromDynamicCast(const Arts::Object& object);
	inline MidiTest_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class MidiTest_stub : virtual public MidiTest_base, virtual public Arts::MidiPort_stub {
protected:
	MidiTest_stub();

public:
	MidiTest_stub(Arts::Connection *connection, long objectID);

};

class MidiTest_skel : virtual public MidiTest_base, virtual public Arts::MidiPort_skel {
public:
	MidiTest_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class MidiTest : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	MidiTest_base *_cache;
	inline MidiTest_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(MidiTest_base *)_pool->base->_cast(MidiTest_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline MidiTest(MidiTest_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef MidiTest_base _base_class;

	inline MidiTest() : Arts::Object(_Creator), _cache(0) {}
	inline MidiTest(const Arts::SubClass& s) :
		Arts::Object(MidiTest_base::_create(s.string())), _cache(0) {}
	inline MidiTest(const Arts::Reference &r) :
		Arts::Object(r.isString()?(MidiTest_base::_fromString(r.string())):(MidiTest_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline MidiTest(const Arts::DynamicCast& c) : Arts::Object(MidiTest_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline MidiTest(const MidiTest& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline MidiTest(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static MidiTest null() {return MidiTest((MidiTest_base*)0);}
	inline static MidiTest _from_base(MidiTest_base* b) {return MidiTest(b);}
	inline MidiTest& operator=(const MidiTest& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::MidiPort() const { return Arts::MidiPort(*_pool); }
	inline MidiTest_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::TimeStamp time();
	inline Arts::TimeStamp playTime();
	inline void processCommand(const Arts::MidiCommand& command);
	inline void processEvent(const Arts::MidiEvent& event);
};

class RawMidiPort_base : virtual public Arts::MidiPort_base {
public:
	static unsigned long _IID; // interface ID

	static RawMidiPort_base *_create(const std::string& subClass = "Arts::RawMidiPort");
	static RawMidiPort_base *_fromString(const std::string& objectref);
	static RawMidiPort_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static RawMidiPort_base *_fromDynamicCast(const Arts::Object& object);
	inline RawMidiPort_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string device() = 0;
	virtual void device(const std::string& newValue) = 0;
	virtual bool input() = 0;
	virtual void input(bool newValue) = 0;
	virtual bool output() = 0;
	virtual void output(bool newValue) = 0;
	virtual bool running() = 0;
	virtual void running(bool newValue) = 0;
	virtual bool open() = 0;
};

class RawMidiPort_stub : virtual public RawMidiPort_base, virtual public Arts::MidiPort_stub {
protected:
	RawMidiPort_stub();

public:
	RawMidiPort_stub(Arts::Connection *connection, long objectID);

	std::string device();
	void device(const std::string& newValue);
	bool input();
	void input(bool newValue);
	bool output();
	void output(bool newValue);
	bool running();
	void running(bool newValue);
	bool open();
};

class RawMidiPort_skel : virtual public RawMidiPort_base, virtual public Arts::MidiPort_skel {
protected:
	// emitters for change notifications
	inline void device_changed(const std::string& newValue) {
		_emit_changed("device_changed",newValue);
	}
	inline void input_changed(bool newValue) {
		_emit_changed("input_changed",newValue);
	}
	inline void output_changed(bool newValue) {
		_emit_changed("output_changed",newValue);
	}
	inline void running_changed(bool newValue) {
		_emit_changed("running_changed",newValue);
	}

public:
	RawMidiPort_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class RawMidiPort : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	RawMidiPort_base *_cache;
	inline RawMidiPort_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(RawMidiPort_base *)_pool->base->_cast(RawMidiPort_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline RawMidiPort(RawMidiPort_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef RawMidiPort_base _base_class;

	inline RawMidiPort() : Arts::Object(_Creator), _cache(0) {}
	inline RawMidiPort(const Arts::SubClass& s) :
		Arts::Object(RawMidiPort_base::_create(s.string())), _cache(0) {}
	inline RawMidiPort(const Arts::Reference &r) :
		Arts::Object(r.isString()?(RawMidiPort_base::_fromString(r.string())):(RawMidiPort_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline RawMidiPort(const Arts::DynamicCast& c) : Arts::Object(RawMidiPort_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline RawMidiPort(const RawMidiPort& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline RawMidiPort(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static RawMidiPort null() {return RawMidiPort((RawMidiPort_base*)0);}
	inline static RawMidiPort _from_base(RawMidiPort_base* b) {return RawMidiPort(b);}
	inline RawMidiPort& operator=(const RawMidiPort& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::MidiPort() const { return Arts::MidiPort(*_pool); }
	inline RawMidiPort_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::TimeStamp time();
	inline Arts::TimeStamp playTime();
	inline void processCommand(const Arts::MidiCommand& command);
	inline void processEvent(const Arts::MidiEvent& event);
	inline std::string device();
	inline void device(const std::string& _newValue);
	inline bool input();
	inline void input(bool _newValue);
	inline bool output();
	inline void output(bool _newValue);
	inline bool running();
	inline void running(bool _newValue);
	inline bool open();
};

class AlsaMidiGateway_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static AlsaMidiGateway_base *_create(const std::string& subClass = "Arts::AlsaMidiGateway");
	static AlsaMidiGateway_base *_fromString(const std::string& objectref);
	static AlsaMidiGateway_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static AlsaMidiGateway_base *_fromDynamicCast(const Arts::Object& object);
	inline AlsaMidiGateway_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual bool rescan() = 0;
};

class AlsaMidiGateway_stub : virtual public AlsaMidiGateway_base, virtual public Arts::Object_stub {
protected:
	AlsaMidiGateway_stub();

public:
	AlsaMidiGateway_stub(Arts::Connection *connection, long objectID);

	bool rescan();
};

class AlsaMidiGateway_skel : virtual public AlsaMidiGateway_base, virtual public Arts::Object_skel {
public:
	AlsaMidiGateway_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class AlsaMidiGateway : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	AlsaMidiGateway_base *_cache;
	inline AlsaMidiGateway_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(AlsaMidiGateway_base *)_pool->base->_cast(AlsaMidiGateway_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline AlsaMidiGateway(AlsaMidiGateway_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef AlsaMidiGateway_base _base_class;

	inline AlsaMidiGateway() : Arts::Object(_Creator), _cache(0) {}
	inline AlsaMidiGateway(const Arts::SubClass& s) :
		Arts::Object(AlsaMidiGateway_base::_create(s.string())), _cache(0) {}
	inline AlsaMidiGateway(const Arts::Reference &r) :
		Arts::Object(r.isString()?(AlsaMidiGateway_base::_fromString(r.string())):(AlsaMidiGateway_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline AlsaMidiGateway(const Arts::DynamicCast& c) : Arts::Object(AlsaMidiGateway_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline AlsaMidiGateway(const AlsaMidiGateway& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline AlsaMidiGateway(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static AlsaMidiGateway null() {return AlsaMidiGateway((AlsaMidiGateway_base*)0);}
	inline static AlsaMidiGateway _from_base(AlsaMidiGateway_base* b) {return AlsaMidiGateway(b);}
	inline AlsaMidiGateway& operator=(const AlsaMidiGateway& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline AlsaMidiGateway_base* _base() {return _cache?_cache:_method_call();}

	inline bool rescan();
};

class AlsaMidiPort_base : virtual public Arts::MidiPort_base {
public:
	static unsigned long _IID; // interface ID

	static AlsaMidiPort_base *_create(const std::string& subClass = "Arts::AlsaMidiPort");
	static AlsaMidiPort_base *_fromString(const std::string& objectref);
	static AlsaMidiPort_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static AlsaMidiPort_base *_fromDynamicCast(const Arts::Object& object);
	inline AlsaMidiPort_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long client() = 0;
	virtual void client(long newValue) = 0;
	virtual long port() = 0;
	virtual void port(long newValue) = 0;
	virtual bool open() = 0;
};

class AlsaMidiPort_stub : virtual public AlsaMidiPort_base, virtual public Arts::MidiPort_stub {
protected:
	AlsaMidiPort_stub();

public:
	AlsaMidiPort_stub(Arts::Connection *connection, long objectID);

	long client();
	void client(long newValue);
	long port();
	void port(long newValue);
	bool open();
};

class AlsaMidiPort_skel : virtual public AlsaMidiPort_base, virtual public Arts::MidiPort_skel {
protected:
	// emitters for change notifications
	inline void client_changed(long newValue) {
		_emit_changed("client_changed",newValue);
	}
	inline void port_changed(long newValue) {
		_emit_changed("port_changed",newValue);
	}

public:
	AlsaMidiPort_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class AlsaMidiPort : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	AlsaMidiPort_base *_cache;
	inline AlsaMidiPort_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(AlsaMidiPort_base *)_pool->base->_cast(AlsaMidiPort_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline AlsaMidiPort(AlsaMidiPort_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef AlsaMidiPort_base _base_class;

	inline AlsaMidiPort() : Arts::Object(_Creator), _cache(0) {}
	inline AlsaMidiPort(const Arts::SubClass& s) :
		Arts::Object(AlsaMidiPort_base::_create(s.string())), _cache(0) {}
	inline AlsaMidiPort(const Arts::Reference &r) :
		Arts::Object(r.isString()?(AlsaMidiPort_base::_fromString(r.string())):(AlsaMidiPort_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline AlsaMidiPort(const Arts::DynamicCast& c) : Arts::Object(AlsaMidiPort_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline AlsaMidiPort(const AlsaMidiPort& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline AlsaMidiPort(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static AlsaMidiPort null() {return AlsaMidiPort((AlsaMidiPort_base*)0);}
	inline static AlsaMidiPort _from_base(AlsaMidiPort_base* b) {return AlsaMidiPort(b);}
	inline AlsaMidiPort& operator=(const AlsaMidiPort& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::MidiPort() const { return Arts::MidiPort(*_pool); }
	inline AlsaMidiPort_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::TimeStamp time();
	inline Arts::TimeStamp playTime();
	inline void processCommand(const Arts::MidiCommand& command);
	inline void processEvent(const Arts::MidiEvent& event);
	inline long client();
	inline void client(long _newValue);
	inline long port();
	inline void port(long _newValue);
	inline bool open();
};

class AudioSync_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static AudioSync_base *_create(const std::string& subClass = "Arts::AudioSync");
	static AudioSync_base *_fromString(const std::string& objectref);
	static AudioSync_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static AudioSync_base *_fromDynamicCast(const Arts::Object& object);
	inline AudioSync_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::TimeStamp time() = 0;
	virtual Arts::TimeStamp playTime() = 0;
	virtual void queueStart(Arts::SynthModule synthModule) = 0;
	virtual void queueStop(Arts::SynthModule synthModule) = 0;
	virtual void execute() = 0;
	virtual void executeAt(const Arts::TimeStamp& timeStamp) = 0;
};

class AudioSync_stub : virtual public AudioSync_base, virtual public Arts::Object_stub {
protected:
	AudioSync_stub();

public:
	AudioSync_stub(Arts::Connection *connection, long objectID);

	Arts::TimeStamp time();
	Arts::TimeStamp playTime();
	void queueStart(Arts::SynthModule synthModule);
	void queueStop(Arts::SynthModule synthModule);
	void execute();
	void executeAt(const Arts::TimeStamp& timeStamp);
};

class AudioSync_skel : virtual public AudioSync_base, virtual public Arts::Object_skel {
public:
	AudioSync_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class AudioSync : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	AudioSync_base *_cache;
	inline AudioSync_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(AudioSync_base *)_pool->base->_cast(AudioSync_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline AudioSync(AudioSync_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef AudioSync_base _base_class;

	inline AudioSync() : Arts::Object(_Creator), _cache(0) {}
	inline AudioSync(const Arts::SubClass& s) :
		Arts::Object(AudioSync_base::_create(s.string())), _cache(0) {}
	inline AudioSync(const Arts::Reference &r) :
		Arts::Object(r.isString()?(AudioSync_base::_fromString(r.string())):(AudioSync_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline AudioSync(const Arts::DynamicCast& c) : Arts::Object(AudioSync_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline AudioSync(const AudioSync& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline AudioSync(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static AudioSync null() {return AudioSync((AudioSync_base*)0);}
	inline static AudioSync _from_base(AudioSync_base* b) {return AudioSync(b);}
	inline AudioSync& operator=(const AudioSync& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline AudioSync_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::TimeStamp time();
	inline Arts::TimeStamp playTime();
	inline void queueStart(Arts::SynthModule synthModule);
	inline void queueStop(Arts::SynthModule synthModule);
	inline void execute();
	inline void executeAt(const Arts::TimeStamp& timeStamp);
};

class MidiTimer_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static MidiTimer_base *_create(const std::string& subClass = "Arts::MidiTimer");
	static MidiTimer_base *_fromString(const std::string& objectref);
	static MidiTimer_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static MidiTimer_base *_fromDynamicCast(const Arts::Object& object);
	inline MidiTimer_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::TimeStamp time() = 0;
	virtual void queueEvent(Arts::MidiPort port, const Arts::MidiEvent& event) = 0;
};

class MidiTimer_stub : virtual public MidiTimer_base, virtual public Arts::Object_stub {
protected:
	MidiTimer_stub();

public:
	MidiTimer_stub(Arts::Connection *connection, long objectID);

	Arts::TimeStamp time();
	void queueEvent(Arts::MidiPort port, const Arts::MidiEvent& event);
};

class MidiTimer_skel : virtual public MidiTimer_base, virtual public Arts::Object_skel {
public:
	MidiTimer_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class MidiTimer : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	MidiTimer_base *_cache;
	inline MidiTimer_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(MidiTimer_base *)_pool->base->_cast(MidiTimer_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline MidiTimer(MidiTimer_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef MidiTimer_base _base_class;

	inline MidiTimer() : Arts::Object(_Creator), _cache(0) {}
	inline MidiTimer(const Arts::SubClass& s) :
		Arts::Object(MidiTimer_base::_create(s.string())), _cache(0) {}
	inline MidiTimer(const Arts::Reference &r) :
		Arts::Object(r.isString()?(MidiTimer_base::_fromString(r.string())):(MidiTimer_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline MidiTimer(const Arts::DynamicCast& c) : Arts::Object(MidiTimer_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline MidiTimer(const MidiTimer& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline MidiTimer(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static MidiTimer null() {return MidiTimer((MidiTimer_base*)0);}
	inline static MidiTimer _from_base(MidiTimer_base* b) {return MidiTimer(b);}
	inline MidiTimer& operator=(const MidiTimer& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline MidiTimer_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::TimeStamp time();
	inline void queueEvent(Arts::MidiPort port, const Arts::MidiEvent& event);
};

class SystemMidiTimer_base : virtual public Arts::MidiTimer_base {
public:
	static unsigned long _IID; // interface ID

	static SystemMidiTimer_base *_create(const std::string& subClass = "Arts::SystemMidiTimer");
	static SystemMidiTimer_base *_fromString(const std::string& objectref);
	static SystemMidiTimer_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static SystemMidiTimer_base *_fromDynamicCast(const Arts::Object& object);
	inline SystemMidiTimer_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class SystemMidiTimer_stub : virtual public SystemMidiTimer_base, virtual public Arts::MidiTimer_stub {
protected:
	SystemMidiTimer_stub();

public:
	SystemMidiTimer_stub(Arts::Connection *connection, long objectID);

};

class SystemMidiTimer_skel : virtual public SystemMidiTimer_base, virtual public Arts::MidiTimer_skel {
public:
	SystemMidiTimer_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class SystemMidiTimer : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	SystemMidiTimer_base *_cache;
	inline SystemMidiTimer_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(SystemMidiTimer_base *)_pool->base->_cast(SystemMidiTimer_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline SystemMidiTimer(SystemMidiTimer_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef SystemMidiTimer_base _base_class;

	inline SystemMidiTimer() : Arts::Object(_Creator), _cache(0) {}
	inline SystemMidiTimer(const Arts::SubClass& s) :
		Arts::Object(SystemMidiTimer_base::_create(s.string())), _cache(0) {}
	inline SystemMidiTimer(const Arts::Reference &r) :
		Arts::Object(r.isString()?(SystemMidiTimer_base::_fromString(r.string())):(SystemMidiTimer_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline SystemMidiTimer(const Arts::DynamicCast& c) : Arts::Object(SystemMidiTimer_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline SystemMidiTimer(const SystemMidiTimer& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline SystemMidiTimer(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static SystemMidiTimer null() {return SystemMidiTimer((SystemMidiTimer_base*)0);}
	inline static SystemMidiTimer _from_base(SystemMidiTimer_base* b) {return SystemMidiTimer(b);}
	inline SystemMidiTimer& operator=(const SystemMidiTimer& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::MidiTimer() const { return Arts::MidiTimer(*_pool); }
	inline SystemMidiTimer_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::TimeStamp time();
	inline void queueEvent(Arts::MidiPort port, const Arts::MidiEvent& event);
};

class AudioMidiTimer_base : virtual public Arts::MidiTimer_base {
public:
	static unsigned long _IID; // interface ID

	static AudioMidiTimer_base *_create(const std::string& subClass = "Arts::AudioMidiTimer");
	static AudioMidiTimer_base *_fromString(const std::string& objectref);
	static AudioMidiTimer_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static AudioMidiTimer_base *_fromDynamicCast(const Arts::Object& object);
	inline AudioMidiTimer_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class AudioMidiTimer_stub : virtual public AudioMidiTimer_base, virtual public Arts::MidiTimer_stub {
protected:
	AudioMidiTimer_stub();

public:
	AudioMidiTimer_stub(Arts::Connection *connection, long objectID);

};

class AudioMidiTimer_skel : virtual public AudioMidiTimer_base, virtual public Arts::MidiTimer_skel {
public:
	AudioMidiTimer_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class AudioMidiTimer : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	AudioMidiTimer_base *_cache;
	inline AudioMidiTimer_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(AudioMidiTimer_base *)_pool->base->_cast(AudioMidiTimer_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline AudioMidiTimer(AudioMidiTimer_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef AudioMidiTimer_base _base_class;

	inline AudioMidiTimer() : Arts::Object(_Creator), _cache(0) {}
	inline AudioMidiTimer(const Arts::SubClass& s) :
		Arts::Object(AudioMidiTimer_base::_create(s.string())), _cache(0) {}
	inline AudioMidiTimer(const Arts::Reference &r) :
		Arts::Object(r.isString()?(AudioMidiTimer_base::_fromString(r.string())):(AudioMidiTimer_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline AudioMidiTimer(const Arts::DynamicCast& c) : Arts::Object(AudioMidiTimer_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline AudioMidiTimer(const AudioMidiTimer& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline AudioMidiTimer(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static AudioMidiTimer null() {return AudioMidiTimer((AudioMidiTimer_base*)0);}
	inline static AudioMidiTimer _from_base(AudioMidiTimer_base* b) {return AudioMidiTimer(b);}
	inline AudioMidiTimer& operator=(const AudioMidiTimer& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::MidiTimer() const { return Arts::MidiTimer(*_pool); }
	inline AudioMidiTimer_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::TimeStamp time();
	inline void queueEvent(Arts::MidiPort port, const Arts::MidiEvent& event);
};

};
// Forward wrapper calls to _base classes:

inline Arts::TimeStamp Arts::MidiPort::time()
{
	return _cache?static_cast<Arts::MidiPort_base*>(_cache)->time():static_cast<Arts::MidiPort_base*>(_method_call())->time();
}

inline Arts::TimeStamp Arts::MidiPort::playTime()
{
	return _cache?static_cast<Arts::MidiPort_base*>(_cache)->playTime():static_cast<Arts::MidiPort_base*>(_method_call())->playTime();
}

inline void Arts::MidiPort::processCommand(const Arts::MidiCommand& command)
{
	 _cache?static_cast<Arts::MidiPort_base*>(_cache)->processCommand(command):static_cast<Arts::MidiPort_base*>(_method_call())->processCommand(command);
}

inline void Arts::MidiPort::processEvent(const Arts::MidiEvent& event)
{
	 _cache?static_cast<Arts::MidiPort_base*>(_cache)->processEvent(event):static_cast<Arts::MidiPort_base*>(_method_call())->processEvent(event);
}

inline Arts::MidiClientInfo Arts::MidiClient::info()
{
	return _cache?static_cast<Arts::MidiClient_base*>(_cache)->info():static_cast<Arts::MidiClient_base*>(_method_call())->info();
}

inline std::string Arts::MidiClient::title()
{
	return _cache?static_cast<Arts::MidiClient_base*>(_cache)->title():static_cast<Arts::MidiClient_base*>(_method_call())->title();
}

inline void Arts::MidiClient::title(const std::string& _newValue)
{
	 _cache?static_cast<Arts::MidiClient_base*>(_cache)->title(_newValue):static_cast<Arts::MidiClient_base*>(_method_call())->title(_newValue);
}

inline void Arts::MidiClient::addInputPort(Arts::MidiPort port)
{
	 _cache?static_cast<Arts::MidiClient_base*>(_cache)->addInputPort(port):static_cast<Arts::MidiClient_base*>(_method_call())->addInputPort(port);
}

inline Arts::MidiPort Arts::MidiClient::addOutputPort()
{
	return _cache?static_cast<Arts::MidiClient_base*>(_cache)->addOutputPort():static_cast<Arts::MidiClient_base*>(_method_call())->addOutputPort();
}

inline void Arts::MidiClient::removePort(Arts::MidiPort port)
{
	 _cache?static_cast<Arts::MidiClient_base*>(_cache)->removePort(port):static_cast<Arts::MidiClient_base*>(_method_call())->removePort(port);
}

inline void Arts::MidiSyncGroup::addClient(Arts::MidiClient client)
{
	 _cache?static_cast<Arts::MidiSyncGroup_base*>(_cache)->addClient(client):static_cast<Arts::MidiSyncGroup_base*>(_method_call())->addClient(client);
}

inline void Arts::MidiSyncGroup::removeClient(Arts::MidiClient client)
{
	 _cache?static_cast<Arts::MidiSyncGroup_base*>(_cache)->removeClient(client):static_cast<Arts::MidiSyncGroup_base*>(_method_call())->removeClient(client);
}

inline void Arts::MidiSyncGroup::addAudioSync(Arts::AudioSync audioSync)
{
	 _cache?static_cast<Arts::MidiSyncGroup_base*>(_cache)->addAudioSync(audioSync):static_cast<Arts::MidiSyncGroup_base*>(_method_call())->addAudioSync(audioSync);
}

inline void Arts::MidiSyncGroup::removeAudioSync(Arts::AudioSync audioSync)
{
	 _cache?static_cast<Arts::MidiSyncGroup_base*>(_cache)->removeAudioSync(audioSync):static_cast<Arts::MidiSyncGroup_base*>(_method_call())->removeAudioSync(audioSync);
}

inline std::vector<Arts::MidiClientInfo> * Arts::MidiManager::clients()
{
	return _cache?static_cast<Arts::MidiManager_base*>(_cache)->clients():static_cast<Arts::MidiManager_base*>(_method_call())->clients();
}

inline Arts::MidiClient Arts::MidiManager::addClient(Arts::MidiClientDirection direction, Arts::MidiClientType type, const std::string& title, const std::string& autoRestoreID)
{
	return _cache?static_cast<Arts::MidiManager_base*>(_cache)->addClient(direction, type, title, autoRestoreID):static_cast<Arts::MidiManager_base*>(_method_call())->addClient(direction, type, title, autoRestoreID);
}

inline void Arts::MidiManager::connect(long clientID, long destinationID)
{
	 _cache?static_cast<Arts::MidiManager_base*>(_cache)->connect(clientID, destinationID):static_cast<Arts::MidiManager_base*>(_method_call())->connect(clientID, destinationID);
}

inline void Arts::MidiManager::disconnect(long clientID, long destinationID)
{
	 _cache?static_cast<Arts::MidiManager_base*>(_cache)->disconnect(clientID, destinationID):static_cast<Arts::MidiManager_base*>(_method_call())->disconnect(clientID, destinationID);
}

inline Arts::MidiSyncGroup Arts::MidiManager::addSyncGroup()
{
	return _cache?static_cast<Arts::MidiManager_base*>(_cache)->addSyncGroup():static_cast<Arts::MidiManager_base*>(_method_call())->addSyncGroup();
}

inline Arts::TimeStamp Arts::MidiTest::time()
{
	return _cache?static_cast<Arts::MidiPort_base*>(_cache)->time():static_cast<Arts::MidiPort_base*>(_method_call())->time();
}

inline Arts::TimeStamp Arts::MidiTest::playTime()
{
	return _cache?static_cast<Arts::MidiPort_base*>(_cache)->playTime():static_cast<Arts::MidiPort_base*>(_method_call())->playTime();
}

inline void Arts::MidiTest::processCommand(const Arts::MidiCommand& command)
{
	 _cache?static_cast<Arts::MidiPort_base*>(_cache)->processCommand(command):static_cast<Arts::MidiPort_base*>(_method_call())->processCommand(command);
}

inline void Arts::MidiTest::processEvent(const Arts::MidiEvent& event)
{
	 _cache?static_cast<Arts::MidiPort_base*>(_cache)->processEvent(event):static_cast<Arts::MidiPort_base*>(_method_call())->processEvent(event);
}

inline Arts::TimeStamp Arts::RawMidiPort::time()
{
	return _cache?static_cast<Arts::MidiPort_base*>(_cache)->time():static_cast<Arts::MidiPort_base*>(_method_call())->time();
}

inline Arts::TimeStamp Arts::RawMidiPort::playTime()
{
	return _cache?static_cast<Arts::MidiPort_base*>(_cache)->playTime():static_cast<Arts::MidiPort_base*>(_method_call())->playTime();
}

inline void Arts::RawMidiPort::processCommand(const Arts::MidiCommand& command)
{
	 _cache?static_cast<Arts::MidiPort_base*>(_cache)->processCommand(command):static_cast<Arts::MidiPort_base*>(_method_call())->processCommand(command);
}

inline void Arts::RawMidiPort::processEvent(const Arts::MidiEvent& event)
{
	 _cache?static_cast<Arts::MidiPort_base*>(_cache)->processEvent(event):static_cast<Arts::MidiPort_base*>(_method_call())->processEvent(event);
}

inline std::string Arts::RawMidiPort::device()
{
	return _cache?static_cast<Arts::RawMidiPort_base*>(_cache)->device():static_cast<Arts::RawMidiPort_base*>(_method_call())->device();
}

inline void Arts::RawMidiPort::device(const std::string& _newValue)
{
	 _cache?static_cast<Arts::RawMidiPort_base*>(_cache)->device(_newValue):static_cast<Arts::RawMidiPort_base*>(_method_call())->device(_newValue);
}

inline bool Arts::RawMidiPort::input()
{
	return _cache?static_cast<Arts::RawMidiPort_base*>(_cache)->input():static_cast<Arts::RawMidiPort_base*>(_method_call())->input();
}

inline void Arts::RawMidiPort::input(bool _newValue)
{
	 _cache?static_cast<Arts::RawMidiPort_base*>(_cache)->input(_newValue):static_cast<Arts::RawMidiPort_base*>(_method_call())->input(_newValue);
}

inline bool Arts::RawMidiPort::output()
{
	return _cache?static_cast<Arts::RawMidiPort_base*>(_cache)->output():static_cast<Arts::RawMidiPort_base*>(_method_call())->output();
}

inline void Arts::RawMidiPort::output(bool _newValue)
{
	 _cache?static_cast<Arts::RawMidiPort_base*>(_cache)->output(_newValue):static_cast<Arts::RawMidiPort_base*>(_method_call())->output(_newValue);
}

inline bool Arts::RawMidiPort::running()
{
	return _cache?static_cast<Arts::RawMidiPort_base*>(_cache)->running():static_cast<Arts::RawMidiPort_base*>(_method_call())->running();
}

inline void Arts::RawMidiPort::running(bool _newValue)
{
	 _cache?static_cast<Arts::RawMidiPort_base*>(_cache)->running(_newValue):static_cast<Arts::RawMidiPort_base*>(_method_call())->running(_newValue);
}

inline bool Arts::RawMidiPort::open()
{
	return _cache?static_cast<Arts::RawMidiPort_base*>(_cache)->open():static_cast<Arts::RawMidiPort_base*>(_method_call())->open();
}

inline bool Arts::AlsaMidiGateway::rescan()
{
	return _cache?static_cast<Arts::AlsaMidiGateway_base*>(_cache)->rescan():static_cast<Arts::AlsaMidiGateway_base*>(_method_call())->rescan();
}

inline Arts::TimeStamp Arts::AlsaMidiPort::time()
{
	return _cache?static_cast<Arts::MidiPort_base*>(_cache)->time():static_cast<Arts::MidiPort_base*>(_method_call())->time();
}

inline Arts::TimeStamp Arts::AlsaMidiPort::playTime()
{
	return _cache?static_cast<Arts::MidiPort_base*>(_cache)->playTime():static_cast<Arts::MidiPort_base*>(_method_call())->playTime();
}

inline void Arts::AlsaMidiPort::processCommand(const Arts::MidiCommand& command)
{
	 _cache?static_cast<Arts::MidiPort_base*>(_cache)->processCommand(command):static_cast<Arts::MidiPort_base*>(_method_call())->processCommand(command);
}

inline void Arts::AlsaMidiPort::processEvent(const Arts::MidiEvent& event)
{
	 _cache?static_cast<Arts::MidiPort_base*>(_cache)->processEvent(event):static_cast<Arts::MidiPort_base*>(_method_call())->processEvent(event);
}

inline long Arts::AlsaMidiPort::client()
{
	return _cache?static_cast<Arts::AlsaMidiPort_base*>(_cache)->client():static_cast<Arts::AlsaMidiPort_base*>(_method_call())->client();
}

inline void Arts::AlsaMidiPort::client(long _newValue)
{
	 _cache?static_cast<Arts::AlsaMidiPort_base*>(_cache)->client(_newValue):static_cast<Arts::AlsaMidiPort_base*>(_method_call())->client(_newValue);
}

inline long Arts::AlsaMidiPort::port()
{
	return _cache?static_cast<Arts::AlsaMidiPort_base*>(_cache)->port():static_cast<Arts::AlsaMidiPort_base*>(_method_call())->port();
}

inline void Arts::AlsaMidiPort::port(long _newValue)
{
	 _cache?static_cast<Arts::AlsaMidiPort_base*>(_cache)->port(_newValue):static_cast<Arts::AlsaMidiPort_base*>(_method_call())->port(_newValue);
}

inline bool Arts::AlsaMidiPort::open()
{
	return _cache?static_cast<Arts::AlsaMidiPort_base*>(_cache)->open():static_cast<Arts::AlsaMidiPort_base*>(_method_call())->open();
}

inline Arts::TimeStamp Arts::AudioSync::time()
{
	return _cache?static_cast<Arts::AudioSync_base*>(_cache)->time():static_cast<Arts::AudioSync_base*>(_method_call())->time();
}

inline Arts::TimeStamp Arts::AudioSync::playTime()
{
	return _cache?static_cast<Arts::AudioSync_base*>(_cache)->playTime():static_cast<Arts::AudioSync_base*>(_method_call())->playTime();
}

inline void Arts::AudioSync::queueStart(Arts::SynthModule synthModule)
{
	 _cache?static_cast<Arts::AudioSync_base*>(_cache)->queueStart(synthModule):static_cast<Arts::AudioSync_base*>(_method_call())->queueStart(synthModule);
}

inline void Arts::AudioSync::queueStop(Arts::SynthModule synthModule)
{
	 _cache?static_cast<Arts::AudioSync_base*>(_cache)->queueStop(synthModule):static_cast<Arts::AudioSync_base*>(_method_call())->queueStop(synthModule);
}

inline void Arts::AudioSync::execute()
{
	 _cache?static_cast<Arts::AudioSync_base*>(_cache)->execute():static_cast<Arts::AudioSync_base*>(_method_call())->execute();
}

inline void Arts::AudioSync::executeAt(const Arts::TimeStamp& timeStamp)
{
	 _cache?static_cast<Arts::AudioSync_base*>(_cache)->executeAt(timeStamp):static_cast<Arts::AudioSync_base*>(_method_call())->executeAt(timeStamp);
}

inline Arts::TimeStamp Arts::MidiTimer::time()
{
	return _cache?static_cast<Arts::MidiTimer_base*>(_cache)->time():static_cast<Arts::MidiTimer_base*>(_method_call())->time();
}

inline void Arts::MidiTimer::queueEvent(Arts::MidiPort port, const Arts::MidiEvent& event)
{
	 _cache?static_cast<Arts::MidiTimer_base*>(_cache)->queueEvent(port, event):static_cast<Arts::MidiTimer_base*>(_method_call())->queueEvent(port, event);
}

inline Arts::TimeStamp Arts::SystemMidiTimer::time()
{
	return _cache?static_cast<Arts::MidiTimer_base*>(_cache)->time():static_cast<Arts::MidiTimer_base*>(_method_call())->time();
}

inline void Arts::SystemMidiTimer::queueEvent(Arts::MidiPort port, const Arts::MidiEvent& event)
{
	 _cache?static_cast<Arts::MidiTimer_base*>(_cache)->queueEvent(port, event):static_cast<Arts::MidiTimer_base*>(_method_call())->queueEvent(port, event);
}

inline Arts::TimeStamp Arts::AudioMidiTimer::time()
{
	return _cache?static_cast<Arts::MidiTimer_base*>(_cache)->time():static_cast<Arts::MidiTimer_base*>(_method_call())->time();
}

inline void Arts::AudioMidiTimer::queueEvent(Arts::MidiPort port, const Arts::MidiEvent& event)
{
	 _cache?static_cast<Arts::MidiTimer_base*>(_cache)->queueEvent(port, event):static_cast<Arts::MidiTimer_base*>(_method_call())->queueEvent(port, event);
}

#endif /* ARTSMIDI_H */
