#ifndef __PC980155REGS_H
#define __PC980155REGS_H

#include "wd33c93.h"

#define REG_ADDRST (base_io+0)
#define REG_CONTRL (base_io+2)
#define REG_CWRITE (base_io+4)
#define REG_STATRD (base_io+4)

#define WD_MEMORYBANK 0x30
#define WD_RESETINT   0x33

#if 0
#define WAIT() outb(0x00,0x5f)
#else
#define WAIT() do{}while(0)
#endif

static inline uchar read_wd33c93(const wd33c93_regs regs, uchar reg_num)
{
  uchar data;
  outb(reg_num, *regs.SASR);
  WAIT();
  data = inb(*regs.SCMD);
  WAIT();
  return data;
}

static inline uchar read_aux_stat(const wd33c93_regs regs)
{
  uchar result;
  result = inb(*regs.SASR);
  WAIT();
  /*  printk("PC-9801-55: regp->SASR(%x) = %x\n", regp->SASR, result); */
  return result;
}
#define READ_AUX_STAT() read_aux_stat(regs)

static inline void write_wd33c93(const wd33c93_regs regs, uchar reg_num,
				 uchar value)
{
  outb(reg_num, *regs.SASR);
  WAIT();
  outb(value, *regs.SCMD);
  WAIT();
}


#define write_wd33c93_cmd(regs,cmd) write_wd33c93(regs,WD_COMMAND,cmd)

static inline void write_wd33c93_count(const wd33c93_regs regs,
					unsigned long value)
{
   outb(WD_TRANSFER_COUNT_MSB, *regs.SASR);
   WAIT();
   outb((value >> 16) & 0xff, *regs.SCMD);
   WAIT();
   outb((value >> 8)  & 0xff, *regs.SCMD);
   WAIT();
   outb( value        & 0xff, *regs.SCMD);
   WAIT();
}


static inline unsigned long read_wd33c93_count(const wd33c93_regs regs)
{
unsigned long value;

   outb(WD_TRANSFER_COUNT_MSB, *regs.SASR);
   value = inb(*regs.SCMD) << 16;
   value |= inb(*regs.SCMD) << 8;
   value |= inb(*regs.SCMD);
   return value;
}

static inline void write_wd33c93_cdb(const wd33c93_regs regs, unsigned int len,
					unsigned char cmnd[])
{
  int i;
  outb(WD_CDB_1, *regs.SASR);
  for (i=0; i<len; i++)
    outb(cmnd[i], *regs.SCMD);
}

#define pc980155_int_enable(regs)  write_wd33c93(regs, WD_MEMORYBANK, read_wd33c93(regs, WD_MEMORYBANK) | 0x04)
#define pc980155_int_disable(regs) write_wd33c93(regs, WD_MEMORYBANK, read_wd33c93(regs, WD_MEMORYBANK) & ~0x04)

#endif
