;;; menu-tree.el --- get/set menu tree title

(defun menu-tree (km)
  (if (not (keymapp km))
      nil
    (let ((lis (cdr (if (symbolp km)
			(symbol-function km)
			km)))
	  (ret nil))
      (while lis
	(let ((entry (car lis))
	      event def name map)
	  (if (not (consp entry))
	      nil
	    (setq event (car entry)
		  def (cdr entry))
	    (if (consp def)
		(cond ((stringp (car def))
		       (setq name (car def)
			     map (cond ((keymapp (cdr def)) (cdr def))
				       ((consp (cdr def)) (cdr (cdr def))))))
		      ((eq 'menu-item (car def))
		       (setq name (nth 1 def)
			     map (nth 2 def)))))
	    (if name
		(setq ret (cons (cons event (cons name (menu-tree map)))
				ret)))))
	(setq lis (cdr lis)))
      (nreverse ret))))
;; (insert (pp (menu-tree (lookup-key global-map [menu-bar]))))

(defvar menu-tree-coding-system
  (if (eq window-system 'x) 'euc-japan)
  "coding system used for menu item")

(defun menu-tree-override (km tree)
  (if (not (keymapp km))
      nil
    (let ((alis (if (symbolp km)
		    (symbol-function km)
		  km)))
      (while tree
	(let ((entry (car tree))
	      event name map cell)
	  (setq event (car entry)
		name (encode-coding-string (car (cdr entry))
					   menu-tree-coding-system)
		map (cdr (cdr entry)))
	  (and (setq cell (assoc event alis))
	       (consp (cdr cell))
	       (cond ((stringp (car (cdr cell)))
		      (setcar (cdr cell) name)
		      (cond ((keymapp (cdr (cdr cell)))
			     (menu-tree-override (cdr (cdr cell)) map))
			    ((consp (cdr (cdr cell)))
			     (menu-tree-override (nthcdr 3 cell) map))))
		     ((eq 'menu-item (car (cdr cell)))
		      (setcar (cdr (cdr cell)) name)
		      (menu-tree-override (nth 3 cell) map)))))
	(setq tree (cdr tree))))))

(defun menu-tree-encode (km)
  (if (not (keymapp km))
      nil
    (let ((alis (if (symbolp km)
		    (symbol-function km)
		  km)))
      (while alis
	(let ((cell (car alis)))
	  (if (not (consp cell))
	      nil
	    (and (consp (cdr cell))
		 (cond ((stringp (car (cdr cell)))
			(setcar (cdr cell) 
				(encode-coding-string (car (cdr cell))
						      menu-tree-coding-system))
			(cond ((keymapp (cdr (cdr cell)))
			       (menu-tree-encode (cdr (cdr cell))))
			      ((consp (cdr (cdr cell)))
			       (menu-tree-encode (nthcdr 3 cell)))))
		       ((eq 'menu-item (car (cdr cell)))
			(setcar (cdr (cdr cell))
				(encode-coding-string (car (cdr (cdr cell)))
						      menu-tree-coding-system))
			(menu-tree-encode (nth 3 cell)))))))
	(setq alis (cdr alis))))))

(defvar menu-tree-alist-ja
  '((global-map
     (buffer "$B%P%C%U%!(B"
	     ;; ...
	     (list-buffers "$B%P%C%U%!0lMw(B"))
     (files "$B%U%!%$%k(B"
	    (open-file "$B3+$/(B")
	    (dired "$B%U%!%$%k0lMw(B")
	    (save-buffer "$BJ]B8(B")
	    (write-file "$BL>A0$r$D$1$FJ]B8(B")
	    (revert-buffer "$B%G%#%9%/$+$iFI$_=P$7(B")
	    (recover-session "$B%;%C%7%g%s$rI|3h(B")
	    (print-buffer "$B%P%C%U%!$N0u:~(B")
	    (print-region "$BA*BrNN0h$N0u:~(B")
	    (ps-print-buffer-faces "$B%P%C%U%!$N0u:~(B(Postscript $B7A<0(B)")
	    (ps-print-region-faces "$BA*BrNN0h$N0u:~(B(Postscript $B7A<0(B)")
	    (ps-print-buffer "$B%P%C%U%!$N0u:~(B($BGr9u(BPostscript $B7A<0(B)")
	    (ps-print-region "$BA*BrNN0h$N0u:~(B($BGr9u(BPostscript $B7A<0(B)")
	    (insert-file "$B%U%!%$%kA^F~(B")
	    (kill-buffer "$B%P%C%U%!$rJD$8$k(B")
	    (separator-buffers "--")
	    (make-frame "$B?7$7$$%U%l!<%`(B")
	    (make-frame-on-display "$B?7$7$$%G%#%9%W%l%$(B")
	    (delete-this-frame "$B%U%l!<%`$rJD$8$k(B")
	    (split-window "$B%&%#%s%I%&J,3d(B")
	    (one-window "$BB>$N%&%#%s%I%&$r>C$9(B")
	    (separator-exit "--")
	    (exit-emacs "$B=*N;(B"))
     (tools "$B%D!<%k(B"
	    (compare "$BHf3S(B"
		     (ediff-files "$B%U%!%$%k(B")
		     (ediff-buffers "$B%P%C%U%!(B")
		     (ediff-files3 "3$B$D$N%U%!%$%k4V(B")
		     (ediff-buffers3 "3$B$D$N%P%C%U%!4V(B")
		     (separator-ediff-files "--")
		     (ediff-directories "$B%U%)%k%@(B")
		     (ediff-directories3 "3$B$D$N%U%)%k%@4V(B")
		     (separator-ediff-directories "--")
		     (ediff-revision "$B2~D{HG(B")
		     (ediff-dir-revision "$B%U%)%k%@$N2~D{HG(B")
		     (separator-ediff-regions "--")
		     (ediff-regions-wordwise "$BC18l$4$H(B($BA*BrNN0h(B)")
		     (ediff-regions-linewise "$B9T$4$H(B($BA*BrNN0h(B)")
		     (separator-ediff-windows "--")
		     (ediff-windows-wordwise "$BC18l$4$H(B($B%&%#%s%I%&(B)")
		     (ediff-windows-linewise "$B9T$4$H(B($B%&%#%s%I%&(B)")
		     (window "$B%&%#%s%I%&4V(B"))
	    (ediff-merge "$B%^!<%8(B"
			 (ediff-merge-files "$B%U%!%$%k(B")
			 (ediff-merge-files-with-ancestor "$B%U%!%$%k(B($B867AIU$-(B)")
			 (ediff-merge-buffers "$B%P%C%U%!(B")
			 (ediff-merge-buffers-with-ancestor "$B%P%C%U%!(B($B867AIU$-(B)")
			 (separator-ediff-merge-dirs "--")
			 (ediff-merge-directories "$B%U%)%k%@(B")
			 (ediff-merge-directories-with-ancestor "$B%U%)%k%@(B($B867AIU$-(B)")
			 (separator-ediff-merge "--")
			 (ediff-merge-revisions "$B2~D{HG(B")
			 (ediff-merge-revisions-with-ancestor "$B2~D{HG(B($B867AIU$-(B)")
			 (ediff-merge-dir-revisions "$B%U%)%k%@$N2~D{HG(B")
			 (ediff-merge-dir-revisions-with-ancestor "$B%U%)%k%@$N2~D{HG(B($B867AIU$-(B)"))
	    (epatch "$B%Q%C%A(B"
		    (ediff-patch-file "$B%U%!%$%k(B")
		    (ediff-patch-buffer "$B%P%C%U%!(B"))
	    (ediff-misc "$BHf3S$$$m$$$m(B"
			(ediff-doc "$B%^%K%e%"%k(B")
			(eregistry "$B%;%C%7%g%s0lMw(B")
			(emultiframe "$B%U%l!<%`;HMQ(B/$BIT;HMQ$N@Z$jBX$((B"))
	    (separator-compare "--")
	    (vc "$B%P!<%8%g%s4IM}(B"
		(vc-register "$BEPO?(B")
		(vc-next-action "$B%A%'%C%/%$%s(B/$B%"%&%H(B")
		(vc-insert-header "$B%X%C%@A^F~(B")
		(vc-revert-buffer "$BJQ99$rGK4~(B")
		(undo "$B%A%'%C%/%$%s$N<h$j>C$7(B")
		(separator2 "----")
		(vc-print-log "$BMzNrI=<((B")
		(vc-update-change-log "$BMzNr99?7(B")
		(vc-diff "$B:G=*HG$HHf3S(B")
		(vc-version-other-window "$B%P!<%8%g%sI=<((B($BJL%&%#%s%I%&(B)")
		(vc-rename-file "$B%U%!%$%kL>JQ99(B")
		(vc-annotate "$BCm<a$r$D$1$k(B")
		(separator1 "----")
		(vc-directory "$B%U%)%k%@0lMw(B")
		(vc-create-snapshot "$B%9%J%C%W%7%g%C%H$r=q$-=P$9(B")
		(vc-retrieve-snapshot "$B%9%J%C%W%7%g%C%H$r<h$j9~$`(B"))
	    (separator-vc "--")
	    (gnus "$B%M%C%H%K%e!<%9(B")
	    (rmail "$B%a!<%k$rFI$`(B")
	    (compose-mail "$B%a!<%k$r=q$/(B")
	    (speedbar "$B%9%T!<%I%P!<I=<((B")
	    (calendar "$B%+%l%s%@!<I=<((B")
	    (separator-1 "--")
	    (grep "$BJ8;zNs8!:w(B")
	    (compile "$B%3%s%Q%$%k(B")
	    (gdb "$B%G%P%C%,(B")
	    (spell "$B%9%Z%k%A%'%C%/(B"
		   (ispell-help "$B%X%k%W(B")
		   (ispell-message "$B%a!<%k(B/$B%K%e!<%95-;v(B")
		   (ispell-buffer "$B%P%C%U%!(B")
		   (ispell-region "$BA*BrNN0h(B")
		   (ispell-comments-and-strings "$B%3%a%s%H(B/$BJ8;zNs(B")
		   (ispell-word "$BC18l(B")
		   (ispell-continue "$B:F3+(B")
		   (ispell-complete-word-interior-frag "$BJ8;zNsJd40$N%U%i%0(B")
		   (ispell-complete-word "$BJ8;zNsJd40(B")
		   (ispell-pdict-save "$B<-=q$rJ]B8(B")
		   (ispell-kill-ispell "$B6/@)=*N;(B")
		   (ispell-change-dictionary "$B%U%)%k%@JQ99(B")
		   (default "$BI8=`(B")
		   (american "$B%"%a%j%+1Q8l(B")
		   (british "$B%$%.%j%91Q8l(B")
		   (castellano "$B%9%Z%$%s8l(B")
		   (castellano8 "$B%9%Z%$%s8l(B(8$B%S%C%H(B)")
		   (czech "$B%A%'%38l(B")
		   (dansk "$B%G%s%^!<%/8l(B")
		   (deutsch "$B%I%$%D8l(B")
		   (deutsch8 "$B%I%$%D8l(B(8$B%S%C%H(B)")
		   (english "$B1Q8l(B")
		   (esperanto "$B%(%9%Z%i%s%H8l(B")
		   (esperanto-tex "$B%(%9%Z%i%s%H8l(B(TeX)")
		   (francais7 "$B%U%i%s%98l(B(7$B%S%C%H(B)")
		   (francais "$B%U%i%s%98l(B")
		   (francais-tex "$B%U%i%s%98l(B(TeX)")
		   (nederlands "$B%*%i%s%@8l(B")
		   (nederlands8 "$B%*%i%s%@8l(B(8$B%S%C%H(B)")
		   (norsk "$B%N%k%&%'!<8l(B")
		   (norsk7-tex "$B%N%k%&%'!<8l(B(7$B%S%C%H(BTeX)")
		   (polish "$B%]!<%i%s%I8l(B")
		   (russian "$B%m%7%"8l(B")
		   (svenska "$B%9%&%'!<%G%s8l(B"))
	    )
     (edit "$BJT=8(B"
	   (undo "$B85$KLa$9(B")
	   (cut "$B@Z$j<h$j(B")
	   (copy "$B%3%T!<(B")
	   (paste "$BE=$jIU$1(B")
	   (select-paste "$BE=$jIU$1(B($BA*Br(B)"
			 ;; ...
			 )
	   (clear "$B:o=|(B")
	   (separator-edit "--")
	   (search "$B8!:w(B"
		   (search-forward "$B2<$X(B")
		   (re-search-forward "$B2<$X(B($B@55,I=8=(B)")
		   (search-backward "$B>e$X(B")
		   (re-search-backward "$B>e$X(B($B@55,I=8=(B)")
		   (query-replace "$BCV49(B")
		   (repeat-search-fwd "$B<!$r8!:w(B")
		   (repeat-regexp-fwd "$B<!$r8!:w(B($B@55,I=8=(B)")
		   (repeat-search-back "$BA0$r8!:w(B")
		   (repeat-regexp-back "$BA0$r8!:w(B($B@55,I=8=(B)")
		   )
	   (bookmark "$B%V%C%/%^!<%/(B"
		     (jump "$BI=<((B")
		     (set "$B%;%C%H(B")
		     (insert "$BFbMF$rA^F~(B")
		     (locate "$B>l=j$rA^F~(B")
		     (rename "$BL>A0JQ99(B")
		     (delete "$B:o=|(B")
		     (edit "$BJT=8(B")
		     (save "$BJ]B8(B")
		     (write "$BL>A0$r$D$1$FJ]B8(B")
		     (load "$B%U%!%$%kFI$_9~$_(B"))
	   (find-tag "$B%?%08!:w(B")
	   (query-replace "$BCV49(B")
	   (query-replace-regexp "$BCV49(B($B@55,I=8=(B)")
	   (props "$BB0@-(B"
		  (fc "$B=qBN(B"
		      (100 "$BI8=`(B")
		      (98 "$BB@;z(B")
		      (105 "$B<PBN(B")
		      (108 "$BB@;z<PBN(B")
		      (117 "$B2<@~IU$-(B")
		      (111 "$B$=$NB>(B"))
		  (fg "$BIA2h?'(B"
		      (111 "$B$=$NB>(B"))
		  (bg "$BGX7J?'(B"
		      (111 "$B$=$NB>(B"))
		  (sp "$BFC<l(B"
		      (114 "$B=q9~$_6X;_(B")
		      (118 "$BIT2D;k(B")
		      (116 "$BIT2D?((B")
		      (115 "$BFC<lB0@-$N<h$j>C$7(B"))
		  (s2 "-----------------")
		  (ju "$B@0Ns(B"
		      (117 "$B$J$7(B")
		      (108 "$B:84s$;(B")
		      (114 "$B1&4s$;(B")
		      (98 "$BI}0lGU(B")
		      (99 "$BCf4s$;(B"))
		  (in "$B%$%s%G%s%H(B"
		      (increase-left-margin "$BA}$d$9(B")
		      (decrease-left-margin "$B8:$i$9(B")
		      (increase-right-margin "$BA}$d$9(B($B1&(B)")
		      (decrease-right-margin "$B8:$i$9(B($B1&(B)"))
		  (s1 "-----------------")
		  (rm "$B=qBN(B/$B?'$rI8=`$KLa$9(B")
		  (ra "$B$9$Y$FI8=`$KLa$9(B")
		  (dp "$BB0@-0lMw(B")
		  (df "$B=qBN(B/$B?'0lMw(B")
		  (dc "$B?'0lMw(B"))
	   (fill "$BD9$$9T$r@^$jJV$9(B"))
     (options "$B%*%W%7%g%s(B"
	      (toggle-global-lazy-font-lock-mode "$B9=J8I=<((B")
	      (auto-fill-mode "$B<+F0@^$jJV$7(B")
	      (toggle-auto-compression "$B<+F005=L!&E83+(B")
	      (transient-mark-mode "$BA*BrNN0h$N6/D4I=<((B")
	      (truncate-lines "$BD9$$9T$r@^$jJV$7$FI=<($7$J$$(B")
	      (case-fold-search "$B8!:w$GBgJ8;z!&>.J8;z$rF10l;k$9$k(B")
	      (uniquify "$B%P%C%U%!L>$K%U%)%k%@L>$r4^$a$k(B")
	      (save-place "$BJT=8;~$N>uBV$rJ]B8(B")
	      (options-separator "--")
	      (debug-on-error "$B%(%i!<H/@8;~$K%G%P%C%,5/F0(B")
	      (debug-on-quit "$B3d$j9~$_H/@8;~$K%G%P%C%,5/F0(B")
	      (mule "$B8@8l(B"
		    (set-language-environment "$B8@8l4D6-@_Dj(B"
					      (Default "$BI8=`(B")
					      (Chinese "$BCf9q8l(B"
						       (Chinese-GB "$BCf9q8l(B(GB)")
						       (Chinese-BIG5 "$BCf9q8l(B(BIG5)")
						       (Chinese-CNS "$BCf9q8l(B(CNS)"))
					      (Cyrillic "$B%m%7%"8l(B"
							(Cyrillic-ISO "$B%m%7%"8l(B(ISO)")
							(Cyrillic-KOI8 "$B%m%7%"8l(B(KOI8)")
							(Cyrillic-ALT "$B%m%7%"8l(B(ALT)"))
					      (Indian "$B%$%s%I8l(B"
						      (Devanagari "$B%G!<%t%!%J!<%,%j!<(B"))
					      (English "$B1Q8l(B")
					      (ASCII "ASCII")
					      (Ethiopic "$B%(%A%*%T%"8l(B")
					      (European "$B%h!<%m%C%Q7O8@8l(B"
							(Latin-1 "$B%i%F%s7O8@8l(B(1)")
							(Latin-2 "$B%i%F%s7O8@8l(B(2)")
							(Latin-3 "$B%i%F%s7O8@8l(B(3)")
							(Latin-4 "$B%i%F%s7O8@8l(B(4)")
							(Latin-5 "$B%i%F%s7O8@8l(B(5)")
							(German "$B%I%$%D8l(B")
							(Slovenian "$B%9%m%t%'%K%"8l(B")
							(Czech "$B%A%'%38l(B")
							(Slovak "$B%9%m%P%-%"8l(B")
							(Romanian "$B%k!<%^%K%"8l(B"))
					      (Turkish "$B%H%k%38l(B")
					      (Greek "$B%.%j%7%c8l(B")
					      (Hebrew "$B%X%V%i%$8l(B")
					      (Japanese "$BF|K\8l(B")
					      (Korean "$B4Z9q8l(B")
					      (Lao "$B%i%*8l(B")
					      (Thai "$B%?%$8l(B")
					      (Tibetan "$B%A%Y%C%H8l(B")
					      (Vietnamese "$B%Y%H%J%`8l(B")
					      (IPA "$B9q:]H/2;5-9f(B"))
		    (mouse-set-font "$B%U%)%s%HA*Br(B")
		    (separator-mule "--")
		    (toggle-input-method "$BF~NOJ}<0%*%s(B/$B%*%U(B")
		    (set-input-method "$BF~NOJ}<0A*Br(B")
		    (separator-input-method "--")
		    (set-various-coding-system "$B%3!<%I7OA*Br(B"
					       (set-buffer-file-coding-system "$B%P%C%U%!(B")
					       (universal-coding-system-argument "$B%3%^%s%I(B")
					       (set-terminal-coding-system "$B%?!<%_%J%k(B")
					       (set-keyboard-coding-system "$B%-!<%\!<%I(B")
					       (set-buffer-process-coding-system "$B%W%m%;%9(B")
					       (set-selection-coding-system "$B%/%j%C%W%\!<%I(B")
					       (set-next-selection-coding-system "$B<!$N@Z$j<h$j(B"))
		    (separator-coding-system "--")
		    (mule-diag "$BB?8@8l2=5!G=$N>uBV$rI=<((B")
		    (view-hello-file "$BB?8@8l$r4^$`J8=q$NNc(B")
		    (describe-language-environment "$B8@8l4D6-$N@bL@(B"
						   (Chinese "$BCf9q8l(B"
							    (Chinese-GB "$BCf9q8l(B(GB)")
							    (Chinese-BIG5 "$BCf9q8l(B(BIG5)")
							    (Chinese-CNS "$BCf9q8l(B(CNS)"))
						   (Cyrillic "$B%m%7%"8l(B"
							     (Cyrillic-ISO "$B%m%7%"8l(B(ISO)")
							     (Cyrillic-KOI8 "$B%m%7%"8l(B(KOI8)")
							     (Cyrillic-ALT "$B%m%7%"8l(B(ALT)"))
						   (Indian "$B%$%s%I8l(B"
							   (Devanagari "$B%G!<%t%!%J!<%,%j!<(B"))
						   (English "$B1Q8l(B")
						   (ASCII "ASCII")
						   (Ethiopic "$B%(%A%*%T%"8l(B")
						   (European "$B%h!<%m%C%Q7O8@8l(B"
							     (Latin-1 "$B%i%F%s7O8@8l(B(1)")
							     (Latin-2 "$B%i%F%s7O8@8l(B(2)")
							     (Latin-3 "$B%i%F%s7O8@8l(B(3)")
							     (Latin-4 "$B%i%F%s7O8@8l(B(4)")
							     (Latin-5 "$B%i%F%s7O8@8l(B(5)")
							     (German "$B%I%$%D8l(B")
							     (Slovenian "$B%9%m%t%'%K%"8l(B")
							     (Czech "$B%A%'%38l(B")
							     (Slovak "$B%9%m%P%-%"8l(B")
							     (Romanian "$B%k!<%^%K%"8l(B"))
						   (Turkish "$B%H%k%38l(B")
						   (Greek "$B%.%j%7%c8l(B")
						   (Hebrew "$B%X%V%i%$8l(B")
						   (Japanese "$BF|K\8l(B")
						   (Korean "$B4Z9q8l(B")
						   (Lao "$B%i%*8l(B")
						   (Thai "$B%?%$8l(B")
						   (Tibetan "$B%A%Y%C%H8l(B")
						   (Vietnamese "$B%Y%H%J%`8l(B")
						   (IPA "$B9q:]H/2;5-9f(B"))
		    (describe-input-method "$BF~NOJ}<0$N@bL@(B")
		    (describe-coding-system "$B%3!<%I7O$N@bL@(B"))
	      (customize "$B%+%9%?%^%$%:(B"
			 (customize "$B%H%C%W%l%Y%k%0%k!<%W(B")
			 (customize-browse "$B%0%k!<%WI=<((B")
			 (separator-3 "--")
			 (customize-changed-options "$BJQ99$5$l$?%*%W%7%g%s(B")
			 (customize-option "$B%*%W%7%g%s(B")
			 (customize-face "$B=qBN(B/$B?'(B")
			 (customize-group "$B%0%k!<%W(B")
			 (separator-2 "--")
			 (customize-apropos "$B%-!<%o!<%I8!:w(B")
			 (customize-apropos-options "$B%-!<%o!<%I8!:w(B($B%*%W%7%g%s(B)")
			 (customize-apropos-faces "$B%-!<%o!<%I8!:w(B($B=qBN(B/$B?'(B)")
			 (customize-apropos-groups "$B%-!<%o!<%I8!:w(B($B%0%k!<%W(B)"))
	      )
     (help-menu "$B%X%k%W(B"
		(sep1 "--")
		(emacs-tutorial "$BN}=,(B")
		(emacs-faq "Emacs $B$K4X$9$k$h$/$"$k<ALd$H$=$N2sEz(B")
		(emacs-news "Emacs $B%K%e!<%9(B")
		(manuals "$B%^%K%e%"%k(B"
			 (sep1 "--")
			 (info "Info $B5/F0(B")
			 (command "$B%3%^%s%I(B")
			 (key "$B%-!<A`:n(B")
			 (sep2 "--")
			 (man "man $B%^%K%e%"%k(B"))
		(describe "$B4JC1$J@bL@(B"
			  (describe-mode "$B%b!<%I(B")
			  (apropos-commands "$B%-!<%o!<%I$r4^$`%3%^%s%I(B")
			  (apropos-variables "$B%-!<%o!<%I$r4^$`JQ?t(B")
			  (list-keybindings "$B%-!<3d$jIU$1(B")
			  (describe-language-environment "$B8@8l4D6-$N@bL@(B"
							 (Chinese "$BCf9q8l(B"
								  (Chinese-GB "$BCf9q8l(B(GB)")
								  (Chinese-BIG5 "$BCf9q8l(B(BIG5)")
								  (Chinese-CNS "$BCf9q8l(B(CNS)"))
							 (Cyrillic "$B%m%7%"8l(B"
								   (Cyrillic-ISO "$B%m%7%"8l(B(ISO)")
								   (Cyrillic-KOI8 "$B%m%7%"8l(B(KOI8)")
								   (Cyrillic-ALT "$B%m%7%"8l(B(ALT)"))
							 (Indian "$B%$%s%I8l(B"
								 (Devanagari "$B%G!<%t%!%J!<%,%j!<(B"))
							 (English "$B1Q8l(B")
							 (ASCII "ASCII")
							 (Ethiopic "$B%(%A%*%T%"8l(B")
							 (European "$B%h!<%m%C%Q7O8@8l(B"
								   (Latin-1 "$B%i%F%s7O8@8l(B(1)")
								   (Latin-2 "$B%i%F%s7O8@8l(B(2)")
								   (Latin-3 "$B%i%F%s7O8@8l(B(3)")
								   (Latin-4 "$B%i%F%s7O8@8l(B(4)")
								   (Latin-5 "$B%i%F%s7O8@8l(B(5)")
								   (German "$B%I%$%D8l(B")
								   (Slovenian "$B%9%m%t%'%K%"8l(B")
								   (Czech "$B%A%'%38l(B")
								   (Slovak "$B%9%m%P%-%"8l(B")
								   (Romanian "$B%k!<%^%K%"8l(B"))
							 (Turkish "$B%H%k%38l(B")
							 (Greek "$B%.%j%7%c8l(B")
							 (Hebrew "$B%X%V%i%$8l(B")
							 (Japanese "$BF|K\8l(B")
							 (Korean "$B4Z9q8l(B")
							 (Lao "$B%i%*8l(B")
							 (Thai "$B%?%$8l(B")
							 (Tibetan "$B%A%Y%C%H8l(B")
							 (Vietnamese "$B%Y%H%J%`8l(B")
							 (IPA "$B9q:]H/2;5-9f(B"))
			  (describe-input-method "$BF~NOJ}<0$N@bL@(B")
			  (describe-coding-system "$B%3!<%I7O$N@bL@(B")
			  (describe-key "$B%-!<A`:n(B")
			  (describe-function "$B4X?t(B")
			  (describe-variable "$BJQ?t(B"))
		(finder-by-keyword "emacs $B%Q%C%1!<%88!:w(B")
		(sep2 "--")
		(report-emacs-bug "$B%P%0%l%]!<%H$rAw$k(B")
		(emacs-version "emacs $B$N%P!<%8%g%s(B")
		(describe-distribution "$B?7$7$$%P!<%8%g%s$N(B emacs $B$NF~<jJ}K!(B")
		(describe-copying "emacs $B$NG[I[$K4X$7$F(B")
		(describe-no-warranty "emacs $B$OL5J]>Z$G$9(B"))
     )
    (emacs-lisp-mode-map
     (emacs-lisp "Emacs-Lisp"
		 (indent-line "$B%$%s%G%s%H(B($B9T(B)")
		 (indent-region "$B%$%s%G%s%H(B($BA*BrNN0h(B)")
		 (comment-region "$B%3%a%s%H%"%&%H(B($BA*BrNN0h(B)")
		 (separator-format "--")
		 (eval-sexp "S-$B<0$NI>2A(B")
		 (eval-region "$BA*BrNN0h$NI>2A(B")
		 (eval-buffer "$B%P%C%U%!$NI>2A(B")
		 (separator-eval "--")
		 (byte-compile "$B%P%$%H%3%s%Q%$%k(B")
		 (emacs-byte-compile-and-load "$B%P%$%H%3%s%Q%$%k8eFI$_9~$_(B")
		 (byte-recompile "$B%P%$%H%3%s%Q%$%k(B($B%U%)%k%@Fb0l3g(B)")
		 (edebug-defun "$B%G%P%C%,$KEPO?(B")
		 )
     )
    (dired-mode-map
     (operate "$B%U%!%$%kA`:n(B"
	      (copy "$B%3%T!<(B")
	      (rename "$BL>A0$rJQ99(B")
	      (delete "$B:o=|(B")
	      (command "$B%U%!%$%k$K%3%^%s%I$r<B9T(B")
	      (symlink "$B%7%s%\%j%C%/%j%s%/:n@.(B")
	      (hardlink "$B%O!<%I%j%s%/:n@.(B")
	      (print "$B0u:~(B")
	      (compress "$B05=L(B")
	      (compile "$B%P%$%H%3%s%Q%$%k(B")
	      (load "$B%m!<%I(B")
	      (chmod "$BB0@-JQ99(B")
	      (chgrp "$B%0%k!<%WJQ99(B")
	      (chown "$B=jM-<TJQ99(B")
	      (search "$B8!:w(B")
	      (query-replace "$BCV49(B"))
     (mark "$B%^!<%/(B"
	   (toggle-marks "$B%^!<%/$rH?E>(B")
	   (mark "$B%^!<%/$9$k(B")
	   (unmark "$B%^!<%/$r>C$9(B")
	   (deletion "$B:o=|MQ$K%^!<%/$9$k(B")
	   (auto-save-files "$B<+F0J]B8%U%!%$%k(B")
	   (backup-files "$B%P%C%/%"%C%W%U%!%$%k(B")
	   (garbage-files "$B$4$_(B")
	   (executables "$B<B9T%U%!%$%k(B")
	   (directory "$B8E$$%P%C%/%"%C%W%U%!%$%k(B")
	   (directories "$B%U%)%k%@(B")
	   (symlinks "$B%7%s%\%j%C%/%j%s%/(B")
	   (unmark-all "$B%^!<%/$r$9$Y$F>C$9(B")
	   (marks "$B%^!<%/$N<oN`$rJQ99$9$k(B")
	   (next "$B<!$N%^!<%/(B")
	   (prev "$BA0$N%^!<%/(B"))
     (regexp "$B@55,I=8=(B"
	     (mark-cont "$B%U%!%$%k$NFbMF$K@55,I=8=$r4^$`(B")
	     (mark "$B%^!<%/(B")
	     (flag "$B:o=|MQ$K%^!<%/(B")
	     (copy "$B%3%T!<(B")
	     (rename "$BL>A0$rJQ99(B")
	     (symlink "$B%7%s%\%j%C%/%j%s%/:n@.(B")
	     (hardlink "$B%O!<%I%j%s%/:n@.(B")
	     (upcase "$B%U%!%$%kL>$rBgJ8;z$K$9$k(B")
	     (downcase "$B%U%!%$%kL>$r>.J8;z$K$9$k(B"))
     (immediate "$B<B9T(B"
		(create-directory "$B%U%)%k%@:n@.(B")
		(find-file "$B3+$/(B")
		(find-file-other-window "$BJL$N%&%#%s%I%&$G3+$/(B")
		(display "$BJL$N%&%#%s%I%&$KI=<((B")
		(view "$B1\Mw%b!<%I$G3+$/(B")
		(diff "$B:9J,(B")
		(backup-diff "$B%P%C%/%"%C%W$H:9J,(B")
		(dashes "--")
		(revert-buffer "$B%P%C%U%!99?7(B"))
     (subdir "$B%5%V%U%)%k%@(B"
	     (insert "$BA^F~(B")
	     (next-dirline "$B<!$N%U%)%k%@(B")
	     (prev-dirline "$BA0$N%U%)%k%@(B")
	     (next-subdir "$B<!$N%5%V%U%)%k%@(B")
	     (prev-subdir "$BA0$N%5%V%U%)%k%@(B")
	     (up "$B0l$D>e$N%U%)%k%@(B")
	     (tree-up "$B%5%V%U%)%k%@$r>e$K0\F0(B")
	     (tree-down "$B%5%V%U%)%k%@$r2<$K0\F0(B")
	     (hide-subdir "$B%5%V%U%)%k%@$r1#$9(B")
	     (hide-all "$B$9$Y$F$N%5%V%U%)%k%@$r1#$9(B"))
     )
    ))

(defvar menu-tree-alist menu-tree-alist-ja
  "alist used for overriding menu item string")

(defun menu-tree-override-by-alist (keymap-symbol)
  (menu-tree-override (lookup-key (symbol-value keymap-symbol) [menu-bar])
		      (cdr (assq keymap-symbol menu-tree-alist)))
  (force-mode-line-update))

(menu-tree-override-by-alist 'global-map)
(menu-tree-override-by-alist 'emacs-lisp-mode-map)
(eval-after-load "dired" '(menu-tree-override-by-alist 'dired-mode-map))

;;; for dynamic overriding menu
;; buffer
(add-hook 'menu-bar-update-hook
	  (lambda ()
	    (if menu-tree-coding-system
		(menu-tree-encode (lookup-key (current-global-map)
					      [menu-bar buffer])))
	    (menu-tree-override (lookup-key (current-global-map) [menu-bar])
				(list (assq 'buffer
					    (cdr (assq 'global-map
						       menu-tree-alist))))))
	  t)

(provide 'menu-tree)
;;; menu-tree.el ends here
