import HandlerAPI
from Mailman import Message,mm_cfg
import sys, re, base64
import quopri,StringIO

if mm_cfg.JAPANESE_CONVERTER == 'unicode':
    import japanese
    def toEuc(s):
        s = re.sub('\033\(J','\033(B',s) # no jis-roman
        x = unicode(s,'japanese.iso-2022-jp-ext','replace')
        x = unicode(x.encode('japanese.iso-2022-jp','replace'),'japanese.iso-2022-jp')
        return x.encode('japanese.euc-jp','replace')

elif mm_cfg.JAPANESE_CONVERTER == 'kconv':
    import kconv
    _toeuc = kconv.Kconv()
    def toEuc(s):
        return _toeuc.convert(s)

remove_spc = re.compile(r'(\?=)\s+(=\?iso-2022-jp\?b\?)', re.I)
mime_head = re.compile(r'=\?iso-2022-jp\?b\?([^?\s]+)\?=', re.I)
mimeqp_head = re.compile(r'=\?iso-2022-jp\?q\?([^?]+)\?=',re.I)

def decode_remove_spc(match):
    return match.group(1) + match.group(2)

def decode_base64(match):
    return base64.decodestring(match.group(1))

def decode_quopri(match):
    x = match.group(1)
    t1 = StringIO.StringIO()
    t2 = StringIO.StringIO()
    t1.write(x)
    t1.seek(0)
    quopri.decode(t1,t2)
    t2.seek(0)
    return t2.read()


def mime_decode_header(line):
    line = re.sub('\n','',line)  # remove CR/LF
    line = remove_spc.sub(decode_remove_spc,line) # remove spaces between
                                                  # encoded parts
    # return mime_head.sub(decode_base64,line)
    line = mime_head.sub(decode_base64,line)
    return mimeqp_head.sub(decode_quopri,line)

def process(mlist, msg, msgdata):
    content_type = msg.getheader('content-type')
    subject = msg.getheader('subject')
    jp_pat = re.compile('iso-2022-jp',re.I)
    message_is_japanese = \
                    content_type and jp_pat.search(content_type) \
                    or \
                    subject and jp_pat.search(subject)
    if   message_is_japanese \
     or \
       (mm_cfg.DEFAULT_SERVER_LANGUAGE == 'ja' and \
       (content_type == None or re.compile(';').search(content_type) == None))\
     :
        subject = msg.getheader('subject')
        if subject:
            subject = toEuc(mime_decode_header(subject))
            del msg['subject']
            msg['Subject'] = subject
        sender = msg.getheader('from')
        if sender:
            sender = toEuc(mime_decode_header(sender))
            del msg['from']
            msg['From'] = sender
        msg.body = toEuc(msg.body)
        if content_type:
            msg['X-MMOriginal-Content-Type'] = content_type
        del msg['content-type']
        msg['Content-Type'] = 'text/plain; charset=euc-jp'
