# Copyright (C) 1998,1999,2000 by the Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software 
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

"""Goo-freemail has its own format for bounces."""

import string
import re

tcre = re.compile(r'Hello, this is goo free-mail system\.')
acre = re.compile(r'^Delivered-To:\s+(?P<addr>.*)$')
ecre = re.compile(r'^Received:')



def process(msg):
    # goo bounces seem to have a known subject value.
    if string.lower(msg.get('from', '')) <> 'mailer-daemon@mail.goo.ne.jp':
        return None
    msg.rewindbody()
    addrs = []
    # simple state machine
    #     0 == nothing seen
    #     1 == tag line seen
    state = 0
    while 1:
        line = msg.fp.readline()
        if not line:
            break
        line = string.strip(line)
        if state == 0 and tcre.search(line):
            state = 1
        elif state == 1:
            mo = acre.match(line)
            if mo:
                addrs.append(mo.group('addr'))
                continue
            mo = ecre.search(line)
            if mo:
                # we're at the end of the error response
                break
    return addrs or None
