#!/bin/sh
#
# mailman install script for Plamo Linux 2.2.5
#
# require: sendmail, apache, namazu
#
export LANG=C

if [ -r /tmp/SeTT_PX ]; then
  ROOT="`cat /tmp/SeTT_PX`"
fi

FQDN=`hostname -f`
MAMAN_DIR=$ROOT/opt/mailman
APACI_DIR=$ROOT/opt/apache
PYTHON_DIR=$ROOT/opt/python2
export PATH=$PYTHON_DIR/bin:$PATH

mv $MAMAN_DIR/Mailman/Defaults.py $MAMAN_DIR/Mailman/Defaults.py.bak
sed -e "s/LOCALHOST/$FQDN/" $MAMAN_DIR/Mailman/Defaults.py.bak > $MAMAN_DIR/Mailman/Defaults.py
python -c 'from compileall import *; compile_dir("/opt/mailman/Mailman")'
(cd $MAMAN_DIR; ./bin/update | tee ./update.log)

groupadd mailman
useradd -g mailman -m -d $MAMAN_DIR mailman


# ( DONOT CHANGE THE NEXT ONE LINE )
# Add Mailman Entry to Apache document index.
FQDN=`hostname -f`
MAMAN_DIR=$ROOT/opt/mailman
APACI_DIR=$ROOT/opt/apache
if [ -f $APACI_DIR/htdocs/contents.list ]; then
  if ! fgrep "GNU Mailman" $APACI_DIR/htdocs/contents.list 1> /dev/null 2>&1; then
    #
    # apache configuration
    #
    cat >> $APACI_DIR/htdocs/contents.list <<EOL

    <P ALIGN="CENTER"> GNU Mailman 2.0.13+J3
    ( <A
        HREF="http://mailman.sourceforge.net/"
      > http://mailman.sourceforge.net/ </A>
        |
      <A
	HREF="http://mm.tkikuchi.net/"
      >http://mm.tkikuchi.net/</A>
    )<BR>
     (Mailman, the GNU Mailing List Manager)<BR>
     <A
      HREF="mailman-2.0.13+J3/"
     >documentation</A>,
     <A
      HREF="mailman/listinfo/"
     >ListInformation</A>
<BR>
    </P>
EOL
    ln -sf $ROOT/usr/doc/mailman-2.0.13+J3 $APACI_DIR/htdocs/mailman-2.0.13+J3

    # copy mailman icons
    if [ -d $APACI_DIR/icons ]; then
      ( cd $MAMAN_DIR/icons/; \
        cp PythonPowered.png gnu-head-tiny.jpg mailman-large.jpg mailman.jpg \
	$APACI_DIR/icons )
    fi

    # add aliases and options to web server configureation
    cat >> $APACI_DIR/conf/httpd.conf<< _EOHTCONF_

#
# Setting for GNU Mailman
#
ScriptAlias	/mailman/	"$MAMAN_DIR/cgi-bin/"
Alias		/pipermail/	"$MAMAN_DIR/archives/public/"

<Location /mailman/>
    Options ExecCGI
    AllowOverride None
</Location>
<Location /pipermail/>
    Options FollowSymLinks
    AllowOverride None
</Location>
_EOHTCONF_

  fi

  #
  # Namazu Search for Mailman
  #
  cp /usr/libexec/namazu.cgi $MAMAN_DIR/cgi-bin
  mv $MAMAN_DIR/namazu/pipermail.pl  /usr/share/namazu/filter 

  cat >>$MAMAN_DIR/cgi-bin/.namazurc<<__ENMZRC
Index		$MAMAN_DIR/namazu
Template	$MAMAN_DIR/namazu
Replace		$MAMAN_DIR/archives/public/ http://$FQDN/pipermail/
Lang		ja_JP.eucJP
__ENMZRC

  cat >>$MAMAN_DIR/namazu/make_namazu<<__EMKNMZ
#!/bin/csh
setenv LANG ja_JP.eucJP
cd $MAMAN_DIR/namazu
/usr/bin/mknmz --media-type='text/html; x-type=pipermail' \
        $MAMAN_DIR/archives/public/*
__EMKNMZ
  chmod +x $MAMAN_DIR/namazu/make_namazu

  if [ -f $MAMAN_DIR/cron/crontab.in ]; then
    if ! fgrep "make_namazu" $MAMAN_DIR/cron/crontab.in 1> /dev/null 2>&1; then
	cat $MAMAN_DIR/namazu/crontab.namazu.add >> $MAMAN_DIR/cron/crontab.in
    fi
  fi

  #
  # Check and fix directory permisions
  #
  chown -R mailman $MAMAN_DIR
  $MAMAN_DIR/bin/check_perms -f


  #
  # Sendmail configuration
  #
  if [ -d /etc/smrsh ]; then
    ( cd /etc/smrsh;  ln -sf $MAMAN_DIR/mail/wrapper )
  fi

  # add mail aliases for mailman
  if ! fgrep "GNU Mailman"  /etc/mail/aliases 1> /dev/null 2>&1; then
    cat >> /etc/mail/aliases << _EOALIAS_
# aliases for GNU Mailman
mailman:	root@$FQDN
mailman-owner:	mailman
_EOALIAS_
    newaliases
  fi

  # Fix userid:groupid for sendmail(acount mail should have ids of 8:12).
  mv /etc/mail/sendmail.cf /etc/mail/sendmail.cf.bak
  sed -e 's/#O DefaultUser=mailnull/O DefaultUser=mail:mail/' \
  	/etc/mail/sendmail.cf.bak > /etc/mail/sendmail.cf
  chown bin:bin /etc/mail/sendmail.cf
  chmod 0444 /etc/mail/sendmail.cf
  kill `pidof /usr/sbin/sendmail`
  /usr/sbin/sendmail -bd -q5m


  #
  # work as mailman account to setup
  #
  /bin/su - mailman -c /opt/mailman/scripts/initmm
  cat >> /etc/mail/aliases <<_EOATEST_
# Mailman test ML for example
#test: "|/opt/mailman/mail/wrapper post test"
#test-admin:              "|/opt/mailman/mail/wrapper mailowner test"
#test-request:            "|/opt/mailman/mail/wrapper mailcmd test"
#test-owner:              test-admin
_EOATEST_
  #newaliases

else
  awk '/Add Mailman Entry/,/#EOS1/' $ROOT/install/doinst.sh >> /tmp/add_apache_test.sh
fi
#EOS1
( cd opt/mailman/archives/public ; rm -rf testlist )
( cd opt/mailman/archives/public ; ln -sf /opt/mailman/archives/private/testlist testlist )
( cd opt/mailman/archives/public ; rm -rf testlist.mbox )
( cd opt/mailman/archives/public ; ln -sf /opt/mailman/archives/private/testlist.mbox testlist.mbox )
