/*
 *	Version numbering for LAME.
 *
 *	Copyright (c) 1999 A.L. Faber
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "version.h"
#include <stdio.h>

static char lpszVersion[80];

char* get_lame_version(void)
{
	if (LAME_ALPHAVERSION>0)
		sprintf(lpszVersion,"%d.%02d (alpha %d)",LAME_MAJOR_VERSION,LAME_MINOR_VERSION,LAME_ALPHAVERSION);
	else if (LAME_BETAVERSION>0)
		sprintf(lpszVersion,"%d.%02d (beta %d)",LAME_MAJOR_VERSION,LAME_MINOR_VERSION,LAME_BETAVERSION);
	else
		sprintf(lpszVersion,"%d.%02d",LAME_MAJOR_VERSION,LAME_MINOR_VERSION);
	return lpszVersion;
}

char* get_psy_version(void)
{
	if (PSY_ALPHAVERSION>0)
		sprintf(lpszVersion,"%d.%02d (alpha %d)",PSY_MAJOR_VERSION,PSY_MINOR_VERSION,PSY_ALPHAVERSION);
	else if (PSY_BETAVERSION>0)
		sprintf(lpszVersion,"%d.%02d (beta %d)",PSY_MAJOR_VERSION,PSY_MINOR_VERSION,PSY_BETAVERSION);
	else
		sprintf(lpszVersion,"%d.%02d",PSY_MAJOR_VERSION,PSY_MINOR_VERSION);
	return lpszVersion;
}

char* get_mp3x_version(void)
{
	if (MP3X_ALPHAVERSION>0)
		sprintf(lpszVersion,"%d:%02d (alpha %d)",MP3X_MAJOR_VERSION,MP3X_MINOR_VERSION,MP3X_ALPHAVERSION);
	else if (MP3X_BETAVERSION>0)
		sprintf(lpszVersion,"%d:%02d (beta %d)",MP3X_MAJOR_VERSION,MP3X_MINOR_VERSION,MP3X_BETAVERSION);
	else
		sprintf(lpszVersion,"%d:%02d",MP3X_MAJOR_VERSION,MP3X_MINOR_VERSION);
	return lpszVersion;
}
