#include "lame.h"

#ifdef HAVEGTK
#include "gtkanal.h"
#include <gtk/gtk.h>
#endif

char mp3buffer[LAME_MAXMP3BUFFER];


/**********************************************************************
 * read one frame and encode it 
 **********************************************************************/
int makeframe(void)
{
  int iread;
  static short int Buffer[2][1152];
  iread=lame_readframe(Buffer);
  /* even if iread=0, get_audio hit EOF and returned Buffer=all 0's.  call
   * makeframe() one last time to flush all buffers */
  lame_encode(Buffer,mp3buffer);
  return iread;
}




/************************************************************************
*
* main
*
* PURPOSE:  MPEG-1,2 Layer III encoder with GPSYCHO 
* psychoacoustic model.
*
************************************************************************/


int main(int argc, char **argv)
{
  lame_init(0);
  if(argc==1) lame_usage(argv[0]);  /* no command-line args  */
  lame_parse_args(argc, argv); 
  lame_print_config();

#ifdef HAVEGTK
  if (gtkflag) gtk_init (&argc, &argv);
  if (gtkflag) gtkcontrol();
  else 
#endif
    while (makeframe());


  lame_cleanup(mp3buffer);
  return 0;
}

