/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1996 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	teleport.c (teleport client)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	960418	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <string.h>
extern char *getenv();

#define DFLT_HOST	"www.delegate.org"
#define DFLT_PORT	8000
extern char *TIMEFORM_ANSI_C;

static char inform(fp,msg)
	FILE *fp;
	char *msg;
{	char stime[64];

	StrftimeLocal(stime,sizeof(stime),TIMEFORM_ANSI_C,time(0));
	fprintf(fp,"%s: %s\n",stime,msg);
}

static openTeleport1(host,port,udp,socks)
	char *host;
	char *socks;
{	int sock = -1;

	if( udp )
		sock = UDP_client_open("sockio","udp",host,port);
	else{
		if( socks[0] )	sock = connectViaSocks(host,port);
		if( sock < 0 )	sock = client_open("sockio","tcp",host,port);
		if( sock < 0 && socks[0] == 0 )
				sock = connectViaSocks(host,port);
	}
	return sock;
}
static openTeleport(host,port,udp,socks)
	char *host;
	char *socks;
{	int sock = -1;
	int sleep1,sleeps;

	sleeps = 0;
	sleep1 = 1;

	if( !udp )
		inform(stderr,"connecting...");

	for(;;){
		sock = openTeleport1(host,port,udp,socks);
		if( 0 <= sock )
			break;
		if( sleeps <   5 ) sleep1 =  1; else
		if( sleeps <  30 ) sleep1 =  5; else
		if( sleeps <  60 ) sleep1 = 10; else
				   sleep1 = 60;
		sleep(sleep1);
		sleeps += sleep1;
	}
	if( !udp && 0 <= sock )
		inform(stderr,"connected.");
	return sock;
}

static relay1(in,out)
{	char line[1024];
	int rcc,wcc;

	fprintf(stderr,"[%d] relay1(%d->%d)\n",getpid(),in,out);
	while( 0 < (rcc = read(in,line,sizeof(line))) ){
		if( (wcc = write(out,line,rcc)) != rcc )
			break;
/*
fprintf(stderr,"[%d](%d->%d) %d in %d out\n",getpid(),in,out,rcc,wcc);
*/
	}
	fprintf(stderr,"[%d] disconnected.\n",getpid());
}
static relays(ac,av,sock,infd,outfd)
	char *av[];
{	char in[32],out[32];
	char *nav[8];

	sprintf(in,"%d",sock);
	sprintf(out,"%d",outfd);

	if( INHERENT_fork() ){
		if( fork() == 0 ){
			execl(av[0],av[0],"relay",in,out,0);
			exit(1);
		}
	}else{
		nav[0] = av[0];
		nav[1] = "relay";
		nav[2] = in;
		nav[3] = out;
		nav[4] = 0;
		Spawnvp("relay/teleport",av[0],nav);
	}
	relay1(infd,sock);
}

teleport_main(ac,av)
	char *av[];
{	int sock;
	char *host;
	int port;
	int ifd,ofd;
	int udp;
	char socks[256],*sv,*ns,*dn;

	DO_INITIALIZE(ac,av);

	if( ac < 2 ){
		fprintf(stderr,"Usage: %s host [port[/udp]]\r\n",av[0]);
		return;
	}
	if( strcmp(av[1],"relay") == 0 )
		return relay1(atoi(av[2]),atoi(av[3]));

	host = av[1];

	if( ac < 3 ){
		port = DFLT_PORT;
		udp = 0;
	}else{	port = atoi(av[2]);
		udp = strstr(av[2],"/udp") != NULL;
	}

	socks[0] = 0;
	sock = openTeleport(host,port,udp,socks);
	if( sock < 0 ){
		fprintf(stderr,"cannot connect.\n");
		exit(1);
	}

	if( !INHERENT_fork() ){
		relays(ac,av,sock,fileno(stdin),fileno(stdout));
	}else{
		ifd = fileno(stdin);
		ofd = fileno(stdout);
		for(;;){
			if( relay_lines(0,1,NULL,dup(ifd),sock,NULL,sock,dup(ofd)) < 0 )
				break;
			close(sock);
			inform(stderr,"disconnected.");
break;
			sock = openTeleport(host,port,udp,socks);
		}
	}
	exit(0);
}
