/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1995 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	xferlog.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <ctype.h>
extern char *TIMEFORM_ANSI_C;

xferlog(log,start,chost,size,path,bin,in,anon,user,auser)
	char *log;
	char *chost,*path,*user,*auser;
{	char *lp,date[1024];
	int now,etime;
	char *action,*service;
	char xpath[1024],xuser[256],*xp;

	now = time(0);
	StrftimeLocal(date,sizeof(date),TIMEFORM_ANSI_C,now);
	etime = now - start;
	action = "_";
	service = "ftp";

	strcpy(xpath,path);
	for( xp = xpath; *xp; xp++ ) if( isspace(*xp) ) *xp = '_';
	strcpy(xuser,user);
	for( xp = xuser; *xp; xp++ ) if( isspace(*xp) ) *xp = '_';

	if( auser != NULL && strcmp(auser,"?") == 0 )
		auser = NULL;

	sprintf(log,"%s %d %s %d %s %s %s %s %s %s %s %d %s",
		date,
		etime,
		chost,
		size,
		xpath,
		bin?"b":"a",
		action,
		in ? "i":"o",
		anon ? "a":"r",
		xuser,
		service,
		auser?1:0,auser?auser:"*"
	);
}
