/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-2000 Yutaka Sato
Copyright (c) 1994-2000 Electrotechnical Laboratory (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
////////////////////////////////////////////////////////////////////////*/
#include <stdio.h>

#define VERSION	"6.1.18"
#define DATE	"September 6, 2000"
#define AUTHOR	"Yutaka Sato"
#define A_ORG	"Electrotechnical Laboratory"
#define A_EMAIL	"ysato@delegate.org"
#define A_SITE	"delegate.org"

#define COPYRIGHT "\
AIST Research Product No. 1994-ETL-8715-1\r\n\
Copyright (c) 1994-2000 Yutaka Sato\r\n\
Copyright (c) 1994-2000 Electrotechnical Laboratory (ETL), AIST, MITI"
char *DELEGATE_copyright(){ return COPYRIGHT; }

char *DELEGATE_ver()
{
	return VERSION;
}
char *DELEGATE_date()
{
	return DATE;
}
char *DELEGATE_verdate()
{	static char buf[64];

	if( buf[0] == 0 ) sprintf(buf,"DeleGate/%s (%s)",
		VERSION,DATE);
	return buf;
}
char *DELEGATE_version(){
	static char version[128];
	sprintf(version,"DeleGate/%s by %s", VERSION, A_EMAIL);
	return version;
}
char *DELEGATE_Ver()
{	static char Ver[128];
	sprintf(Ver,"DeleGate/%s (%s) by %s (%s)", VERSION,DATE, AUTHOR,A_ORG);
	return Ver;
}
char *DELEGATE_Version(){
	static char Version[128];
	sprintf(Version,"%s (%s) %s", DELEGATE_version(), AUTHOR, DATE);
	return Version;
}

char *DELEGATE_Distribution(){
	return "ftp://ftp.delegate.org/pub/DeleGate/";
}

char *DELEGATE_homepage(){
	return "http://www.delegate.org/delegate/";
}

put_identification(out)
	FILE *out;
{
	fprintf(out,"%s\r\n",DELEGATE_verdate());
	fprintf(out,"%s\r\n",COPYRIGHT);
	fprintf(out,"--\r\n");
	fprintf(out,"FTP: <URL:%s>\r\n",DELEGATE_Distribution());
	fprintf(out,"WWW: <URL:http://www.%s/>\r\n",A_SITE);
	fprintf(out,"Mail:<URL:mailto:feedback@%s>\r\n",A_SITE);
	fprintf(out,"     <URL:http://www.%s/feedback/>\r\n",A_SITE);
}

