/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	urlesc.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	950421	extracted from url.c
//////////////////////////////////////////////////////////////////////#*/
#include <ctype.h>
#include <string.h>

#define ishex(ch)	(ch && strchr("0123456789abcdefABCDEF",ch))

unescape_specials(str,set,succ)
	char *str,*set,*succ;
{	char *ep,sx[3];
	int len,x;

	len = strlen(succ);
	if( ep = strchr(str,'%') ){
	    if( ishex(ep[1]) && ishex(ep[2]) && strncmp(&ep[3],succ,len)==0 ){
		sx[0] = ep[1];
		sx[1] = ep[2];
		sx[2] = 0;
		sscanf(sx,"%x",&x);
		if( strchr(set,x) ){
			ep[0] = x;
			strcpy(&ep[1],&ep[3]);
		}
	    }
	}
}
nonxalpha_unescape(src,dst,spacealso)
	char *src,*dst;
{	char ch,*cp,sx[3];
	int num;
	int x;

	if( src != dst )
		strcpy(dst,src);

	num = 0;
	for( cp = dst; ch = *cp; cp++ )
		if( ch == '%' && ishex(cp[1]) && ishex(cp[2]) ){
			sx[0] = cp[1];
			sx[1] = cp[2];
			sx[2] = 0;
			sscanf(sx,"%x",&x);
			if( spacealso || !strchr(" \t\r\n",x) ){
				cp[0] = x;
				strcpy(&cp[1],&cp[3]);
				num++;
			}
		}
	return num;
}
url_escape(src,dst,escs)
	char *src,*dst,*escs;
{	char escaped[4096];
	char ch,*sp,*dp;

	if( src == dst )
		dp = escaped;
	else	dp = dst;
	for( sp = src; ch = *sp; sp++ ){
		if( (ch & 0x80) || iscntrl(ch) || strchr(escs,ch) || ch == '%' ){
			sprintf(dp,"%%%02x",ch & 0xFF);
			dp += strlen(dp);
		}else	*dp++ = ch;
	}
	*dp = 0;
	if( src == dst )
		strcpy(src,escaped);
}

logurl_escape(src,dst)
	char *src,*dst;
{
	url_escape(src,dst," \t\r\n%\"<>");
}
nonxalpha_escape(src,dst)
	char *src,*dst;
{
	url_escape(src,dst," \t\n%?#");
}
safe_escape(src,dst)
	char *src,*dst;
{
	url_escape(src,dst," \t\n\"#%&'/<>?");
}

h2toi(h2)
	char *h2;
{	char hb[3];
	int i = -1;

	if( ishex(h2[0]) && ishex(h2[1]) ){
		hb[0] = h2[0]; hb[1] = h2[1]; hb[2] = 0;
		sscanf(hb,"%x",&i);
	}
	return i;
}
url_strstr(url,pat)
	unsigned char *url,*pat;
{	int plen,ulen,pch,uch,xuch,xpch;

	ulen = 0;
	for( plen = 0; pch = pat[plen]; plen++ ){
		uch = url[ulen++];
		if( uch == pch && uch != '%' )
			continue;
		if( uch == '%' ){
			xuch = h2toi(url+ulen);
			if( xuch == pch ){
				ulen += 2;
				continue;
			}
		}
		if( pch == '%' ){
			xpch = h2toi(pat+plen+1);
			if( xpch == uch ){
				plen += 2;
				continue;
			}
		}
		if( uch == '%' && pch == '%' ){
			if( xuch == xpch ){
				ulen += 2;
				plen += 2;
				continue;
			}
		}
		break;
	}
	if( pch == 0 )
		return ulen;
	else	return 0;
}
