/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	telnet.c (telnet proxy)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	940304	created
//////////////////////////////////////////////////////////////////////#*/
#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include "vsignal.h"
#include "delegate.h"
#include "ystring.h"
extern char *getClientHostPortUser();

static char Xdisplay[256];
static char Xproxy[256];
static int Xpid;

static int THREAD;
static int THREAD_exiting;
static char *useTHREAD;
extern char *INHERENT_thread();

static int env_valid;
static jmp_buf tel_env;
static void sigPIPE(sig){
	signal(SIGPIPE,SIG_IGN);
	if( env_valid ){
		env_valid = 0;
		if( !THREAD ) longjmp(tel_env,SIGPIPE);
	}
}
static void sigTERM(sig){
	signal(SIGTERM,SIG_IGN);
	if( env_valid ){
		env_valid = 0;
		if( !THREAD ) longjmp(tel_env,SIGTERM);
	}
}

#define CtoS	1	/* client to server */
#define StoC	2	/* server to client */
#define CtoD	3	/* client to delegate */
#define DtoS	4	/* delegate to server */
#define DtoC	5	/* delegate to client */

#define SE	240
#define NOP	241
#define EC	247
#define EL	248
#define SB	250
#define WILL	251
#define WONT	252
#define DO	253
#define DONT	254
#define IAC	255

#define SYNCH	242

#define IS	0
#define VAR	0
#define VALUE	1

#define O_ECHO		 1
#define O_SUPAHEAD	 3	/* Suppress Go Ahead */
#define O_STATUS	 5	/* Give Status */
#define O_NAOL		 8	/* Negotiate About Output Line width */
#define O_NAOP		 9	/* Negotiate About Output Page size */
#define O_TERMTYPE	24	/* Teminal Type */
#define O_NAWS		31	/* Negotiate About Window Size */
#define O_TSPEED	32	/* Terminal Speed */
#define O_LFLOW		33	/* Remote Flow Control */
#define O_XDISPLOC	35	/* X Display Location */
#define O_ENVIRON	36	/* Environment Variables */

static int gotSIGURG;
static void sigurg(sig)
{	char *ssig;

	signal(SIGURG,sigurg);
	gotSIGURG += 1;
	if( sig == SIGURG ) ssig = "URG"; else
	if( sig == SIGIO  ) ssig = "IO"; else
			    ssig = "??";
	sv1log("got SIG%s (%d)\n",ssig,gotSIGURG);
}

/*
#include <sys/sockio.h>
setRecvSIGURG(sock)
{	int pgrp;

	signal(SIGURG,sigurg);
	pgrp = getpid();
	ioctl(sock,SIOCSPGRP,&pgrp);
	ioctl(sock,SIOCGPGRP,&pgrp);
	sv1log("set receive SIGURG [%d] %d\n",sock,pgrp);
}
*/

extern int IO_TIMEOUT;

static Read(what,sock,dst,buf,fsbsize,timeout)
	char *what,*buf;
{	int cnt,rcc,ci,cj;
	char *sdir;
	int start,nready;

	rcc = 0;
	start = time(0);
	for( cnt = 0; cnt < 10; cnt++ ){
		if( THREAD )
			nready = thread_PollIn(sock,timeout*1000);
		else	nready = PollIn(sock,timeout*1000);

		if( THREAD_exiting ){
			sv1log("THREAD_exiting: PollIn()=%d\n",nready);
			rcc = -1;
			break;
		}

		if( nready < 0 ){
			sv1log("nready = %d, errno=%d\n",nready,errno);
			rcc = -1;
			break;
		}
		if( nready == 0 ){
			if( timeout <= time(0)-start ){
				rcc = -1;
				break;
			}

			if( relayOOB(sock,dst) )
				continue;

			msleep(10);
			continue;
		}
		errno = 0;
		rcc = read(sock,buf,fsbsize);
		if( rcc <= 0 ){
			sv1log("sock=%d read=%d, errno=%d\n",sock,rcc,errno);
			break;
		}
		if( THREAD_exiting ){
			sv1log("THREAD_exiting: read()=%d\n",rcc);
			break;
		}

		if( !gotSIGURG )
			break;

		if( rcc <= 0 ){
			sv1log("%s read failed (%d) waiting SYNCH (%d)\n",
				what,cnt,gotSIGURG);
			if( 0 < cnt ){
				sv1log("#### faield (%d) wait 0.1 second.\n",cnt);
				msleep(100);
			}
			continue;
		}

		for( ci = 0; ci < rcc; ci++ )
		if( (buf[ci] & 0xFF) == SYNCH ){
			sv1log("%s got SYNCH (%d)\n",what,gotSIGURG);
			gotSIGURG = 0;
			ci++;
			break;
		}
		if( ci == rcc )
			continue;

		rcc -= ci;
		for( cj = 0; cj < rcc; cj++ )
			buf[cj] = buf[ci+cj];
		break;
	}
	for( ci = 0; ci < rcc; ci++ ){
		if( (buf[ci] & 0xFF) == SYNCH )
			Verbose("######## SYNCH in non Sync mode.\n");
	}
	return rcc;
}

#define C_S	1
#define S_C	2
static int dump_commands;
static int ClientsWill[128];
static int ServersWill[128];

/*
 * The following stuff is to control ECHOing (and editing with DEL or
 * so) of user-input at the proxy-login dialog (with "Host:" prompt)
 *
 * The default status of ECHO option is WONT/DONT ECHO as described
 * in RFC857.  But some clients programs (like MS's one) seem to
 * expect the server to be WILL ECHO by default, making full-duplex
 * (character by character) communication without doing local-echo...
 * Doing ECHO negotiation between DeleGate and client is a possible
 * solution, like in older version of DeleGate, but it spoiles
 * the transparent relaying between a server and a client.
 *
 * In secondary connections after closing the first session to a
 * server, a client may be in different status from the initial one
 * (probably in explicit DO ECHO and DO SUPGA). It might make "Host:"
 * dialogue (its editing) be different from the first one (may not be
 * harmful), and make inconsistency with the server (can be harmful)...
 */
static int ClientsDO[256];
static int guessedHalfdup = -1;
static isHalfdup(){
	int doga;

	if( doga = ClientsDO[O_SUPAHEAD] ) 
		return doga == DONT;
	if( 0 < guessedHalfdup )
		return 1;
	return 0; /* it should be 0 based on RFC858... */ 
}
static willEcho(){
	int doecho;

	/* explicitly ordered by the client */
	if( doecho = ClientsDO[O_ECHO] )
		return doecho == DO;

	/* negotiated something leaving ECHO as default */
	if( ClientsDO[O_SUPAHEAD] )
		return 0;

	/* suppress redundant echo in half-duplex communication */
	if( isHalfdup() )
		return 0;

	/* it should be 0 baesd on RFC857... */
	return 1;
}
static logEcho()
{	char *echo,*supga;

	switch( ClientsDO[O_ECHO] ){
		case DO:  echo = "DoEcho"; break;
		case DONT:echo = "DontEcho"; break;
		default:  echo = "none"; break;
	}
	switch( ClientsDO[O_SUPAHEAD] ){
		case DO:  supga = "DoSupGA"; break;
		case DONT:supga = "DontSupGA"; break;
		default:  supga = "none"; break;
	}
	sv1log("%s-Echo [client-says:%s,%s], Half=%d(%d)\n",
		willEcho()?"WILL":"WONT",echo,supga,
		isHalfdup(),guessedHalfdup);
}

static clearServersWill()
{	int si;

	for( si = 0; si < 128; si++)
		ServersWill[si] = 0;
}

static char *code(ch)
{	char *mn;
	int co;

	co = 1;
	switch( ch ){
		case SE:  co = 0; mn = "SE";		break;
		case 241: co = 0; mn = "NOP";		break;
		case 242: co = 0; mn = "DataMark";	break;
		case 243: co = 0; mn = "Break";		break;
		case 244: co = 0; mn = "InterruptProcess";	break;
		case 245: co = 0; mn = "AbortOutput";	break;
		case 246: co = 0; mn = "AreYouThere";	break;
		case 247: co = 0; mn = "Erasecharacter";	break;
		case 248: co = 0; mn = "EraseLine";	break;
		case 249: co = 0; mn = "Goahead";	break;
		case SB:  co = 0; mn = "SB";		break;
		case WILL:co = 1; mn = "WILL";		break;
		case WONT:co = 1; mn = "WONT";		break;
		case DO:  co = 1; mn = "DO";		break;
		case DONT:co = 1; mn = "DONT";		break;
		case IAC: co = 1; mn = "IAC";		break;
		default:  co = 0; mn = NULL;		break;
	}
	return mn;
}
static char _opt[8];
static char *option(ch)
{
	switch( ch ){
		case O_ECHO:     return "Echo";
		case O_SUPAHEAD: return "SuppressGoAhead";
		case O_STATUS:	 return "GiveStatus";
		case O_TERMTYPE: return "TerminalType";
		case O_NAOP:     return "NegotiateAboutOutputPageSize";
		case O_NAWS:     return "NegotiateAboutWindowSize";
		case O_TSPEED:   return "TerminalSpeed";
		case O_LFLOW:	 return "RemoteFlowControl";
		case O_XDISPLOC: return "XDisplayLocation";
		case O_ENVIRON:  return "EnvironmentValiables";
	}
	sprintf(_opt,"%d",ch);
	return _opt;
}

static int docontrol;
extern void *ccx_global;
static controlcommand(Conn,toC,fromC)
	Connection *Conn;
{	char code[2],msg[128];

	write(toC,"\r\n> ",4);
	read(fromC,code,1);
	code[1] = 0;
	sprintf(msg,"%c\r\n",code[0]);
	write(toC,msg,strlen(msg));
	global_setCCX(Conn,code,msg);
	write(toC,msg,strlen(msg));
}

static scanCommands(direction,buf,cc)
	char *buf;
{	int i,cch,ch,cont;
	char vch[2048],*mn;
	char *sdir;

	switch( direction ){
		case CtoS: sdir = "CS"; break;
		case DtoS: sdir = "DS"; break;
		case CtoD: sdir = "CD"; break;
		case StoC: sdir = "SC"; break;
		case DtoC: sdir = "DC"; break;
		default:   sdir = "??"; break;
	}

	for(i = 0; i < cc; i++){

	    if( direction == CtoS )
		cc += rewriteTelnet(direction,buf+i,cc-i);

	    ch = buf[i] & 0xFF;
	    vch[0] = 0;
	    if( ch == IAC ){
	        ch = buf[++i] & 0xFF;
		if( WILL <= ch && ch <= DONT ){
			cch = ch;
			mn = code(cch);
	        	ch = buf[++i] & 0xFF;
			sprintf(vch,"%-4s %s",mn,option(ch));
			if( direction == CtoS || direction == CtoD ){
				if( ch == O_XDISPLOC ){
					if( cch == WONT && Xdisplay[0] ){
						Verbose("WONT->WILL %s\n",option(ch));
						buf[i-1] = cch = WILL;
						mn = code(cch);
						sprintf(vch,"%-4s %s",mn,option(ch));
					}
				}
				if( ch == O_TERMTYPE || ch == O_ENVIRON )
				Verbose("%s Client-Says %s\n",sdir,vch);
				if( cch == WILL
				 || cch == WONT && ClientsWill[ch] == 0 )
					ClientsWill[ch] = cch;
				if( cch == DO || cch == DONT )
					ClientsDO[ch] = cch;
			}else
			if( direction == StoC ){
				ServersWill[ch] = cch;
			}
		}else
		if( ch == SB ){
			strcpy(vch,"SB,");
			ch = buf[++i];
			strcat(vch,option(ch));

			for(i++; i < cc; i++ ){
				ch = buf[i] & 0xFF;
				if( ' ' < ch && ch < 0x7F ){
					if( buf[i-1]<=' ' || 0x7F<=buf[i-1] )
						strcat(vch,",");
					sprintf(vch+strlen(vch),"%c",ch);
				}else
				if( mn = code(ch) ){
					strcat(vch,",");
					strcat(vch,mn);
				}else{
					strcat(vch,",");
					sprintf(vch+strlen(vch),"%d",ch);
				}
				if( ch == SE )
					break;
			}
		}
	        Verbose("%s[%3d] %02x:%3d %s\n",sdir,i,ch,ch,vch);
	    }else{
		if( direction == StoC ){
			/* code conversion */
			if( ccx_global ) cc = ccx_telnet(ccx_global,buf,&i,cc);
		}else
		if( direction == CtoS ){
			static numCC;
			if( ccx_global ){
				/* conversion switch command ... */
				/*
				if( ch == ('C'-0x40) ){
					numCC++;
					if( 2 < numCC ){
						sv1log("## ctrl-C*%d\n",numCC);
						numCC = 0;
						if( i+1 == cc ){
							docontrol = 1;
							cc--;
						}
					}
				}else	numCC = 0;
				*/
			}
		}
	    }
	}
	return cc;
}
ccx_telnet(ccx,buf,ip,cc)
	void *ccx;
	unsigned char *buf;
	int *ip;
{	unsigned char out[4096],tmp[4096];
	int i,j,k,l,tc,oc;

	i = *ip;
	for( j = i; j < cc; j++ )
		if( (buf[j] & 0xFF) == IAC )
			break;

	oc = CCXexec(ccx,buf+i,j-i,out,sizeof(out));
	tc = 0;
	for( k = j; k < cc; k++ ) tmp[tc++] = buf[k];
	for( k = 0; k < oc; k++ ) buf[i++] = out[k];
	l = i;
	for( k = 0; k < tc; k++ ) buf[l++] = tmp[k];
	cc = l;

	*ip = i;
	return cc;
}

static getCommand(fp,cbuf)
	FILE *fp;
	char *cbuf;
{	int ci,ch,ach;

	ci = 0;
	cbuf[ci++] = ch = getc(fp);

	if( WILL <= ch && ch <= DONT ){
		cbuf[ci++] = ach = getc(fp);
	}else
	if( ch == SB ){
		do {
			ch = getc(fp);
			if( ch == EOF )
				break;
			cbuf[ci++] = ch;
		} while(ch != SE);
	}
	return ci;
}
static getline(visible,fc,tc,line,cbuf)
	FILE *fc,*tc;
	char *line,*cbuf;
{	int ready;
	int ch,ci;
	int endCR;
	int lx;
	int ii;
	char *cb;
	int timeout;
	char cbufbuf[1024];

	if( cbuf == NULL )
		cbuf = cbufbuf;
	endCR = 0;
	ci = 0;
	lx = 0;

	if( Xproxy[0] )
		timeout = LOGIN_TIMEOUT * 1000 * 4;
	else	timeout = LOGIN_TIMEOUT * 1000;

	/*
	 * "Password:" for proxy-authorization should be hidden.
	 * To do so, DeleGate must notify that I WILL DO FULL DUPLEX ECHO
	 * to the client. (This had been the default before 6.1.3)
	 */
	if( !visible ){
		if( ClientsDO[O_ECHO] != DO && ClientsWill[O_ECHO] != WONT )
			putIAC(tc,WILL,O_ECHO);
		if( ClientsDO[O_SUPAHEAD] != DO )
			putIAC(tc,WILL,O_SUPAHEAD);
	}

	for(;;){
		if( fflush(tc) == EOF )
			break;

		ready = fPollIn(fc,timeout);
		if( ready <= 0 ){
			if( ready == 0 ){
fprintf(tc,"\r\n---------- PROXY-TELNET login: TIMEOUT(%d).\r\n",
					timeout);
				fflush(tc);
				return EOF;
			}
			break;
		}
		ch = fgetc(fc);

		if( ch != IAC && ch != 0 ){
			if( guessedHalfdup < 0 ){
				if( ready_cc(fc) <= 0 )
					guessedHalfdup = 0;
				else	guessedHalfdup = 1;
			}
			if( lx == 0 )
				logEcho();
		}

		if( visible ){
			if( willEcho() )
			if( isprint(ch) ){
				putc(ch,tc);
				fflush(tc);
			}

			if( ch == '?' ){
				if( fPollIn(fc,300) == 0 ){
					line[lx++] = ch;
					goto EOL;
				}
			}
		}else{
			if( isprint(ch) || ch == '\t' ){
				putc('*',tc);
				fflush(tc);
			}
		}

		if( ch != IAC )
			Verbose("CD %x\n",ch);

		switch( ch ){
			case IAC:
				cbuf[ci] = ch;
				ii = 1 + getCommand(fc,cbuf+ci+1);
				ci += scanCommands(CtoS,cbuf+ci,ii);
				break;

			case 0: break;
			case '\001': break; /* ? */

			case 'D'-0x40:
				fprintf(tc,"\r\n");
				fflush(tc);
			case EOF:
				Verbose("--EOF from client--\n");
				return EOF;
			case 0x7F:
			case 'H'-0x40:
				if( 0 < lx ){
					fwrite("\b \b",1,3,tc);
					lx--;
				}
				break;

			case 'U'-0x40:
			{	for( ii = 0; ii < lx; ii++ ) fputc('\b',tc);
				for( ii = 0; ii < lx; ii++ ) fputc(' ',tc);
				for( ii = 0; ii < lx; ii++ ) fputc('\b',tc);
				lx = 0;
				break;
			}

			case '\r':
				endCR = 1; /* X-( */
				if( 0 < ready_cc(fc) ){
					int nch;
					nch = getc(fc);
					if( nch == '\n' ){
						ch = nch;
						endCR = 0;
					}else	ungetc(nch,fc);
				}
			case '\n':
				Verbose("EOL char = %x\n",ch);
				goto EOL;
			default:
				line[lx++] = ch;
				break;
		}
	} EOL:
	line[lx] = 0;

	if( willEcho() )
	fputs("\r\n",tc);
	return ci;
}

static putIAC(tc,com,what)
	FILE *tc;
{	char ibuf[32],ii;

	ii = 0;
	ibuf[ii++] = IAC; ibuf[ii++] = com; ibuf[ii++] = what;
	ii = scanCommands(DtoC,ibuf,ii);
	fwrite(ibuf,1,ii,tc);
}
static sayWelcome(Conn,tc)
	Connection *Conn;
	FILE *tc;
{	char *aurl,rurl[256],msg[2048];

	aurl = "/-/builtin/mssgs/telnet/telnet-banner.dhtml";
	getBuiltinData(Conn,"TELNET-banner",aurl,msg,sizeof(msg),rurl);
	put_eval_dhtml(Conn,rurl,tc,msg);
}
static putHELP(Conn,tc)
	Connection *Conn;
	FILE *tc;
{	char *aurl,rurl[256],msg[2048];

	aurl = "/-/builtin/mssgs/telnet/telnet-help.dhtml";
	getBuiltinData(Conn,"TELNET-help",aurl,msg,sizeof(msg),rurl);
	put_eval_dhtml(Conn,rurl,tc,msg);
}
static cantConnMessage(Conn,serv,tc)
	Connection *Conn;
	char *serv;
	FILE *tc;
{	char *aurl,rurl[256],msg[2048];

	aurl = "/-/builtin/mssgs/telnet/telnet-cantconn.dhtml";
	getBuiltinData(Conn,"TELNET-cantconn",aurl,msg,sizeof(msg),rurl);
	put_eval_dhtml(Conn,rurl,tc,msg);
}
static ConnectedMessage(Conn,serv,tc,comline)
	Connection *Conn;
	char *serv;
	FILE *tc;
	char *comline;
{
	fprintf(tc,"-- Connected to %s.\r\n",serv);
	if( toProxy ){
		fprintf(tc,"Connected to another telnet-proxy.\r\n");
		fprintf(tc,"Your input[%s] is forwarded to it.\r\n",comline);
	}
	fflush(tc);
}

static get_hostname(Conn,fc,tc,line,cbuf,csize,ncom)
	Connection *Conn;
	FILE *fc,*tc;
	char *line,*cbuf;
	int *csize;
{	int ci;
	char clhost[256];

/*
	putIAC(tc,WILL,O_ECHO);
	putIAC(tc,WILL,O_SUPAHEAD);
*/

	if( ncom == 0 )
		sayWelcome(Conn,tc);

	if( ncom == 0 )
	if( !source_permitted(Conn) ){
		getpeerNAME(FromC,clhost);
		fprintf(tc,
		"!!!!!!!! HOST <%s> not permitted by DeleGate\r\n",clhost);
		fflush(tc);
		service_permitted(Conn,"telnet"); /* delay */
		return EOF;
	}

	fprintf(tc,">> Host name: ");
	if( fflush(tc) == EOF )
		return EOF;
	ci = getline(1,fc,tc,line,cbuf);
	if( ci == EOF )
		return EOF;

	fflush(tc);
	*csize = ci;
	return 0;
}
static relayClientsWill(ts,op)
	FILE *ts;
{	int co;

	if( co = ClientsWill[op] ){
		Verbose("DS Client-Said %s %s.\n",code(co),option(op));
		putc(IAC,ts);
		putc(co,ts);
		putc(op,ts);
	}
}
static relayClientsWills(ts)
	FILE *ts;
{	int op;
	for( op = 0; op < 128; op++ )
		relayClientsWill(ts,op);
}

static CS(Conn,fcbsize,omask)
	Connection *Conn;
{	char buf[0x4000];
	int gotsig;
	int rcc;
	int count,total;

	if( FromC < 0 ){
		sv1log("CS-REALY: NO INPUT\n");
		Finish(0);
	}

	total = count = 0;
	if( fcbsize == 0 )
		fcbsize = 1;
	if( sizeof(buf) < fcbsize )
		fcbsize = sizeof(buf);

	if( (gotsig = setjmp(tel_env)) == 0 ){
		env_valid = 1;
		sigsetmask(omask);
		for(;;){
			rcc = Read("CS",FromC,ToS,buf,fcbsize,IO_TIMEOUT);
			if( rcc <= 0 )
				break;

			if( dump_commands && C_S )
				rcc = scanCommands(CtoS,buf,rcc);

			count += 1;
			total += rcc;

			if( docontrol ){
				docontrol = 0;
				controlcommand(Conn,ToC,FromC);
				if( rcc == 0 )
					continue;
			}

			if( ToS < 0 )
				continue;

			if( write(ToS,buf,rcc) <= 0 )
				break;
		}
		if( rcc <= 0 ) sv1log("CS-EOF\n");
	}
	sv1log("CS-RELAY[%d>%d]: %dBytes %dI/O buf=%d\n",
		FromC,ToS,total,count,fcbsize);

	if( gotsig == SIGPIPE ){
		/* the server has done but the response data
		 * to the client may remain (for safety...)
		 */
		sv1log("CS-SIGPIPE\n");
		sleep(1);
	}
	return total;
}
static SC(Conn,fsbsize,omask)
	Connection *Conn;
{	char buf[0x4000];
	int gotsig;
	int rcc,wcc;
	int count,total;

	total = count = 0;
	if( fsbsize == 0 )
		fsbsize = 1;
	if( sizeof(buf) < fsbsize )
		fsbsize = sizeof(buf);

	if( setjmp(tel_env) == 0 ){
		env_valid = 1;
		sigsetmask(omask);
		for(;;){
			rcc = Read("SC",FromS,ToC,buf,fsbsize,IO_TIMEOUT);
			if( rcc <= 0 )
				break;

			count += 1;
			total += rcc;
			if( (dump_commands & S_C) || CCX )
				rcc = scanCommands(StoC,buf,rcc);

			if( (wcc = write(ToC,buf,rcc)) <= 0 )
				break;
		}
		if( rcc <= 0 ) sv1log("SC-EOF\n");
	}
	sv1log("SC-RELAY[%d<%d]: %dBytes %dI/O buf=%d\n",
		ToC,FromS,total,count,fsbsize);
	return total;
}

static THREADexit(Conn)
	Connection *Conn;
{	int efd;

	if( THREAD && THREAD_exiting == 0 ){
		THREAD_exiting = 1;
		if( !IsAlive(FromC) ) efd = FromC; else
		if( !IsAlive(FromS) ) efd = FromS; else
		{
			sv1log("THREAD_exit: both side are alive ? %d,%d\n",
				FromC,FromS);
			Finish(-1);
		}
		sv1log("THREAD_exit: dup closed socket %d to %d/%d,%d/%d\n",
			efd,FromC,ToC,FromS,ToS);
		if( efd != FromC ) dup2(efd,FromC);
		if( efd != ToC   ) dup2(efd,ToC);
		if( efd != FromS ) dup2(efd,FromS);
		if( efd != ToS   ) dup2(efd,ToS);
	}
}
static SC1(Conn,fsbsize,omask)
	Connection *Conn;
{	int cc;

	dumpTimer();
	/*
	setRecvSIGURG(FromS);
	*/
	cc = SC(Conn,fsbsize,omask);
	THREADexit(Conn);
	return cc;
}
static CS1(Conn,fcbsize,omask)
	Connection *Conn;
{	int cc;

	dumpTimer();
	/*
	setRecvSIGURG(FromC);
	*/
	cc = CS(Conn,fcbsize,omask);
	THREADexit(Conn);
	return cc;
}

static bidirectional_relay(Conn,fcbsize,fsbsize)
	Connection *Conn;
{	register int ppid,cpid;
	int omask;
	int total;
	void (*opipe)();
	void (*oterm)();
	void (*ointr)();

	useTHREAD = INHERENT_thread();

	Verbose("buffer: CS=%d[%d>%d] SC=%d[%d>%d] (%s)\n",
		fcbsize,FromC,ToS,fsbsize,FromS,ToC,
		useTHREAD?useTHREAD:"FORK");

	omask = sigblock(sigmask(SIGPIPE)|sigmask(SIGTERM));
	opipe = Vsignal(SIGPIPE,sigPIPE);
	oterm = Vsignal(SIGTERM,sigTERM);
	ointr = Vsignal(SIGINT, sigTERM);

	if( FromC < 0 ){
		total = SC(Conn,fsbsize,omask);
	}else
	if( FromS < 0 ){
		total = CS(Conn,fcbsize,omask);
	}else
	if( useTHREAD ){
		THREAD = 1;
		THREAD_exiting = 0;
		thread_fork(0,CS1,Conn,fsbsize,omask);
		SC1(Conn,fcbsize,omask,ppid);
		THREAD = 0;
	}else{
		ppid = getpid();
		if( (cpid = Fork("bidirectiona_relay")) == 0 ){
			total = SC1(Conn,fsbsize,omask);
			signal(SIGTERM,SIG_IGN);
			signal(SIGPIPE,SIG_IGN);
			Kill(ppid,SIGTERM);
			Finish(0);
		}else{
			total = CS1(Conn,fcbsize,omask);
			signal(SIGTERM,SIG_IGN);
			signal(SIGPIPE,SIG_IGN);
			Kill(cpid,SIGTERM);
			wait(0);
		}
	}

	signal(SIGPIPE,opipe);
	signal(SIGTERM,oterm);
	signal(SIGTERM,ointr);
	sigsetmask(omask);
	return total;
}

static getServersWill(fromS,tc)
	FILE *tc;
{	int rcc;
	char scbuf[4096];

	if( PollIn(fromS,1000) ){
		rcc = readTIMEOUT(fromS,scbuf,sizeof(scbuf));
		sv1log("######## %d bytes from the server\n",rcc);
		rcc = scanCommands(StoC,scbuf,rcc);
		fwrite(scbuf,1,rcc,tc);
		fflush(tc);
	}
}

static putXdisplay(ts,display)
	FILE *ts;
	char *display;
{	char ibuf[128],ch;
	int ii,ij;
	int opt;

	if( ServersWill[O_XDISPLOC] != DO && ServersWill[O_ENVIRON] != DO )
		return 0;

	if( ServersWill[O_XDISPLOC] == DO )
		opt = O_XDISPLOC;
	else	opt = O_ENVIRON;

if( opt == O_ENVIRON )
	return 0;

	ii = 0;
	ibuf[ii++] = IAC; ibuf[ii++] = WILL; ibuf[ii++] = opt;
	ibuf[ii++] = IAC; ibuf[ii++] = SB;   ibuf[ii++] = opt;
	ibuf[ii++] = IS;
	if( opt == O_ENVIRON ){
		ibuf[ii++] = VAR;
		for( ij = 0; ch = "DISPLAY"[ij]; ij++ )
			ibuf[ii++] = ch;
		ibuf[ii++] = VALUE;
	}
	for( ij = 0; ch = display[ij]; ij++ )
		ibuf[ii++] = ch;
	ibuf[ii++] = IAC; ibuf[ii++] = SE;
	ii = scanCommands(DtoC,ibuf,ii);
	fwrite(ibuf,1,ii,ts);
	return 1;
}

static makeXproxy1(Conn,myname,peername)
	Connection *Conn;
	char *myname,*peername;
{	char me[256],myhp[256];
	int xpid;

/*
Socks can accept only one X connection ...

	if( Conn->sv_viaSocks ){
		char rhost[32];
		int rport,rsock;

		rsock = bindViaSocks(Conn,DST_HOST,DST_PORT,rhost,&rport);
		sv1log("#### sock=%d host=%s port=%d\n",rsock,rhost,rport);
		close(sock);
	}
*/

	ClientIF_HP(Conn,myhp);
	sprintf(me,"%s://%s/",DFLT_PROTO,myhp);
	xpid = makeXproxy(Conn,Xproxy,Xdisplay,myname,peername,me,0);
	sv1log("#### Xproxy[%d]: %s <- %s <- %s\n",
		xpid,Xdisplay,Xproxy,peername);
	return xpid;
}

extern char *gethostaddr();
static char *xhosts[64];
static setXhost(host,hosts)
	char *host,*hosts;
{	int xi,xj,rm;
	char *host1;
	
	rm = 0;
	if( *host == '+' )
		host++;
	else
	if( *host == '-' ){
		rm = 1;
		host++;
	}
	for( xi = 0; host1 = xhosts[xi]; xi++ ){
		if( streq(host1,host) )
			break;
	}
	if( rm ){
		if( host1 != NULL ){ /* found */
			free(host1);
			for( xj = xi; xhosts[xj] = xhosts[xj+1]; xi++){}
		}
	}else{
		if( host1 == NULL ){
			xhosts[xi] = strdup(host);
		}
	}
	hosts[0] = 0;
	for( xi = 0; host1 = xhosts[xi]; xi++ ){
		if( 0 < xi )
			strcat(hosts," ");
		strcat(hosts,host1);
	}
}

static proxy_telnet(Conn)
	Connection *Conn;
{	FILE *tc,*fc,*ts;
	char comline[256],cbuf[256];
	char command[256],hostport[256],serv[256],*addr,clnt[256];
	char auth[256],auser[256],ahost[256],*iuser;
	int port;
	int csize;
	int ns,ncom;

	tc = fdopen(ToC,"w");
	fc = fdopen(ToC,"r");

	Xpid = 0;
	Xdisplay[0] = 0;
	dump_commands |= C_S; /* to check WILL/WONT TERMTYPE ... */

	ncom = 0;
	for(ns = 0;;ns++){
		if( get_hostname(Conn,fc,tc,comline,cbuf,&csize,ncom) == EOF ){
			sv1log("EOF from the client\n");
			break;
		}
		ncom++;

		if( comline[0] == 0 ){
			sv1log("EMPTY line for QUIT\n");
			break;
		}

		command[0] = hostport[0] = 0;
		sscanf(comline,"%s %[^\r\n]",command,hostport);
		if( streq(command,"q") || streq(command,"quit") || streq(command,"exit") ){
			sv1log("[%s] command from the client\n",command);
			break;
		}else
		if( streq(command,"help") || streq(command,"?") ){
			putHELP(Conn,tc);
			fflush(tc);
			continue;
		}else
		if( streq(command,"x") || streq(command,"x-gw") ){
			char host[128];
			int port;

			sv1log("TIS compati. proxy-telnet with X-proxy\n");
			host[0] = 0;
			if( sscanf(hostport,"%[^:]:%d",host,&port) != 2 ){
				if( host[0] == 0 )
					getpeerNAME(FromC,hostport);
				strcat(hostport,":0");
				fprintf(tc,"####[regarded as] x-gw %s\r\n",hostport);
				fflush(tc);
			}
			strcpy(Xdisplay,hostport);
			continue;
		}else
		if( streq(command,"a") || streq(command,"accept") ){
			char myname[256];
			char hosts[1024];

			if( hostport[0] == 0 ){
				fprintf(tc,"???? Usage: accept hostname\r\n");
				fflush(tc);
				continue;
			}
			hostIFfor(hostport,myname);
			sv1log("myname = %s\n",myname);
			if( myname[0] == 0 ){
				fprintf(tc,"???? cannot find a route to %s\r\n",hostport);
				fflush(tc);
				continue;
			}

			/*setXhost(hostport,hosts);*/
			if( 0 < Xpid )
				Kill(Xpid,SIGTERM);

			Xpid = makeXproxy1(Conn,myname,hostport);
			fprintf(tc,"####[X-Proxy] accept host '%s'\r\n",hostport);
			fprintf(tc,"####[started] use DISPLAY '%s'\r\n",Xproxy);
			fflush(tc);
			continue;
		}else
		if( streq(command,"j") ){
			char stat[256];
			global_setCCX(Conn,hostport,stat);
			fprintf(tc,"-- charcode conversion [%s]%s\r\n",
				hostport,stat);
			fflush(tc);
			continue;
		}else
		if( streq(command,"t") || streq(command,"telnet")
		 || streq(command,"c") || streq(command,"connect") ){
			sv1log("TIS compati. proxy-telnet\n");
		}else{
			strcpy(hostport,comline);
		}
		serv[0] = 0;
		port = DFLT_PORT;
		sscanf(hostport,"%s %d",serv,&port);

		if( serv[0] == 0 ){
			sv1log("empty command for QUIT form the client\n");
			break;
		}

		auser[0] = ahost[0] = 0;
		if( doAUTH(Conn,fc,tc,"telnet",serv,port,auser,ahost,getline,NULL) == EOF )
			break;

		if( iuser = getClientHostPortUser(Conn,clnt,NULL) )
			sprintf(clnt+strlen(clnt),"(%s)",iuser);
		auth[0] = 0;
		if( auser[0] )
			sprintf(auth,"<%s@%s>",auser,ahost);

		sv1log("TELNET LOGIN FROM %s%s TO %s\n",clnt,auth,serv);
fputLog(Conn,"Login","TELNET; from=%s%s; to=%s\n",clnt,auth,serv);

		if( (addr = gethostaddr(serv)) == NULL )
			addr = "unknown host";

		fprintf(tc,"-- Trying %s [%s:%d] ...\r\n",
			serv,addr,DST_PORT);
		fflush(tc);

		ConnError = 0;
		if( connect_to_serv(Conn,FromC,ToC,0) < 0 ){
			cantConnMessage(Conn,serv,tc);
			fflush(tc);
		}else{
			ConnectedMessage(Conn,serv,tc,comline);
			clearServersWill();
			getServersWill(FromS,tc);

			ts = fdopen(dup(ToS),"w");
			if( csize ){
				Verbose("C-S %d bytes\n",csize);
				fwrite(cbuf,1,csize,ts);
				fflush(ts);
			}
			if( Xdisplay[0] ){
				char myname[256],peername[256];

				gethostNAME(ToS,myname);
				getpeerNAME(ToS,peername);
				Xpid = makeXproxy1(Conn,myname,peername);
			}
			if( toProxy ){
				sv1log("#### connected to Proxy telnet\n");
				/* fprintf(ts,"telnet %s\r\n",serv); */
				if( Xdisplay[0] ){
					fprintf(ts,"x-gw %s\r\n",Xproxy);
					fflush(ts);
				}
				fprintf(ts,"%s",comline);
			}else{
				if( Xdisplay[0] ){
					int set;

					set = putXdisplay(ts,Xproxy);
					fprintf(tc,"####[set %s] setenv DISPLAY %s\r\n\r\n",
						set?"automatically":"manually",Xproxy);
					fflush(tc);
				}
			}

			/* Some telnet client (at least SunOS's one)
			 * does not repeat WILL/WONT twice.
			 */
			relayClientsWills(ts);
			fclose(ts);
			bidirectional_relay(Conn,1024,1024);
			fprintf(tc,"\r\n");

			if( 0 < Xpid ){
				Kill(Xpid,SIGTERM);
				Xpid = 0;
			}
			ncom = 0;
		}
	}
	if( 0 < Xpid ){
		Kill(Xpid,SIGTERM);
		Xpid = 0;
	}
}

static AsServer(Conn)
	Connection *Conn;
{	FILE *fc,*tc,*fp;
	char uname[128],myhost[128];
	char user[128],pass[128];
	char ibuf[128];
	int ii;
	char line[1024],*dp,com[128],*arg,pwd[1024];

	ClientIF_name(Conn,fileno(fc),myhost);
	Uname(uname);

	fc = fdopen(FromC,"r");
	tc = fdopen(ToC,"w");
	fputs("\r\n",tc);
	fprintf(tc,"%s (%s) Telnet-%s\r\n",uname,myhost,DELEGATE_version());
	fputs("\r\n",tc);

	ii = 0;
	ibuf[ii++] = IAC; ibuf[ii++] = WONT; ibuf[ii++] = O_ECHO;
	ibuf[ii++] = IAC; ibuf[ii++] = DO;   ibuf[ii++] = O_ECHO;
	fwrite(ibuf,1,ii,tc);
	fflush(tc);
	scanCommands(DtoC,ibuf,ii);
	ii = read(fileno(fc),line,sizeof(line));
	scanCommands(CtoD,ibuf,ii);

	fputs("UserName: ",tc);
	fflush(tc);
	if( fgets(line,sizeof(line),fc) == NULL )
		goto EXIT;
	lineScan(line,user);
	sv1log("USER: %s\n",user);

	ii = 0;
	ibuf[ii++] = IAC; ibuf[ii++] = WILL; ibuf[ii++] = O_ECHO;
	ibuf[ii++] = IAC; ibuf[ii++] = DONT; ibuf[ii++] = O_ECHO;
	fwrite(ibuf,1,ii,tc);
	fflush(tc);
	scanCommands(DtoC,ibuf,ii);
	ii = read(fileno(fc),line,sizeof(line));
	scanCommands(CtoD,ibuf,ii);

	fputs("PassWord: ",tc);
	fflush(tc);
	if( fgets(line,sizeof(line),fc) == NULL )
		goto EXIT;
	fputs("\r\n",tc);
	lineScan(line,pass);
	if( Authenticate(Conn,"localhost",user,pass,"/") < 0 )
		goto EXIT;

	ii = 0;
	ibuf[ii++] = IAC; ibuf[ii++] = WONT; ibuf[ii++] = O_ECHO;
	ibuf[ii++] = IAC; ibuf[ii++] = DO;   ibuf[ii++] = O_ECHO;
	fwrite(ibuf,1,ii,tc);
	fflush(tc);
	scanCommands(DtoC,ibuf,ii);
	ii = read(fileno(fc),line,sizeof(line));
	scanCommands(CtoD,ibuf,ii);

	for(;;){
		getcwd(pwd,sizeof(pwd));
		fprintf(tc,"%s> ",pwd);
		fflush(tc);

		if( fgets(line,sizeof(line),fc) == NULL )
			break;
		sv1log("%s> %s",pwd,line);
		if( dp = strpbrk(line,"\r\n") )
			*dp = 0;
		arg = wordScan(line,com);
		while( *arg == ' ' || *arg == '\t' )
			arg++;
		if( strcmp(com,"cd") == 0 || strcmp(com,"chdir") == 0 ){
			chdir(arg);
			continue;
		}
		if( strcmp(com,"exit") == 0 || strcmp(com,"quit") == 0 )
			break;

		fp = popen(line,"r");
		while( fgets(line,sizeof(line),fp) != NULL ){
			if( dp = strpbrk(line,"\r\n") )
				*dp = 0;
			fputs(line,tc);
			fputs("\r\n",tc);
		}

		fflush(tc);
		pclose(fp);
	}
EXIT:
	fclose(tc);
	fclose(fc);
}

service_telnet(Conn)
	Connection *Conn;
{
	if( LOG_VERBOSE )
		dump_commands = C_S | S_C;

	if( BORN_SPECIALIST )
	if( strcmp(iSERVER_PROTO,"telnet") == 0 )
	if( strcmp(DFLT_HOST,"-.-") == 0 ){
		AsServer(Conn);
		return;
	}
	if( isMYSELF(DFLT_HOST) ){
		ImProxy = 1;
		return proxy_telnet(Conn);
	}

	if( ToC < 0 || ToS < 0 )
		return;

	/* Telnet clients may not start any negotiation when the
	 * target port is not the standard telnet port, because the server
	 * could be a non telnet server.  Telnet relay server is normally
	 * bound to non standard telnet port, thus initiating Telnet
	 * negotiation in the relay will be helpful for clients to notice
	 * that he is connected with telnet server.
	 */
	{	char buf[3];
		buf[0] = IAC; buf[1] = WILL; buf[2] = O_SUPAHEAD;
		write(ToC,buf,3);
		scanCommands(DtoC,buf,3);
	}
	return bidirectional_relay(Conn,0x2000,0x2000);
}


/*
 *	parse and rewrite telnet protocol
 */

#define EOA		0x100
#define START		0x101
#define LOOP		0x102
#define STR		0x103
#define RW_TERM		0x104
#define RW_XDISPLOC	0x105
#define RW_ENVIRON	0x106

static short Trans[][32] = {
 { IAC, SB, O_ENVIRON,  IS, START, VALUE, STR, VAR, STR, RW_ENVIRON, LOOP },
 { IAC, SB, O_TERMTYPE, IS, START, STR, RW_TERM,    EOA },
 { IAC, SB, O_XDISPLOC, IS, START, STR, RW_XDISPLOC, EOA },
 0
};

static getString(buf,cc,c0,str)
	unsigned char *buf,*str;
{	int ci,ch,si;

	si = 0;
	for(ci = c0; ci < cc; ci++ ){
		ch = str[si++] = buf[ci];
		if( ch < ' ' || 0x7F < ch )
			break;
	}
	str[si] = 0;
	return ci;
}
static removeString(buf,cc,from,to)
	char *buf;
{	int len,ci;

	len = to - from;
	for( ci = from; ci < cc; ci++ )
		buf[ci] = buf[ci+len];
	return -len;
}
static replaceString(buf,cc,from,to,new)
	char *buf,*new;
{	int len,nlen,inc;
	int ci;

	len = to - from;
	nlen = strlen(new);
	inc = nlen - len;

	if( 0 < inc )
		for( ci = cc-1; to <= ci; ci-- ) buf[ci+inc] = buf[ci];
	else	for( ci = to;   ci <  cc; ci++ ) buf[ci+inc] = buf[ci];
	for( ci = 0; ci < nlen; ci++ )
		buf[from+ci] = new[ci];
	return inc;
}

rewriteTelnet(direction,buf,cc)
	unsigned char *buf;
{	int si,sji,sjp;
	int chi,chp;
	short *sb1;
	int inc = 0,inc1;
	char str[4][2048];
	int strx,start_sjp,start_sji;

	for( si = 0; ; si++ ){
	    sb1 = Trans[si];
	    if( sb1[0] == 0 )
		break;

	    sji = 0;
	    strx = 0;
	    for( sjp = 0;; sjp++ ){
	        chp = sb1[sjp];
		chi = buf[sji];

		switch( chp ){
		  case EOA:
			goto NEXTALT;

		  case START:
			strx = 0;
			start_sji = sji;
			start_sjp = sjp;
			break;

		  case LOOP:
			sjp = start_sjp -1;
			break;

		  case STR:
			sji = getString(buf,cc,sji,str[strx]);
			strx++;
			break;

		  case RW_XDISPLOC:
			if( direction == CtoS )
			if( Xproxy[0] && !streq(Xproxy,str[0]) ){
				sv1log("DISPLAY [%s] -> [%s]\n",str[0],Xproxy);
				inc1 = replaceString(buf,cc,start_sji,sji,
					Xproxy);
				inc += inc1;
				sji += inc1;
			}
			break;

		  case RW_ENVIRON:
			sv1log("ENVIRON [%s=%s]\n",str[0],str[1]);

			if( streq(str[0],"DISPLAY") )
			if( direction == CtoS )
			if( Xproxy[0] && !streq(Xproxy,str[1]) ){
				inc1 = replaceString(buf,cc,start_sji,sji,
					Xproxy);
				inc += inc1;
				sji += inc1;
			}
			break;

		  default:
			if( chp != chi )
				goto NEXTALT;
			sji++;
		}
	    } NEXTALT:;
	}
	return inc;
}
