/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	sopen.c (socket to/from I/O)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	940730	created
//////////////////////////////////////////////////////////////////////#*/
#define SH	"/bin/sh"
#include "delegate.h"

static sv1log(fmt,a,b,c,d,e,f,g)
	char *fmt,*a,*b,*c,*d,*e,*f,*g;
{	char out[4096];

/*
	sprintf(out,fmt,a,b,c,d,e,f,g);
	fprintf(stderr,"[%d][%d] %s",getpid(),strlen(out),out);
	fflush(stderr);
*/
}

sdopen(in,out)
{	int sv[2];

	Socketpair(sv);
	if( Fork("sdopen") == 0 ){
		close(sv[1]);
/*
		sio_relay(sv[0],in,out,1,0);
*/
		sio_relay(sv[0],in,out,1,1);
		Finish(0);
	}else{
		close(sv[0]);
		return sv[1];
	}
}

extern char **environ;
sspopen(command,envp)
	char *command;
	char *envp[];
{	int ssv[2],csv[2];
	int fd;
	char *xenv[256];
	int et,ei;

	et = 0;
	for( ei = 0; environ[ei]; ei++ )
		xenv[et++] = environ[ei];
	for( ei = 0; envp[ei]; ei++ )
		xenv[et++] = envp[ei];
	xenv[et] = 0;

	Socketpair(ssv);
	if( Fork("ssopen") == 0 ){
		close(ssv[1]);

		Socketpair(csv);
		if( Fork("sspopen") == 0 ){
			/*close(csv[1]);*/
			dup2(csv[0],0);
			dup2(csv[0],1);

			for( fd = 3; fd < 32; fd++ )
				close(fd);

			execle(SH,"sh","-c",command,0,xenv);
		}else{
			/*close(csv[0]);*/
			CallSrelay(ssv[0],csv[1],csv[1],1,1);
		}
		Finish(0);
	}
	close(ssv[0]);
	return ssv[1];
}

sfopen(func,arg)
	int (*func)();
	char *arg;
{	int ssv[2],csv[2];

	Socketpair(ssv);
	if( Fork("sfopen") == 0 ){
		close(ssv[1]);
		Socketpair(csv);

		if( Fork("sfopen") == 0 ){
			close(ssv[0]);
			close(csv[1]);
			dup2(csv[0],0);
			dup2(csv[0],1);
			(*func)(arg);
		}else{
			close(csv[0]);
			CallSrelay(ssv[0],csv[1],csv[1],1,1);
		}
		Finish(0);
	}
	close(ssv[0]);
	return ssv[1];
}

spopen(command,envp)
	char *command;
	char *envp[];
{	int ssv[2];
	int toc[2],fromc[2];
	int fd;
	char *xenv[256];
	int et,ei;

	Socketpair(ssv);
	if( Fork("spopen") == 0 ){
		close(ssv[1]);
		pipe(toc);
		pipe(fromc);

		if( Fork("spopen") == 0 ){
			close(ssv[0]);
			dup2(toc[0],0);   close(toc[0]);   close(toc[1]);
			dup2(fromc[1],1); close(fromc[0]); close(fromc[1]);

			for( fd = 3; fd < 32; fd++ )
				close(fd);

			et = 0;
			for( ei = 0; environ[ei]; ei++ )
				xenv[et++] = environ[ei];

			if( envp )
			for( ei = 0; envp[ei]; ei++ )
				xenv[et++] = envp[ei];
			xenv[et] = 0;

			if( envp )
				execle(SH,"sh","-c",command,0,xenv);
			else	system(command);
			Finish(0);
		}else{
			close(toc[0]);
			close(fromc[1]);
			CallSrelay(ssv[0],fromc[0],toc[1],1,1);
			Finish(0);
		}
	}else{
		close(ssv[0]);
		return ssv[1];
	}
}

#include <string.h>
#include <signal.h>

/*
sio_relay(sock,in,out,flushsock,flushout)
{	int rc;
	char buf[512];

	if( Fork("sio_relay") == 0 ){
		while( 0 < (rc = read(in,buf,sizeof(buf))) )
			write(sock,buf,rc);
		Kill(getppid(),SIGTERM);
	}else{
		while( 0 < (rc = read(sock,buf,sizeof(buf))) )
			write(out,buf,rc);
	}
}
*/

#define PACKSIZE 120 /* must smaller than 256 when encoded to pass through a unix tty */

char *isEOFSTR(str,len)
	char *str;
{	int si;
	char *sp;

	for( si = len-1; 0 < si; si-- )
		if( str[si] != '\r' && str[si] != '\n' )
			break;
	if( 3 <= si )
	if( str[si+1] == '\r' || str[si+1] == '\n' )
	{
		sp = str+si-3;
		if( strncmp(sp,"->|@",4) == 0 )
			return sp;
	}
	return 0;
}
sio_relay(sock,in,out,flushsock,flushout)
{	FILE *Sock,*In,*Out;
	int rc,wc;
	char line[512],ibuf[PACKSIZE],obuf[512];
	int slen,len;
	char *eofp,eofc;
	int eofl;

	if( Fork("sio_relay") == 0 ){
		In = fdopen(in,"r");


		Sock = fdopen(sock,"w");

		while( fgets(line,sizeof(line),In) != NULL ){
			slen = strlen(line);
			if( eofp = isEOFSTR(line,slen) ){
				eofl = strlen(eofp);
				eofc = *eofp;
				*eofp = 0;
				len = decode7(line,obuf);
				fwrite(line,1,len,Sock);
				fflush(Sock);

				*eofp = eofc;
				fwrite(eofp,1,eofl,Sock);
				fflush(Sock);
				continue;
			}else	len = decode7(line,obuf);

			wc = fwriteTIMEOUT(obuf,1,len,Sock);
			if( flushsock )
				fflush(Sock);
		}
		fflush(Sock);
		Kill(getppid(),SIGTERM);
	}else{
		Out = fdopen(out,"w");
		while( 0 < (rc = read(sock,ibuf,sizeof(ibuf))) ){
			len = encode7(ibuf,line,rc,sizeof(line));
			sv1log("S>O %s\n",ibuf);
			fwriteTIMEOUT(line,1,len,Out);
			if( flushout || isEOFSTR(ibuf,rc) )
				fflush(Out);
		}
	}
}
