/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1996-1999 Yutaka Sato
Copyright (c) 1996-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	socks4.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	960219	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
extern char *gethostbyAddr();
extern char *gethostaddr();
extern int IO_TIMEOUT;
extern int CON_TIMEOUT;
extern int ACC_TIMEOUT;

#define SOCKS_VERSION	4
#define SOCKS_CONNECT	1
#define SOCKS_BIND	2
#define SOCKS_ACCEPT	8	/* pseudo command */
#define SOCKS_RESULT	90
#define SOCKS_FAIL	91
#define SOCKS_NO_IDENTD	92
#define SOCKS_BAD_ID	93

static char *scommand(command)
{
	switch(command){
		case SOCKS_CONNECT:	return "CONNECT";
		case SOCKS_BIND:	return "BIND";
		case SOCKS_ACCEPT:	return "ACCEPT";
		default:		return "BAD-COM";
	}
}

SocksV4_isConnectReuqest(pack,leng,ver,addr,port,user)
	unsigned char *pack;
	int *ver;
	char *addr;
	int *port;
	unsigned char **user;
{
	if( pack[0] == 4 )
	if( pack[1] == SOCKS_CONNECT ){
		*ver = 4;
		*port = pack[2] << 8 | pack[3];
		sprintf(addr,"%d.%d.%d.%d",pack[4],pack[5],pack[6],pack[7]);
		*user = &pack[8];
		return 8 + strlen(*user) + 1;
	}
	return 0;
}

static makePacket(obuf,version,command,host,port,user)
	char *obuf,*host,*user;
{	char *addr;
	int av[4][1];
	int pc;
	
	addr = gethostaddr(host);
	if( addr == NULL ){
		sv1log("Don't try Socks for unknown host\n");
		return -1;
	}

	if( command == SOCKS_CONNECT && strcmp(addr,"0.0.0.0") == 0 )
		return -1;
	if( sscanf(addr,"%d.%d.%d.%d",av[0],av[1],av[2],av[3]) != 4 )
		return -1;

	obuf[0] = version;
	obuf[1] = command;

	obuf[2] = port >> 8;
	obuf[3] = port;

	obuf[4] = av[0][0];
	obuf[5] = av[1][0];
	obuf[6] = av[2][0];
	obuf[7] = av[3][0];

	strcpy(obuf+8,user);
	pc = 8 + strlen(user) + 1;

	return pc;
}
static char *getAddrPart(pack,addr)
	unsigned char *pack;
	char *addr;
{
	sprintf(addr,"%d.%d.%d.%d",pack[4],pack[5],pack[6],pack[7]);
	return addr;
}

/*
 *	SOCKS SERVER
 */
SocksV4_server(ctx,_1,_2,fromC,toC)
	void *ctx;
{	FILE *fc;
	unsigned char ibuf[16],obuf[16];
	int pc,ver,com,ch;
	int ux,dstport;
	char dstaddr[64],host[512],user[512];
	char local[512],remote[512],ahost[64],bhost[64];
	int aport,bport,asock,bsock,csock,nready,socks[2],readyv[2];

	fc = fdopen(fromC,"r");
	setbuf(fc,NULL);
	pc = fread(ibuf,8,1,fc);
	if( pc <= 0 )
		return;
	ver = ibuf[0];
	com = ibuf[1];
	dstport = (ibuf[2] << 8) | ibuf[3];
	sprintf(dstaddr,"%d.%d.%d.%d",ibuf[4],ibuf[5],ibuf[6],ibuf[7]);
	gethostbyAddr(dstaddr,host);

	if( com != SOCKS_CONNECT && com != SOCKS_BIND ){
		syslog_ERROR("#### ERROR: NON SOCKS CLIENT ?[%d]\n",com);
		return;
	}

	ux = 0;
	for( ux = 0; ; ux++ ){
		if( sizeof(user)-1 <= ux )
			return;
		ch = fgetc(fc);
		if( ch == EOF )
			return;
		if( ch == 0 )
			break;
		user[ux] = ch;
	}
	user[ux] = 0;

sv1log("[SocksV4-serv] %d ver[%d] com[%d/%s] port[%d] host[%s][%s] user[%s]\n",
		pc,ver,com,scommand(com),dstport,dstaddr,host,user);

	set_realserver(ctx,"tcprelay",dstaddr,dstport);
	if( !service_permitted(ctx,"tcprelay") )
		goto failed;

	strcpy(local,"*:*");
	sprintf(remote,"%s:%d",dstaddr,dstport);
	if( com == SOCKS_BIND ){
		if( GetViaSocks(ctx,dstaddr,dstport) ){
			sv1log("#### MUST DO bindViaSocks... %s:%d\n",
				dstaddr,dstport);
		}
		bsock = VSocket(ctx,"BIND/SocksV4",-1,local,remote,"listen=1");
		if( bsock < 0 )
			goto failed;
		bport = scan_hostport1(local,bhost);
		makePacket(obuf,SOCKS_VERSION,SOCKS_RESULT,bhost,bport,"");
		write(toC,obuf,8);

		socks[0] = fromC;
		socks[1] = bsock;
		nready = PollIns(ACC_TIMEOUT*1000,2,socks,readyv);
		if( nready <= 0 || readyv[1] <= 0 ){
			close(bsock);
			goto failed;
		}

		asock = VSocket(ctx,"ACPT/SocksV4",bsock,local,remote,"");
		close(bsock);
		aport = scan_hostport1(local,ahost);
		makePacket(obuf,SOCKS_VERSION,SOCKS_RESULT,ahost,aport,"");
		write(toC,obuf,8);
		tcp_relay2(IO_TIMEOUT*1000,fromC,asock,asock,toC);
		close(asock);
	}else{
		csock = VSocket(ctx,"CNCT/SocksV4",-1,local,remote,"");
		if( csock < 0 )
			goto failed;
		bport = scan_hostport1(local,bhost);
		makePacket(obuf,SOCKS_VERSION,SOCKS_RESULT,bhost,bport,"");
		write(toC,obuf,8);
		tcp_relay2(IO_TIMEOUT*1000,fromC,csock,csock,toC);
		close(csock);
	}
	return;

failed:
	makePacket(obuf,SOCKS_VERSION,SOCKS_FAIL,dstaddr,dstport,"");
	write(toC,obuf,8);
}

/*
 *	SOCKS CLIENT
 */
static getResponse(sock,command,rhost,rport)
	unsigned char *rhost;
	int *rport;
{	FILE *fs;
	unsigned char ibuf[128];
	int pc;

	if( PollIn(sock,CON_TIMEOUT*1000) <= 0 ){
		sv1log("SOCKS response TIMEOUT (%d)\n",CON_TIMEOUT);
		return SOCKS_FAIL;
	}
	pc = readsTO(sock,ibuf,8,CON_TIMEOUT*1000);

	sv1log("[SocksV4-clnt] %s %d ver[%d] stat[%d] host[%d.%d.%d.%d]:%d\n",
		scommand(command),
		pc,
		ibuf[0],ibuf[1],
		ibuf[4],ibuf[5],ibuf[6],ibuf[7],
		ibuf[2]<<8|ibuf[3]);

	if( rhost != NULL )
		sprintf(rhost,"%d.%d.%d.%d",ibuf[4],ibuf[5],ibuf[6],ibuf[7]);
		/* it can be "0.0.0.0" for BIND when the Socks server did
		 * bind() with wild-card address.  If it is necessary
		 * (ex. for PORT/FTP) it must be got from the response for
		 * CONNECT command (for control connection).
		 */


	if( rport != NULL )
		*rport = (ibuf[2] << 8) | ibuf[3];

	return ibuf[1];
}
SocksV4_clientStart(sock,command,host,port,user,rhost,rport,xaddr)
	char *host,*user,*rhost;
	int *rport;
	char *xaddr;
{	unsigned char obuf[128],i,*ap;
	int pc,wcc,rep;

	pc = makePacket(obuf,SOCKS_VERSION,command,host,port,user);
	if( pc < 0 )
		return -1;

	wcc = write(sock,obuf,pc);
	rep = getResponse(sock,command,rhost,rport);

	if( rep == SOCKS_RESULT ){
		if( command == SOCKS_CONNECT && xaddr != NULL )
		{
			getAddrPart(obuf,xaddr);
		}
		return 0;
	}else	return -1;
}
SocksV4_acceptViaSocks(sock,rhost,rport)
	char *rhost;
	int *rport;
{	int rep;

	rep = getResponse(sock,SOCKS_ACCEPT,rhost,rport);
	if( rep == SOCKS_RESULT )
		return 0;
	else	return -1;
}
