/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1997 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	pgps.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	970208	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
extern FILE *TMPFILE();
#include "delegate.h"
#include "ystring.h"
extern FILE *PGPcodec();

extern int PGP_ENCODE;
extern int PGP_DECODE;

service_pgps(Conn)
	Connection *Conn;
{	FILE *fc,*tc;
	char req[1024],com[1024],arg[1024],*wp;
	char pass[1024];
	char me[1024];

	fc = fdopen(FromC,"r");
	tc = fdopen(ToC,"w");
	sprintf(me,"PGP server on DeleGate/%s",DELEGATE_ver());

	if( PollIn(FromC,1000) <= 0 ){
		fprintf(tc,"+OK %s ready.\r\n",me);
		fflush(tc);
	}
	pass[0] = 0;

	for(;;){
		fgets(req,sizeof(req),fc);
		wp = wordScan(req,com);
		lineScan(wp,arg);

		if( strcaseeq(com,"QUIT") ){
			fprintf(tc,"+OK bye\r\n");
			fflush(tc);
			break;
		}
		if( strcaseeq(com,"HELP") ){
			fprintf(tc,"+OK Usage of %s\r\n",me);
			fprintf(tc,"  PASS pass-phrase ... set pass-phrase\r\n");
			fprintf(tc,"  SIGN ... sign following message\r\n");
			fprintf(tc,"  ENCR ... encrypt following message\r\n");
			fprintf(tc,"  VRFY ... verify following message\r\n");
			fprintf(tc,"  DECR ... decrypt following message\r\n");
/*
fprintf(tc,"  ADDKEY URL ... add public key getting it from URL\r\n");
*/
			fprintf(tc,"  QUIT ... end the session\r\n");
			fprintf(tc,"  HELP ... this message\r\n");
			fprintf(tc,"  GET ... control via HTTP\r\n");
			fprintf(tc,"  POST ... post via HTTP\r\n");
			fprintf(tc,".\r\n");
		}else
		if( strcaseeq(com,"PASS") ){
			strcpy(pass,arg);
			if( pass[0] == 0 )
				fprintf(tc,"-ERR [PASS} empty pass phrase\r\n");
			else	fprintf(tc,"+OK [PASS] set\r\n");
		}else
		if( strcaseeq(com,"SIGN") ){
			PGPcodecSV(fc,tc,com,pass);
		}else
		if( strcaseeq(com,"ENCR") ){
			PGPcodecSV(fc,tc,com,pass);
		}else
		if( strcaseeq(com,"DECR") ){
			PGPcodecSV(fc,tc,com,pass);
		}else
		if( strcaseeq(com,"GET") ){
			respGET(tc);
			fflush(tc);
			break;
		}else{
			fprintf(tc,"-ERR [%s] Unknown command\r\n",com);
		}
		fflush(tc);
	}
}

PGPcodecSV(fc,tc,com,pass)
	FILE *fc,*tc;
	char *com;
	char *pass;
{	FILE *out;
	char EOR[1024];

	fprintf(tc,"+OK enter data ending with \".\" on a line by itself\r\n");
	fflush(tc);

	out = PGPcodec(fc,com,pass,EOR);

	fprintf(tc,"+OK [%s] Converted data follows ending with \".\"\r\n",com);
	copyfile1(out,tc);
	fprintf(tc,".\r\n");
	fclose(out);
}

static respGET(tc)
	FILE *tc;
{
	fprintf(tc,"HTTP/1.0 200 OK\r\n");
	fprintf(tc,"Content-Type: text/html\r\n");
	fprintf(tc,"Server: DeleGate/%s\r\n",DELEGATE_ver());
	fprintf(tc,"\r\n");
	fprintf(tc,"<TITLE>PGP Server</TITLE>\r\n");
	fprintf(tc,"<H2>PGP Server</H2>\r\n");
}
