/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1999 Yutaka Sato
Copyright (c) 1994-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	gopher.c (GOPHER [RFC1XXX] proxy)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
	The DeleGate for the Gopher+ protocol rewrites selectors in reponses
	of:
		1. request for directory type
		2. request for search type
		3. request for any type with INFO requset(postfixed with "!")
History:
	940303	created
//////////////////////////////////////////////////////////////////////#*/
#include "delegate.h"
#include "http.h" /* putHttpHeader */

extern char *fgetsTIMEOUT();
extern char *DDI_fgetsFromC();
extern char *Sprintf();

extern FILE *cache_fopen_rd();
extern FILE *cache_fopen_rw();

#define SELSZ	2048
#define OBUFSIZ	0x2000	/* should be smaller than 0x10000 for NEWS-OS */

#define IS_TEXT(gtype)		(gtype=='0')
#define IS_DIR(gtype)		(gtype=='1')
#define IS_SEARCH(gtype)	(gtype=='7')

proxyable_gtype(gtype)
{
	return !strchr("38T",gtype);
}

static is_INFO(req)
	char *req;
{	char *tab;

	if( strlen(req) )
	if( tab = strrchr(req,'\t') )
		return tab[1] == '!';
	return 0;
}
static is_DIR(req)
	char *req;
{	char *dp;

	if( dp = strpbrk(req,"\t\r\n") )
		if( dp[-1] == '/' )
			return 1;
	return 0;
}

/*
 *	Put Directory Entity redirecting it to me.
 */
static gopher_fputs(Conn,rgtype,request,line,fp)
	Connection *Conn;
	char *request;
	char *line;
	FILE *fp;
{	char bline[2048];
	char iline[2048];
	char egtype;

	strcpy(bline,line);
	line = bline;
	egtype = *line;

	if( BORN_SPECIALIST || ACT_SPECIALIST )
	if(IS_DIR(rgtype)||is_DIR(request)||IS_SEARCH(rgtype)||is_INFO(request))
	if( egtype != '.' && egtype != '-' && egtype != ' '
	 && egtype != '8' && egtype != 'T'
	){
		char xline[2048];
		char attr[256];
		char *Uname;
		char *selector;
		char *host;
		int   iport;
		char *ext;
		char xselector[SELSZ];
		char myhost[SELSZ];
		int  myport;

		strcpy(xline,line);
		egtype = decomp_dirent(xline,attr,
			&Uname,&selector,&host,&iport,&ext);
		if( egtype == 0 )
			goto PUT;

		strcpy(xselector,selector);
		if( proxyable_gtype(egtype) )
			delegate_selector(xselector,host,iport,egtype);

		if( ACT_SPECIALIST && !META_SPECIALIST ){
			strcpy(myhost,DELEGATE_LHOST);
			myport = DELEGATE_LPORT;
		}else	myport = ClientIF_H(Conn,myhost);

		sprintf(line,"%s%c%s\t%s\t%s\t%d%s",
			attr,egtype,Uname,xselector,myhost,myport,ext);
	}
PUT:
	if( BORN_SPECIALIST || ACT_SPECIALIST || ACT_TRANSLATOR )
	if( cur_codeconvCL(NULL) ){
		line_codeconv(line,iline,"x-gopher/dirent");
		line = iline;
	}
	return fputs(line,fp);
}

gopher_filter(ac,av,Conn)
	char *av[];
	Connection *Conn;
{	char line[2048];

	BORN_SPECIALIST = 1;
	while( fgetsTIMEOUT(line,sizeof(line),stdin) )
		gopher_fputs(Conn,'1',"1",line,stdout);
}

static Modified(Conn,cdate,req)
	Connection *Conn;
	char *req;
{	static Connection *MConn;
	char sel[SELSZ];
	FILE *fs;
	char line[1024],mdate[256],scdate[256];
	int modified;

	if( MConn == 0 )
		MConn = (Connection*)calloc(sizeof(Connection),1);
	*MConn = *Conn;
	Conn = MConn;
	if( connect_to_serv(Conn,FromC,ToC,0) < 0 )
		return 0;

	sscanf(req,"%[^\t\r\n]",sel);
	sprintf(sel+strlen(sel),"\t!\r\n\r\n");
	write(ToS,sel,strlen(sel));

	fs = fdopen(FromS,"r");

	StrftimeGMT(scdate,sizeof(scdate),TIMEFORM_GOPHER,cdate);
	modified = 1;
	while( fgetsTIMEOUT(line,sizeof(line),fs) != NULL ){
		if( strncasecmp(" Mod-Date:",line,9) == 0 ){
			sv1log("Mod-Date: %s\n",line);
			if( sscanf(line,"%*[^<]<%[^>]",mdate) ){
				modified = (0 < strcmp(mdate,scdate));
				sv1log("Mod-Date: %s > %s = %d\n",
					mdate,scdate,modified);
				if( modified )
					sv1log("Modified\n");
				else	sv1log("NOT Modified\n");
			}
			break;
		}
		if( streq(line,".\r\n") )
			break;
	}
	fclose(fs);
	close(ToS);
	return modified;
}

static readout_cache(Conn,req,gtype,cachefp,tc)
	Connection *Conn;
	char *req;
	FILE *cachefp,*tc;
{	char line[2048];
	int totalc = 0;

	rewind(cachefp);
	if( IS_DIR(gtype) || is_DIR(req) || IS_SEARCH(gtype) || is_INFO(req) ){
		check_codeconvSP(Conn,1);
		while( fgetsTIMEOUT(line,sizeof(line),cachefp) ){
			totalc += strlen(line);
			gopher_fputs(Conn,gtype,req,line,tc);
		}
	}else
	if( IS_TEXT(gtype) )
		totalc = CCV_relay_text(Conn,cachefp,tc,NULL);
	else	totalc = copy_fileTIMEOUT(cachefp,tc,NULL);
	fflush(tc);
	return totalc;
}

static fgets_selector(Conn,str,size,fp)
	Connection *Conn;
	char *str;
	FILE *fp;
{	char gtype,cgtype;
	char rproto[64];
	char rserver[256];
	int riport;

	if( DDI_fgetsFromC(Conn,str,size,fp) == NULL )
		return 0;

	sv1log("GOPHER SELECTOR: %s",str);

	if( *str == 0 || strchr(" \t\r\n",*str) != 0 )
	if( D_SELECTOR[0] ){
		char tmp[128];

		strcpy(tmp,str);
		sprintf(str,"%s%s",D_SELECTOR,tmp);
		sv1log("GOPHER SELECTOR: %s",str);
	}

/*	if( BORN_SPECIALIST ) */
	if( BORN_SPECIALIST || ACT_SPECIALIST )
	if( CTX_url_derefer(Conn,"gopher",str,NULL,DELEGATE_FLAGS,rproto,rserver,&riport) ){

/* if rproto != "gopher" then it's ERROR because gopher client cannot
 * receive response from non-gopher server */

set_realsite(Conn,"gopher",rserver,riport);

/* obsolete, but used in connect_to_serv() ... */
strcpy(DFLT_PROTO,rproto);
strcpy(DFLT_HOST,rserver);
DFLT_PORT = riport;

		add_DGheader(Conn,D_SERVER,"%s://%s:%d",rproto,rserver,riport);
		log_PATH(Conn,">");
		sv1log("GOPHER REMOTE > [%s] %s://%s:%d %s",
			DELEGATE_FLAGS,rproto,rserver,riport,str);
	}

	gtype = get_gtype(str,str);
	if( cgtype = CTX_get_clientgtype(Conn) ) /* sent from client */
		gtype = cgtype;
	else	CTX_set_clientgtype(Conn,gtype);
	add_DGinputs(Conn,"%s",str);
	return gtype;
}

static cache_Path(host,iport,gtype,req,path)
	char *host,*req,*path;
{	char selector[2048];
	char *cache_dir;
	char cachefile[2048];
	char ext[256];
	char *rp;
	char *dp;
	char *cp;

	*path = 0;
	strcpy(selector,"?");

	if( (cache_dir = cachedir()) == 0 )
		return 0;

	cp = Sprintf(cachefile,"%s/%s/%s",cache_dir,"gopher",host);
	if( iport != serviceport("gopher") )
		cp = Sprintf(cp,":%d",iport);

	selector[0] = ext[0] = 0;
	sscanf(req,"%*c/%[^\r\n\t]\t%[^\r\n\t]",selector,ext);

	if( selector[0] == 0 ){
		sv1log("empty selector, request = %s",req);
		rp = req;
		if( *rp == '/' )
			rp++;

		if( IS_DIR(gtype) && strchr("\r\n\t",rp[0]) )
			;
		else	return 0;
	}

	if( IS_DIR(gtype) ){
		if( selector[0] )
			cp = Sprintf(cp,"/%s/",selector);
		else	cp = Sprintf(cp,"/");

		if( dp = strchr(req,'\t') ){
			strcpy(ext,"?");
			sscanf(dp+1,"%[^\r\n\t ]",ext);
			strcat(cp,ext);
		}else	strcat(cp,"=");

		strcpy(path,cachefile);
		return 1;
	}
	if( gtype && strchr(GOPHER_CACHE_ITEM,gtype) ){
		Sprintf(cp,"/%s%s",selector,ext);
		strcpy(path,cachefile);
		return 1;
	}
	return 0;
}

static relay_response();
service_gopher(Conn)
	Connection *Conn;
{	FILE *fc,*tc,*fs;
	FILE *cachefp;
	char gtype,req[2048];
	char line[0x10000];
	char o_buff[OBUFSIZ];
	char c_buff[OBUFSIZ];
	char *server = DFLT_HOST;
	int iport = DFLT_PORT;
	int useCache;
	char cpath[2048];
	int cdate;
	int totalc;

	fc = fdopen(FromC,"r");
	if( fc == NULL )
		Exit(-1,"fdopen(FromC=%d) failed\n",FromC);
	setbuf(fc,NULL);

	tc = fdopen(ToC,"w");
	if( tc == 0 )
		Exit(-1,"fdopen(ToC=%d) failed\n",ToC);
	setbuffer(tc,o_buff,sizeof(o_buff));

	if( (gtype = fgets_selector(Conn,req,sizeof(req),fc)) == 0 ){
		sv1log("GOPHER null REQUEST ?\n");
		return;
	}

	if( !service_permitted(Conn,"gopher",FromC) ){
		char myhp[256];

		ClientIF_HP(Conn,myhp);
		fprintf(tc,"--1\r\n");
		fprintf(tc,"1 Forbidden by DeleGate on `%s'.\r\n",myhp);
		fprintf(tc,"0 Proxy Gopher Server %s\r\n",DELEGATE_version());
		fprintf(tc,".\r\n");
		fcloseLinger(tc);
		fclose(fc);
		return;
	}

cpath[0] = 0;
	setupConnect(Conn);
	if( without_cache() )
		useCache = 0;
	else	useCache = cache_Path(server,iport,gtype,req,cpath);
	cachefp = NULL;
	cdate = -1;

/* 941010 if( useCache && !BORN_SPECIALIST ){ */
	if( useCache ){
		int cretry = 0;
		int expire = gopher_EXPIRE(Conn,server);
		int dontWaitCache = DontWaitCache;
		set_DG_EXPIRE(Conn,expire);

	retry_read:
		if( cachefp != NULL ){
			fclose(cachefp);
			cachefp = NULL;
		}
		cdate = -1;
		if( 5 < cretry++ )
			goto give_up;

		if( !DontReadCache )
		if( cachefp = cache_fopen_rd("GOPHER",cpath,expire,&cdate) ){
			if( lock_for_rd("GOPHER",cretry,cpath,cachefp) != 0 ){
				sleep(CACHE_RDRETRY_INTERVAL);
				goto retry_read;
			}

			sv1log("GOPHER <= [%s] %s %d %s",cpath, server,iport,req);
			fgetsTIMEOUT(line,sizeof(line),cachefp);
			if(line[0]=='-' && line[1]=='-'){
				sv1log("GOPHER <= ??? %s",line);
				cache_delete(cpath);
				goto retry_read;
			}
			totalc = readout_cache(Conn,req,gtype,cachefp,tc);
			fclose(cachefp); /* unlock Shared lock */

			fflush(tc); set_linger(fileno(tc),DELEGATE_LINGER);
			sv1log("GOPHER %d bytes of cached data transfered\n",totalc);
			return;
		}
		if( cachefp = cache_fopen_rw("GOPHER",cpath) ){
			if( file_lock_wr("GOPHER",cachefp) != 0 ){
				if( !DontReadCache && !dontWaitCache ){
					sleep(CACHE_WRRETRY_INTERVAL);
					goto retry_read;
				}else{
					fclose(cachefp);
					cachefp = NULL;
				}
			}else{
				DontWaitCache = 1;
				if( !DontReadCache && !dontWaitCache ){
					if( cdate != -1 )
					/*if( isGopherPlus(server) )*/
					if( !Modified(Conn,cdate,req) ){
						ftouch(cachefp,time(0));
						goto retry_read;
					}
				}
				setbuffer(cachefp,c_buff,sizeof(c_buff));
			}
		}
	} give_up:

	if( 0 < FromS ){
		sv1log("Already Connected To the Server: %d\n",FromS);
		write(ToS,req,strlen(req));
	}else{

/* to syncronize ? */
/* add_DGinputs(Conn,"\r\n"); */
/* This disturbs real Gopher+ server and causes premature EOF */

		if( connect_to_serv(Conn, FromC,ToC, 1) < 0 )
		{
			fprintf(tc,"--2\r\n");
			fprintf(tc,"DeleGate: connection to %s:%d failed.\n",
				DFLT_HOST,DFLT_PORT);
			fflush(tc);
			return;
		}
	}

	if( toMaster )
		sv1log("GOPHER -> (%s:%d) %s",server,iport,req);
	else{
		sv1log("GOPHER => (%s:%d) %s",server,iport,req);
		std_setsockopt(ToS);
	}

	fs = fdopen(FromS,"r");
	if( fs == NULL ){
		sv1log("Error fdopen(%d) failed\n",FromS);
		return;
	}

/* Send selector message if the server is a real server, otherwise
 * the message to the Mediator has sent in connect_to_server.
 */
/* It comes to be suppried in the connect_to_server.
   if( !toMaster ) write(ToS,req,strlen(req)); */

	totalc = relay_response(Conn,req,gtype,fs,tc,cachefp);
	sv1log("GOPHER %d bytes of data transfered\n",totalc);

	close(ToS);

	if( cachefp ){
		if( totalc <= 0 )
			cache_delete(cpath);
		else{
			sv1log("written to [%s]\n",cpath);
			Ftruncate(cachefp,0,1);
		}
		fclose(cachefp); /* unlock Exclusive lock */
	}
}

static relay_response(Conn,req,gtype,fs,tc,cachefp)
	Connection *Conn;
	char *req;
	FILE *fs,*tc,*cachefp;
{	int error,totalc,rcc;
	char head[32];
	char line[2048];

	error = 0;
	totalc = 0;
	if( IS_DIR(gtype) || is_DIR(req) || IS_SEARCH(gtype) || is_INFO(req) ){
		check_codeconvSP(Conn,1);
		for(;;){
			line[0] = 0;
			if( fgetsTIMEOUT(line,sizeof(line),fs) == NULL ){
				error = 1;
				sv1log("GOPHER << premature EOF\n");

				/* Gopher+ */
				if( cachefp )
					gopher_fputs(Conn,gtype,req,"--2\r\n",tc);
				break;
			}
			if( line[0] == '-' ){
				error = 1;
				if( cachefp )
				sv1log("error: %s",line);
			}

			totalc += strlen(line);
			gopher_fputs(Conn,gtype,req,line,tc);
			fflush(tc);
			if( cachefp )
				fputs(line,cachefp);

			if( streq(line,".\r\n") ){
				totalc -= 3;
				break;
			}
		}
	}else
	if(  IS_TEXT(gtype) ){
		if( (totalc = CCV_relay_text(Conn,fs,tc,cachefp)) < 0 )
			error = 1;
	}else{
		rcc = freadTIMEOUT(head,1,sizeof(head),fs);
		if( rcc == 0 )
			error = 1;
		else{
			/* Gopher+ */
			if( head[0] == '-' )
				error = 1;
			fwriteTIMEOUT(head,1,rcc,tc);
			if( cachefp )
			fwrite(head,1,rcc,cachefp);

			if( (totalc = copy_fileTIMEOUT(fs,tc,cachefp)) < 0 )
				error = 1;
		}
	}
	if( error && (0 < totalc) )
		totalc = -totalc;

	fcloseLinger(tc);
	Verbose("%d bytes put.\n",totalc);
	return totalc;
}

decomp_dirent(line,attr,uname,selector,host,iport,ext)
	char *line,*attr;
	int *iport;
	char **uname,**selector,**host,**ext;
{	char *dp;
	int egtype;

	attr[0] = 0;
	egtype = *line;
	if( egtype == '+' ){
		if( dp = strchr(line,':') ){
			*dp++ = 0;
			strcpy(attr,line);
			strcat(attr,":");
			if( *dp == ' ' ){
				strcat(attr," ");
				dp++;
			}
			strcpy(line,dp);
			egtype = *line;
		}
	}
	dp = line + 1;
	*uname = dp;
	if(dp=strchr(dp,'\t')){ *dp++ = 0; *selector = dp; }else return 0;
	if(dp=strchr(dp,'\t')){ *dp++ = 0; *host = dp;     }else return 0;
	if(dp=strchr(dp,'\t')){ *dp++ = 0; *iport=atoi(dp);}else return 0;
	if(dp=strchr(dp,'\t')){ *ext = dp;               }
			else  { *ext = "\r\n";	         }

	return egtype;
}

static isGopherPlus(host)
	char *host;
{	char path[1024];
	char *cache_dir;

	cache_dir = cachedir();
	sprintf(path,"%s/%s/+",cache_dir,"gopher",host);
	if( fileIsflat(path) )
		return 1;
	sprintf(path,"%s/%s/$",cache_dir,"gopher",host);
	if( fileIsflat(path) )
		return 1;
	return 0;
}

static dirent2html(Conn,fs,tc,iconbase)
	Connection *Conn;
	FILE *fs,*tc;
	char *iconbase;
{	char dirent[2048],cdirent[2048];
	char html[2048];
	char attr[256],gtype,*uname,*selector,*host,*ext;
	char hostport[256],xsel[SELSZ];
	char *space;
	int iport;
	char *hp;
	char url[SELSZ],*img,*alt;
	int lines,gplus,error;
	int do_conv;
	int totalc = 0;

	gplus = 0;
	lines = 0;
	error = 0;
	do_conv = check_codeconvSP(Conn,1);

	/* Avoid X-Mosaic bug (?) which specially treat '?' character
	 * in within first 2 bytes (?)
	 */
	space = "- ";

	while( fgetsTIMEOUT(dirent,sizeof(dirent),fs) != NULL ){
		totalc += strlen(dirent);
		if( streq(dirent,".\r\n") )
			break;
		if( lines == 0 && dirent[0] == '-' && dirent[1] == '-' )
			error = 1;
		lines++;

		if( do_conv ){
			line_codeconv(dirent,cdirent,"text/html");
			strcpy(dirent,cdirent);
		}

		gtype = decomp_dirent(dirent,attr,
			&uname,&selector,&host,&iport,&ext);

		if( gtype == 0 ){
			Verbose("%s",dirent);
			continue;
		}
		if( host == 0 || *host == 0 ){
			fprintf(tc,"%s<BR>\n",dirent);
			continue;
		}

		switch( gtype ){
		    case '0': alt="[TXT]"; img="text.gif";	break;
		    case '1': alt="[DIR]"; img="directory.gif";	break;
		    case '2': alt="[???]"; img="unknown.gif";	break;
		    case '3': alt="[ERR]"; img="unknown.gif";	break;
		    case '4': alt="[HEX]"; img="binhex.gif";	break;
		    case '5': alt="[BIN]"; img="binary.gif";	break;
		    case '6': alt="[UUE]"; img="uu.gif";	break;
		    case '7': alt="[IDX]"; img="index.gif";	break;
		    case '8': alt="[TEL]"; img="telnet.gif";	break;
		    case '9': alt="[BIN]"; img="binary.gif";	break;
		    case 'g': alt="[GIF]"; img="image.gif";	break;
		    case 'I': alt="[IMG]"; img="image.gif";	break;
		    case 'T': alt="[TEL]"; img="telnet.gif";	break;
		    default:  alt="[???]"; img="unknown.gif";	break;
		}

		nonxalpha_escape(selector,xsel);
		if( iport == 0 || iport == serviceport("gopher") )
			sprintf(hostport,"%s",host);
		else	sprintf(hostport,"%s:%d",host,iport);

		if( gtype == '8' || gtype == 'T' )
			sprintf(url,"telnet://%s/%s",hostport,xsel);
		else{
			if( is_redirected_selector(xsel) && GOPHER_ON_HTTP )
				sprintf(url,"http://%s/%s",hostport,xsel);
			else{
			sprintf(url,"gopher://%s/%c%s",hostport,gtype,xsel);
			redirect_url(Conn,url,url);
			}
		}

		hp = html;
		hp = Sprintf(hp,"<IMG ALT=\"%s\" SRC=\"%s%s\" ALIGN=TOP>",alt,
			iconbase,img);
		hp = Sprintf(hp,"<A HREF=\"%s\">",url);
		hp = Sprintf(hp,"%s%s</A><BR>\n",space,uname);
		fputs(html,tc);
	}
	fprintf(tc,"<HR>\n");
	if( gplus )
		fprintf(tc,"[Gopher+]");
	/* if( charset ) fprintf("[charset=%s]",charset); */

	putFrogForDeleGate(Conn,tc,"[%d line%s]",lines,1<lines?"s":"");
	fflush(tc);
	return totalc;
}

HttpGopher(Conn,vno,svsock,server,iport,gtype,path)
	Connection *Conn;
	char *server,*path;
{	int msock;
	FILE *tc,*fs;
	char *ctype;
	char xpath[2048];
	char iconbase[1024];
	int totalc;
	char request[2048];
	char dserv[256];
	int toHTML;

	del_DGlocalheader(Conn); /* expects raw/transparent gopher server */
	nonxalpha_unescape(path,xpath,1);
	path = xpath;
	sprintf(request,"%s\r\n",path);

	tc = fdopen(dup(ToC),"w");

	sprintf(dserv,"Gopher/HTTP gateway ETL-DeleGate/%s",DELEGATE_ver());
	if( gtype == '7' ){
		char req[2048],*dp;

		if( strchr(path,'?') == 0 ){
			sv1log("GENERATED Searchable Gopher Index\n");
			setConnDone(Conn);
			totalc = putHttpHeaderV(Conn,tc,vno,dserv,"text/html",(char*)0,0,0,0);
			fprintf(tc,"<B>Searchable Gopher Index</B>\n<ISINDEX>\n");
			totalc += putFrogForDeleGate(Conn,tc,"");
			fflush(tc);
			goto EXIT;
		}
		strcpy(req,path);
		if( dp = strchr(req,'?') )
			*dp = '\t';
		sprintf(request,"%s\r\n",req);
	}
	if( streq(request,"/\r\n") )
		strcpy(request,"\r\n");

	if( (msock = svsock) == -1 )
	if( (msock = connect_to_serv(Conn,FromC,ToC,0)) < 0 ){
		totalc = -1;
		goto EXIT;
	}

	write(msock,request,strlen(request));
	Verbose("Gopher/HTTP: %s",request);
	setConnDone(Conn);

	fs = fdopen(msock,"r");
/* setbuf(fs,NULL); */

	switch( gtype ){
		case '0': ctype = "text/plain";	break;
		case '1':
		case '7': ctype = "text/html";	break;
		case 'g': ctype = "image/gif";	break;
		case 'I': ctype = "image/gif";	break;
		case '-': ctype = "text/plain";	break;
		default:
		case '9': ctype = "application/octet-stream"; break;
	}

	if( streq(ctype,"text/plain") && plain2html() ){
		toHTML = 1;
		totalc = 11;
		ctype = "text/html";
	}else{
		toHTML = 0;
		totalc = 0;
	}
	putHttpHeaderV(Conn,tc,vno,dserv,ctype,(char*)0,0,0,0);
	if( toHTML )
		fputs("<PRE>",tc);

	if( DELEGATE_IMAGEDIR )
		strcpy(iconbase,DELEGATE_IMAGEDIR);
	else	getCERNiconBase(Conn,iconbase);

	if( gtype == '0' ){
		totalc += CCV_relay_text(Conn,fs,tc,NULL);
	}else
	if( gtype == '1' || gtype == '7' ){
		char hostport[256];
		char gpath[2048];

		HostPort(hostport,"gopher",server,iport);
		fprintf(tc,"<I> GopherMenu </I> ");
		fprintf(tc,"<B>\n");
/*
fprintf(tc,"gopher://%s/%c%s\n",hostport,gtype,path);
*/
		if( strcmp(path,"/") == 0 )
			gpath[0] = 0;
		else	sprintf(gpath,"%c%s",gtype,path);
		putAncestorAnchor(Conn,tc,"gopher",server,iport,gpath,0);

		fprintf(tc,"</B>\n");
		fprintf(tc,"<HR>\n");
		totalc += dirent2html(Conn,fs,tc,iconbase);
	}else{
		fflush(tc);
/*
		totalc += relay_svcl(Conn,-1,ToC,msock,-1,1,512);
*/
		totalc += copy_fileTIMEOUT(fs,tc,NULL);
	}
	if( toHTML )
		fputs("</PRE>",tc);
	fcloseLinger(tc);
	tc == NULL;
	Verbose("GOPHER: %d bytes put.\n",totalc);

	fclose(fs);
EXIT:
	if( tc != NULL )
		fcloseTIMEOUT(tc);
	return totalc;
}
