/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1997 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	nntpgw.c (NNTP / HTTP gateway)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	970202	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <ctype.h>
#include "delegate.h"
#include "ystring.h"

int ACLMAX = 32;
int ACL_MAXLINES = 128;
int ACL_MAXBYTES = 32*1024;

extern FILE *openMuid();
extern FILE *openGACL();
extern FILE *SMTP_POST();
extern FILE *openAclFile();

static printAdmin(tc,stime,com,user,admstat,admid)
	FILE *tc;
	char *stime,*com,*user,*admstat,*admid;
{	char adminid[1024],*ap;

	adminid[0] = 0;
	sscanf(admid,"<%[^>]",adminid);
	fprintf(tc,"[%s] %-4s %-10s ",stime,com,user);
	if( ap = strchr(adminid,'-') ) if( *++ap && *++ap ) while( *++ap ) *ap = '*';
	if( strcasecmp(admstat,"anonymous") == 0 )
		fprintf(tc,"%-10s %s\r\n",admstat,adminid);
	else	fprintf(tc,"%-10s <A HREF=?Admin=GetACL&ADMINID=%s>%s</A>\r\n",admstat,adminid,adminid);
}

getSubscription(Conn,tc,userclass,newsgroup,subp,unsp)
	Connection *Conn;
	FILE *tc;
	char *userclass;
	char *newsgroup;
	int *subp,*unsp;
{	FILE *acl;
	char ac1[2048],*wp,stime[128],com[128],user[128],admstat[128];
	char admid[1024];
	int point,adm,sub,uns;

	adm = sub = uns = 0;
	if( acl = openAclFile(0,DST_PROTO,DST_HOST,DST_PORT,newsgroup) ){
		while( fgets(ac1,sizeof(ac1),acl) ){
			wp = wordScan(ac1,stime);
			wp = wordScan(wp,com);
			wp = wordScan(wp,user);
			if( strcmp(userclass,user) != 0 )
				continue;

			wp = wordScan(wp,admstat);
			if( strcaseeq(admstat,"open") )
				point = 10;
			else	point = 1;
			if( strcaseeq(com,"On") ){ adm++; sub += point; } else
			if( strcaseeq(com,"Off")){ adm++; uns += point; }

			if( tc != NULL ){
				wordScan(wp,admid);
				printAdmin(tc,stime,com,user,admstat,admid);
			}
		}
		fclose(acl);
	}

	if( subp ) *subp = sub;
	if( unsp ) *unsp = uns;
	return adm;
}

static setACL(Conn,add,aclID,user,url,cfp,tc,env,ckfunc)
	Connection *Conn;
	char *aclID;
	char *user;
	char *url;
	FILE *cfp,*tc;
	char *env;
	char *(*ckfunc)();
{	char ctl[2048],com[2048],arg[2048];
	char ac1[2048];
	char Ver[256],AdmClass[128],Base[1024];
	int len;
	int errors = 0;
	int nl,cnl;
	FILE *acl;
	char admid[2048],*xp,xmbox[128];
	int off;
	char *cp;
	char stime[64];
	char *err;
	int bytes;

	cnl = 0;
	bytes = 0;
	Ver[0] = 0;
	AdmClass[0] = 0;
	Base[0] = 0;
	StrftimeLocal(stime,sizeof(stime),"%Y/%m/%d-%H:%M:%S",time(0));

	sprintf(admid,"<%s>",aclID);

	for( nl = 1; fgets(ctl,sizeof(ctl),cfp) != NULL; nl++ ){
		bytes += strlen(ctl);
		if( ACL_MAXBYTES < bytes ){
fprintf(tc,"[WARNING] your ACL should be smaller than %d bytes.\r\n",
ACL_MAXBYTES);
			fprintf(tc,"[WARNING] remaining list is ignored.\r\n");
			errors++;
			break;
		}

		if( cp = strchr(ctl,'#') )
			*cp = 0;
		if( ctl[0] == 0 )
			continue;

		com[0] = arg[0] = 0;
		sscanf(ctl,"%[^: \t\r\n]%*[: \t\r\n]%[^\r\n]",com,arg);
		if( com[0] == 0 )
			continue;

		if( strcaseeq(com,"ACL-Version") ){
			strcpy(Ver,arg);
			continue;
		}
		if( strcaseeq(com,"Admin-Class") ){
			if( !strcaseeq(arg,"anonymous") ){
				fprintf(tc,"[FATAL: unknown Admin-Class] %s\r\n",arg);
				return -1;
			}
			strcpy(AdmClass,arg);
			continue;
		}
		if( strcaseeq(com,"Base-URL") ){
			char proto[128],login[128],path[128];
			char clogin[128];

			decomp_absurl(arg,proto,login,path,sizeof(path));
			HostPort(clogin,DST_PROTO,DST_HOST,DST_PORT);
			if( strcmp(proto,DST_PROTO) || hostcmp(login,clogin) ){

fprintf(tc,"[FATAL: Base-URL arrogation] <%s> should be <%s://%s>\r\n",
arg,DST_PROTO,clogin);

				return -1;
			}
			strcpy(Base,arg);
			continue;
		}

		if( Ver[0] == 0 ){
			fprintf(tc,"[FATAL: no ACL-Version specified]\r\n");
			return -1;
		}
		if( AdmClass[0] == 0 ){
			strcpy(AdmClass,"anonymous");
			fprintf(tc,"[WARNING: no Admin-Class specified] assumed %s\r\n",
				AdmClass);
		}
		if( ACL_MAXLINES < nl ){
fprintf(tc,"[WARNING] your ACL should be less than %d lines.\r\n",
ACL_MAXLINES);
			fprintf(tc,"[WARNING] remaining list is ignored.\r\n");
			errors++;
			break;
		}

		if( strcaseeq(com,"On") || strcaseeq(com,"Off") ){
			++cnl;

			if( add && ACLMAX < cnl ){
fprintf(tc,"[WARNING] you cannot control ACLs for more than %d newsgroups.\r\n",
ACLMAX);
				fprintf(tc,"[WARNING] remaining list is ignored.\r\n");
				errors++;
				break;
			}
			if( add && (err = (*ckfunc)(env,Base,arg)) ){
				fprintf(tc,"[ERROR] %d:[%s] %s: %s\r\n",
					nl,err,com,arg);
				errors++;
				continue;
			}

			acl = openAclFile(1,DST_PROTO,DST_HOST,DST_PORT,arg);
			fseek(acl,0,0);
			for(;;){
				off = ftell(acl);
				if( fgets(ac1,sizeof(ac1),acl) == NULL )
					break;
				if( xp = strstr(ac1,admid) ){
					if( add )
					fprintf(tc,"[UPDATE] %d: %s: %s\r\n",nl,com,arg);
					fseek(acl,off,0);
					break;
				}
			}
			if( add ){
				fprintf(acl,"%s %-10s %-10s %-10s %s\r\n",
					stime,com,user,AdmClass,admid);
			}else{
				int fsize,rcc;
				char *buff;

				fsize = file_size(fileno(acl));
				buff = (char*)malloc(fsize);
				rcc = fread(buff,1,file_size(),acl);
				fseek(acl,off,0);
				fwrite(buff,1,rcc,acl);
				free(buff);
				Ftruncate(acl,off,0);
			}
			fclose(acl);
			continue;
		}
	}
	return errors;
}

extern char *MailGate();
static notifyAdmin(Conn,admfp,infp,adminid,adminmbox,event)
	Connection *Conn;
	FILE *admfp;
	FILE *infp;
	char *adminid,*adminmbox,*event;
{	char mailer[128],line[1024];
	char stime[128];
	FILE *fp;

	mailer[0] = 0;

	fseek(admfp,0,0);
	while( fgets(line,sizeof(line),admfp) != NULL ){
		if( sscanf(line,"MAILER: %s",mailer) )
			break;
	}
	if( mailer[0] ){
		fp = SMTP_POST(mailer,25,adminmbox,MailGate(Conn));
		fprintf(fp,"Subject: Notice: GACL %s\r\n",event);
		fprintf(fp,"\r\n");
		fprintf(fp,"ACTION: %s\r\n",event);
		fprintf(fp,"MUID: %s\r\n",adminid);
		fprintf(fp,"\r\n--CONTENT--\r\n");
		if( infp ){
			fseek(infp,0,0);
			copyfile1(infp,fp);
		}
		fprintf(fp,"\r\n--REQUEST--\r\n");
		HTTP_putRequest(Conn,fp);
		fprintf(fp,"--END--\r\n");
		pclose(fp);
	}
	fseek(admfp,0,2);
	StrftimeLocal(stime,sizeof(stime),"%Y/%m/%d-%H:%M:%S",time(0));
	fprintf(admfp,"[%s] %s\r\n",stime,event);
	fflush(admfp);
}

httpAdmin(Conn,user,tc,group,search,env,prfunc,ckfunc,adminid)
	Connection *Conn;
	char *user;
	FILE *tc;
	char *group,*search;
	char *env;
	int (*prfunc)();
	int (*ckfunc)();
	char *adminid;
{	char *np,sub[128],dhtml[128];
	char url[1024],durl[1024],aurl[1024],aclurl[1024];
	char adminmbox[1024];
	FILE *cfp,*acl;
	char opath[1024];
	FILE *admfp;
	char line[1024];

	sub[0] = 0;
	sscanf(search,"Admin=%[^&]",sub);

	if( np = strstr(search,"USER=") )
		sscanf(np,"USER=%[^&]",user);

	adminid[0] = 0;
	if( np = strstr(search,"ADMINID=") )
		sscanf(np,"ADMINID=%[^&]",adminid);

	url[0] = 0;
	if( np = strstr(search,"URL=") )
		sscanf(np,"URL=%[^&]",url);
	nonxalpha_unescape(url,durl,0);

/*
	if( !streq(user,"anonymous") ){
		fprintf(tc,"you cannot control %s users\r\n",user);
		return;
	}
*/

	if( streq(sub,"GetACL") || streq(sub,"PutACL") ){
		char line[1024];

		if( adminid[0] == 0 ){
			fprintf(tc,"You must show your <I>Admin-ID</I>.\r\n");
			return;
		}

		if( streq(sub,"PutACL") )
		if( durl[0] == 0 ){
			fprintf(tc,"You must show your <I>ACL-URL</I> (URL of your GACL).\r\n");
			return;
		}else
		if( durl[0] ){
			cfp = tmpfile();
			URLget(durl,1,cfp);
			if( file_size(fileno(cfp)) <= 0 ){
				fprintf(tc,"Your GACL at &lt;%s&gt; is not accessible\r\n",durl);
				return;
			}
		}

		if( (admfp = openMuid(0,adminid,adminmbox)) == NULL ){
			fprintf(tc,"The <I>Admin-ID</I> shown [%s] does not exist.\r\n",adminid);
			return;
		}
		if( streq(sub,"GetACL") )
		if( (acl = openGACL(0,adminid)) && 0 < file_size(fileno(acl)) ){
			line[0] = 0;
			while( fgets(line,sizeof(line),acl) != NULL ){
				if( line[0] == '#' ){
					fputs(line,tc);
					break;
				}
				if( line[0] == '\r' || line[0] == '\n' )
					break;
			}
			if( line[0] != '#' ) /* maybe template */
				fprintf(tc,"#<PLAINTEXT>\r\n");

			copyfile1(acl,tc);
			fflush(tc);
			notifyAdmin(Conn,admfp,acl,adminid,adminmbox,"downloaded");
			return;
		}

		acl = openGACL(1,adminid);
		line[0] = 0;
		fgets(line,sizeof(line),acl);
		fseek(acl,0,0);

		if( streq(sub,"GetACL") ){
putBuiltinHTML(Conn,acl,"NNTP/HTTP-Gateway-Admin","news/adminNewACL.dhtml",NULL,prfunc,env);
			fflush(acl);
			fseek(acl,0,0);
			copyfile1(acl,tc);
			notifyAdmin(Conn,admfp,acl,adminid,adminmbox,"created+downloaded");
			fclose(acl);
			fflush(tc);
			return;
		}

		if( line[0] == 0 || line[0] == '#' ){
			fseek(admfp,0,2);
			fprintf(admfp,"ACL-URL: %s\r\n",durl);
			fflush(admfp);
		}else{
			/* check consistensy of ACL-URL */
		}

		uploadACL(Conn,user,tc,acl,cfp,adminid,adminmbox,durl,env,ckfunc);

		fseek(cfp,0,0);
		copyfile1(cfp,acl);
		Ftruncate(acl,0,1);

		fflush(tc);
		notifyAdmin(Conn,admfp,cfp,adminid,adminmbox,"uploaded");

		fclose(cfp);
		fclose(acl);
		fclose(admfp);
	}

	sprintf(dhtml,"news/admin%s.dhtml",sub);
	putBuiltinHTML(Conn,tc,"NNTP/HTTP-Gateway-Admin",dhtml,NULL,prfunc,env);
}

uploadACL(Conn,user,tc,oldacl,newacl,aclID,mbox,durl,env,ckfunc)
	Connection *Conn;
	char *user;
	FILE *tc,*oldacl,*newacl;
	char *aclID,*mbox;
	char *durl;
	int (*ckfunc)();
{	int errors;
	int osize;
	char line[1024];

	fprintf(tc,"<PLAINTEXT>\r\n");
	fprintf(tc,"UPLOAD/UPDATE/REMOVE Gateway Access Control List (GACL)\r\n");
	fprintf(tc,"Source GACL URL: <%s>\r\n",durl);
	fprintf(tc,"\r\n--DIAGNOSIS--\r\n");

	osize = file_size(fileno(oldacl));

	if( 0 < osize ){
		while( fgets(line,sizeof(line),oldacl) != 0 ){
			/* skip HTTP header */
			if( line[0] == '#' || line[0] == '\r' || line[0] == '\n' )
				break;
		}
		setACL(Conn,0,aclID,user,durl,oldacl,tc,env,ckfunc);
		fseek(oldacl,0,0);
	}

	if( file_size(fileno(newacl)) <= 0 ){
		if( 0 < osize )
			fprintf(tc,"Your ACL is removed\r\n");
	}else{
		errors = setACL(Conn,1,aclID,user,durl,newacl,tc,env,ckfunc);
		if( errors == 0 )
			fprintf(tc,"NO ERROR\r\n");

		fseek(newacl,0,0);
		fprintf(tc,"\r\n--SOURCE--\r\n");
		copyfile1(newacl,tc);
	}
	if( 0 < osize ){
		fprintf(tc,"\r\n--PREVIOUS--\r\n");
		copyfile1(oldacl,tc);
		fseek(oldacl,0,0);
	}

	fprintf(tc,"\r\n--END--\r\n");
}
