/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1997-1999 Yutaka Sato
Copyright (c) 1997-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	env.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	970814	extracted from delegated.c
//////////////////////////////////////////////////////////////////////#*/
#include "config.h"
#include "param.h"
#include "delegate.h"
#include "log.h"

extern char EXEC_PATH[];
extern char **environ;
extern char *getenv();
extern char *getv();

int  main_argc;
char **main_argv;
static int  ext_argc;
static char *ext_argv[MAX_ARGC];
static int  extovw_argc;
static char *extovw_argv[MAX_ARGC];
static int  gen_envx;
static char *gen_environ[32];
static char *ext_environ[MAX_ARGC];

int DELEGATE_EXTOVW;
DELEGATE_clearEnv()
{
	extovw_argc = 0;
}
char *DELEGATE_getEnv(name)
	char *name;
{	char *value;

	if( value = getv(gen_environ,name) )
		return value;
	if( value = getv(extovw_argv,name) )
		return value;
	if( value = getv(main_argv,name) )
		return value;
	if( value = getv(ext_argv,name) )
		return value;
	return getenv(name);
}
DELEGATE_copyEnv(av,ac,path,abuff)
	char *av[],*path,*abuff;
{	int ai;
	char hosts[0x4000],port[256];
	char *ap;

	ap = abuff;

	if( lVERB() ){
		av[ac++] = "-vv";
	}
	else{
		printServPort(port,"",0);
/*
		sprintf(ap,"%s=%s++",P_LOGFILE,port);
*/
		sprintf(ap,"%s=%s",P_LOGFILE,port);
		av[ac++] = ap;  ap += strlen(ap) + 1;
	}

	sprintf(ap,"%s=%s",P_EXEC_PATH,path);
	av[ac++] = ap; ap += strlen(ap) + 1;

	for( ai = 0; ai < ext_argc; ai++ )
		av[ac++] = ext_argv[ai];

	for( ai = 1; ai < main_argc; ai++ )
		if( main_argv[ai] )
			av[ac++] = main_argv[ai];

	for( ai = 0; ai < extovw_argc; ai++ )
		av[ac++] = extovw_argv[ai];

	for( ai = 0; ai < gen_envx; ai++ )
		av[ac++] = gen_environ[ai];

	if( dump_HOSTS(hosts) ){
		sprintf(ap,"%s=%s",P_HOSTS,hosts);
		Verbose("%s\n",ap);
		av[ac++] = ap; ap += strlen(ap) + 1;
	}
	return ac;
}
DELEGATE_copyEnvPM(dav,name)
	char *dav[],*name;
{	int ac;

	ac = 0;
	ac += copy_param(name,&dav[ac],environ);
	ac += copy_param(name,&dav[ac],ext_argv);
	ac += copy_param(name,&dav[ac],&main_argv[1]);
	ac += copy_param(name,&dav[ac],gen_environ);
	return ac;
}

/*
static char *getEnvT(name)
	char *name;
{	char *body;
	if( body = getEnv(name) )
		if( body[-1] == '=' )
			return body - strlen(name) - 1;
		else	return body - strlen(name);
	return 0;
}
*/

DELEGATE_addEnvExt(env)
	char *env;
{
	if( lVERB() || lARGDUMP() ){
		if( DELEGATE_EXTOVW )
			fprintf(stderr,"<%d> %s\n",extovw_argc,env);
		else	fprintf(stderr,"<%d> %s\n",ext_argc,env);
	}
	if( DELEGATE_EXTOVW )
		extovw_argv[extovw_argc++] = strdup(env);
	else	ext_argv[ext_argc++] = strdup(env);
}
DELEGATE_pushEnv(name,value)
	char *name,*value;
{	char env[1024];

	sprintf(env,"%s=%s",name,value);
	gen_environ[gen_envx++] = strdup(env);
}
typedef struct {
	Connection *sv_Conn;
	int	(*sv_func)();
	char	*sv_arg;
	int	sv_ign_include;
} SvArg;
static scanenv1(sva,val)
	SvArg *sva;
	char *val;
{
	if( strncmp(val,INC_SYM,INC_SYM_LEN) == 0 )
		return 0;
	else	return (*sva->sv_func)(sva->sv_Conn,val,sva->sv_arg);
}
DELEGATE_scanEnv(Conn,name,func,arg)
	Connection *Conn;
	char *name;
	int (*func)();
	char *arg;
{	int nhit;
	SvArg sva;

	nhit = 0;
	sva.sv_Conn = Conn;
	sva.sv_func = func;
	sva.sv_arg = arg;
	nhit += scanv(environ,name,scanenv1,&sva);
	nhit += scanv(ext_argv,name,scanenv1,&sva);
	nhit += scanv(main_argv,name,scanenv1,&sva);
	nhit += scanv(extovw_argv,name,scanenv1,&sva);
	nhit += scanv(gen_environ,name,scanenv1,&sva);
	return nhit;
}

#define CFput(fp,fmt,ai,msg) {\
	if( fp != NULL ) fprintf(fp,fmt,ai,msg); else sv0log(fmt,ai,msg); \
	leng += strlen(msg); \
}
DELEGATE_dumpEnv(fp,genalso,imPM)
	FILE *fp;
{	int ai;
	char *env;
	int leng = 0;

	if( fp != NULL && !imPM ){
		char port[128];
		printServPort(port,"-P",genalso);
		fprintf(fp,"%s\n",port);
	}

	for( ai = 0; env = environ[ai]; ai++ )
	if( 0 <= check_param(env,0) )
		CFput(fp,"env[%d] %s\n",ai,env);

	for( ai = 0; ai < ext_argc; ai++ )
		CFput(fp,"ext[%d] %s\n",ai,ext_argv[ai]);

	for( ai = 1; ai < main_argc; ai++ )
	if( 0 <= check_param(main_argv[ai],0) )
		CFput(fp,"arg[%d] %s\n",ai,main_argv[ai]);

	if( genalso )
	for( ai = 0; gen_environ[ai]; ai++ )
		CFput(fp,"gen[%d] %s\n",ai,gen_environ[ai]);

	return leng;
}


/*
 * inporting configuration parameters
 */
int param_file = -1;
int param_mtime = 0;

new_param_file(path)
	char *path;
{	FILE *fp,*TMPFILE();

	if( 0 <= param_file )
		return;
	fp = TMPFILE("PARAM_FILE");
	/*
	 * it should be a visible file under ETCDIR or ADMDIR ...
	 */
	param_file = dup(fileno(fp));
	fclose(fp);
	param_mtime = file_mtime(param_file);
}
add_params(Conn,tc,command)
	Connection *Conn;
	FILE *tc;
	char *command;
{	FILE *fp;
	int pid;
	char com[1024],param[1024];

	/*
	 * must check accees right here...
	 */

	if( param_file < 0 ){
		fprintf(tc,"500 no parameter file\r\n");
		return -1;
	}

	com[0] = param[0] = 0;
	sscanf(command,"%s %[^\r\n]",com,param);

	/*
	 * param may be +=URL
	 */

	if( com[0] == 0 || param[0] == 0 ){
		fp = fdopen(dup(param_file),"r");
		fseek(fp,0,0);
		fputs("200 list of inported parameters follows:\r\n",tc);
		copyfile1(fp,tc);
		fputs(".\r\n",tc);
		fclose(fp);
		return 0;
	}
	if( check_param(param,0) < 0 ){
		fprintf(tc,"500 unknown parameter: %s\r\n",param);
		return -1;
	}
	if( lock_exclusiveTO(param_file,2000,NULL) != 0 ){
		fprintf(tc,"500 cannot lock parameter file\r\n");
		return -1;
	}
	pid = getpid();
	fp = fdopen(dup(param_file),"w");
	fprintf(fp,"%d %s\r\n",pid,param);
	fclose(fp);

	sv1log("#### PARAM INPORTED: %d %s\n",pid,param);
	fprintf(tc,"200 ok.\r\n");
	return 0;
}
load_params(Conn)
	Connection *Conn;
{	FILE *fp;
	char line[1024],param[1024];
	int mtime,pid;

	if( param_file < 0 )
		return;
	mtime = file_mtime(param_file);
	if( mtime == param_mtime )
		return;
	param_mtime = mtime;
	sv1log("#### PARAM updated\n");

	fp = fdopen(dup(param_file),"r");
	fseek(fp,0,0);
	while( fgets(line,sizeof(line),fp) ){
		sscanf(line,"%d %[^\r\n]",&pid,param);
		sv1log("#### %d %s\n",pid,param);
		if( strncmp(param,"MOUNT=",6) == 0 ){
			scan_MOUNT(Conn,param+6);
			init_mtab();
		}
	}
	fclose(fp);
}
