/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	embed.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	941001	created
	970104	self wild-card extension
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <string.h>

file1(path)
	char *path;
{	FILE *fp;
	int nc,col,ch;
	int cr,lf;
	int bin;

	fp = fopen(path,"r");
	if( fp == NULL ){
		fprintf(stderr,"cannot open: %s\n",path);
		return 0;
	}

	printf(" {\"%s\",\"\\\n",path);
	nc = 0;
	col = 0;
	cr = 0;
	lf = 0;
	bin = 0;
	while( (ch = getc(fp)) != EOF ){
		nc++;
		if( 70 <= col ){
			printf("\\\n");
			col = 0;
		}
		if( ch == '\n' && !bin ){ printf("\\n\\\n"); col = 0; lf++;}else
		if( ch == '\r' && !bin ){ printf("\\r");    col += 2; cr++;}else
		if( ch == '\t' && !bin ){ printf("\\t");    col += 2; }else
		if( ch == '"'  && !bin ){ printf("\\\"");   col += 2; }else
		if( ch == '\\' && !bin ){ printf("\\\\");   col += 2; }else
		if( bin || ch<0x20 || 0x7F<=ch || ch=='"' || ch=='\\' ){
			if( 0x80 <= ch )
				bin = 1;
			printf("\\%03o",ch);
			col += 4;
		}else{
			printf("%c",ch);
			col += 1;
		}
	}
	if( cr == 0 && 2048 < nc + lf ){
	fprintf(stderr,"######## WARNING: \"%s\"\n",path);
	fprintf(stderr,"######## This string value will over flow (%d+%d)\n",
		nc,lf);
	fprintf(stderr,"######## on the system where line ends with CR LF\n");
	}
	printf("\", %d\n },\n",nc);
	fclose(fp);
	return 0;
}

dir1(file,filter,curdir,recursive)
	char *file,*filter,*curdir,*recursive;
{	char ncurdir[1024];
	char *pp,path[1024];
	int plen;

	if( recursive && file[0] != '.' ){
		sprintf(ncurdir,"%s/%s",curdir,file);
		Scandir(ncurdir,dir1,filter,ncurdir,recursive);
	}

	if( filter[0] == '*' ){
		if( (pp = strstr(file,filter+1)) == NULL )
			return 0;
		if( pp[strlen(filter+1)] != 0 )
			return 0;
	}else{
		if( strcmp(file,filter) != 0 )
			return 0;
	}
	sprintf(path,"%s/%s",curdir,file);
	file1(path);
	return 0;
}

main(ac,av)
	char *av[];
{	int ai;
	char *id;
	char dirfile[1024],*fllter,*recursive;

	setBinaryIO();

	if( ac < 0 ){
		fprintf(stderr,"Usage: %s variable-name file-names\n",
			av[0]);
		exit(1);
	}
	id = av[1];
	printf("int MADE_TIME_%s = %d;\n",id,time(0));
	printf("struct { char *name; char *data; int size; }\n");
	printf("builtin_%s[] = {\n",id);

	for( ai = 2; ai < ac; ai++ ){
		strcpy(dirfile,av[ai]);
		if( fllter = (char*)strrchr(dirfile,'/') ){
			*fllter++ = 0;
			if( recursive = strstr(dirfile,"**") ){
				*recursive = 0;
				if( dirfile < recursive && recursive[-1] == '/' )
					recursive[-1] = 0;
			}
		}else	fllter = "";
		Scandir(dirfile,dir1,fllter,dirfile,recursive);
	}
	printf("0\n};\n");

	if( ADMINPASS[0] != 0 ){
		char src[256],*psp,*np,md5list[1024],*mdp;
		int pi;

		psp = ADMINPASS;
		mdp = md5list;
		for( pi = 0; pi < 8; pi++ ){
			if( pi != 0 )
				*mdp++ = ':';
			if( *psp ){
				if( sscanf(psp,"%[^:]",src) ){
					if( *src != 0 )
						toMD5(src,mdp);
					mdp += strlen(mdp);
				}
				if( *psp == ':' )
					psp++;
				else
				if( np = strchr(psp,':') )
					psp = np + 1;
				else	psp = "";
			}
		}
		*mdp = 0;
		printf("char *builtin_ADMINPASS = \"%s\";\n",md5list);
	}else{
		printf("char *builtin_ADMINPASS = \"\";\n");
	}
	exit(0);
}
