/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1999 Electrotechnical Laboratry (ETL), AIST, MITI
Copyright (c) 1994-1999 Yutaka Sato

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	croncom.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	981120	extracted from delegated.c (5.7.6)
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "param.h"
#include "ystring.h"
extern char *DELEGATE_EXPIRELOG;
extern char *cachedir();
extern char EXEC_PATH[];
extern int RESTART_NOW;

static int crons[256];
static int ncrons;
static int cronid;
spawnv_self(aac,aav)
	char *aav[];
{	int pid;
	int ai,ac;
	char *av[32];

	if( 256 <= ncrons ){
		sv1log("#### too many cron children (%d)\n",ncrons);
		return 0;
	}
	ac = 0;
	av[ac++] = EXEC_PATH;
	for( ai = 0; ai < aac; ai++ )
		av[ac++] = aav[ai];
	av[ac] = NULL;

	pid = SpawnvpDirenv("SpawnSelf",EXEC_PATH,av);

	cronid++;
	crons[ncrons++] = pid;
	sv1log("CRON(%d) START [%s] cid=%d pid=%d\n",ncrons,av[1],cronid,pid);
	return pid;
}
static spawn_system(command,inherits)
	char *command;
{	int ac;
	char *av[32];

	ac = 0;
	av[ac++] = "-Fsystem";
	av[ac++] = command;
	av[ac] = NULL;
	return spawnv_self(ac,av);
}
DELEGATE_cronExit(pid)
{	int pi,pj;

	for( pi = 0; pi < ncrons; pi++ ){
		if( crons[pi] == pid ){
			for( pj = pi; pj < ncrons-1; pj++ )
				crons[pj] = crons[pj+1];
			crons[pj] = 0;
			sv1log("CRON(%d) FINISH pid=%d\n",ncrons,pid);
			ncrons--;
			return pid;
		}
	}
	return 0;
}
extern char *Isnumber();
static internal_actions(action,act,arg)
	char *action,*act,*arg;
{	int pid;
	char *av[32],ab[8][128];
	int ac,ai,aj;

	pid = 0;
	if( act[0] == 0 ){
		ac = decomp_args(av,32,arg,ab);
		pid = spawnv_self(ac,av);
	}else
	if( act[0] == 'F' ){
		sprintf(ab[0],"-%s",act);
		av[0] = ab[0];
		ac = 1 + decomp_args(&av[1],32-1,arg,ab[1]);
		pid = spawnv_self(ac,av);
	}else
	if( strcmp(act,"exit") == 0 ){
		Finish(atoi(arg));
	}else
	if( strcmp(act,"suspend") == 0 ){
		int sec = atoi(arg);
		sv1log("sleeping %d...\n",sec);
		sleep(sec);
	}else
	if( strcmp(act,"restart") == 0 ){
		RESTART_NOW = 1;
	}else
	if( strcmp(act,"expire") == 0 ){
		char period[32],log[1024],param[1024],*rem,*env;

		if( cachedir() == NULL )
			return 0;
		if( (env = DELEGATE_getEnv(P_EXPIRELOG)) == 0 )
			env = DELEGATE_EXPIRELOG;
		strcpy(log,env);
		DELEGATE_substfile(log,"",NULL,NULL,NULL);
		sprintf(param,"LOGFILE=%s",log);

		rem = arg;
		if( Isnumber(arg) )
			rem = wordScan(arg,period);
		else
		if( env = DELEGATE_getEnv(P_EXPIRE) )
			strcpy(period,env);
		else	strcpy(period,"+7d");

		ac = 0;
		av[ac++] = "-Fexpire";
		av[ac++] = cachedir();
		av[ac++] = "-rm";
		av[ac++] = "-atime";
		av[ac++] = period;
		av[ac++] = "-sum";
		av[ac++] = "-ign";
		av[ac++] = param;
		ai = sscanf(rem,"%s %s %s %s %s",ab[0],ab[1],ab[2],ab[3],ab[4]);
		for( aj = 0; aj < ai; aj++ )
			av[ac++] = ab[aj];
		av[ac] = NULL;
		pid = spawnv_self(ac,av);
	}else
	if( strcmp(act,"exec") == 0 ){
		DELEGATE_execmain(arg);
		Finish(-1);
	}else
	if( strcmp(act,"system") == 0 ){
		pid = spawn_system(arg,0);
	}
	return pid;
}

/*
 *  sched_action is called by sched_eval(), and returns the list of
 *  finished actions....
 */
DELEGATE_sched_action(Conn,action)
	void *Conn;
	char *action;
{	char act[1024],arg[1024];
	int pid;

	act[0] = arg[0] = 0;
	sscanf(action,"%s %[^\r\n]",act,arg);

	if( act[0] == '-' ){
		internal_actions(action+1,act+1,arg);
	}else
	if( isFullpath(act) ){
		sv1log("SYSTEM-COMMAND: %s\n",action);
		pid = spawn_system(action,0);
	}else
	{
		sv1log("#### UNKNOWN ACTION: %s\n",action);
	}
}

static void *Cron;
extern void *sched_create();
DELEGATE_sched_execute(now,callback,Conn)
	int (*callback)();
	void *Conn;
{	int next;

	next = sched_eval(Cron,now,callback,Conn);
	return next;
}
scan_CRON(Conn,cronspec)
	void *Conn;
	char *cronspec;
{
	if( Cron == NULL )
		Cron = sched_create();
	sched_append(Cron,cronspec);
	return 0;
}

/*
 * CRONS -- per session scheduler
 */
static void *SubCron;
DELEGATE_session_sched_execute(now,callback,Conn)
	int (*callback)();
	void *Conn;
{	int next;

	next = sched_eval(SubCron,now,callback,Conn);
	return next;
}
scan_CRONS(Conn,cronspec)
	void *Conn;
	char *cronspec;
{
sv1log("#### SESSION SCHED[%s]\n",cronspec);
	if( SubCron == NULL )
		SubCron = sched_create();
	sched_append(SubCron,cronspec);
	return 0;
}
