/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1999 Yutaka Sato
Copyright (c) 1994-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	conf.c (configuration variables)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	March94	created
//////////////////////////////////////////////////////////////////////#*/

#include "delegate.h"
#include "param.h"

char	*MYSELF			= "-.-";
char	*DELEGATE_CONFIG        = "delegated.cf:/usr/etc/delegated.cf";
char	*DELEGATE_ADMIN_DFLT    = ADMIN;
char	*DELEGATE_ADMIN         = "";
char	*DELEGATE_ADMINPASS     = ADMINPASS;
char	*DELEGATE_OWNER         = "nobody";
char	*DELEGATE_G_PERMIT      = "*";
char	*DELEGATE_S_PERMIT      = "!*,.";
char	*DELEGATE_TELNET_PERMIT = "!*,telnet/{23,992}";
char	*DELEGATE_SOCKS_PERMIT  = "!*,socks,tcprelay";
char	*DELEGATE_HTTP_PERMIT   = "!*,http,https/{443,563},gopher,ftp,wais";
char	*DELEGATE_LOCALNET      = "localhost,./@,-/@,.o/@"; /* .localnet */
char	*DELEGATE_RELAY         = "proxy,delegate:*:*:.localnet;proxy";
char	*DELEGATE_RELIABLE      = ".localnet";
char	*DELEGATE_FORCEON       = "all";

char	 SERV_HTTP[]            = "-.-";
char	 SERV_GOPHER[]          = "gopher.tc.umn.edu";
char	 SERV_WAIS[]            = "cnidr.org";

char	*NOTIFY_PLATFORM        = "*.etl.go.jp,*.delegate.org";
char	*DELEGATE_LOGCENTER     = "www.delegate.org:8000";
char	*PUBLIC_CENTER          = "http://www.delegate.org/-/";
char	*PUBLIC_DIR             = "${ACTDIR}/public/";
char	*DELEGATE_DGPATH        = "+:.:${HOME}/delegate";

char	 DELEGATE_FLAGS[128]    = "";
int	 DELEGATE_LINGER        = 20; /* seconds */

char	*DELEGATE_DGROOT        = "";
char	*DELEGATE_VARDIR        = "${DGROOT?&:/var/spool/delegate}";
char	*DELEGATE_LIBDIR        = "${VARDIR}/lib";
char    *DELEGATE_LIBPATH       = ".:${STARTDIR}:${LIBDIR}:${EXECDIR}";
char	*DELEGATE_WORKDIR       = "${VARDIR}/work/${PORT}";
char	*DELEGATE_LOGDIR        = "${VARDIR}/log";
char	*DELEGATE_ETCDIR        = "${VARDIR}/etc";
char	*DELEGATE_ADMDIR        = "${VARDIR}/adm";
char	*DELEGATE_HOSTID        = "${ETCDIR}/hosts/serno";
char	*DELEGATE_SMTPGATE	= "${ETCDIR}/smtpgate";
char	*DELEGATE_MTAB          = "${ETCDIR}/conf/${PORT}/mtab";
char	*DELEGATE_NEWSLIB       = "${ETCDIR}/news";
char    *DELEGATE_DBFILE        = "";
char    *DELEGATE_UASFILE       = "${LOGDIR}/uas/${UA}";
char    *DELEGATE_LOGFILE       = "${LOGDIR}/${PORT}";
char    *DELEGATE_ERRORLOG      = "${LOGDIR}/errors.log";
char    *DELEGATE_TRACELOG      = "${LOGDIR}/ptrace.log";
char    *DELEGATE_EXPIRELOG     = "${LOGDIR}/expire.log";
char	*DELEGATE_ABORTLOG      = "${LOGDIR}/abort/${PORT}";
char    *DELEGATE_ACTDIR        = "${DGROOT?&/act:/tmp/delegate}";
char    *DELEGATE_TMPDIR        = "${DGROOT?&/tmp:/tmp/delegate}";
char    *DELEGATE_PIDFILE       = "${ACTDIR}/pid/${PORT}";
char	*DELEGATE_SOCKETS       = "${ACTDIR}/sockets";
char    *DELEGATE_STATFILE      = "";
char	*DELEGATE_PARAMFILE	= "${ETCDIR}/params/${PORT}";
char    *DELEGATE_PROTOLOG      = "${LOGDIR}/${PORT}.${PROTO}";
char    *DELEGATE_CACHEDIR      = "${VARDIR}/cache";
char	*DELEGATE_CACHEFILE     = "$[server:%P/%L/%p]";
int      DELEGATE_CACHE_CONTROL = 0;
char	*GOPHER_CACHE_ITEM      = "04569gI";
int	 GOPHER_EXPIRE          = 1*24*60*60;	/* 1 day */
int	 HTTP_EXPIRE            = 1*24*60*60;	/* 1 day */
int	 FTP_EXPIRE             = 1*24*60*60;	/* 1 day */
int	 FTP_ACCEPT_TIMEOUT     = 30; /* data connection timeout: 1 minute */
int	 DELEGATE_syncro        = 0; /* syncronous mode (only one client
                                          at a time, for debug) */
char	*DELEGATE_IMAGEDIR      = 0;

int	 DELEGATE_LISTEN        = 20;
int 	 MAX_DELEGATE           = 64;
int	 BREAK_STICKY           = 0;

int	 STANDBY_MAX            = 16;
int	 STANDBY_TIMEOUT        = 30;
int	 FDSET_MAX              = 64;

int	 HELLO_TIMEOUT          = 30; /* HELLO negotiation with the MASTER */
int	 LOGIN_TIMEOUT		= 60; /* Proxy telnet/ftp */
int	 SERVER_TIMEOUT         = 0;
int	 SERVER_RESTART         = 0;

int	 BORN_SPECIALIST;

int	 MASTER_ROUND_ROBIN     = 0;
double   IDENT_TIMEOUT          = 10;
char    *HTTP_AUTHBASE          = "/delegate-auth";

/*
 *	CACHE FILE CONTROLE
 */
int CACHE_RDRETRY_INTERVAL = 10; /* in seconds */
int CACHE_WRRETRY_INTERVAL = 10; /* in seconds */

disable_cache()
{
	DELEGATE_CACHE_CONTROL = -1;
}
enable_cache()
{
	DELEGATE_CACHE_CONTROL = 0;
}
without_cache(){
	return DELEGATE_CACHE_CONTROL < 0;
}

extern int CACHE_READONLY;
scan_CACHE(Conn,spec)
	Connection *Conn;
	char *spec;
{
	if( streq(spec,"do") )
		enable_cache();
	else
	if( streq(spec,"no") )
		disable_cache();
	else
	if( streq(spec,"ro") )
		CACHE_READONLY = 1;
}

scan_CACHEDIR(dirs)
	char *dirs;
{
	if( dirs )
		DELEGATE_CACHEDIR = dirs;
}
scan_CACHEFILE(file)
	char *file;
{
	DELEGATE_CACHEFILE = file;
}

strsubstDirEnv(dir,dgroot,vardir)
	char *dir,*dgroot,*vardir;
{	char *pp,*dp,*subst;
	char *var,pat[1024],word1[1024],word2[1024];

	strsubst(dir,"${VARDIR}",vardir);
	strsubst(dir,"${DGROOT}",dgroot);

	subst = "${DGROOT?";
	if( pp = strstr(dir,subst) ){
		var = dgroot;
		word1[0] = word2[0] = 0;
		sscanf(pp+strlen(subst),"%[^:]:%[^}]",word1,word2);
		strcpy(pat,pp);
		if( dp = strchr(pat,'}') )
			dp[1] = 0;
		if( var && *var )
			strsubst(dir,pat,word1);
		else	strsubst(dir,pat,word2);
		strsubst(dir,"&",var);
	}
}

extern char *cachedir();
char *cachefmt()
{	static char fmt[1024];

	sprintf(fmt,"%s/%s",cachedir(),DELEGATE_CACHEFILE);
	return fmt;
}
set_DG_EXPIRE(Conn,expi)
	Connection *Conn;
{
	add_DGheader(Conn,D_EXPIRE,"%ds",expi);
}
scan_EXPIRE(Conn,expire)
	Connection *Conn;
	char *expire;
{	char period[256],triple[1024],cmap[1024];

	if( strchr(expire,':') ){
		period[0] = triple[0] = 0 ;
		sscanf(expire,"%[^:]:%s",period,triple);
		sprintf(cmap,"%s:expire:%s",period,triple);
	}else	sprintf(cmap,"%s:expire:*:*:*",expire);
	scan_CMAP(Conn,cmap);
}
find_EXPIRE(Conn,dflt_ev)
	Connection *Conn;
{	char expire[256];
	int ev;

	if( D_EXPIRE[0] )
		ev = cache_expire(D_EXPIRE,dflt_ev);
	else
	if( 0 <= find_CMAP(Conn,"expire",expire) )
		ev = cache_expire(expire,dflt_ev);
	else	ev = dflt_ev;
	return ev;
}
http_EXPIRE(Conn,url)
	Connection *Conn;
	char *url;
{
	return find_EXPIRE(Conn,HTTP_EXPIRE);
}
gopher_EXPIRE(Conn,url)
	Connection *Conn;
	char *url;
{ 
	return find_EXPIRE(Conn,GOPHER_EXPIRE);
}
ftp_EXPIRE(Conn)
	Connection *Conn;
{
	return find_EXPIRE(Conn,FTP_EXPIRE);
}

scan_hostport1(hostport,host)
	char *hostport,*host;
{	char ch,*sp,*dp;
	char *pp;
	int port;

	port = 0;
	dp = host;
	pp = 0;

	for( sp = hostport; ch = *sp; sp++ )
	switch( ch ){
		case '/': case '?':
		case ' ': case '\t': case '\r': case '\n': case '\f':
			goto EXIT;

		case ':':
			port = atoi(sp+1);
			pp = dp;
			break;

		case '@':
			dp = host;
			port = 0;
			pp = 0;
			break;

		default:
			if( (ch & 0x80) || ch <= 0x20 )
				goto EXIT;
			*dp++ = ch;
			break;
	}
EXIT:
	if( pp ) *pp = 0;
	*dp = 0;
	return port;
}
scan_hostport1x(proto,login,host)
	char *proto,*login,*host;
{	int port;

	port = scan_hostport1(login,host);
	if( port == 0 )
		port = serviceport(proto);
	return port;
}

scan_hostport0(hostport,host)
	char *hostport,*host;
{	char ch,*sp,*dp;
	int port;

	port = 0;
	dp = host;
	for( sp = hostport; ch = *sp; sp++ ){
		if( ch == ':' ){
			port = atoi(sp+1);
			break;
		}
		if( strchr("/ \t\r\n",ch) )
			break;
		*dp++ = ch;
	}
	*dp = 0;
	return port;
}
scan_hostport(proto,hostport,host)
	char *proto,*hostport,*host;
{	int iport;

	iport = scan_hostport0(hostport,host);
	if( iport == 0 ){
		iport = serviceport(proto);
		/*
		if( iport == 0 )
		syslog_ERROR("## standard port for `%s' is unknown\n",proto);
		*/
	}
	return iport;
}

extern char *isSetProxyOfClient();
char *baseURL(Conn)
	Connection *Conn;
{	char *cl_proxy;
	char mhp[256],cl_proto[64];
	char *self;

	if( Conn->cl_baseurl[0] )
		return Conn->cl_baseurl;

	self = Conn->iconbase;
	if( self[0] == 0 ){
		if( cl_proxy = isSetProxyOfClient(Conn,cl_proto) ){
			if( cl_proto[0] )
				sprintf(self,"%s://%s",cl_proto,cl_proxy);
			else	sprintf(self,"//%s",cl_proxy);
		}else{
			HTTP_ClientIF_HP(Conn,mhp);
			sprintf(self,"%s://%s",CLNT_PROTO,mhp);
		}
	}
	return self;
}

char *MY_HOSTPORT()
{
	return MYSELF;
}
isMYSELF(host)
	char *host;
{
	if( streq(host,MYSELF) )
		return 1;
	if( streq(host,"-") )
		return 1;
	return 0;
}

never_cache(){
	return strchr(DELEGATE_FLAGS,'C') != 0;
}
remote_access(){
	return strchr(DELEGATE_FLAGS,'R') != 0;
}
use_numaddress()
{
	return strchr(DELEGATE_FLAGS,'N') != 0;
}
reserve_url()
{
	if( strchr(DELEGATE_FLAGS,'=') || strchr(DELEGATE_FLAGS,'T') )
		return 1;
	else	return 0;
}

/*
 *	BUILT-IN FILES
 */
typedef struct {
	char	*name;
	char	*data;
	int	 size;
} EmbededFile;
extern EmbededFile builtin_data[];

char *getIcon(name,size)
	char *name;
	int *size;
{	int i;
	EmbededFile *icons;

	icons = builtin_data;
	for(i = 0; icons[i].name; i++)
		if( strcmp(name,icons[i].name) == 0 ){
			*size = icons[i].size;
			return icons[i].data;
		}
	return 0;
}

char *getMssg(name,size)
	char *name;
	int *size;
{
	return getIcon(name,size);
}
scanIcons(name,func,arg1,arg2)
	char *name;
	int (*func)();
	char *arg1,*arg2;
{	EmbededFile *icons,*ef;
	int i;

	icons = builtin_data;
	for(i = 0; icons[i].name; i++){
		ef = &icons[i];
		if( strstr(ef->name,name) )
			(*func)(ef->name,ef->data,ef->size,arg1,arg2);
	}
}

char iSERVER_PROTO[32];
char iSERVER_HOST[256];
int  iSERVER_PORT;


extern char *getClientUserC();
extern char *HTTP_getRequestField();

char *strfConn(Conn,fmt,str)
	Connection *Conn;
	char *fmt,*str;
{	char *fp,*sp,*user,buff[1024],*dp;

	str[0] = 0;
	sp = str;
	for( fp = fmt; *fp; fp++ ){
		if( *fp != '%' ){
			*sp++ = *fp;
			continue;
		}
		if( *++fp == 0 )
			break;

		switch( *fp ){
		case '%':
			strcpy(sp,"%");
			break;

		case 'u':
			if( user = getClientUserC(Conn) )
				strcpy(sp,user);
			else	strcpy(sp,"-");
			break;

		case 'h':
			if( CLNT_HOST[0] )
				strcpy(sp,CLNT_HOST);
			else{
				getClientHostPort(Conn,sp);
				if( *sp == 0 )
					strcpy(sp,"-");
			}
			sp += strlen(sp);
			if( TeleportHost[0] ){
				*sp++ = '.';
				*sp++ = '-';
				*sp++ = '.';
				strcpy(sp,TeleportHost);
			}
			break;

		case 'i':
			gethostNAME(ClientSock,sp);
			break;

		case 'd':
			getClientHostPort(Conn,buff);
			if( dp = strrchr(buff,'.') )
				strcpy(sp,dp+1);
			else	strcpy(sp,buff);
			break;

		case 'a':
			getClientHostPortAddr(Conn,NULL,sp);
			break;

		case 'n':
			getClientHostPortAddr(Conn,NULL,buff);
			strNetaddr(buff,sp);
			break;

		case 'A':
			if( 0 <= find_CMAP(Conn,"authgen",buff) ){
				strfConn(Conn,buff,sp);
				if( strchr(buff,':') == 0 )
					strcat(buff,":");
			}
			break;

		case 'H':
			gethostname(sp,256);
			break;

		case 'M':
			strcpy(sp,DELEGATE_ADMIN);
			break;

		case 'O':
			getUsername(getuid(),sp);
			break;

		case 'F':
		case 'L':
		case 'D':
			if( HTTP_getRequestField(Conn,"From",buff,sizeof(buff)) ){
				switch( *fp ){
				case 'F': sscanf(buff,"%s",sp); break;
				case 'L': sscanf(buff,"%[^@]",sp); break;
				case 'D': sscanf(buff,"%*[^@]@%s",sp); break;
				}
			}
			if( *sp == 0 ) strcpy(sp,"-");
			break;

		case 'U':
		case 'P':
   if( HTTP_originalRequestField(Conn,"Proxy-Authorization",buff,sizeof(buff))
    || HTTP_originalRequestField(Conn,"Authorization",buff,sizeof(buff))
         || HTTP_getRequestField(Conn,"Authorization",buff,sizeof(buff)) ){
				char bauth[1024],xauth[1024];
				sscanf(buff,"Basic %s",bauth);
				str_from64(bauth,strlen(bauth),xauth,sizeof(xauth));
				switch( *fp ){
				case 'U': sscanf(xauth,"%[^:]",sp); break;
				case 'P': sscanf(xauth,"%*[^:]:%s",sp); break;
				}
			}
			if( *sp == 0 ) strcpy(sp,"-");
			break;

		case 'Q':
			if( HTTP_getRequestField(Conn,"Forwarded",buff,sizeof(buff)) )
			if( dp = strstr(buff," for ") )
				sscanf(dp+5,"%s",sp);
			if( *sp == 0 ) strcpy(sp,"-");
			break;
		}
		sp += strlen(sp);
	}
	*sp = 0;
	return sp;
}

extern char *Sprintf();
make_conninfo(Conn,conninfo,cfi)
	Connection *Conn;
	char *conninfo,*cfi;
{	char buff[1024],*sp;
	char *proto;

	sp = conninfo;
	proto = DFLT_PROTO;
	sp = Sprintf(sp,"Client-Protocol: %s\n",proto);
	sp = Sprintf(sp,"Server-Protocol: %s\n",REAL_PROTO);

	sp = strfConn(Conn,"Client-User-Ident: %u\n",sp);
	sp = strfConn(Conn,"Client-Host: %h\n",sp);
	sp = strfConn(Conn,"Client-Addr: %a\n",sp);
	sp = strfConn(Conn,"Client-User-Auth: %U\n",sp);

	sp = Sprintf(sp,"Server-Host: %s\n",DST_HOST);

	ClientIF_HP(Conn,buff);
	sprintf(sp,"Client-IF-Host: %s\n",buff);
	sp += strlen(sp);
}

fcloseLinger(fp)
	FILE *fp;
{
	fflush(fp);
	set_linger(fileno(fp),DELEGATE_LINGER);
	fcloseTIMEOUT(fp);
	set_linger(fileno(fp),0);
}

int	 IamPrivateMASTER       = 0;
int	 MASTERisPrivate        = 0 ;
int	 myPrivateMASTER        = 0 ;


#define WIN_PGROOT	"/Program Files"
#define WIN_DGROOT	"/Program Files/DeleGate"

#define DFLT_OWNER	"nobody"
#define DGROOT_GLOB	"/var/spool"
#define DGROOT_DFLT	"/tmp"
#define DGROOT_NAME	"delegate"

tryDGROOT(created,uid,gid,updir,fmt,a,b,c)
	int *created;
	char *updir,*fmt,*a,*b,*c;
{	char dir[1024],*env;
	int isdir,rwx;

	*created = 0;
	strcpy(dir,updir);
	if( *dir != 0 && strtailchr(dir) != '/' )
		strcat(dir,"/");
	sprintf(dir+strlen(dir),fmt,a,b,c);
	setOWNER(dir,uid,gid); /* this must be done beofre mkdirRX() */

	if( isdir = fileIsdir(dir) ){
		rwx = access_RWX(dir);
		if( rwx != 0 && getuid() == 0 && uid != 0 ){
			seteuid(uid);
			rwx = access_RWX(dir);
			seteuid(0);
		}
		if( rwx != 0 ){
fprintf(stderr,"-delegate[%d]- insufficient access right: DGROOT=%s\n",
getpid(),dir);
			isdir = 0;
		}
	}else
	if( File_is(dir) ){
		isdir = 0;
	}else
	if( isdir = (mkdirRX(dir) == 0) ){
		*created = 1;
	}
	if( isdir ){
		if( DELEGATE_DGROOT == 0 || strcmp(DELEGATE_DGROOT,dir) != 0 )
			DELEGATE_DGROOT = strdup(dir);
		if( env = DELEGATE_getEnv(P_DGROOT) )
		if( strcmp(env,dir) != 0 )
			DELEGATE_pushEnv(P_DGROOT,dir);
		if( File_uid(dir) != uid )
			setOWNER("",-1,-1);
		return 1;
	}
	return 0;
}

static int DGROOT_done;
setDGROOT(){
	char *umasks,*dgroot,*owner,*env;
	int umaski;
	char user[256],home[1024],shell[1024];
	int issu,withshell,uid,gid;
	int pid;
	int created = 0;

	pid = getpid();
	if( DGROOT_done == pid )
		return 0;
	DGROOT_done = pid;

	if( umasks = DELEGATE_getEnv(P_UMASK) ){
		umaski = -1;
		sscanf(umasks,"%o",&umaski);
		if( umaski != -1 ){
			umask(umaski);
		}
		/* can be umasks for directory, file, ... respectively */
	}

	if( dgroot = DELEGATE_getEnv(P_DGROOT)  ){
		DELEGATE_DGROOT = strdup(dgroot);
		if( *DELEGATE_DGROOT == 0 ){
			/* compatible with DeleGate/5.X and former */
			return 0;
		}
	}

	if( getuid() == 0 ){
		if( (owner = DELEGATE_getEnv(P_OWNER)) == 0 )
			owner = DFLT_OWNER;
		if( scan_guid(owner,&uid,&gid) == 0 ){
			getUsername(uid,user);
		}else{
			strcpy(user,DFLT_OWNER);
			uid = -1;
			gid = -1;
		}
	}else{
		uid = getuid();
		gid = getgid();
		getUsername(uid,user);
	}

	/*
	 * if DGROOT is defined explicitly, use it.
	 */
	dgroot = DELEGATE_DGROOT;
	if( dgroot != NULL && *dgroot != 0 ){
		if( tryDGROOT(&created,uid,gid,"","%s",dgroot) )
			return created;
fprintf(stderr,"-delegate[%d]- bad DGROOT=%s\n",getpid(),dgroot);
	}

	/*
	 * on Windows: \Program Files\DeleGate
	 */
	if( fileIsdir(WIN_PGROOT) ){
		DELEGATE_DGROOT = strdup(WIN_DGROOT);
		return created;
	}

	/*
	 * on Unix: $HOME/delegate
	 *          /var/spool/delegate/$OWNER
	 *          /tmp/delegate/$OWNER
	 */
	issu = (uid == 0 || gid == 0);
	withshell = getSHELL(uid,shell) && *shell != 0;
	if( !issu && withshell ){
		if( uid == getuid() && (env = DELEGATE_getEnv("HOME")) )
			strcpy(home,env);
		else	getHOME(uid,home);
		if( strcmp(home,"/") != 0 && fileIsdir(home) )
		if( tryDGROOT(&created,uid,gid,home,"%s",DGROOT_NAME) )
			return created;
	}

	if( tryDGROOT(&created,uid,gid,DGROOT_GLOB,"%s-%s",DGROOT_NAME,user) )
		return created;

	if( tryDGROOT(&created,uid,gid,DGROOT_DFLT,"%s-%s",DGROOT_NAME,user) )
		return created;

	return 0;
}


extern FILE *fopen_PATH();
extern char **vect_PATH();
static char **LIBPATHv;
static initLIBPATH(){
	char libpath[2048];

	if( LIBPATHv == 0 ){
		strcpy(libpath,DELEGATE_LIBPATH);
		DELEGATE_substfile(libpath,"",NULL,NULL,NULL);
		LIBPATHv = vect_PATH(libpath);
	}
}

FILE* fopenLIB(file,mode,xpath)
	char *file,*mode,*xpath;
{
	initLIBPATH();
	return fopen_PATH(LIBPATHv,file,mode,xpath);
}
fullpathLIB(path,mode,xpath)
	char *path,*mode,*xpath;
{	FILE *fp;

	initLIBPATH();
	if( fp = fopen_PATH(LIBPATHv,path,mode,xpath) ){
		fclose(fp);
		return 1;
	}
	return 0;
}
