/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1996-1999 Yutaka Sato
Copyright (c) 1996-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	cgi.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	960110	created
//////////////////////////////////////////////////////////////////////#*/
#include "delegate.h"
#include "http.h"
#include <ctype.h>
#include <errno.h>
#define MY_CGIVER	"1.1"

extern char EXEC_PATH[];
extern int main_argc;
extern char **main_argv;
extern char **environ;
extern char *HTTP_outCharset();
extern char *getFieldValue2();
#define getFieldValue(str,fld,buf,siz) getFieldValue2(str,fld,buf,siz)
#define getFV(str,fld,buf)             getFieldValue2(str,fld,buf,sizeof(buf))

static cgi_head2env(head,Evp)
	char *head;
	StrVec *Evp;
{	char field[0x1000];
	char accepts[2048],langs[256];
	char *fp,*np,*vp;

	accepts[0] = 0;
	langs[0] = 0;

	Strncpy(field,head,sizeof(field)-2);
	strcat(field,"\r\n");
	fp = field;

	while( np = strpbrk(fp,"\r\n") ){
		*np++ = 0;
		for( vp = fp; *vp; vp++ ){
			if( *vp == ':' ){
				*vp++ = 0;
				if( isspace(*vp) )
					vp++;
				break;
			}
			if( islower(*vp) )
				*vp = toupper(*vp);
			else
			if( *vp == '-' )
				*vp = '_';
		}
		if( strcmp(fp,"ACCEPT_LANGUAGE") == 0 ){
			if( langs[0] != 0 )
				strcat(langs,", ");
			strcat(langs,vp);
		}else
		if( strcmp(fp,"ACCEPT") == 0 ){
			if( accepts[0] != 0 )
				strcat(accepts,", ");
			strcat(accepts,vp);
		}else{
			SVaddEnvf(Evp,"HTTP_%s=%s",fp,vp);
		}
		fp = np;
		while( *fp == '\r' || *fp == '\n' )
			fp++;
	}

	if( accepts[0] ){
		SVaddEnvf(Evp,"HTTP_ACCEPT=%s",accepts);
	}
	if( langs[0] ){
		SVaddEnvf(Evp,"HTTP_ACCEPT_LANGUAGE=%s",langs);
	}
}

static char *cgienv;
scan_CGIENV(Conn,envlist)
	Connection *Conn;
	char *envlist;
{
	cgienv = strdup(envlist);
	return 0;
}

cgi_makeEnv(conninfo,req,head,vurl,vpath,datapath,scripturl,extrapath,av,Evp)
	char *conninfo;
	char *req,*head;
	char *vurl,*vpath,*datapath,*scripturl,*extrapath;
	char *av[];
	StrVec *Evp;
{	char *search;
	char *dp;
	char tmp[2048];
	int ac,ei;
	char *es;
	char *fp,*np,*vp;
	char auth[1024],atype[128],auserpass[256],auser[256];
	char method[128];
	char *randenv;

	randenv = 0;
	for( ei = 0; es = environ[ei]; ei++ ){
		if( strncmp(es,"RANDENV=",8) == 0 )
			randenv = es;
		else
		if( cgienv == NULL || strmatch_list(es,cgienv,"^=",NULL,NULL) )
			Evp->sv_ev[Evp->sv_ec++] = es;
	}

	atype[0] = auser[0] = 0;
	if( getFV(head,"Authorization",auth) ){
		HTTP_decompAuth(auth,atype,sizeof(atype),auserpass,sizeof(auserpass));
		sscanf(auserpass,"%[^:]",auser);
	}

	/* AUTH_TYPE */
	SVaddEnvf(Evp,"AUTH_TYPE=%s",atype);

	/* CONTENT_LENGTH */
	if( getFV(head,"Content-Length",tmp) == 0 )
		strcpy(tmp,"0");
	SVaddEnvf(Evp,"CONTENT_LENGTH=%d",atoi(tmp));

	/* CONTENT_TYPE */
	if( getFV(head,"Content-Type",tmp) == 0 )
		strcpy(tmp,"text/html");
	SVaddEnvf(Evp,"CONTENT_TYPE=%s",tmp);

	/* GATEWAY_INTERFACE */
	SVaddEnvf(Evp,"GATEWAY_INTERFACE=CGI/%s",MY_CGIVER);

	/* HTTP-* */
	cgi_head2env(head,Evp);

	/* PATH_INFO */
	es =
	SVaddEnvf(Evp,"PATH_INFO=%s",extrapath);
	if( es )
	if( search = strchr(es,'?') )
		*search = 0;

	/* PATH_TRANSLATED */
	SVaddEnvf(Evp,"PATH_TRANSLATED=%s",*extrapath?datapath:"");
	Verbose("PATH_TRANSLATED=%s\n",*extrapath?datapath:"");

	/* QUERY STRING */
	if( search = strchr(vpath,'?') )
		*search++ = 0;
	SVaddEnvf(Evp,"QUERY_STRING=%s",search?search:"");

	/* REMOTE_ADDR */
	/* REMOTE_HOST */
	/* REMOTE_IDENT */
	/* REMOTE_USER */
	getFieldValue(conninfo,"Client-Addr",tmp,sizeof(tmp));
	SVaddEnvf(Evp,"REMOTE_ADDR=%s",tmp);

	getFieldValue(conninfo,"Client-Host",tmp,sizeof(tmp));
	SVaddEnvf(Evp,"REMOTE_HOST=%s",tmp);

	getFieldValue(conninfo,"Client-User-Ident",tmp,sizeof(tmp));
	if( strcmp(tmp,"-") == 0 )
		tmp[0] = 0;
	SVaddEnvf(Evp,"REMOTE_IDENT=%s",tmp);

	SVaddEnvf(Evp,"REMOTE_USER=%s",auser);

	/* REQUEST_METHOD */
	wordScan(req,method);
	SVaddEnvf(Evp,"REQUEST_METHOD=%s",method);
	/* REQUEST_URL (extended for CFI) */
	SVaddEnvf(Evp,"REQUEST_URL=%s",vpath);
	SVaddEnvf(Evp,"REQUEST_URI=%s",vurl);

	/* SCRIPT_NAME */
	SVaddEnvf(Evp,"SCRIPT_NAME=%s",scripturl);

	/* SERVER_NAME */
	/* SERVER_PORT */
	/* SERVER_PROTOCOL */
	/* SERVER_SOFTWARE */
	{	char svhp[256],svhost[256];
		int svport;

		svhost[0] = 0;
		if( getFV(head,"Host",svhp) ){
			svport = 80;
			sscanf(svhp,"%[^:]:%d",svhost,&svport);
		}
		if( svhost[0] == 0 ){
			GetHostname(svhost,sizeof(svhost));
			svport = SERVER_PORT();
		}

		SVaddEnvf(Evp,"SERVER_NAME=%s",svhost);
		SVaddEnvf(Evp,"SERVER_PORT=%d",svport);
		SVaddEnvf(Evp,"SERVER_PROTOCOL=HTTP/%s",MY_HTTPVER);
		SVaddEnvf(Evp,"SERVER_SOFTWARE=DeleGate/%s",
				DELEGATE_ver());
	}
	if( randenv )
		Evp->sv_ev[Evp->sv_ec++] = randenv;
	Evp->sv_ev[Evp->sv_ec] = 0;

	if( av != NULL ){
		ac = 0;
		if( search ){
			fp = SPrintf(Evp->sv_MemF,"%s+",search);
			while( np = strchr(fp,'+') ){
				av[ac++] = fp;
				*np = 0;
				fp = np + 1;
			}
		}
		av[ac] = 0;
	}
/*
for( ei = 0; ei < ac; ei++ ) fprintf(stderr,"#### ARG[%2d] %s\n",ei,av[ei]);
for( ei = 0; ei < ec; ei++ ) fprintf(stderr,"#### ENV[%2d] %s\n",ei,ev[ei]);
*/
}

static cgi_response(Conn,req,ihead,in,out,stcodep)
	Connection *Conn;
	char *req,*ihead;
	FILE *in,*out;
	int *stcodep;
{	char ohead[0x10000],*hp;
	char ctype[1024],status[1024];
	char location[1024];
	char mimever[1024];
	char field[1024],value[1024];
	char line[1024],*tp;
	int hleng,bleng,cleng,hcc;
	char ostat[1024];
	char *xcharset;
	int codeconv;
	int headonly;
	int putConnection;
	Connection ConnBuff;

	if( Conn == NULL ){
		bzero(&ConnBuff,sizeof(Connection));
		Conn = &ConnBuff;
	}

	hp = ohead;
	xcharset = HTTP_outCharset(Conn);

	strcpy(status,"200 CGI-OK");
	location[0] = 0;
	if( getFV(ihead,"Content-Type",ctype) )
		rmField(ihead,"Content-Type");
	else	strcpy(ctype,"text/plain");
	strcpy(mimever,MY_MIMEVER);

	hcc = 0;
	cleng = -1;
	headonly = strncasecmp(req,"HEAD ",5) == 0;
	putConnection = 0;

	for(;;){
		if( fgets(line,sizeof(line),in) == NULL )
			break;
		hcc += strlen(line);

		if( tp = strpbrk(line,"\r\n") )
			*tp = 0;

		if( line[0] == 0 )
			break;

		if( strchr(line,':') == NULL )
		if( line[0] != ' ' && line[0] != '\t' )
			/* is folding supported in HTTP ? */
		{
			sv1log("NON header from CGI program? %s\n",line);
			break;
		}

		field[0] = value[0] = 0;
		sscanf(line,"%[^:]:%[^\r\n]",field,value);
		if( strcasecmp(field,"MIME-Version") == 0 ){
			lineScan(value,mimever);
			continue;
		}
		if( strcasecmp(field,"Status") == 0 ){
			lineScan(value,status);
			continue;
		}
		if( strcasecmp(field,"Location") == 0 ){
			lineScan(value,location);
			continue;
		}
		if( strcasecmp(field,"Content-Type") == 0 ){
			lineScan(value,ctype);
			continue;
		}
		if( strcasecmp(field,"Content-Length") == 0 )
			cleng = atoi(value);

		sprintf(hp,"%s\r\n",line);
		hp += strlen(hp);
	}
	if( hcc == 0 )
		return 0;

	sprintf(hp,"MIME-Version: %s\r\n",mimever);
	hp += strlen(hp);

	if( getFV(ihead,"Server",line) == NULL ){
		sprintf(hp,"Server: DeleGate/%s\r\n",DELEGATE_ver());
		hp += strlen(hp);
	}

	if( location[0] ){
		char server[256];
		strcpy(status,"302 Moved (output of CGI)");
		if( location[0] == '/' ){
			if( Conn )
				ClientIF_HP(Conn,server);
			else{
				sprintf(server,"%s:%s",
					getenv("SERVER_NAME"),
					getenv("SERVER_PORT"));
			}
			sprintf(hp,"Location: http://%s%s\r\n",server,location);
		}else	sprintf(hp,"Location: %s\r\n",location);
		hp += strlen(hp);
	}
	sprintf(ostat,"HTTP/%s %s\r\n",MY_HTTPVER,status);
	sprintf(hp,"Content-Type: %s\r\n",ctype);
	codeconv = strncasecmp(ctype,"text/",5) == 0 && xcharset != NULL;
	if( codeconv )
		replace_charset(hp,xcharset);
	hp += strlen(hp);

	if( atoi(status) == 304 )
		headonly = 1;

	if( stcodep )
		*stcodep = atoi(status);

	if( headonly
	 || 0 < cleng && file_size(fileno(in)) - ftell(in) == cleng ){
		if( Conn ){
			if( getKeepAlive(Conn,hp) ){
				putConnection = 1;
				hp += strlen(hp);
			}
		}
	}
	if( Conn ){
		if( !putConnection ){
			sprintf(hp,"Connection: close\r\n");
			hp += strlen(hp);
		}
	}

	strcpy(hp,ihead);
	hp += strlen(hp);
	strcpy(hp,"\r\n");

	fputs(ostat,out);
	fputs(ohead,out);
	hleng = strlen(ostat) + strlen(ohead);

	if( headonly ){
		bleng = 0;
	}else{
		if( codeconv )
			bleng = CCV_relay_text(Conn,in,out,NULL);
		else
		if( 0 < cleng )
			bleng = copyfile1(in,out);
		else	bleng = simple_relayf(in,out);
	}
	return hleng+bleng;
}
static putExecError(tcd,execpath)
	char *execpath;
{	FILE *tc;
	char *env;

	sv1log("#### FAILED EXEC: %s\n",execpath);
	if( env = getenv("PATH") )
		sv1log("#### PATH=%s\n",env);

	tc = fdopen(tcd,"w");
	fprintf(tc,"Status: 500 cannot execute\r\n");
	fprintf(tc,"Content-Type: text/plain\r\n");
	fprintf(tc,"\r\n");
	fprintf(tc,"Couldn't find or execte the CGI script.\r\n");
}
cgi_process(Conn,tc,execpath,workdir,av,ev,pfp)
	Connection *Conn;
	FILE *tc;
	char *execpath,*workdir;
	char *av[],*ev[];
	FILE *pfp[];
{	int toCGI[2],fromCGI[2];
	char **savenv;
	char savdir[1024];
	char savfds[2];
	int pid;
	FILE *cfp;
	char *cav[32],cab[1024],line[64];
	int cai;

	pipe(toCGI);
	pipe(fromCGI);
	setCloseOnExec(toCGI[1],1);
	setCloseOnExec(fromCGI[0],1);
	savenv = environ;
	environ = ev;

	sv1log("chdir(%s)\n",workdir);
	getcwd(savdir,sizeof(savdir));
	chdir(workdir);

	savfds[0] = dup(0); dup2(toCGI[0],0); close(toCGI[0]);
	savfds[1] = dup(1); dup2(fromCGI[1],1); close(fromCGI[1]);

	if( cfp = fopen(execpath,"r") ){
		fgets(line,sizeof(line),cfp);
		if( strncasecmp(line,"#!CGI-DeleGate",14) == 0 ){
/*
 * should pass access control parameters to control the access via CGI...
 */
			sprintf(cab,"+=%s",execpath);
			execpath = EXEC_PATH;
			cai = 0;
			cav[cai++] = execpath; 
			cav[cai++] = "-Fcgi";
			cav[cai++] = cab;
			cav[cai] = 0;
			av = cav;
		}
		fclose(cfp);
	}

	if( INHERENT_fork() ){
		if( (pid = Fork("CGI")) == 0 ){
		/* don't use Execvp() because it not returns even on error. */
			execvp(execpath,av);
			putExecError(1,execpath);
			Finish(-1);
		}
	}else{
		pid = SpawnvpDirenv("CGI",execpath,av);
		if( pid == -1 )
			putExecError(1,execpath);
	}

	dup2(savfds[0],0); close(savfds[0]);
	dup2(savfds[1],1); close(savfds[1]);
	environ = savenv;
	chdir(savdir);
	pfp[1] = fdopen(toCGI[1],"w");
	pfp[0] = fdopen(fromCGI[0],"r");
	return pid;
}

exec_cgi(Conn,req,reqhead,scriptpath,datapath,vurl,vpath,scripturl,extpath,fc,tc,stcodep)
	Connection *Conn;
	char *req,*reqhead,*scriptpath,*datapath;
	char *vurl,*vpath,*scripturl,*extpath;
	FILE *fc,*tc;
	int *stcodep;
{
	FILE *pfp[2];
	char oreq[2048];
	char tmp[128];
	int leng;
	char workdir[1024];
	char *tp;
	char *av[32],*ev[128],eb[0x10000];
	StrVec Env;
	char conninfo[4096];
	int pid;

	make_conninfo(Conn,conninfo,NULL);
	strcpy(workdir,datapath);
	if( tp = strrchr(workdir,'/') )
		*tp = 0;
	av[0] = scriptpath;

	SVinit(&Env,"exec_cgi",ev,128,eb,sizeof(eb));
	cgi_makeEnv(conninfo,req,reqhead,vurl,vpath,datapath,
		scripturl,extpath, &av[1],&Env);
	pid = cgi_process(Conn,tc,scriptpath,workdir,av,ev,pfp);

	if( getFV(reqhead,"Content-Length",tmp) ){
		int leng,rcc,wcc;
		char body[0x10000];

		leng = atoi(tmp);
		rcc = fread(body,1,leng,fc);
		wcc = fwrite(body,1,rcc,pfp[1]);
		fflush(pfp[1]);
		body[leng] = 0;
		sv1log("## Sent message body data to CGI %d/%d\n",wcc,rcc);
	}
	fclose(pfp[1]);
	leng = cgi_response(Conn,req,"",pfp[0],tc,stcodep);
	fclose(pfp[0]);

	if( 0 < pid ){
	    int xpid,start,ntry;

	    start = time(NULL);
	    for( ntry = 0; ; ntry++ ){
		xpid = NoHangWait();
		sv1log("Wait*%d CGI-program exit: %d / %d\n",ntry,xpid,pid);
		if( xpid == pid )
			break;
		if( 10 < start-time(NULL) ){
			sv1log("KILL CGI-program to exit[%d]: %d\n",ntry,pid);
			Kill(pid,1);
			Kill(pid,9);
		}
		if( xpid <= 0 )
			sleep(1);
	    }
	}
	return leng;
}

static dump(request)
	char *request;
{	int ei;
	char *env;

	printf("Content-Type: text/html\r\n\r\n");
	printf("<H2>DeleGate as a CGI program</H2>\n");
	printf("<PRE>\r\n");
	printf("%s\r\n",request);
	for( ei = 0; env = environ[ei]; ei++ )
		printf("%s\r\n",env);
	printf("</PRE>\r\n");
	fflush(stdout);
}

cgi_delegate(ac,av,Conn)
	char *av[];
	Connection *Conn;
{	char ei;
	char request[4096],*rp;
	char *env,*method,*url,*ver;
	char field[128],value[4096];
	char *host,*port,*path,server[1024],mount[1024],delegate[1024];
	char *leng,*type;
	char *query,qext[1024];
	char *chost,*caddr,*cuser;
	int fromHttpd[2],toHttpd[2];
	int wcc;

	method = getenv("REQUEST_METHOD");
	url = getenv("PATH_INFO");
	ver = getenv("SERVER_PROTOCOL");
	host = getenv("SERVER_NAME");
	port = getenv("SERVER_PORT");
	path = getenv("SCRIPT_NAME");
	query = getenv("QUERY_STRING");
	chost = getenv("REMOTE_HOST");
	caddr = getenv("REMOTE_ADDR");
	cuser = getenv("REMOTE_IDENT");

	if( method == 0 || host == 0 || port == 0 || path == 0 ){
		printf("Status: 500 CGI-DeleGate Error\r\n");
		return;
	}
	if( url == 0 ){
		printf("Status: 404 CGI-DeleGate Not Found\r\n");
		return;
	}

	/*
	 * CGI-DeleGate must be recognized as a directory as "xxx/"
	 * so that "yyy" in CGI-DeleGate is represented as "xxx/yyy"
	 */
	if( strtailchr(path) != '/' )
	if( url[0] == 0 ){
				sprintf(url,"http://%s",host);
				if( atoi(port) != 80 )
					sprintf(url+strlen(url),":%s",port);
				sprintf(url+strlen(url),"%s/",path);
				printf("Status: 302 moved\r\n");
				printf("Location: %s\r\n",url);
				printf("\r\n");
				return;
	}
	if( url[0] == 0 )
		url = "/";

	sv1log("CGI-DeleGate accepted: %s@%s[%s]\n",
		cuser?cuser:"-",chost?chost:"",caddr?caddr:"");

	Conn->from_myself = 1;
	ACT_SPECIALIST = 1;
	if( chost && chost[0] )
		strcpy(CLNT_HOST,chost);
	else	strcpy(CLNT_HOST,caddr);

	sprintf(server,"%s://%s:%s%s","http",host,port,path);
	scan_SERVER(Conn,server);

/*
	sprintf(mount,"http://%s:%s%s",host,port,path);
	set_MOUNT(Conn,"/-","=","");
	set_MOUNT(Conn,"/*",mount,"");
*/

	sprintf(delegate,"%s:%s",host,port);
	scan_DELEGATE(Conn,delegate);
	/*
	 * This cl_baseurl must used as the base URLpath for any absolute
	 * URLs in the response message (including URLs of built-in icons)
	 * put from this CGI-DeleGate...
	 */
	if( Conn->cl_baseurl[0] == 0 )/* can be set manually by BASEURL */
		set_BASEURL(Conn,path);

	/*
	if( strtailchr(Conn->cl_baseurl) == '/' )
		Conn->cl_baseurl[strlen(Conn->cl_baseurl)-1] = 0;
	 * cl_baseurl is expected to be without trailing '/' but the
	 * original SCRIPT_NAME can be ended with "/" when the CGI script
	 * is named like ../welcome.cgi (the / should be erased in the
	 * parent DeleGate??)
	 */

	rp = request;
	if( query && *query )
		sprintf(qext,"?%s",query);
	else	qext[0] = 0;

/* the response from this CGI-DeleGate must be in the version of the
 * client request, or must be converted to it by the caller HTTP server,
 * but it is not likely...
 */
if( strcmp(ver,"HTTP/1.1") == 0 ) ver = "HTTP/1.0";


	sprintf(rp,"%s %s%s %s\r\n",method,url,qext,ver?ver:"");
	rp += strlen(rp);

	for( ei = 0; env = environ[ei]; ei++ ){
		if( strncmp(env,"HTTP_",5) == 0 )
		if( sscanf(env+5,"%[^=]=%[^\n]",field,value) == 2 ){
			char *fp;

			for( fp = &field[1]; *fp; fp++ ){
				if( isupper(*fp) )
					*fp = tolower(*fp);
				if( *fp == '_' )
					*fp = '-';
			}
			if( strcasecmp(field,"Accept") == 0 ){
			}
			sprintf(rp,"%s: %s\r\n",field,value);
			rp += strlen(rp);
		}
	}

	/* dump(request); */

	/*
	 * Generate a HTTP request message header from CGI environment and
	 * relay it to the HTTP-DeleGate (acting as CGI-program) as if the
	 * requeset was sent from a usual HTTP client. It seems necessary
	 * to be a process to relay the body of a request message which may
	 * exist (POST method for example)
	 */
	Socketpair(fromHttpd);
	if( Fork("CGI-DeleGate-To") == 0 ){
		fclose(stdout);
		fclose(stderr);
		close(fromHttpd[0]);

		if( type = getenv("CONTENT_TYPE") ){
			sprintf(rp,"Content-Type: %s\r\n",type);
			rp += strlen(rp);
		}
		if( leng = getenv("CONTENT_LENGTH") ){
			sprintf(rp,"Content-Length: %s\r\n",leng);
			rp += strlen(rp);
		}
		strcpy(rp,"\r\n");
		write(fromHttpd[1],request,strlen(request));
		wcc = simple_relayTimeout(fileno(stdin),fromHttpd[1],1000);
		sv1log("CGI-DeleGate-To: relayed request body %d+%d bytes\n",
			strlen(request),wcc);
		Finish(0);
	}
	close(fromHttpd[1]);
	fclose(stdin);

	/*
	 * Relay a output from the HTTP-DeleGate to the server converting
	 * into the format of CGI output.
	 */
	Socketpair(toHttpd);
	if( Fork("CGI-DeleGate-From") == 0 ){
		char stat[1024],*rcode,head1[4096];
		FILE *resp;
		int ch,hcc,bcc;

		close(toHttpd[1]);
		resp = fdopen(toHttpd[0],"r");
		fgets(stat,sizeof(stat),resp);
		hcc = strlen(stat);
		bcc = 0;

		if( strncmp(stat,"HTTP/",5) == 0 ){
		   if( rcode = strchr(stat,' ') ){
			fprintf(stdout,"Status: %s",rcode);
			while( fgets(head1,sizeof(head1),resp) != NULL ){
				hcc += strlen(head1);

				if( strncasecmp(head1,"Location:",9) == 0 ){
/* should be reverse MOUNTed ...?
 * but it seems to be done in CGI-DeleGate with scan_DELEGATE() + BASEURL...
 */
					fputs(head1,stdout);
				}else
				if( strncasecmp(head1,"Content-Type",12)==0
				 || strncasecmp(head1,"Last-Modified",13)==0
				){
					fputs(head1,stdout);
				}else
				if( head1[0] == '\r' || head1[0] == '\n' ){
					fputs(head1,stdout);
					break;
				}
			}
		    }
		}else	fputs(stat,stdout);
		while( 0 < ready_cc(resp) ){
			if( (ch = getc(resp)) == EOF )
				break;
			putc(ch,stdout);
			bcc++;
		}
		fflush(stdout);

		bcc += simple_relay(toHttpd[0],fileno(stdout));
		sv1log("CGI-DeleGate-From: relayed response %d+%d bytes\n",hcc,bcc);
		Finish(0);
	}
	close(toHttpd[0]);
	fclose(stderr);
	fclose(stdout);

	execGeneralist(Conn,fromHttpd[0],toHttpd[1],-1);
	close(fromHttpd[0]);
	close(toHttpd[1]);
	LOG_flushall();

	/*
	 * wait() post processes to exit() not to finish before filtered output
	 * from post process drained.
	 */
	wait(0);
	wait(0);
}

form2v(form,maxargc,argv)
	char *form;
	char *argv[];
{	char *sp,*dp;
	int argc;

	sp = form;
	argc = 0;
	for(;;){
		argv[argc++] = sp;
		if( dp = strchr(sp,'&') )
			*dp++ = 0;
		nonxalpha_unescape(sp,sp,1);
		if( dp == 0 )
			break;
		sp = dp;
	}
	return argc;
}
HTTP_form2v(Conn,fc,maxargc,argv)
	Connection *Conn;
	FILE *fc;
	char *argv[];
{	char cLeng[1024],form[0x10000];
	int cleng,rcc;
	int argc,argi;

	HTTP_getRequestField(Conn,"Content-Length",cLeng,sizeof(cLeng));
	cleng = atoi(cLeng);

	argc = 0;
	form[0] = 0;
	if( 0 < cleng ){ /* && if Content-Type: x-form */
		rcc = fread(form,1,cleng,fc);
		form[rcc] = 0;
		argc = form2v(form,argc,argv);
	}
	argv[argc] = 0;
	return argc;
}

extern FILE *TMPFILE();
system_CGI(conninfo,oreq,req,head,cgi,in,out)
	char *conninfo,*oreq,*req,*head,*cgi;
	FILE *in,*out;
{	char *ev[128],eb[0x10000];
	FILE *tmp;
	char *xhead,*dp;
	char *url,*ourl;
	HttpRequest reqx,oreqx;
	char **oenv;
	StrVec Env;

	xhead = strdup(head);
	decomp_http_request(oreq,&oreqx);
	ourl = oreqx.hq_url;
	decomp_http_request(req,&reqx);
	url = reqx.hq_url;
	SVinit(&Env,"sysgem_CGI",ev,128,eb,sizeof(eb));
	cgi_makeEnv(conninfo,req,xhead,"",ourl,url,"","",NULL,&Env);

	oenv = environ;
	environ = ev;

	tmp = TMPFILE("CFI-system_CGI");
	System(cgi,in,tmp);
	environ = oenv;
	fseek(tmp,0,0);
	if( dp = strstr(head,"\r\n\r\n") )
		dp[2] = 0;
	if( dp = strstr(head,"\n\n") )
		dp[1] = 0;
	cgi_response(NULL,req,head,tmp,out,NULL);
	fclose(tmp);

	free(xhead);
}
