/*///////////////////////////////////////////////////////////////////////
Copyright (c) 1995-1999 Electrotechnical Laboratry (ETL), AIST, MITI
Copyright (c) 1995-1999 Yutaka Sato

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	resolv.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	950817	created
//////////////////////////////////////////////////////////////////////#*/

#include <stdio.h>
#include "ystring.h"
#include "vsocket.h"
#include "dns.h"
extern char *VSA_ntoa();

#define MAX_NS		10
#define MAX_NS_PARA	 1
#define MAX_RETRY	 2	/* retry for each server */
int RSLV_TIMEOUT1 =	 2;	/* timeout for current request packet */
int RSLV_TIMEOUT =	30;
int RSLV_INV_TIMEOUT =   6;

#define typemask(type)	(1<<type)

int RSLV_TIMEDOUT;

static char *SYM_TYPE[] = {
	"TYPE=0?",	"A",		"NS",		"MD",
	"MF",		"CNAME",	"SOA",		"MB",
	"MG",		"MR",		"NULL",		"WKS",
	"PTR",		"HINFO",	"MINFO",	"MX",
	"TXT",		"TYPE=17?",	"TYPE=18?",	"TYPE=19?",
	"XPTR",		"TYPE=21?",	"TYPE=22?",	"TYPE=23?",
};
#define symTYPE(class)  (class<=20 ? SYM_TYPE[class]:(class==255 ? "QALL":"?"))

static char *SYM_RCODE[] = {
	"No-error",	"Format-error",	"Server-failure", "Name-error",
     "Not-implemented",	"Refused",	"Error-6",	"Error-7",
	"Error-8",	"Error-9",	"Error-A",	"Error-B",
	"Error-C",	"Error-D",	"Error-E",	"Error-F",
};
static char *SYM_RR[] = {
	"RR=0?",
	"ANS",
	"SER",
	"ADD",
};
static char *SYM_CLASS[] = {
	"CLASS=0?",
	"IN",
	"CS",
	"CH",
	"HS",
};
#define symCLASS(class)	(class<=4?SYM_CLASS[class]:"CLASS-X")

static octet *makeHeader(head,id,qr,opcode,aa,tc,rd,ra,z,rcode,qdc,anc,nsc,arc)
	octet *head;
{
	head[ 0] = (id>>8) & 0xFF;
	head[ 1] = id & 0xFF;
	head[ 2] = (qr << 7) | (opcode << 3) | (aa << 2) | (tc << 1) | rd;
	head[ 3] = (ra << 7) | (z << 4) | rcode;
	head[ 4] = (qdc >> 8) & 0xFF;
	head[ 5] = qdc & 0xFF;
	head[ 6] = (anc >> 8) & 0xFF;
	head[ 7] = anc & 0xFF;
	head[ 8] = (nsc >> 8) & 0xFF;
	head[ 9] = nsc & 0xFF;
	head[10] = (arc >> 8) & 0xFF;
	head[11] = arc & 0xFF;
	return &head[12];
}
static octet *scanHeader(head,Hp)
	octet *head;
	Header *Hp;
{	octet *hp;

	hp = head;
	getShort(hp,Hp->id);
	getShort(hp,Hp->M);
	getShort(hp,Hp->qdcount);
	getShort(hp,Hp->ancount);
	getShort(hp,Hp->nscount);
	getShort(hp,Hp->arcount);
	return &head[12];
}
static octet *dumpHeader(head,Hp)
	octet *head;
	Header *Hp;
{	octet *mp,buf[1024];
	int M;

	mp = scanHeader(head,Hp);
	M = Hp->M;
	sprintf(buf,
	"ID=%d FLAGS=%08x QR=%d Opcode=%d AA=%d TC=%d RD=%d RA=%d Z=%d RCODE=%d ",
		Hp->id,
		M,
		H_QR(M),
		H_OPCODE(M),
		H_AA(M),
		H_TC(M),
		H_RD(M),
		H_RA(M),
		H_Z(M),
		H_RCODE(M)
	);
	sprintf(buf+strlen(buf),"QD=%d AN=%d NS=%d AR=%d",
		Hp->qdcount,
		Hp->ancount,
		Hp->nscount,
		Hp->arcount
	);
	debug(DBG_HEAD,"%s\n",buf);
	return mp;
}

static octet *putName(qp,name)
	octet *qp,*name;
{	octet *np;
	octet label[255],*lp;

	for( np = name; *np; np++ ){
		lp = label;
		if( *np == '.' ){
			debug(DBG_ANY,"FATAL ERROR: empty label [%s]\n",name);
			return NULL;
		}
		while( *np && *np != '.' )
			*lp++ = *np++;
		*lp = 0;
		*qp++ = strlen(label);
		strcpy(qp,label);
		qp += strlen(qp);
		if( *np == 0 )
			break;
	}
	*qp++ = 0;
	return qp;
}
static octet *makeQuestion(question,name,type,class)
	octet *question,*name;
{	octet *qp;

	qp = question;
	qp = putName(qp,name);
	if( qp == NULL )
		return NULL;

	*qp++ = 0xFF & (type >> 8);
	*qp++ = 0xFF & type;
	*qp++ = 0xFF & (class >> 8);
	*qp++ = 0xFF & class;
	return qp;
}
static octet *scanName(msg,sp,name,lev)
	octet *msg,*sp;
	char *name;
{	char *np;
	int len,low,off,here;

	np = name;
	while( len = *sp++ ){
		if( len & 0xC0 ){
			/* This is a pointer (2 bytes).  First 2 bits should
			 * be one (11) in a pointer. 10 and 01 combinations
			 * are reserved for future use.
			 */
			if( (len & 0xC0) != 0xC0 ){
debug(DBG_ANY,"### bad pointer(%d): %x: %x\n",lev,here,len);
				sprintf(np,"BAD-POINTER-%x",len);
				np += strlen(np);
				break;
			}
			low = *sp++;
			off = ((len & 0x3F) << 8) | low;

			here = sp - msg;
			if( here <= off ){
debug(DBG_ANY,"### bad pointer(%d): %d <= %d: %x %x\n",lev,here,off,len,low);
				sprintf(np,"BAD-POINTER-%x-%x",len,low);
				np += strlen(np);
				break;
			}
			scanName(msg,&msg[off],np,lev+1);
			return sp;
		}else{
/*
			strncpy(np,sp,len);
*/
			bcopy(sp,np,len);
			np += len;
			sp += len;
			if( *sp != 0 )
				*np++ = '.';
		}
	}
	*np = 0;
	return sp;
}
static octet *scanQuery(msg,question,name,typep,classp)
	octet *msg,*question,*name;
	int *typep,*classp;
{	octet *qp;

	qp = question;
	qp = scanName(msg,qp,name,0);
	getShort(qp,*typep);
	getShort(qp,*classp);
	return qp;
}
static octet *dumpQuestion(qdi,msg,question)
	octet *msg,*question;
{	octet *qp;
	octet name[512];
	int type,class;
	int nid;

	qp = scanQuery(msg,question,name,&type,&class);

	nid = DNS_putbyname(name);
	debug(DBG_NS,"QUE[%2d]%8s: <%d>%s %s %s\n",
		qdi,"",nid,name,symCLASS(class),symTYPE(type));
	DNS_putbyname(name);
	return qp;
}

static hexd(fmt,col,str,len)
	char *fmt;
	octet *str;
{	int i;
	for( i = 0; i < len; i++ ){
		if( (i % col) == 0 ){
			if( i != 0 )
				debug(DBG_ALL,"\n");
			debug(DBG_ALL,"%6d: ",i);
		}
		debug(DBG_ALL,fmt,str[i]);
	}
	debug(DBG_ALL,"\n");
}
static octet *dumpResourceRecord(whatx,rri,msg,size,rr)
	octet *msg,*rr;
{	octet name[512],rname[512];
	octet *mp;
	int type,class,ttl,rdlength;
	char *what,*stype,*sclass;
	int nid,rnid;
	char addr[32];
	char *rp,rdata[512];
	int pref;

	what = SYM_RR[whatx];
	if( msg+size <= rr ){
		debug(DBG_ANY,"### %s[%2d]: %d >= size %d\n",
			what,rri,rr-msg,size);
		return 0;
	}

	mp = scanName(msg,rr,name,0);
	nid = DNS_putbyname(name);

	getShort(mp,type);
	getShort(mp,class);
	getLong(mp,ttl);
	getShort(mp,rdlength);

	if( type <= 0 || 16 < type || class <= 0 ||  4 < class ){
debug(DBG_ANY,"### %s[%2d]%8d: <%d>%d class=%x type=%x\n",
	what,rri,ttl,nid,name,class,type);
		return 0;
	}

	stype = symTYPE(type);
	sclass = symCLASS(class);

	debug(DBG_RR,"%s[%2d]%8d: <%d>%s %s %s\n",
		what,rri,ttl,nid,name,sclass,stype);

	rnid = 0;

	rp = rdata;
	*rp++ = type;
	*rp++ = class;

	switch( type ){
	    case TY_A:
		sprintf(addr,"%d.%d.%d.%d",mp[0],mp[1],mp[2],mp[3]);
		rnid = DNS_putbyaddr(addr);
		*rp++ = mp[0];
		*rp++ = mp[1];
		*rp++ = mp[2];
		*rp++ = mp[3];
		DNS_putattr(nid,typemask(type),ttl,rdata,6);
		debug(DBG_RR,"<%d>%d.%d.%d.%d\n",
			rnid,mp[0],mp[1],mp[2],mp[3]);
		break;

	    case TY_MX:
	    case TY_NS: case TY_CNAME: case TY_PTR:
		if( type != TY_MX )
			scanName(msg,mp,rname,0);
		else	scanName(msg,mp+2,rname,0);

		rnid = DNS_putbyname(rname);
		*rp++ = 0xFF & (rnid >> 24);
		*rp++ = 0xFF & (rnid >> 16);
		*rp++ = 0xFF & (rnid >>  8);
		*rp++ = 0xFF & (rnid >>  0);
		if( type == TY_MX ){
			*rp++ = mp[0];
			*rp++ = mp[1];
		}
		DNS_putattr(nid,typemask(type),ttl,rdata,6);
		debug(DBG_RR,"%s <%d>%s\n",name,rnid,rname);
		break;
	    case TY_SOA:
{
char mname[512],rname[512];
int serial,refresh,retry,expire,minimum;
		scanName(msg,mp,mname,0);
		scanName(msg,mp,rname,0);
		getLong(mp,serial);
		getLong(mp,refresh);
		getLong(mp,retry);
		getLong(mp,expire);
		getLong(mp,minimum);
		debug(DBG_RR,"%s %s %d %d %d %d %d\n",mname,rname,
			serial,refresh,retry,expire,minimum);
}
		break;
	    default:
		if( debug(DBG_RR,"[%d]\n",rri) )
			/*hexd("[%d]",16,mp,rdlength)*/;
		break;
	}
	mp += rdlength;
	return mp;
}

/*
 *	Name Servers
 */

static VSAddr Me;

static makeMysock()
{	int len;
	int rcode;
	int mysock;

	mysock = socket(AF_INET,SOCK_DGRAM,0);
	if( mysock < 0 ){
		debug(DBG_FORCE,"RESOLVY cannot get socket() [errno=%d]\n",
			errno);
		return mysock;
	}
	len = VSA_atosa(&Me,0,"0.0.0.0");
	rcode = bind(mysock,(SAP)&Me,len);
	len = sizeof(Me);
	getsockname(mysock,(SAP)&Me,&len);
	debug(DBG_ANY,"DNS port = %d/udp\n",VSA_port(&Me));
	return mysock;
}

static RR_isin(v1,rrv,rri)
	octet *v1;
	octet *rrv[];
{	int ri,vi,leng;
	octet *r1;

	for( ri = 0; ri < rri; ri++ ){
		r1 = rrv[ri];
		if( r1 == v1 )
			return 1;

		if( r1[0] == TY_A ){
			leng = 2+4;
			for( vi = 0; vi < leng; vi++ )
				if( r1[vi] != v1[vi] )
					break;
			if( vi == leng )
				return 1;
		}
	}
	return 0;
}

static int Phase;
static lookupCache(nid,qtype,rri,rrc,rrv)
	octet *rrv[];
{	char dname[512],cdname[512];
	octet *av[128];
	octet *a1,*ap;
	int ac,ai;
	int ival;
	int type,class;
	int cnid;

	++Phase;
	DNS_nodephase(nid,Phase);
	DNS_nodename(nid,dname);
	ac = DNS_getattr(nid,typemask(qtype)|typemask(TY_CNAME),0,128,av);
	if( 0 < ac ){
		debug(DBG_CACHE,"lookup <%d>%s [%d]\n",nid,dname,ac);
		for( ai = 0; ai < ac; ai++ ){
			a1 = av[ai];
			type = *a1++;
			class = *a1++;
			ap = a1;
			getLong(ap,ival);

			if( RR_isin(av[ai],rrv,rri) ){
				debug(DBG_ANY,"[%d][%d] ignore duplicate RR\n",
					rri,ai);
				continue;
			}

			if( type == TY_A ){
				debug(DBG_CACHE,"[%d] A %d.%d.%d.%d\n",
					ai,a1[0],a1[1],a1[2],a1[3]);
				rrv[rri++] = av[ai];
			}else
			if( type == TY_PTR ){
				DNS_nodename(ival,dname);
				debug(DBG_CACHE,"[%d] PTR %s\n",ai,dname);
				rrv[rri++] = av[ai];
			}else
			if( type == TY_CNAME ){
				DNS_nodename(ival,cdname);
				if( DNS_nodephase(ival,Phase) == Phase ){
				debug(DBG_ANY,"LOOP[%d] in CNAME: %s -> %s\n",
						Phase,dname,cdname);
					continue;
				}
				debug(DBG_CACHE,"[%d] CNAME %s\n",ai,cdname);
				rrv[rri++] = av[ai];
				cnid = DNS_getbyname(cdname);
				rri = lookupCache(cnid,qtype,rri,rrc,rrv);
			}else
			if( type == TY_MX ){
				DNS_nodename(ival,dname);
				debug(DBG_CACHE,"[%d] MX %s\n",ai,dname);
				rrv[rri++] = av[ai];
			}
		}
	}
	return rri;
}

set_nameserver(domain,addr)
	char *domain,*addr;
{	unsigned int nsnid,nsanid;
	octet rdata[6];
	unsigned int iaddr;

	nsnid = DNS_putbyname(domain);
	nsanid = DNS_putbyaddr(addr);
	rdata[0] = TY_NS;
	rdata[1] = CL_IN;
	rdata[2] = nsanid>>24;
	rdata[3] = nsanid>>16;
	rdata[4] = nsanid>>8;
	rdata[5] = nsanid;
	DNS_putattr(nsnid,typemask(TY_NS),3600,rdata,6);

	iaddr = inet_addrV4(addr);
	rdata[0] = TY_A;
	rdata[1] = CL_IN;
	rdata[2] = iaddr>>24;
	rdata[3] = iaddr>>16;
	rdata[4] = iaddr>>8;
	rdata[5] = iaddr;
	DNS_putattr(nsanid,typemask(TY_A),3600,rdata,6);
}

static getns1(nid,nsx,nsc,nservv)
	VSAddr *nservv;
{	VSAddr *ns;
	octet *nsv[32],*nsav[32],*ap;
	int nns,nsi,na;
	int nsnid;
	int addr;

	char dname[512],sname[512];

	DNS_nodename(nid,dname);
	nns = DNS_getattr(nid,typemask(TY_NS),0,32,nsv);

	for( nsi = 0; nsi < nns; nsi++ ){
		ap = nsv[nns-1-nsi];
		ap += 2;
		getLong(ap,nsnid);
		DNS_nodename(nsnid,sname);

		if( na = DNS_getattr(nsnid,typemask(TY_A),0,32,nsav) ){
			ap = nsav[0];
			ap += 2;

if( strcmp(".",dname) != 0 )
debug(DBG_NS,"        %s[%d] server=<%s %s[%d.%d.%d.%d]>\n",
dname,nsi,dname,sname,ap[0],ap[1],ap[2],ap[3]);

			ns = &nservv[nsx++];
			VSA_btosa(ns,AF_INET,ap,53);
			getLong(ap,addr);
			if( nsc <= nsx )
				break;
		}else{
			debug(DBG_ANY,"%s[%d] cannot get address of %s\n",
				dname,nsi,sname);
		}
	}
	return nsx;
}
static getns(nid,nsc,nservv)
	VSAddr *nservv;
{	int nsx,nsi;
	int dnid;

	nsx = 0;
/*
	if( dnid = DNS_getbyname(RES_NSDOM0) )
		nsx = getns1(dnid,nsx,nsc,nservv);
*/
	/* recursive servers ? first */
	for( nsi = 0; ;nsi++ ){
		VSAddr *ns;

		ns = &nservv[nsx];
		if( RES_getns1(nsi,ns) == 0 )
			break;
		if( VSA_port(ns) == 0 ) /* under initialization ? */
			continue;

		debug(DBG_NS,"        %s[%d] server=<%s [%s:%d]>\n",
			RES_NSDOM0,nsx,RES_NSDOM0,
			VSA_ntoa(ns),VSA_port(ns));
		nsx++;
	}

	while( nid ){
		nsx = getns1(nid,nsx,nsc,nservv);
		nid = DNS_parent(nid);
	}
	return nsx;
}

extern char resolv_errmsg[512];
static dumpResponse(qidbase,resp,rc,hp,addr)
	octet *resp;
	Header *hp;
	char *addr;
{	octet *mp;
	char qname[1024];
	int nqd,qdi,rri;

	mp = dumpHeader(resp,hp);
	if( hp->id < qidbase )
		debug(DBG_NS,"OBSOLETE[%d<%d]from[%s]\n",hp->id,qidbase,addr);

	qname[0] = 0;
	if( nqd = hp->qdcount ){
		for( qdi = 0; qdi < nqd; qdi++ ){
			scanName(resp,mp,qname,0);
			mp = dumpQuestion(qdi,resp,mp);
		}
	}
	for( rri = 0; mp && rri < hp->ancount; rri++ )
		mp = dumpResourceRecord(RR_ANSWER,rri,resp,rc,mp);
	for( rri = 0; mp && rri < hp->nscount; rri++ )
		mp = dumpResourceRecord(RR_SERVER,rri,resp,rc,mp);
	for( rri = 0; mp && rri < hp->arcount; rri++ )
		mp = dumpResourceRecord(RR_ADDITIONAL,rri,resp,rc,mp);

resolv_errmsg[0] = 0;
if( addr[0] )
	sprintf(resolv_errmsg,"recv[%s](%d) ",addr,rc);
sprintf(resolv_errmsg+strlen(resolv_errmsg),
"Q[%s] ID=%d/%d AA=%d RD=%d RA=%d RCODE=%d ans,ns,add=%d,%d,%d",
qname, hp->id,qidbase,
H_AA(hp->M),H_RD(hp->M),H_RA(hp->M),H_RCODE(hp->M),
hp->ancount,hp->nscount,hp->arcount);

	debug(DBG_NS,"%s\n",resolv_errmsg);
	return hp->ancount + hp->nscount + hp->arcount;
}
static recvResponse(mysock,qidbase,from,hp)
	VSAddr *from;
	Header *hp;
{	int fromlen;
	int rc;
	octet *mp;
	octet resp[2048];
	char addr[64];

	fromlen = sizeof(*from);
rc = SOCKS_recvfrom(mysock,(char*)resp,sizeof(resp),0,(SAP)from,&fromlen);
	if( rc <= 0 )
		return -1;
	if( fromlen <= 0 ){
		debug(DBG_FORCE,"recvResponse(%d): rc=%d fromlen=%d\n",
			mysock,rc,fromlen);
		return -1;
	}
	strcpy(addr,VSA_ntoa(from));
	return dumpResponse(qidbase,resp,rc,hp,addr);
}

static int QID;
static int ownerPID;
static int mysock0;			/* background servers */
static int mysocks[MAX_NS_PARA];	/* connected to each foreground server 
					 * to detect UNREACHABLE error on recv
					 */

initDNSconn(){
	int mypid;
	int nsi,mysock1;

	mypid = getpid();
	if( ownerPID == mypid )
		return mysock0;

	if( ownerPID != 0 ){
		debug(DBG_NS,"initDNSconn(): previous pid=%d close",
			ownerPID);
		close(mysock0);
		SOCKS_udpclose(mysock0);
		for( nsi = 0; nsi < MAX_NS_PARA; nsi++ ){
			mysock1 = mysocks[nsi];
			close(mysock1);
			SOCKS_udpclose(mysock1);
			debug(DBG_NS,"(%d)",mysock1);
		}
		debug(DBG_NS,"\n");
	}

	debug(DBG_NS,"initDNSconn(): pid=%d\n",mypid);
	ownerPID = mypid;
	QID = 0;

	mysock0 = makeMysock();
	if( mysock0 < 0 )
		return mysock0;
	setCloseOnExec(mysock0);
	for( nsi = 0; nsi < MAX_NS_PARA; nsi++ ){
		mysock1 = mysocks[nsi] = makeMysock();
		setCloseOnExec(mysock1);
	}
	return mysock0;
}

int RES_BACKGROUND = 1;

getRRbynameaddr(timeout,name,qtype,rrc,rrv)
	octet *name;
	char *rrv[];
{	int wc;
	int nid;
	int nhit;
	VSAddr servers[128],*ns,*xns;
	VSAddr qservers[128],qns;
	int qserverx[128],npns,pnsi,ntry;
	VSAddr rservers[128],rns;
	int salen;
	int nns,nsi,sns,nque,nrns,rnsi;
	int nsent,nrecv;
	int qidbase;
	char qbuf[1024];
	octet *qp;
	int qlen;
	int start;
	int mysock1;
	int timeout1;
	int fds[MAX_NS_PARA+1];
	int rdv[MAX_NS_PARA+1]; 
	VSAddr cns[MAX_NS_PARA+1];
	int resps[MAX_NS_PARA+1],nresp;
	Header Head;
	int M,gotAA;
	int gotRecovErr; /* got recoverable errors */

	nid = DNS_putbyname(name);
	if( nhit = lookupCache(nid,qtype,0,rrc,rrv) )
		goto EXIT;

	if( initDNSconn() < 0 )
		goto EXIT;

	qidbase = ++QID;
	qp = makeHeader(qbuf,QID, 0,O_QUERY,0,0,1,0,0,0, 1,0,0,0);
	qp = makeQuestion(qp,name,qtype,CL_IN);
	if( qp == NULL )
		goto EXIT;

	qlen = (char*)qp - qbuf;

dumpHeader(qbuf,&Head);
dumpQuestion(0,qbuf,qbuf+12);

	gotAA = 0;
	gotRecovErr = 0;
	npns = 0;
	nrns = 0;
	nque = 0;
	nhit = 0;
	nsent = nrecv = 0;

	start = time(0);
	for(;;){
		debug(DBG_NS,"queries=%d responses=%d\n",nque,nrns);

		if( nhit = lookupCache(nid,qtype,0,rrc,rrv) )
			goto EXIT;

		if( gotRecovErr ){
			debug(DBG_NS,"ERR=%d AA=%d\n",gotRecovErr,gotAA);
			if( 2 < gotRecovErr )
				goto EXIT;
			/* leave a small chance to avoid a mad server */
			timeout = RSLV_TIMEOUT1;
		}else
		if( gotAA ){
			debug(DBG_NS,"AA got (%d).\n",gotAA);
			goto EXIT;
		}
		if( timeout < (time(0) - start) ){
			debug(DBG_NS,"TIMEOUT: %d\n",timeout);
			break;
		}
		if( MAX_NS <= nrns ){
			debug(DBG_NS,"MAX_NS: %d <= %d\n",MAX_NS,nrns);
			break;
		}

		nns = getns(nid,128,servers);
		if( nns <= 0){
			debug(DBG_NS,"no server\n");
			break;
		}

		fds[0] = mysock0;
		sns = 0;
		for( nsi = 0; nsi<nns && sns<MAX_NS_PARA; nsi++ ){
			xns = ns = &servers[nsi];
			for( rnsi = 0; rnsi < nrns; rnsi++ ){
				if( VSA_comp(xns,&rservers[rnsi]) == 0 )
					goto NEXT;
			}
			for( pnsi = 0; pnsi < npns; pnsi++ ){
			    if( VSA_comp(xns,&qservers[pnsi]) == 0 ){
				ntry = qserverx[pnsi];
				qserverx[pnsi] += 1;
				if( MAX_RETRY <= ntry ){
if( RES_BACKGROUND )
if( ntry == MAX_RETRY ){
ns = &qservers[pnsi];
salen = VSA_size(ns);
SOCKS_sendto(mysock0,qbuf,qlen,0,(SAP)ns,salen);
debug(DBG_NS,"sent BACKGROUND, ID=%d, sent=%d, recv=%d, time=%d, %s\n",
QID,nsent,nrecv,time(0)-start,VSA_ntoa(ns));
}
					goto NEXT;
				}
				break;
			    }
			}
			if( pnsi == npns ){
				qservers[pnsi] = *ns;
				qserverx[pnsi] = 1;
				npns++;
			}

			fds[sns+1] = mysock1 = mysocks[sns];
			cns[sns+1] = *ns;
			nque++;
			qns = *ns;
salen = VSA_size(ns);
wc = SOCKS_sendto(mysock1,qbuf,qlen,0,(SAP)ns,salen);
			sns++;
			nsent++;

			if( wc < 0 )
				qserverx[pnsi] = MAX_RETRY;

			debug(DBG_NS,"sent[%s] (%d) put=%d ID=%d\n",
				VSA_ntoa(ns),qserverx[pnsi],wc,
				QID);
		NEXT:;
		}

		timeout1 = RSLV_TIMEOUT1;
		if( sns == 0 ){
			int remain;
			remain = timeout - (time(0) - start);
			if( 0 < nque && 0 < remain ){
				timeout1 = remain;
				debug(DBG_NS,"no more server, wait %dsec.\n",
					remain);
			}else{
				debug(DBG_NS,"no more server, %d %d\n",
					remain,nque);
				break;
			}
		}

		nresp = 0;
		for( nsi = 0; nsi < sns+1; nsi++ )
			resps[nsi] = 0;

		for( nsi = 0; nsi < nque; nsi++ ){ 
			int nready, fdi;
			int nans;
			int timeout;

			timeout = 1;
			for( fdi = 0; fdi < sns+1; fdi++ ){
				if( resps[fdi] == 0 ){
					timeout = timeout1 * 1000;
					break;
				}
			}
			nready = PollIns(timeout,sns+1,fds,rdv);
			if( nready <= 0 ){
				RSLV_TIMEDOUT = 1;
				break;
			}

			for( fdi = 0; fdi < sns+1; fdi++ ){
			    if( 0 < rdv[fdi] ){
				resps[fdi] = 1;
				nans=recvResponse(fds[fdi],qidbase,&rns,&Head);

if( 0 <= nans && Head.id < qidbase ){
	debug(DBG_NS,"ignore result for former query (%d / %d)\n",
		Head.id, qidbase);
	continue;
}
				nrecv++;

if( fdi == 0 )
debug(DBG_NS,"recv BACKGROUND, ID=%d/%d, sent=%d, recv=%d, time=%d, %s\n",
Head.id,qidbase, nsent,nrecv,time(0)-start,VSA_ntoa(&rns));

				if( nans < 0 ){
					rns = cns[fdi];
					debug(DBG_NS,"unreachable ? %s\n",
						VSA_ntoa(&rns));
				}else{
				    M = Head.M;
				    if( H_AA(M) )
					gotAA++;

				    if( H_AA(M) || H_RD(M) && H_RA(M) ){
					if( H_RCODE(M) == 3 ){
						debug(DBG_NS,"Non-existing domain.\n");
						goto EXIT;
					}
					if( H_RCODE(M) == 0 && nans == 0 ){
						debug(DBG_NS,"Nothing.\n");
						if( H_AA(M) )
							gotRecovErr += 2;
						else	gotRecovErr += 1;
					}
				    }
				}

				nresp++;
				if( nhit = lookupCache(nid,qtype,0,rrc,rrv) )
					goto EXIT;
				rservers[nrns++] = rns;
			    }
			}
		}
		nque -= nresp;
	}
EXIT:
	return nhit;
}

gethostbynameaddr_dns(name,qtype,rrc,rrv,rrb,cname)
	octet *name,*rrv[],*rrb;
	char *cname;
{	octet *rp;
	int rri,rro;
	int ival;
	char dname[512];
	octet *rrp;
	int start;
	int timeout;
	int type;
	int mx,nmx,mxi,rmx;
	octet *mxv[64];

	mx = qtype == TY_A && strncmp(name,"-MX.",4) == 0;
	if( mx ){
		name += 4;
		nmx = gethostbynameaddr_dns(name,TY_MX,rrc,rrv,rrb,cname);
		/* multiple MXs should be sorted by their preference...
		 * - returned in -PREFERENCE-VALUE.mx-host.domain
		 * - sort 
		 * - remove "-PREFERENCE-VALUE."
		 */
		if( nmx == 0 && cname[0] != 0 ){
			/* not MX but CNAME is cached */
			char cn[512];
			strcpy(cn,cname);
			cname[0] = 0;
			nmx = gethostbynameaddr_dns(cn,TY_MX,rrc,rrv,rrb,cname);
		}
		if( nmx <= 0 )
			return gethostbynameaddr_dns(name,qtype,rrc,rrv,rrb,cname);

		for( mxi = 0; mxi < nmx; mxi++ )
			mxv[mxi] = rrv[mxi];
		rmx = 0;
		rrp = rrb;
		for( mxi = 0; mxi < nmx; mxi++ ){
			rmx += gethostbynameaddr_dns(mxv[mxi],TY_A,
				rrc-rmx,rrv+rmx,rrp,NULL);
			rrp = rrv[rmx+1];
		}
		return rmx;
	}

	start = time(0);
	if( qtype == TY_A )
		timeout = RSLV_TIMEOUT;
	else	timeout = RSLV_INV_TIMEOUT;

	rrc = getRRbynameaddr(timeout,name,qtype,rrc,rrv);
	rrp = rrb;

	rro = 0;
	for( rri = 0; rri < rrc; rri++ ){
		type = rrv[rri][0];
		rp = rrv[rri] = &rrv[rri][2];
		rrv[rro] = rrv[rri];

		switch( type ){
		    case TY_A:
			/*printf("[%d] %d.%d.%d.%d\n",
				rri,rp[0],rp[1],rp[2],rp[3]);*/
			rrv[rro] = rrp;
			bcopy(rp,rrp,4);
			rrp += 4;
			rro++;
			break;

		    case TY_MX:
		    case TY_CNAME:
			if( qtype == TY_PTR )
				break;

		    case TY_PTR:
			getLong(rp,ival);
			DNS_nodename(ival,dname);
			if( type == TY_CNAME ){
				if( cname != 0 )
					strcpy(cname,dname);
				if( qtype != TY_CNAME && qtype != TY_PTR )
					continue;
			}
			rrv[rro] = rrp;
			strcpy(rrp,dname);
			rrp += strlen(rrp)+1;
			rro++;
			break;
		}
	}
	rrv[rro] = 0;
	rrv[rro+1] = rrp; /* return value to MX search */

	debug(DBG_NS,"%d seconds, %d(%d) records\n",time(0)-start,rro,rrc);
	return rro;
}


char *DNS_DOMAIN;
char *DNS_ORIGIN;
char *DNS_ADMIN;
int   DNS_SERIAL;
int   DNS_REFRESH;
int   DNS_RETRY;
int   DNS_EXPIRE;
int   DNS_MINTTL;

static struct hostent *gethostbyN(name)
	char *name;
{	struct hostent *ht;
	octet xname[512],*dp;

	ht = NULL;
	if( dp = strcasestr(name,DNS_DOMAIN) )
	if( dp[strlen(DNS_DOMAIN)] == 0 ){
		strcpy(xname,name);
		dp = strcasestr(xname,DNS_DOMAIN);
		*dp = 0;
		if( xname < dp && dp[-1] == '.' )
			dp[-1] = 0;
		ht = _GETHOSTBYNAME(xname);
	}
	if( ht == NULL )
		ht = _GETHOSTBYNAME(name);
	if( ht == NULL ){
		sprintf(xname,"%s.%s",name,DNS_DOMAIN);
		ht = _GETHOSTBYNAME(xname);
	}
	return ht;
}
static putRR_A(rrpp,name)
	octet **rrpp;
	char *name;
{	octet *rrp;
	struct hostent *ht;
	int anc,rttl,rrdlength;
	int ai;

	rrp = *rrpp;

	ht = gethostbyN(name);
	if( ht == NULL )
		return 0;

	anc = 0;
	rttl = DNS_MINTTL;
	rrdlength = ht->h_length;
	for( ai = 0; ht->h_addr_list[ai] != 0; ai++ ){
		rrp = putName(rrp,name);
		putShort(rrp,TY_A);
		putShort(rrp,CL_IN);
		putLong(rrp,rttl);
		putShort(rrp,rrdlength);
		bcopy(ht->h_addr_list[ai],rrp,rrdlength);
		rrp += rrdlength;
		anc++;
	}

	*rrpp = rrp;
	return anc;
}
static putRR_SOA(rrpp,name)
	octet **rrpp;
	char *name;
{	octet *rrp;
	octet rbuff[512],*np;
	int anc,rttl,rrdlength;
	struct hostent *ht;

	rrp = *rrpp;

	ht = gethostbyN(name);
	if( ht == NULL )
		return 0;

	np = rbuff;
	np = putName(np,DNS_ORIGIN);
	np = putName(np,DNS_ADMIN);
	putLong(np,DNS_SERIAL);
	putLong(np,DNS_REFRESH);
	putLong(np,DNS_RETRY);
	putLong(np,DNS_EXPIRE);
	putLong(np,DNS_MINTTL);
	rrdlength = np - rbuff;

	anc = 1;
	rttl = 0;
	rrp = putName(rrp,DNS_DOMAIN);
	putShort(rrp,TY_SOA);
	putShort(rrp,CL_IN);
	putLong(rrp,rttl);
	putShort(rrp,rrdlength);
	bcopy(rbuff,rrp,rrdlength);
	rrp += rrdlength;

	*rrpp = rrp;
	return anc;
}
static putRR_PTR(rrpp,name)
	octet **rrpp;
	char *name;
{	octet *rrp;
	struct hostent *ht;
	octet rbuff[512],*np;
	int anc,rttl,rrdlength;
	VSAddr sab;
	char *baddr;
	int bleng,btype;

	rrp = *rrpp;

	if( strcasestr(name,REVERSE_DOM) == 0 )
		return 0;
	if( VSA_dnstosa(&sab,0,name) <= 0 )
		return 0;
	bleng = VSA_decomp(&sab,&baddr,&btype,NULL);
	ht = _GETHOSTBYADDR(baddr,bleng,btype);
	if( ht == NULL )
		return 0;

	anc = 0;
	rttl = DNS_MINTTL;
	np = putName(rbuff,ht->h_name);
	rrdlength = np - rbuff;
	{
		rrp = putName(rrp,name);
		putShort(rrp,TY_PTR);
		putShort(rrp,CL_IN);
		putLong(rrp,rttl);
		putShort(rrp,rrdlength);
		bcopy(rbuff,rrp,rrdlength);
		rrp += rrdlength;
		anc++;
	}
	/*
	for( ai = 0; ht->h_aliases[ai]; ai++ )
		anc++;
	*/

	*rrpp = rrp;
	return anc;
}

dns_search(reply,query,qcc)
	octet *reply,*query;
{	octet *qp,*rp;
	Header Head,RHead;
	int QM,RM,qdc,anc,nsc,arc;
	octet name[512];
	octet RRbuf[2048],*rrp;
	int qtype,qclass;
	int rtype,rclass,rttl,rrdlength;
	octet rbuff[512],*np;
	int rleng;

	qp = query;
	qp = scanHeader(qp,&Head);
	qp = scanQuery(query,qp,name,&qtype,&qclass);

	debug(DBG_FORCE,"QUERY %s %s %s\n",
		name,symCLASS(qclass),symTYPE(qtype));

	rrp = RRbuf;

	anc = 0;
	switch( qtype ){
	    case TY_SOA:anc += putRR_SOA(&rrp,name); break;
	    case TY_A:  anc += putRR_A(&rrp,name);   break;
	    case TY_PTR:anc += putRR_PTR(&rrp,name); break;

	    case TY_NS:
		break;
	    case TY_MX:
		break;

	    case TY_QALL:
			anc += putRR_A(&rrp,name);
			anc += putRR_SOA(&rrp,name);
			anc += putRR_PTR(&rrp,name);
			break;
	}

	QM = Head.M;
	RM = 0;
	SET_QR(RM,1);
	SET_OPCODE(RM,H_OPCODE(QM));
	SET_AA(RM,1);
	SET_RD(RM,H_RD(QM));
	SET_RA(RM,0);
	if( anc == 0 )
		SET_RCODE(RM,3);
	qdc = 1;

	rp = reply;
	putShort(rp,Head.id);
	putShort(rp,RM);
	putShort(rp,qdc);
	putShort(rp,anc);
	putShort(rp,0);
	putShort(rp,0);
	rp = makeQuestion(rp,name,qtype,qclass);

	if( anc ){
		bcopy(RRbuf,rp,rrp-RRbuf);
		rp += (rrp-RRbuf);
	}

	rleng = rp - reply;
	dumpResponse(Head.id,reply,rleng,&RHead,"");
	return rleng;
}

dns_server(qsock,rsock)
{	int icc,occ;
	char ib[2048],ob[2048];

	icc = read(qsock,ib,sizeof(ib));
	occ = dns_search(ob,ib,icc);
	write(rsock,ob,occ);
}
int (*RES_DNSSERVER)() = dns_server;
int (*RES_DNSSEARCH)() = dns_search;
