/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1995-1999 Yutaka Sato
Copyright (c) 1995-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	reshost.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	950817	created
//////////////////////////////////////////////////////////////////////#*/

#include <stdio.h>
#include "ystring.h"

#include "vsocket.h"
#include "dns.h"

typedef struct {
  struct hostent h_ent;
	char	*namev[64];
	char	 nameb[1024];
	char	*addrv[64];
	char	 addrb[1024];
} Hostent;
#define Rnamev	Rhostent.namev
#define Rnameb	Rhostent.nameb
#define Raddrv	Rhostent.addrv
#define Raddrb	Rhostent.addrb

static Hostent Rhostent = {
	Rnameb,
	&Rnamev[1],
	0,/*AF_INET,*/
	4,
	Raddrv
};

int RES_NOSYS;
gethostbynameaddr_sys(name,qtype,rc,rv,rb,cname)
	char *name,*rv[],*rb,*cname;
{	struct hostent *ht;
	int ac;
	char *ap;
	int ax;

	if( RES_NOSYS )
		return 0;

	if( qtype == TY_A )
		ht = EX_GETHOSTBYNAME(name);
	else{
		VSAddr sab;
		char *baddr;
		int bleng,btype;
		VSA_atosa(&sab,0,name);
		bleng = VSA_decomp(&sab,&baddr,&btype,NULL);
		ht = EX_GETHOSTBYADDR(baddr,bleng,btype);
	}
	if( ht == NULL )
		return 0;

	if( qtype == TY_A ){
		for( ac = 0; ap = ht->h_addr_list[ac]; ac++ ){
			bcopy(ap,rb,4);
			rv[ac] = rb;
			rb += 4;
		}
	}else{
		ac = 0;
		if( ht->h_name ){
			strcpy(rb,ht->h_name);
			rv[ac++] = rb;
			rb += strlen(rb) + 1;
		}
		if( ht->h_aliases )
		for( ax = 0; ap = ht->h_aliases[ax]; ax++ ){
			strcpy(rb,name);
			rv[ac++] = rb;
			rb += strlen(rb) + 1;
		}
	}
	if( cname ){
		if( ht->h_name )
			strcpy(cname,ht->h_name);
		else	*cname = 0;
	}
	return ac;
}

static dnsrch1(dname,name,qtype,rc,rv,rb,cname)
	char *dname,*name,*rv[],*rb,*cname;
{	char fqdn[512];
	int ac;

	if( dname == NULL )
		strcpy(fqdn,name);
	else
	if( strcmp(dname,".") == 0 )
		sprintf(fqdn,"%s.",name);
	else	sprintf(fqdn,"%s.%s",name,dname);

	ac = gethostbynameaddr_dns(fqdn,qtype,rc,rv,rb,cname);
	if( 0 < ac ){
		if( cname != NULL && *cname == 0 )
		if( strcmp(name,fqdn) != 0 )
			strcpy(cname,fqdn);
	}
	return ac;
}

extern int MIN_ABSNDOTS;
extern char **res_DNSRCH();
extern char *res_DEFDNAME();

gethostbynameaddr_dnsrch(name,qtype,rc,rv,rb,cname)
	char *name,*rv[],*rb,*cname;
{	int ndots,tryabs,abstrial;
	int ac,si;
	char *np,*dname;
	char **dnsrch;

	ndots = 0;
	for( np = name; *np; np++ )
		if( *np == '.' )
			ndots++;

	tryabs = MIN_ABSNDOTS <= ndots;
	abstrial = 0;

	if( tryabs ){
		abstrial++;
		if( 0 < (ac = dnsrch1(NULL, name,qtype,rc,rv,rb,cname)) )
			return ac;
	}
	if( dnsrch = res_DNSRCH() ){
	    for( si = 0; dname = dnsrch[si]; si++ ){
		if( strcmp(dname,".") == 0 )
			abstrial++;
		debug(DBG_ANY,"DNSRCH[%d] = %s\n",si,dname);
		if( 0 < (ac = dnsrch1(dname,name,qtype,rc,rv,rb,cname)) )
			return ac;
	    }
	}else
	if( dname = res_DEFDNAME() ){
		debug(DBG_ANY,"DEFDNAME = %s\n",dname);
		if( 0 < (ac = dnsrch1(dname,name,qtype,rc,rv,rb,cname)) )
			return ac;
	}
	if( abstrial == 0 ){
		if( 0 < (ac = dnsrch1(NULL, name,qtype,rc,rv,rb,cname)) )
			return ac;
	}
	return -1;
}
RES_next_res(where,ri,res,arg)
	char *where,*res,*arg;
{	int ro,ch;

	res[0] = 0;
	if( arg != NULL ) arg[0] = 0;

	if( where[ri] == ',' )
		ri++;
	if( where[ri] == 0 )
		return 0;

	ro = 0;
	res[ro++] = where[ri++];
	if( where[ri] == ':' ){
		res[ro++] = where[ri++];
		while( (ch = where[ri]) && ch != ',' )
			res[ro++] = where[ri++];
	}
	res[ro] = 0;
	if( arg != NULL && res[1] == ':' && res[2] != 0 )
		strcpy(arg,res+2);
	return ri;
}
static caching(lastres,ac,nameaddr,rv,byname,cname,unknown_mark,marklen)
	char *nameaddr,*rv[],*cname,*unknown_mark;
{
	/* don't cache the result from the cache */
	if( lastres != RT_CACHE ){
		puthost_cache(nameaddr,rv,byname,cname);
	}else{
		ac = rem_unknown(rv,unknown_mark,marklen);
	}
	return ac;
}

gethostbyname_all(where, rwhere, name, rv, rb, cname)
	char *where,*rwhere;
	char *name,*rv[],*rb;
	char *cname;
{	int ri,res,ac;
	char res1[512],arg[512];
	int lastres;
	int with_cache = 0;
	int leng;

	res_log(0);

	if( 256 <= (leng = strlen(name)) ){
		debug(DBG_FORCE,"Host name too long(%d): %s\n",leng,name);
		if( 500 < leng )
			return 0;
	}

	ac = 0;
	res = 0;
	lastres = 0;
	rwhere[0] = rwhere[1] = 0;
	cname[0] = 0;

	for( ri = 0; ri = RES_next_res(where,ri,res1,arg); ){
	  debug(DBG_ANY,"        RES[%s] %s\n",res1,where);
	  res = res1[0];
	  lastres = res;
	  switch(res){
	    case RT_CACHE:
		with_cache = 1;
		ac = gethostbynameaddr_cache(arg,name,rv,rb,1,cname,0);
		break;
	    case RT_FILE:
		ac = gethostbynameaddr_file(arg,name,rv,rb,1,cname);
		break;
	    case RT_NIS:
		ac = gethostbynameaddr_nis(_NISMAP_NAME,arg,name,rv,rb,1,cname);
		break;
	    case RT_DNS:
		ac = gethostbynameaddr_dnsrch(name,TY_A,64,rv,rb,cname);
		break;
	    case RT_SYS:
		ac = gethostbynameaddr_sys(name,TY_A,64,rv,rb,cname);
		break;
	  }
	  if( 0 < ac ){
		rwhere[0] = res;
		break;
	  }
	  res = 0;
	}
	if( 0 < ac )
		rv[ac] = 0;
	else	rv[0] = 0;

	if( with_cache && lastres )
		ac = caching(lastres,ac,name,rv,1,cname,UNKNOWN_HOSTADDR,4);

	debug(DBG_NS,"Hit: %d\n",ac);
	res_log(res?res:'-',1,name,rv,cname);
	return ac;
}

/*
 * exclude elements from given host name list "namev[namec]"
 * if the IP address of a element does not match "caddr".
 */
static isHostnameOf(namec,namev,nameb,caddr)
	char *namev[],*nameb;
	char *caddr;
{	unsigned char *av[32],ab[1024],cn[512],*a1,addr1[32];
	int ia[4];
	char oa[4];
	int na,ai,aj,ok;

	sscanf(caddr,"%d.%d.%d.%d",&ia[0],&ia[1],&ia[2],&ia[3]);
	oa[0]=ia[0]; oa[1]=ia[1]; oa[2]=ia[2]; oa[3]=ia[3];

	ok = 0;
	for( ai = 0; ai < namec; ai++ ){
		na = gethostbynameaddr_dns(namev[ai],TY_A,32,av,ab,cn);
		if( na == 0 ){
			debug(DBG_FORCE,"DNS INCONSISTENT: %s -> %s -> ?\n",
				caddr,namev[ai]);
		}else
		for( aj = 0; aj < na; aj++ ){
			a1 = av[aj];
			if( bcmp(oa,a1,4) == 0 ){
				namev[ok++] = namev[ai];
				break;
			}
			sprintf(addr1,"%d.%d.%d.%d",a1[0],a1[1],a1[2],a1[3]);
			debug(DBG_FORCE,"DNS INCONSISTENT: %s -> %s -> %s\n",
				caddr,namev[ai],addr1);
		}
	}
	return ok;
}

gethostbyaddr_all(where, rwhere, caddr, rv, rb)
	char *where,*rwhere;
	char *caddr,*rv[],*rb;
{	int ri,res,ac;
	int lastres;
	char res1[512],arg[512];
	int with_cache = 0;

	res_log(0);

	ac = 0;
	res = 0;
	lastres = 0;
	rwhere[0] = 0;

	for( ri = 0; ri = RES_next_res(where,ri,res1,arg); ){
	  debug(DBG_ANY,"        RES[%s] %s\n",res1,where);
	  res = res1[0];
	  lastres = res;
	  switch(res){
	    case RT_CACHE:
		with_cache = 1;
		ac = gethostbynameaddr_cache(arg,caddr,rv,rb,0,NULL,0);
		break;
	    case RT_FILE:
		ac = gethostbynameaddr_file(arg,caddr,rv,rb,0,NULL);
		break;
	    case RT_NIS:
		ac = gethostbynameaddr_nis(_NISMAP_ADDR,arg,caddr,rv,rb,0,NULL);
		break;
	    case RT_DNS:
	    case RT_SYS:
		{
		int a1,a2,a3,a4;
		char name[256];
		sscanf(caddr,"%d.%d.%d.%d",&a1,&a2,&a3,&a4);
		sprintf(name,"%d.%d.%d.%d.%s.",a4,a3,a2,a1,REVERSE_DOM);
		if( res == RT_DNS )
			ac = gethostbynameaddr_dns(name,TY_PTR,32,rv,rb,NULL);
		else	ac = gethostbynameaddr_sys(caddr,TY_PTR,32,rv,rb,NULL);
		if( 0 < ac && RES_VERIFY )
			ac = isHostnameOf(ac,rv,rb,caddr);
		}
		break;
	  }
	  if( 0 < ac ){
		rwhere[0] = res;
		break;
	  }
	  res = 0;
	}
	if( 0 < ac )
		rv[ac] = 0;
	else	rv[0] = 0;

	if( with_cache && lastres )
		ac = caching(lastres,ac,caddr,rv,0,NULL,UNKNOWN_HOSTNAME,0);

	debug(DBG_NS,"Hit: %d\n",ac);
	res_log(res?res:'-',0,caddr,rv,NULL);
	return ac;
}

struct hostent *RES_gethostbyaddr();
struct hostent *RES_gethostbyname(name)
	char *name;
{	int ac;
	unsigned int iaddr;
	char caddr[64],cname[512],where[8];
	octet *dp;

	RES_init();
	debug(DBG_ANY,"gethostbyname(%s)\n",name);

	iaddr = inet_addrV4(name);
	if( iaddr != -1 )
		return RES_gethostbyaddr((char*)&iaddr,4,AF_INET);

	ac = gethostbyname_all(resolvers,where, name, Raddrv, Raddrb, cname);
	if( ac <= 0 )
		return NULL;

	Raddrv[ac] = 0;

	if( cname[0] != 0 && strcmp(cname,name) != 0 ){
		Rnamev[0] = Rnameb;                  strcpy(Rnamev[0],cname);
		Rnamev[1] = Rnameb+strlen(Rnameb)+1; strcpy(Rnamev[1],name);
		Rnamev[2] = 0;
	}else{
		Rnamev[0] = Rnameb; strcpy(Rnameb,name);
		Rnamev[1] = 0;
	}
	if( 1 < ac )
		sort_ipaddrs(Raddrv);

	Rhostent.h_ent.h_addrtype = AF_INET;
	return &Rhostent.h_ent;
}

struct hostent *RES_gethostbyaddr(baddr, len, type)
	octet *baddr;
	int len, type;
{	char caddr[64],cname[512],where[8],where2[8];
	int ac;

	RES_init();
	sprintf(caddr,"%d.%d.%d.%d",baddr[0],baddr[1],baddr[2],baddr[3]);
	debug(DBG_ANY,"gethostbyaddr(%s)\n",caddr);

	ac = gethostbyaddr_all(resolvers,where,caddr,Rnamev,Rnameb);
	if( ac <= 0 )
		return NULL;

	Raddrv[0] = Raddrb;
	bcopy(baddr,Raddrb,len);
	Raddrv[1] = 0;

/*
if( where[0] == 'D' ){
	ac = gethostbyname_all(where,where2, Rnameb,Raddrv,Raddrb,cname);
	if( 1 < ac )
		sort_ipaddrs(Raddrv);
}
*/
	Rhostent.h_ent.h_addrtype = type;
	return &Rhostent.h_ent;
}

RES_sethostent(stayopen)
{
}
RES_endhostent()
{
}
struct hostent *RES_gethostent()
{
	return NULL;
}

RES_matchLine(what,byname,name,line,rv,rb,cname)
	char *what,*name;
	char *line,*rv[],*rb;
	char *cname;
{	char *lp;
	char addr[64],host[512],host1[512];
	char *ap;
	int iaddr;
	int ac;

	ac = 0;

	if( lp = strchr(line,'#') ){
		if( lp == line )
			goto EXIT;
		*lp = 0;
	}
	if( lp = strchr(line,'\n') )
		*lp = 0;

	lp = wordScan(line,addr);
	if( addr[0] == 0 )
		goto EXIT;

	if( byname ){
		wordScan(lp,host1);
		for(;;){
			lp = wordScan(lp,host);
			if( host[0] == 0 )
				break;
					
			if( strcasecmp(host,name) == 0 ){
				debug(DBG_ANY,"RES: <%s> %s\n",what,line);
				rv[ac++] = rb;
				iaddr = inet_addrV4(addr);
				bcopy(&iaddr,rb,4);
				rb += 4;
				strcpy(cname,host1);
				break;
			}
		}
	}else{
		if( strcmp(addr,name) == 0 ){
			debug(DBG_ANY,"RES: <%s> %s\n",what,line);
			for(;;){
				lp = wordScan(lp,host);
				if( host[0] == 0 )
					break;
				rv[ac++] = rb;
				strcpy(rb,host);
				rb += strlen(rb) + 1;
			}
		}
	}
EXIT:
	rv[ac] = rb;
	return ac;
}

typedef struct {
	char	*h_path;
	int	 h_date;
	int	 h_size;
	char	*h_buff;
} HostFile;
static HostFile hosts[4];
extern char *Malloc();

static readhosts1(path,fp,hp)
	char *path;
	FILE *fp;
	HostFile *hp;
{	char *datap,*cp;
	int mtime,peak,leng;

	debug(DBG_ANY,"HOSTS: %s\n",path);
	if( hp->h_path && hp->h_path[0] == '/' ){
		mtime = File_mtime(hp->h_path); 
		if( 0 < mtime && mtime <= hp->h_date ){
			debug(DBG_ANY,"HOSTS: no change in %s\n",path);
			hp->h_date = time(0);
			return;
		}
	}

	hp->h_path = (char*)strdup(path);
	hp->h_date = time(0);

	peak = 0;
	for(;;){
		if( hp->h_size <= peak+2+1024+1 ){
			hp->h_size += 64*1024;
			hp->h_buff = Malloc(hp->h_buff,hp->h_size);
		}

		datap = &hp->h_buff[peak+2];
		if( fgets(datap,1024,fp) == NULL )
			break;
		if( cp = strpbrk(datap,"#\r\n") ){
			*cp-- = 0;
			while( datap <= cp && (*cp == ' ' || *cp == '\t') )
				*cp-- = 0;
		}
		if( datap[0] == 0 )
			continue;

		leng = strlen(datap);
		hp->h_buff[peak+0] = leng >> 8;
		hp->h_buff[peak+1] = leng;
		peak += 2 + leng + 1;
	}
	hp->h_buff[peak+0] = 0;
	hp->h_buff[peak+1] = 0;
}

gethostbynameaddr_file(path,name,rv,rb,byname,cname)
	char *path,*name;
	char *rv[],*rb,*cname;
{	FILE *fp;
	int now,ac;
	HostFile *hp;
	char *lp;
	int leng;

	hp = &hosts[0];
	now = time(0);
	if( hp->h_buff == NULL || 60 < (now-hp->h_date) ){
		if( path == NULL || path[0] == 0 )
			path = _HOSTSFILE;

		if( strncmp(path,"sh:",3) == 0 )
			fp = popen(path+3,"r");
		else	fp = fopen(path,"r");

		if( fp == NULL ){
			debug(DBG_ANY,"cannot open %s\n",path);
			return -1;
		}

		readhosts1(path,fp,&hosts[0]);

		if( strncmp(path,"sh:",3) == 0 )
			pclose(fp);
		else	fclose(fp);
	}

	ac = 0;
	for( lp = hp->h_buff; leng = (lp[0]<<8|lp[1]&0xFF); lp += leng+3 ){
		ac += RES_matchLine(path,byname,name,lp+2,&rv[ac],rb,cname);
		rb = rv[ac];
	}
	return ac;
}

gethostbynameaddr_nis(map,domain,name,rv,rb,byname,cname)
	char *map,*domain,*name;
	char *rv[],*rb;
	char *cname;
{	char *ypdomain,*key,*val;
	char line[1024],*lp;
	int klen,vlen;
	int rcode;
	int ac;

	if( domain != NULL && domain[0] != 0 )
		ypdomain = domain;
	else{
		ypdomain = NULL;
		rcode = yp_get_default_domain(&ypdomain);
		if( rcode != 0 || ypdomain == NULL || *ypdomain == 0 )
			return -1;
		if( strcmp(ypdomain,"(none)") == 0 )
			return -1;
	}

	rcode = yp_match(ypdomain,map,name,strlen(name),&val,&vlen);
	if( rcode != 0 )
		return -1;

	ac = 0;
	for( lp = val; *lp; ){
		lineScan(lp,line);
		ac += RES_matchLine(map,byname,name,line,&rv[ac],rb,cname);
		rb = rv[ac];
		if( lp = strchr(lp,'\n') )
			lp++;
		else	break;
	}
	return ac;
}
