/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1995-1999 Yutaka Sato
Copyright (c) 1995-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	reshost.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	950817	created
//////////////////////////////////////////////////////////////////////#*/

#include <stdio.h>
#include "ystring.h"

extern char *getenv();

#include "dns.h"
int DNS_debug;

#include "vsocket.h"

#if defined(sgi) || defined(__RES) && (19931104 <= __RES)
#define _RSTATE 1
#else
#define _RSTATE 0
#endif

#ifdef RES_STATE
#define RSTATE !_RSTATE
#else
#define RSTATE  _RSTATE
#endif

#if RSTATE
typedef struct __res_state State;
#else
typedef struct state State;
#endif

#if defined(ultrix)
#define NSLIST(sx)	ns_list[sx].addr
#else
#define NSLIST(sx)	nsaddr_list[sx]
#endif

State _RES = {0};
int MIN_ABSNDOTS = 1;

#define MAX_SORTLIST	16
#define ADDRLEN	4
typedef struct {
	unsigned char	addr[ADDRLEN];
	unsigned char	mask[ADDRLEN];
} AddrMask;
static AddrMask sort_list[MAX_SORTLIST];
static int Nsortlist;

#ifndef RSLV_CONF
#define RSLV_CONF	"/etc/resolv.conf"
#endif

#ifndef HOSTSFILE
#define HOSTSFILE	"/etc/hosts"
#endif

#ifndef NISMAP_NAME
#define NISMAP_NAME	"hosts.byname"
#endif

#ifndef NISMAP_ADDR
#define NISMAP_ADDR	"hosts.byaddr"
#endif

#ifndef RSLV_ORDER
#define RSLV_ORDER	"CFNDS"
#endif

char *_RSLV_CONF = RSLV_CONF;
char *_HOSTSFILE = HOSTSFILE;
char *_NISMAP_NAME = NISMAP_NAME;
char *_NISMAP_ADDR = NISMAP_ADDR;

#define RESOLVERS_SIZ 512
char resolvers[RESOLVERS_SIZ] = RSLV_ORDER;

char *RES_VERIFY;
#define VIA_SOCKS	"//"

static char _confid[64];

RES_getconf(buf)
	char *buf;
{	char *bp;
	char *addr,*dom;
	int ni,si;
	int options;

	bp = buf;
	sprintf(bp,"RES_ORDER=%s\n",resolvers); bp += strlen(bp);
	sprintf(bp,"HOSTSFILE=%s\n",_HOSTSFILE); bp += strlen(bp);
	sprintf(bp,"NSIMAP_NAME=%s\n",_NISMAP_NAME); bp += strlen(bp);
	sprintf(bp,"NSIMAP_ADDR=%s\n",_NISMAP_ADDR); bp += strlen(bp);
	sprintf(bp,"RSLV_CONF=%s\n",_RSLV_CONF); bp += strlen(bp);
	sprintf(bp,"DNS_NSCOUNT=%d\n",_RES.nscount); bp += strlen(bp);
	options = _RES.options & ~(RES_DEBUG);
	sprintf(bp,"DNS_OPTIONS=%d\n",options); bp += strlen(bp);
	sprintf(bp,"DNS_DEFDNAME=%s\n",_RES.defdname); bp += strlen(bp);
	for( ni = 0; ni < _RES.nscount; ni++ ){
		addr = VSA_ntoa(&_RES.nsaddr_list[ni]);
		sprintf(bp,"DNS_SERVER=%s\n",addr); bp += strlen(bp);
	}
	for( si = 0; dom = _RES.dnsrch[si]; si++ ){
		sprintf(bp,"DNS_SEARCH=%s\n",dom); bp += strlen(bp);
	}
}
char *RES_confid(id)
	char *id;
{	char buf[2048];

	if( _confid[0] == 0 ){
		RES_getconf(buf);
		toMD5(buf,_confid);
		debug(DBG_CACHE,"#### RES_confid = %s\n%s",_confid,buf);
	}

	strcpy(id,_confid);
	debug(DBG_CACHE,"RES_confid = %s\n",id);
	return id;
}
#define clear_confid()	_confid[0] = 0;

static bindINS(sin,nlisten)
	VSAddr *sin;
{	int sock,rcode;
	int sinlen;

	sock = socket(AF_INET,SOCK_STREAM,0);
	sinlen = VSA_size(&sin);
	if( bind(sock,(SAP)sin,sinlen) == 0 ){
		listen(sock,nlisten);
		return sock;
	}else{
		close(sock);
		return -1;
	}
}
static connINS(sin)
	VSAddr *sin;
{	int sock;
	int sinlen;

	sock = socket(AF_INET,SOCK_STREAM,0);
	sinlen = VSA_size(&sin);
	if( connectTO(sock,sin,sinlen,100) == 0 ){
		return sock;
	}else{
		close(sock);
		return -1;
	}
}

extern void *callFuncTimeout();
static struct hostent *_GethostByname(name)
	char *name;
{	struct hostent *hp;

	hp = (struct hostent *)callFuncTimeout(3,NULL,EX_GETHOSTBYNAME,name);
	return hp;
}

static struct hostent myhost;

static struct hostent *getmyhost()
{	char myname[256];
	struct hostent *hp;

	if( myhost.h_name != NULL )
		return &myhost;

	gethostname(myname,sizeof(myname));
	if( hp = _GethostByname(myname) )
		return hp;

	myhost.h_name = strdup(myname);
	myhost.h_length = 4;
	myhost.h_addr_list = (char**)malloc(sizeof(char*)*2);
	myhost.h_addr_list[0] = (char*)calloc(1,4); /* 0.0.0.0 */
	myhost.h_addr_list[1] = NULL;
	return &myhost;
}

static VSAddr selfs[16];
static int selfN;
RES_isself(mysock)
{	int len;
	VSAddr *self1;

	len = sizeof(VSAddr);
	self1 = &selfs[selfN];
	getsockname(mysock,(SAP)self1,&len);
	debug(DBG_ANY,"self [%d] %s\n",selfN,VSA_ntoa(self1));
	selfN++;
}
static isself1(me,to)
	VSAddr *me,*to;
{	int testsock;
	VSAddr sin;

	if( VSA_port(me) != VSA_port(to) )
		return 0;
	if( VSA_addr(me) == VSA_addr(to) )
		return 1;
	if( VSA_addrisANY(to) )
		return 1;
	if(!VSA_addrisANY(me) )
		return 0; /* neither is wild card "0.0.0.0" */

	/* now "me" is wildcard. so check if "to" is directed to "me" */
	if( VSA_addr(to) == inet_addrV4("127.0.0.1") )
		return 1;

	sin = *to;
	VSA_setport(&sin,0);
	testsock = bindINS(&sin,1);
	if( 0 <= testsock  ){
		close(testsock);
		return 1;
	}else	return 0;
}
static isself(to)
	VSAddr *to;
{	int si;

	for( si = 0; si < selfN; si++ )
		if(  isself1(&selfs[si],to) )
			return 1;
	return 0;
}
RES_nsloopcheck(mysock)
{	int nsx,nsi,nsj;
	int len;
	VSAddr me,sin;

	len = sizeof(VSAddr);
	getsockname(mysock,(SAP)&me,&len);

	nsx = _RES.nscount;
	for( nsi = 0; nsi < nsx; ){
		VSA_copy(&sin,&_RES.NSLIST(nsi));
		if( isself1(&me,&sin) ){
			for( nsj = nsi; nsj < nsx-1; nsj++ )
				VSA_copy(&_RES.NSLIST(nsj),&_RES.NSLIST(nsj+1));
			VSA_zero(&_RES.NSLIST(nsj));
			_RES.nscount -= 1;
			nsx -= 1;
			debug(DBG_FORCE,"## removed self as NS[%d] %s:%d\n",
				nsi,VSA_ntoa(&sin),VSA_port(&sin));
		}else	nsi++;
	}
}

RES_ns1(res,ns,domain)
	State *res;
	char *ns,*domain;
{	VSAddr sin;
	int nsx;
	struct hostent *hp;
	char *saddr;
	char *socks,*cp,nsb[256],ssb[256];
	char nsbp[256];
	int port;

	clear_confid();
	nsx = -1;
	if( strcmp(domain,RES_NSDOM0) == 0 ){
		/* reserver the position */
		if( res->nscount < MAXNS ){
			nsx = res->nscount++;
			VSA_zero(&res->NSLIST(nsx));
		}
	}

	ssb[0] = 0;
	if( socks = strstr(ns,VIA_SOCKS) ){
		strcpy(nsb,ns);
		ns = nsb;
		socks = strstr(ns,VIA_SOCKS);
		*socks = 0;
		if( cp = strpbrk(ns,"# \t") )
			*cp = 0;
		sscanf(socks+strlen(VIA_SOCKS),"%[-_.0-9A-Z:]",ssb);
	}

	port = PORT_DNS;
	if( strchr(ns,':') ){
		sscanf(ns,"%[^:]:%d",nsbp,&port);
		ns = nsbp;
	}

	if( VSA_strisaddr(ns) )
		VSA_atosa(&sin,port,ns);
	else
	if( hp = _GethostByname(ns) )
		VSA_htosa(&sin,port,hp,0);
	else
	if( hp = _GETHOSTBYNAME(ns) )
		VSA_htosa(&sin,port,hp,0);
	else	VSA_atosa(&sin,port,"255.255.255.255");

	if( !VSA_isaddr(&sin) ){
		debug(DBG_FORCE,"ERROR: unknown DNS server: %s\n",ns);
		/* remove the reserved slot */
		if( 0 <= nsx ){
			res->nscount--;
			for(; nsx < res->nscount; nsx++ )
				res->NSLIST(nsx) = res->NSLIST(nsx+1);
		}
		return;
	}

	if( isself(&sin) ){
		debug(DBG_FORCE,"## don't add self[%s:%d] as NS\n",
			VSA_ntoa(&sin),VSA_port(&sin));
		return;
	}
	saddr = VSA_ntoa(&sin);
	RES_socks(saddr,ssb);

	if( strcmp(domain,RES_NSDOM0) == 0 ){
	  if( 0 <= nsx ){
		VSA_copy(&res->NSLIST(nsx),&sin);
		debug(DBG_ANY,"        RES_NS[%d]=%s/%s\n",nsx,saddr,domain);
	  }else	debug(DBG_ANY," ignore RES_NS(%d)=%s/%s\n",MAXNS,ns,domain);
	}else{
		debug(DBG_ANY,"        RES_NS[%d]=%s/%s\n",nsx,saddr,domain);
		set_nameserver(domain,saddr);
	}
}

DNS_connect(addr,port)
	char *addr;
{	VSAddr sin;

	VSA_atosa(&sin,port,addr);
	return connINS(&sin);
}

RES_getns1(nsi,sin)
	VSAddr *sin;
{	State *res;

	res = &_RES;
	if( nsi < _RES.nscount ){
		VSA_copy(sin,&res->NSLIST(nsi));
		return 1;
	}
	return 0;
}

load_rslvconf(res,path,loadns)
	State *res;
	char *path;
{	FILE *fp;
	char line[1024],com[1024],arg[1024];
	char *dp;
	char s[8][128];
	int sc,si;

	clear_confid();
	debug(DBG_ANY,"load_rslvconf(%s)\n",path);
	if( strncmp(path,"sh:",3) == 0 )
		fp = popen(path+3,"r");
	else	fp = fopen(path,"r");

	if( fp == NULL ){
		char buff[2048],where[256];
		FILE *TMPFILE();
		if( regGetResolvConf(buff,where) == 0 ){
			fp = TMPFILE("regGetResolvConf");
			fputs(buff,fp);
			fflush(fp);
			fseek(fp,0,0);
			debug(DBG_ANY,"resolv.conf from registory: %s\n%s\n",
				where,buff);
		}
	}

	if( fp == NULL )
		return;

	while( fgets(line,sizeof(line),fp) != NULL ){
	    if( dp = strpbrk(line,"#;") )
		*dp = 0;
	    if( sscanf(line,"%s %s",com,arg) < 2 )
		continue;

	    if( strcmp(com,"debug") == 0 ){
		res->options |=  RES_DEBUG;
	    }else
	    if( strcmp(com,"nameserver") == 0 ){
		if( loadns ){
		    RES_ns1(res,arg,RES_NSDOM0);
		}
	    }else
	    if( strcmp(com,"domain") == 0 ){
		strcpy(res->defdname,arg);
		res->options |= RES_DEFNAMES;
	    }else
	    if( strcmp(com,"ndots") == 0 ){
		MIN_ABSNDOTS = atoi(arg);
	    }else
	    if( strcmp(com,"search") == 0 ){
		sc = sscanf(line,"%*s %s %s %s %s %s %s %s %s",
		    s[0],s[1],s[2],s[3],s[4],s[5],s[6],s[7]);

		if( loadns && 0 < sc ){
		    strcpy(res->defdname,s[0]);
		    for( si = 0; si < MAXDNSRCH && si < sc; si++ ){
			debug(DBG_ANY,"        RES_SRCH[%d] %s\n",si,s[si]);
			res->dnsrch[si] = strdup(s[si]);
		    }
		    res->dnsrch[sc] = 0;
		    res->options |=  RES_DNSRCH;
		    res->options &= ~RES_DEFNAMES;
		}
	    }else
	    if( strcmp(com,"sortlist") == 0 ){
		RES_scan_sortlist(line);
	    }
	}
	if( strncmp(path,"sh:",3) == 0 )
		pclose(fp);
	else	fclose(fp);
}

static ns1(name)
	char *name;
{	char nameb[128];
	char *domain;

	strcpy(nameb,name);
	if( domain = strchr(nameb,'/') )
		if( domain[1] == '/' )
			domain = strchr(domain+2,'/');
	if( domain )
		*domain++ = 0;
	else	domain = RES_NSDOM0;

	RES_ns1(&_RES,nameb,domain);
	return 0;
}
RES_ns(nslist)
	char *nslist;
{
	if( nslist )
		scan_commaList(nslist,0,ns1);
	return 0;
}
RES_verify(verify)
	char *verify;
{
	RES_VERIFY = strdup(verify);
}
RES_verifyFaiure(host,badhost)
	char *host,*badhost;
{	char *sp,sc,*dp;

	dp = badhost;
	if( sp = RES_VERIFY ){
		for( ; sc = *sp; sp++ ){
			if( sc == '*' ){
				strcpy(dp,host);
				dp += strlen(dp);
			}else{
				*dp++ = sc;
			}
		}
	}
	*dp = 0;
}

RES_debug(debug)
	char *debug;
{
	_RES.options |= RES_DEBUG;
	DNS_debug |= atoi(debug);
	return 0;
}
RES_domain(domain)
	char *domain;
{
	strcpy(_RES.defdname,domain);
	return 0;
}
RES_order(order,porder)
	char *order,*porder;
{	int oi;
	char buff[RESOLVERS_SIZ];

	clear_confid();
	if( porder == NULL )
		porder = buff;
	strcpy(porder,resolvers);
	Strncpy(resolvers,order,sizeof(resolvers));

	debug(DBG_ANY,"RES_order(%s,%s)\n",resolvers,porder);
	return 0;
}
RES_conf(path)
	char *path;
{	static char *confpath;

	if( _RSLV_CONF == confpath )
		free(confpath);
	_RSLV_CONF = confpath = strdup(path);
	return 0;
}
RES_hosts(path)
	char *path;
{
	_HOSTSFILE = strdup(path);
	return 0;
}

RES_add_sortlist(addrs,masks,len)
	char *addrs[],*masks[];
{	int sx;

	for( sx = 0; addrs[sx]; sx++)
		RES_add_sortlist1(addrs[sx],masks?masks[sx]:NULL,len);
}
RES_add_sortlist1(addr,mask,len)
	unsigned char *addr,*mask;
{	AddrMask *sp;
	int ai,nm;
	unsigned char dmask[32];

	if( MAX_SORTLIST <= Nsortlist+1 ){
		debug(DBG_ANY,"!! exceed MAX_SORTLIST[%d]\n",MAX_SORTLIST);
		return;
	}
	if( mask == NULL || mask[0] == 0 ){
		mask = dmask;
		switch( ((int)addr[0] & 0xC0) >> 6 ){
		    case 0:  nm = 1; break;
		    case 2:  nm = 2; break;
		    default: nm = 3; break;
		}
		for( ai = 0; ai < nm ; ai++ )
			mask[ai] = 255;
		for( ; ai < len && ai < sizeof(dmask); ai++ )
			mask[ai] = 0;
	}
	debug(DBG_ANY,"        sortlist[%d] %d.%d.%d.%d / %d.%d.%d.%d\n",
		Nsortlist,
		addr[0],addr[1],addr[2],addr[3],
		mask[0],mask[1],mask[2],mask[3]);

	sp = &sort_list[Nsortlist++];
	for(ai = 0; ai < len; ai++){
		sp->addr[ai] = addr[ai];
		sp->mask[ai] = mask[ai];
	}
}
RES_scan_sortlist(line)
	char *line;
{	char s[16][128];
	char addr[32],mask[32];
	int a[16],m[16];
	int sc,si,ai;
	char ba[16],bm[16];
	int len = 4;

	sc = sscanf(line,"%*s %s %s %s %s %s %s %s %s %s %s",
	    s[0],s[1],s[2],s[3],s[4],s[5],s[6],s[7],s[8],s[9]);

	for( si = 0; si < sc; si++ ){
		addr[0] = mask[0] = 0;
		sscanf(s[si],"%[^/]/%s",addr,mask);
		for( ai = 0; ai < len; ai++ )
			a[ai] = m[ai] = 0;
		sscanf(addr,"%d.%d.%d.%d",&a[0],&a[1],&a[2],&a[3]);
		sscanf(mask,"%d.%d.%d.%d",&m[0],&m[1],&m[2],&m[3]);
		for( ai = 0; ai < len; ai++ ){
			ba[ai] = a[ai];
			bm[ai] = m[ai];
		}
		RES_add_sortlist1(ba,bm,len);
	}
}

static int lastRRX[256];
int RES_ROUNDROBIN = 1;

RES_roundrobin(hosts)
	char *hosts;
{
	if( strcmp(hosts,"*") == 0 )
		RES_ROUNDROBIN = 1;
	else	RES_ROUNDROBIN = 0;
}

sort_ipaddrs(addrs)
	unsigned char *addrs[];
{	unsigned char *ap,*mp;
	int si,sx,hit;

	if( RES_ROUNDROBIN ){
		int sn,si,sx,so,rrx;
		unsigned char *saddrs[256],*a1;

		rrx = 0;
		for( sn = 0; a1 = saddrs[sn] = addrs[sn]; sn++ )
			rrx += a1[0] + a1[1] + a1[2] + a1[3];
		rrx %= 256;
		sx = lastRRX[rrx] % sn;
		lastRRX[rrx] += 1;
		so = 0;
		for( si = sx; si < sn; si++ )
			addrs[so++] = saddrs[si];
		for( si = 0; si < sx; si++)
			addrs[so++] = saddrs[si];
	}

	hit = 0;
	for( si = 0; si < Nsortlist; si++ ){
		ap = sort_list[si].addr;
		mp = sort_list[si].mask;
		hit += sort_ipaddrs1(&addrs[hit],ap,mp);
	}
}

#define btohl(ap) ((ap[0]<<24) | (ap[1]<<16) | (ap[2]<<8) | ap[3])
sort_ipaddrs1(addrs,ap,mp)
	unsigned char *addrs[];
	unsigned char *ap,*mp;
{	unsigned char *cap,*saddrs[256],done[1];
	int ciaddr,cimasked;
	int sn,sx,dn,hit,imask;

	ciaddr = btohl(ap);
	imask = btohl(mp);
	cimasked = ciaddr & imask;

	for( sn = 0; addrs[sn]; sn++ )
		;

	dn = 0;
	for( sx = 0; cap = addrs[sx]; sx++ ){
		if( cap != done )
		if( (btohl(cap) & imask) == cimasked ){
			saddrs[dn++] = cap;
			addrs[sx] = done;
		}
	}
	hit = dn;
	for( sx = 0; sx < sn; sx++ )
		if( addrs[sx] != done )
			saddrs[dn++] = addrs[sx];
	for( sx = 0; sx < sn; sx++ )
		addrs[sx] = saddrs[sx];

	debug(DBG_ANY,"sort_ipaddrs(%d.%d.%d.%d/%d.%d.%d.%d) - %d/%d\n",
		ap[0],ap[1],ap[2],ap[3],mp[0],mp[1],mp[2],mp[3],hit,sn);
	return hit;
}
static res_getoptions(options,soptions)
	char *soptions;
{
	*soptions = 0;
	if( options & RES_DEBUG    ) strcat(soptions,"DEBUG ");
	if( options & RES_RECURSE  ) strcat(soptions,"RECURSE ");
	if( options & RES_DEFNAMES ) strcat(soptions,"DEFNAMES ");
	if( options & RES_DNSRCH   ) strcat(soptions,"DNSRCH ");
}

int RES_localdns;
RES_init()
{	char *env,*conf;
	char savorder[RESOLVERS_SIZ];
	int loadns;
	struct hostent *hp;
	char options[1024];
	int rx;
	char res1[RESOLVERS_SIZ],arg[RESOLVERS_SIZ];

	if( _RES.options & RES_INIT )
		return;
	_RES.options |= RES_INIT;

	if( env = getenv("RES_DEBUG") )
		RES_debug(env);

	if( _RES.options & RES_DEBUG ){
		if( DNS_debug == 0 )
			DNS_debug = DBG_NS;
	}
	debug(DBG_ANY,"RES_init()\n");
	Strncpy(savorder,resolvers,sizeof(savorder));
	strcpy(resolvers,"FND");

	Strncpy(resolvers,savorder,sizeof(resolvers));
	if( env = getenv("RES_ORDER") )
		Strncpy(resolvers,env,sizeof(resolvers));
	debug(DBG_ANY,"        RES_ORDER=%s\n",resolvers);

	for( rx = 0; rx = RES_next_res(resolvers,rx,res1,arg); ){
		if( res1[0] == 'D' && arg[0] != 0 )
			RES_ns1(&_RES,arg,RES_NSDOM0);
	}

	if( env = getenv("RES_NS") )
		RES_ns(env);
	if( env = getenv("RES_VRFY") )
		RES_verify(env);

/*
	loadns = _RES.nscount == 0;
*/
	loadns = 1; /* NSLIST is necessary for resolution of other NS ... */
	if( (conf = getenv("RES_CONF")) == 0 )
		conf = _RSLV_CONF;
	load_rslvconf(&_RES,conf,loadns);

	if( env = getenv("RES_HOSTS") )
		RES_hosts(env);

	if( Nsortlist == 0 )
	if( hp = getmyhost() )
		RES_add_sortlist(hp->h_addr_list,NULL,hp->h_length);

	if( _RES.nscount == 0 )
	/* registory about DNS should be searched on Windows ... */
	if( hp = getmyhost() ){
		unsigned char *ap;
		char saddr[32];
		int dnsock;

		ap = (unsigned char*)hp->h_addr_list[0];
		/* ap[3] = 0xFF;  (broad cast in the segment) */
		sprintf(saddr,"%d.%d.%d.%d",ap[0],ap[1],ap[2],ap[3]);

		if( RES_localdns == 0 ){
			if( 0 <= (dnsock = DNS_connect(saddr,PORT_DNS)) ){
				close(dnsock);
				RES_localdns = 1;
				debug(DBG_FORCE,"Found local NS (%s:%d)\n",
					saddr,PORT_DNS);
			}else{
				RES_localdns = -1;
				debug(DBG_FORCE,"No local NS (%s:%d)\n",
					saddr,PORT_DNS);
			}
		}
		if( 0 < RES_localdns )
			RES_ns1(&_RES,saddr,RES_NSDOM0);

	}
	if( (env = getenv("RES_DOMAIN")) || (env = getenv("LOCALDOMAIN")) ){
		strcpy(_RES.defdname,env);
		_RES.options &= ~RES_DNSRCH;
		_RES.options |=  RES_DEFNAMES;
	}

	if( _RES.defdname[0] )
		debug(DBG_ANY,"        RES_DOMAIN=%s\n",_RES.defdname);

	res_getoptions(_RES.options,options);
	debug(DBG_ANY,"        options = %s\n",options);
}

char resolv_errmsg[512];
int (*RES_debugprinter)();
res_debug(flag,fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n)
	char *fmt,*a,*b,*c,*d,*e,*f,*g,*h,*i,*j,*k,*l,*m,*n;
{	int now;

	if( flag == DBG_FORCE || _RES.options & RES_DEBUG && DNS_debug & flag ){
		now = time(0);
		if( RES_debugprinter )
			(*RES_debugprinter)(fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
		else{
			fprintf(stderr,"%02d:%02d ",(now%3600)/60,now%60);
			fprintf(stderr,fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
		}
		return 1;
	}else	return 0;
}
int (*RES_log)();
res_log(which,byname,name,rv,cname)
	char *name,*rv[],*cname;
{
	if( RES_log )
		(*RES_log)(which,byname,name,rv,cname);
}

static putNames(hp)
	struct hostent *hp;
{	unsigned char *op;
	int hi;

	printf("%s",hp->h_name);
	for( hi = 0; ;hi++){
		op = (unsigned char*)hp->h_aliases[hi];
		if( op == NULL )
			break;
		printf(",%s",op);
	}
}
static putAddrs(hp)
	struct hostent *hp;
{	unsigned char *op;
	int hi;

	for( hi = 0; ; hi++ ){
		op = (unsigned char*)hp->h_addr_list[hi];
		if( op == NULL )
			break;
		if( 0 < hi )
		printf(",");
		printf("%d.%d.%d.%d",op[0],op[1],op[2],op[3]);
	}
}

struct hostent *RES_gethost(addrhost)
	char *addrhost;
{	struct hostent *hp;
	VSAddr sab;
	int bleng,btype;
	char *baddr;

	if( VSA_strisaddr(addrhost) ){
		VSA_atosa(&sab,0,addrhost);
		bleng = VSA_decomp(&sab,&baddr,&btype,NULL);
		hp = _GETHOSTBYADDR(baddr,bleng,btype);
	}else{
		hp = _GETHOSTBYNAME(addrhost);
	}
	return hp;
}
RES_1(f_aton,fp,arg)
	FILE *fp;
	char *arg;
{	struct hostent *hp;

	if( f_aton ){
		if( VSA_strisaddr(arg) ) /* is IP address */
			if( hp = RES_gethost(arg) ){
				printf("%s\n",hp->h_name);
				return;
			}
		printf("%s\n",arg);
		return;
	}
	hp = RES_gethost(arg);

	if( hp ){
		unsigned char *op;
		int hi;
		putAddrs(hp);
		printf("\t");
		putNames(hp);
		printf("\n");
	}else{
		if( VSA_strisaddr(arg) )
			printf("?\t%s\n",arg);
		else	printf("%s\t?\n",arg);
		/*exit(1);*/
	}
}
RES_1s(addrhost,addr_host)
	char *addrhost;
	char *addr_host;
{	struct hostent *hp;
	unsigned char *op,addr[32];

	if( hp = RES_gethost(addrhost) ){
		op = (unsigned char *)hp->h_addr;
		sprintf(addr,"%d.%d.%d.%d",op[0],op[1],op[2],op[3]);
		sprintf(addr_host,"%s\t%s\n",addr,hp->h_name);
		return 1;
	}
	return 0;
}

extern int RSLV_TIMEOUT;
RES_timeout(timeout)
{
	RSLV_TIMEOUT = timeout;
	return 1;
}

RES_socks(ns,socks)
	char *ns,*socks;
{	char host[256];
	int port;

	if( *socks == 0 )
		return;

	port = 1080;
	sscanf(socks,"%[^:]:%d",host,&port);
	if( !VSA_strisaddr(host) )
		return;

	debug(DBG_ANY,"SOCKS=[%s][%s:%d]\n",ns,host,port);
	SOCKS_addserv(ns,PORT_DNS,host,port);
}

char **res_DNSRCH(){
	if( (_RES.options & RES_DNSRCH) && _RES.dnsrch[0] )
		return _RES.dnsrch;
	else	return NULL;
}
char *res_DEFDNAME(){
	if( (_RES.options & RES_DEFNAMES) && _RES.defdname[0] )
		return _RES.defdname;
	else	return NULL;
}



static int f_aton;
resolvy_main(ac,av)
	char *av[];
{	int ai;
	char *arg;

	DO_INITIALIZE(ac,av);

	if( ac <= 1 ){
fprintf(stderr,
"Usage -- %s [NS=nameserver] { domain-name | ip-address }\n",av[0]);
fprintf(stderr,
"<ip-address> can be specified as a range like: aa.bb.cc.dd-ee\n");
		exit(-1);
	}
	for( ai = 1; ai < ac; ai++ ){
		arg = av[ai];
		if( strncmp(arg,"-d",2) == 0 ){
			RES_debug(arg+2);
			continue;
		}else
		if( strcmp(arg,"+n") == 0 ){
			f_aton = 1;
			continue;
		}else
		if( strncmp(arg,"NS=",3) == 0 ){
			RES_ns(arg+3);
		}else
		if( strcmp(arg,"-") == 0 ){
			char line[256],*dp;

			while( fgets(line,sizeof(line),stdin) != NULL ){
				if( dp = strpbrk(line,"\r\n") )
					*dp = 0;
				RES_1(f_aton,stdout,line);
				fflush(stdout);
			}
		}else
		if( strcmp(arg,"-s") == 0 ){
			dns_server(0,1);
		}else{
			resolv1(arg);
		}
	}
	exit(0);
}
static resolv1(arg)
	char *arg;
{	int a1,a2,a3,a41,a42,a4;
	char addr[256];

	if( sscanf(arg,"%d.%d.%d.%d-%d",&a1,&a2,&a3,&a41,&a42) == 5 ){
		for( a4 = a41; a4 < a42; a4++ ){
			sprintf(addr,"%d.%d.%d.%d",a1,a2,a3,a4);
			RES_1(f_aton,stdout,addr);
		}
	}else{
		RES_1(f_aton,stdout,arg);
	}
	fflush(stdout);
}
