/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1997-1999 Yutaka Sato
Copyright (c) 1997-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	winreg.c (Windows Registory Access)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	980630	extracted from winserv.c
//////////////////////////////////////////////////////////////////////#*/

#ifdef _MSC_VER

#include <stdio.h>
#include <string.h>
#include <windows.h>
#include <winbase.h>

char *env_REGSERV = "REGSERV";

#define SERVICE_REG  "SYSTEM\\CurrentControlSet\\Services"
#define OSERVICE_REG "Software\\Microsoft\\Windows\\CurrentVersion"

regPutVec(what,servname,ac,av)
	char *what,*servname,*av[];
{	HKEY hkey;
	DWORD disp;
	LONG res;
	char rkey[1024];
	char args[0x2000],*ap;
	int ai;

	sprintf(rkey,"%s\\%s\\%s",SERVICE_REG,servname,what);
	res = RegCreateKeyEx(
		HKEY_LOCAL_MACHINE,
		rkey,
		NULL,
		"",
		REG_OPTION_NON_VOLATILE,
		KEY_ALL_ACCESS,
		NULL,
		&hkey,
		&disp);

	ap = args;
	for(ai = 0; ai < ac; ai++){
		strcpy(ap,av[ai]);
		ap += strlen(ap) + 1;
	}
	*ap++ = 0;

	res = RegSetValueEx(
		hkey,
		"ARGV",
		NULL,
		REG_MULTI_SZ,
		args, ap-args);

	if( res != 0 ){
		printf("ERROR. Cannot set registory: %s\r\n",av[ai]);
		exit(0);
	}

	printf("OK. %s are saved in registory:\r\n\"%s\\%s\"\n",
		what,"HKEY_LOCAL_MACHINE",rkey);

	RegCloseKey(hkey);
}
regGetVec(what,servname,ac,av)
	char *what,*servname,*av[];
{	HKEY hkey;
	char rkey[1024];
	char argb[0x2000],*args,*ap;
	int type,len,bi;
	int res;
	int nac;

	sprintf(rkey,"%s\\%s\\%s",SERVICE_REG,servname,what);
	res = RegOpenKeyEx(
		HKEY_LOCAL_MACHINE,
		rkey,
		NULL,
		KEY_QUERY_VALUE,
		&hkey);
		
	type = REG_MULTI_SZ;
	len = sizeof(argb);
	res = RegQueryValueEx(
		hkey,
		"ARGV",
		NULL,
		&type,
		argb,
		&len);

	args = malloc(len);
	bcopy(argb,args,len);

	nac = 0;
	for( ap = args; *ap; ap++ ){
		av[nac++] = ap;
		ap += strlen(ap);
	}
	av[nac] = 0;

	RegCloseKey(hkey);
	return nac;
}
regPutService(servname,ac,av)
	char *servname;
	char *av[];
{	char rkey[1024];
	HKEY hkey;
	LONG res;
	DWORD disp;
	char *a1,args[2048],*ap;
	int ai;
	int type,len;
	char value[2048],yn[128];
	char *rstype;

	if( (rstype = getenv(env_REGSERV)) == NULL )
		rstype = "once";
	if( strcaseeq(rstype,"once") )
		sprintf(rkey,"%s\\RunServicesOnce",OSERVICE_REG);
	else	sprintf(rkey,"%s\\RunServices",OSERVICE_REG);
	printf("Registory: HKEY_LOCAL_MACHINE\\%s\r\n",rkey);

	res = RegCreateKeyEx(
		HKEY_LOCAL_MACHINE,
		rkey,
		NULL,
		"",
		REG_OPTION_NON_VOLATILE,
		KEY_ALL_ACCESS,
		NULL,
		&hkey,
		&disp);

	if( res != ERROR_SUCCESS ){
		printf("ERROR: cannot open the registory\r\n");
		return -1;
	}

	len = sizeof(value);
	res = RegQueryValueEx(hkey,servname,NULL,&type,value,&len);
	if( res == ERROR_SUCCESS ){
		printf("Serivce exists: %s = %s\n",servname,value);
		printf("Remove it ? [y] / n : ");
		fflush(stdout);
		fgets(yn,sizeof(yn),stdin);
		if( yn[0] != 'y' && yn[0] != '\r' && yn[0] != '\n' )
			goto EXIT;
		RegDeleteValue(hkey,servname);
		printf("Register new service ? [y] / n : ");
		fflush(stdout);
		fgets(yn,sizeof(yn),stdin);
		if( yn[0] != 'y' && yn[0] != '\r' && yn[0] != '\n' )
			goto EXIT;
	}

	ap = args;
	for( ai = 0; ai < ac; ai++ ){
		if( 0 < ai )
			*ap++ = ' ';
		a1 = av[ai];
		if( strpbrk(a1," \t") && strchr(a1,'"') == NULL )
			sprintf(ap,"\"%s\"",a1);
		else	strcpy(ap,a1);
		ap += strlen(ap);
	}
	strcpy(ap," -SERVICE");

	res = RegSetValueEx(
		hkey,
		servname,
		NULL,
		REG_SZ,
		args, strlen(args));
	printf("Registered new serivce: %s = %s\r\n",servname,args);
	printf("Reboot the system to enable this service.\r\n");

EXIT:
	RegCloseKey(hkey);
	return 0;
}
regGetResolvConf(buf,where)
	char *buf,*where;
{	HKEY hkey;
	char rkey[1024];
	LONG res;
	char *bp;
	int type,len,nv,vi;
	char value[1024],vv[4][256];

	buf[0] = 0;
	sprintf(rkey,"%s\\%s\\%s",SERVICE_REG,"Tcpip","Parameters");
	res = RegOpenKeyEx(HKEY_LOCAL_MACHINE, rkey, NULL,
		KEY_QUERY_VALUE, &hkey);

	if( res != ERROR_SUCCESS ){
		sprintf(rkey,"%s\\%s\\%s",SERVICE_REG,"VxD","MSTCP");
		res = RegOpenKeyEx(HKEY_LOCAL_MACHINE, rkey, NULL,
			KEY_QUERY_VALUE, &hkey);
		if( res != ERROR_SUCCESS )
			return -1;
	}

	if( where )
		strcpy(where,rkey);
	bp = buf;

	type = REG_SZ;
	len = sizeof(value);
	res = RegQueryValueEx(hkey,"Domain",NULL,&type,value,&len);
	if( res == ERROR_SUCCESS && value[0] ){
		sprintf(bp,"domain %s\r\n",value);
		bp += strlen(bp);
	}

	type = REG_SZ;
	len = sizeof(value);
	res = RegQueryValueEx(hkey,"SearchList",NULL,&type,value,&len);
	if( res == ERROR_SUCCESS && value[0] ){
		sprintf(bp,"search %s\r\n",value);
		bp += strlen(bp);
	}

	type = REG_SZ;
	len = sizeof(value);
	res = RegQueryValueEx(hkey,"NameServer",NULL,&type,value,&len);
	if( res == ERROR_SUCCESS && value[0] ){
		char *dp;
		for( dp = value; *dp; dp++ )
			if( *dp == ',' )
				*dp = ' ';
		nv = sscanf(value,"%s %s %s %s",vv[0],vv[1],vv[2],vv[3]);
		for( vi = 0; vi < nv; vi++ )
		{
			sprintf(bp,"nameserver %s\r\n",vv[vi]);
		bp += strlen(bp);
		}
	}

	RegCloseKey(hkey);
	return 0;
}


#else
regGetResolvConf(buf,where)
	char *buf,*where;
{
	*buf = 0;
	return -1;
}
#endif
