/*////////////////////////////////////////////////////////////////////////
Copyright (c) 2000 Yutaka Sato
Copyright (c) 2000 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	sed.c (small subset of sed)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	000607	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
extern void *frex_create();
extern char *frex_matchX();

#define LNSIZE	1024
#define SC_ECHO		0x1000
#define SC_GLOB		0x8000
#define SC_MATCH	0x0001
#define SC_PRINT	0x0010
#define SC_SUBST	0x0020
#define SC_DELETE	0x0040
#define ISBLANKLN(line)	(*line=='\r' || *line=='\n')

typedef struct _SedCom {
	int	 c_com;
	char	 c_matchpat[128];
	void	*c_matchrex;
	char	 c_srcpat[128];
	void	*c_srcrex;
	char	 c_outpat[128];
struct _SedCom	*c_next;
} SedCom;
typedef struct {
	int	 s_noecho;
	int	 s_putlnum;	/* line number (cat -n) */
	int	 s_unbuff;	/* unbuffered output (cat -u) */
	int	 s_visual;	/* visualize non-printing char (cat -v) */
	int	 s_sbline;	/* to a single blank line (more -s) */
	int	 s_uniqln;	/* (uniq) */
	char	 s_prevline[LNSIZE];
	SedCom	*s_com1;
	SedCom	*s_come;
} SedEnv;

SedEnv *sed_new()
{	SedEnv *se;

	se = (SedEnv*)calloc(1,sizeof(SedEnv));
	return se;
}
sed_free(se)
	SedEnv *se;
{
}
static char *scan_pat(str,delch,pat,rexp,skip)
	char *str,*pat;
{	char *sp,sc,*op;

	op = pat;
	sp = str;
	if( rexp ){
		if( *sp == '^' ){
			sp++;
		}else{
			/**op++ = '.';*/
			*op++ = '*';
		}
	}
	for(; sc = *sp; sp++ ){
		if( sc == delch ){
			if( skip )
				sp++;
			break;
		}
		*op++ = sc;
	}
	*op = 0;
	return sp;
}
sed_compile(se,command)
	SedEnv *se;
	char *command;
{	char *com;
	SedCom *sc;
	char delch;

	sc = (SedCom*)calloc(1,sizeof(SedCom));
	com = command;
	if( *com == '/' ){
		com = scan_pat(com+1,'/',sc->c_matchpat,1,1);
		sc->c_matchrex = frex_create(sc->c_matchpat);
	}
	switch( *com ){
	case 's':
		sc->c_com |= SC_SUBST;
		delch = com[1];
		com = scan_pat(com+2,delch,sc->c_srcpat,1,0);
		sc->c_srcrex = frex_create(sc->c_srcpat);
		if( *com != delch ){
		}else{
			com = scan_pat(com+1,delch,sc->c_outpat,0,0);
		}
		break;
	}
	for(; *com; com++ ){
		switch( *com ){
		case 'd': sc->c_com |= SC_DELETE; break;
		case 'g': sc->c_com |= SC_GLOB; break;
		case 'p': sc->c_com |= SC_PRINT; break;
		}
	}
	if( se->s_com1 == 0 )
		se->s_com1 = sc;
	if( se->s_come )
		se->s_come->c_next = sc;
	se->s_come = sc;
	return 0;
ERROR:
	free(sc);
	return -1;
}
static char *sed_fmt(sc,op,spat,len)
	SedCom *sc;
	char *op,*spat;
{	char fc,*fp;

	for( fp = sc->c_outpat; fc = *fp; fp++ ){
		if( fc == '&' ){
			bcopy(spat,op,len);
			op += len;
		}else	*op++ = fc;
	}
	*op = 0;
	return op;
}
static apply_commands(se,iline,oline)
	SedEnv *se;
	char *iline,*oline;
{	SedCom *sc;
	char *start,*next,*op,*ip;
	int len;
	int match = 0;
	char lineb[LNSIZE];

	for( sc = se->s_com1; sc; sc = sc->c_next ){
		if( se->s_noecho && (sc->c_com & SC_PRINT) == 0 ){
			continue;
		}
		if( sc->c_matchrex ){
			if( next = frex_matchX(sc->c_matchrex,iline,&start) )
				match |= SC_MATCH;
			else	continue;
		}
		if( sc->c_com & SC_DELETE ){
			match |= SC_DELETE;
			oline[0] = 0;
			continue;
		}

		if( sc->c_srcrex ){
			ip = iline;
			op = oline;
			while( next = frex_matchX(sc->c_srcrex,ip,&start) ){
				match |= SC_SUBST;
				len = start - ip;
				bcopy(ip,op,len);
				op += len;
				op = sed_fmt(sc,op,start,next-start);
				ip = next;
				if( (sc->c_com & SC_GLOB) == 0 )
					break;
			}
			strcpy(op,ip);
			strcpy(lineb,oline);
			iline = oline;
		}
	}
	return match;
}
sed_execute(se,in,out,err)
	SedEnv *se;
	FILE *in,*out,*err;
{	char iline[LNSIZE],oline[LNSIZE],vline[LNSIZE];
	int match,match1;
	SedCom *sc;
	char *crp,crlfb[4];

	while( fgets(iline,sizeof(iline),in) != NULL ){
		if( se->s_noecho )
			match = 0;
		else	match = SC_ECHO;
		if( crp = strpbrk(iline,"\r\n") ){
			strncpy(crlfb,crp,sizeof(crlfb));
			*crp = 0;
		}
		strcpy(oline,iline);
		if( se->s_com1 ){
			match1 = apply_commands(se,iline,oline);
			if( oline[0] == 0 && (match1 & SC_DELETE) )
				continue;
			match |= match1;
		}
		strcat(oline,crlfb);
		if( se->s_sbline ){
			if( ISBLANKLN(oline) )
			if( ISBLANKLN(se->s_prevline) )
				match = 0;
		}
		if( se->s_uniqln ){
			if( strcmp(oline,se->s_prevline) == 0 )
				match = 0;
		}
		if( match == 0 )
			continue;

		if( se->s_putlnum ){
			fprintf(out,"%6d\t",se->s_putlnum);
			se->s_putlnum++;
		}
		if( se->s_visual ){
			Str2vstr(oline,strlen(oline),vline,sizeof(vline));
			fputs(vline,out);
		}else{
			fputs(oline,out);
		}
		if( se->s_unbuff && ready_cc(in) <= 0 )
			fflush(out);
		strcpy(se->s_prevline,oline);
	}
}

static FILE *fin,*fout;
sed_main(ac,av)
	char *av[];
{	int ai;
	char *arg,*ap;
	FILE *in,*out,*err;
	SedEnv *se;
	char *com;
	int ifiles;

	if( ac <= 1 ){
		fprintf(stderr,"Usage: %s [-nsuNU] command [files]\n",av[0]);
		return -1;
	}

	se = sed_new();
	if( fout )
		out = fout;
	else	out = stdout;
	if( fin )
		in = fin;
	else	in = stdin;
	err = stderr;
	ifiles = 0;
	com = 0;
	for( ai = 1; ai < ac; ai++ ){
		arg = av[ai];
		if( strcmp(arg,"-e") == 0 ){
			arg = av[++ai];
			if( ai < ac ){
				com = arg;
				sed_compile(se,arg);
			}
		}else
		if( strcmp(arg,"-f") == 0 ){
		}else
		if( *arg == '-' ){
			for( ap = arg+1; *ap; ap++ ){
				switch( *ap ){
				case 'n': se->s_noecho = 1; break;
				case 's': se->s_sbline = 1; break;
				case 'u': se->s_unbuff = 1; break;
				case 'v': se->s_visual = 1; break;
				case 'N': se->s_putlnum = 1; break;
				case 'U': se->s_uniqln = 1; break;
				}
			}
		}else
		if( com == 0 ){
			com = arg;
			sed_compile(se,arg);
		}else{
			ifiles++;
			in = fopen(arg,"r");
			if( in == NULL ){
				fprintf(stderr,"%s: cannot open\r\n",arg);
				return -1;
			}
			sed_execute(se,in,out,err);
		}
	}
	if( ifiles == 0 ){
		sed_execute(se,in,out,err);
	}
	return 0;
}
sedFilter(in,out,comline,args)
	FILE *in,*out;
	char *comline,*args;
{	char *av[128],argb[2048];
	int ac;

	ac = decomp_args(av,128,comline,argb);
	fin = in;
	fout = out;
	sed_main(ac,av);
}
