/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1999 Yutaka Sato
Copyright (c) 1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	randstack.c (randomize stack base)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	991118	created
ToDo:
	- the order of environ[*] should be randomized also
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "yalloca.h"
int RAND_TRACE = 0;
int RANDSTACK_RANGE = 64;
int RANDSTACK_UNIT = 128;
static unsigned int prev_rand;

static unsigned int trand1(max)
	unsigned int max;
{	unsigned int sec,usec;
	int nrand;

	sec = Gettimeofday(&usec);
	nrand = ((prev_rand<<8) ^ (usec >> 10)) % max;
	prev_rand = nrand;
	return nrand;
}

randstack_call(func,a0,a1,a2,a3)
	int (*func)();
	char *a0,*a1,*a2,*a3;
{	AllocaArg arg;
	unsigned int size;

	if( RANDSTACK_RANGE == 0 )
		size = 0;
	else	size = trand1(RANDSTACK_RANGE);
	arg.s_what = "#### RANDSTACK";
	arg.s_sp0 = (unsigned int)&func;
	arg.s_func = func;
	arg.s_av[0] = a0; arg.s_av[1] = a1;
	arg.s_av[2] = a2; arg.s_av[3] = a3;
	arg.s_size = size;
	arg.s_unit = RANDSTACK_UNIT;
	arg.s_count = size;
	arg.s_trace = RAND_TRACE;
	return alloca_call(&arg);
}

int RANDENV_RANGE = 1024;
randenv()
{	int randen,ex;
	char rande[0x4000];

	if( RANDENV_RANGE <= 0 )
		return;
	randen = trand1(RANDENV_RANGE);
	strcpy(rande,"RANDENV=");
	for( ex = 0; ex < randen; ex++ )
		rande[8+ex] = 'X';
	rande[8+ex] = 0;
	putenv(strdup(rande));
	if( RAND_TRACE )
		porting_dbg("#### RANDENV (%4d)",randen);
}

int RANDFD_RANGE = 32;
static getrandfd(tfd,rand)
{	int fds[256],nfd,rfd,fdi,fdx,foff;

	rfd = tfd;
	for( fdx = 0; fdx < rand; ){
		nfd = dup(tfd);
		if( nfd < 0 ){
			/* no more fd, so select from available ones */
			if( 1 < fdx ){
				foff = trand1(fdx);
				rfd = fds[foff];
			}
			break;
		}
		fds[fdx++] = nfd;
		rfd = nfd;
	}
	for( fdi = 0; fdi < fdx; fdi++ ){
		close(fds[fdi]);
	}
	return rfd;
}
randfd(fd)
{	unsigned int foff;
	int tfd,rfd;
	FILE *tmp;

	if( fd < 0 )
		return fd;

	if( RANDFD_RANGE == 0 )
		return fd;

	tmp = fopen("/dev/null","r");
	if( tmp == NULL )
		tmp = tmpfile();
	if( tmp == NULL )
		return fd;
	tfd = fileno(tmp);

	foff = trand1(RANDFD_RANGE);

	rfd = getrandfd(tfd,foff);
	fclose(tmp);

	rfd = dup2(fd,rfd);
	if( 0 <= rfd )
		close(fd);
	else	rfd = fd;

/*
	if( RAND_TRACE ){
		fprintf(stderr,"#### RANDFD (%2d) = %2d -> %2d\n",foff,fd,rfd);
	}
*/
	return rfd;
}
