/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1998-1999 Electrotechnical Laboratry (ETL), AIST, MITI
Copyright (c) 1998-1999 Yutaka Sato

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	nbio.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	980804	extracted from inets.c
//////////////////////////////////////////////////////////////////////#*/

#include <errno.h>
#include <stdio.h>
#include "vsocket.h"

connectTO(sock,addr,leng,timeout)
	SAP addr;
{	int NB;
	int rcode;
	int nready;

	if( timeout == 0 )
		return connect(sock,addr,leng);

	NB = getNonblockingIO(sock);
	if( !NB ) rcode = setNonblockingIO(sock,1);

	errno = 0;
	rcode = connect(sock,addr,leng);

	if( rcode == 0 ){
		if( !NB ) setNonblockingIO(sock,0);
		return 0;
	}
	switch( errno ){
	  case ECONNREFUSED:
	  case ENETUNREACH:
	  case EHOSTUNREACH:
		syslog_ERROR("## connect[%d] refused (%d)\n",sock,errno);
		return -1;
	}

	nready = PollOut(sock,timeout);
	if( !NB ) setNonblockingIO(sock,0);

	if( nready <= 0 ){
		syslog_ERROR("## connect[%d] TIMEOUT(%d)\n",sock,timeout);
		errno = ETIMEDOUT;
		return -1;
	}

	if( !sock_isconnected(sock) ){
		syslog_ERROR("## connect[%d] failure (%d)\n",sock,errno);
		errno = ETIMEDOUT;
		return -1;
	}

	return 0;
}

SetNonblockingIO(what,sock,on)
	char *what;
{	int onbio,nnbio;

	if( sock < 0 )
		return;

	onbio = getNonblockingIO(sock);
	setNonblockingIO(sock,on);
	nnbio = getNonblockingIO(sock);
	if( onbio != nnbio )
		syslog_DEBUG("NBIO[%s][%d] %d -> %d\n",what,sock,onbio,nnbio);
}

sendOOB(sock,buff,size)
	char *buff;
{
	return send(sock,buff,size,MSG_OOB);
}
recvOOB(sock,buff,size)
	char *buff;
{
	if( 0 < recv(sock,buff,size,MSG_OOB|MSG_PEEK) )
		return recv(sock,buff,size,MSG_OOB);
	else	return -1;
}
/* relay OOB (maybe SYNCH signal of Telnet) */
relayOOB(in,out)
{	char buff[128];
	int rcc;
	int pi,nready;

	msleep(1);
	SetNonblockingIO("relayOOB",in,1);
	rcc = recvOOB(in,buff,sizeof(buff));
	SetNonblockingIO("relayOOB",in,0);
	if( rcc != 1 )
		return 0;

	syslog_DEBUG("relay OOB: [%d]->[%d] %dbytes (%x)\n",
		in,out,rcc,buff[0]&0xFF);
	sendOOB(out,buff,rcc);

	/* if the protocol is Telnet,
	 *  in-band data should be ignored until the MARK(242) ... */
	for( pi = 0; pi < 50; pi++ ){
		if( nready = PollIn(in,1) )
			break;
		msleep(10);
	}
	syslog_DEBUG("relay OOB: nready=%d after %dms\n",nready,pi*10);

	return 1;
}
Peek1(sock){
	char buf[1];
	return recv(sock,buf,1,MSG_PEEK);
}

Send(s,buf,len)
	char *buf;
{	int wcc;

	wcc = send(s,buf,len,0);
	return wcc;
}
RecvFrom(sock,buf,len,froma,fromp)
	char *buf;
	char *froma;
	int *fromp;
{	VSAddr from;
	int rcc,fromlen;

	fromlen = sizeof(from);
	rcc = SOCKS_recvfrom(sock,buf,len,0,(SAP)&from,&fromlen);
	strcpy(froma,VSA_ntoa(&from));
	*fromp = VSA_port(&from);
	return rcc;
}
SendTo(sock,buf,len,host,port)
	char *buf,*host;
{	VSAddr to;
	int tolen;

	tolen = VSA_atosa(&to,port,host);
	return SOCKS_sendto(sock,buf,len,0,(SAP)&to,tolen);
}

/*
 * 991112 extracted from tcprelay.c
 */
int dump_tcprelay = 0;
static bdump(src,dst,buf,rcc)
	char *buf;
{	int rc,ch;

	printf("[%2d->%2d](%d) ",src,dst,rcc);
	for( rc = 0; rc < rcc; rc++ ){
		ch = buf[rc] & 0xFF;
		if( 0x21 <= ch && ch <= 0x7E )
			printf("%c",ch);
		else	printf(".");
	}
	printf(" ");
	for( rc = 0; rc < rcc; rc++ ){
		if( rc != 0 ) printf(" ");
		ch = buf[rc] & 0xFF;
		printf("%02x",ch);
	}
	printf("\n");
}

simple_relayTimeout(src,dst,timeout)
{	int rcc,wcc,rcc1,wcc1,nio;

	rcc = wcc = 0;
	for( nio = 0;; nio++ ){
		if( !IsWindows95() || file_ISSOCK(src) )
		if( timeout != 0 )
		if( PollIn(src,timeout) <= 0 )
			break;
		if( relay1(NULL,src,dst,&rcc1,&wcc1) <= 0 )
			break; 
		rcc += rcc1;
		wcc += wcc1;
	}
	syslog_ERROR("simple_relay [%d -> %d] = (%d -> %d) / %d\n",
		src,dst,rcc,wcc,nio);
	return rcc;
}

#include "fpoll.h"
simple_relayfTimeout(src,dst,timeout)
	FILE *src,*dst;
{	int rcc,wcc,ch;

	for( rcc = 0; READYCC(src); rcc++ ){
		ch = getc(src);
		if( ch == EOF )
			return rcc;
		putc(ch,dst);
	}
	fflush(dst);
	syslog_ERROR("simple_relayf [%d -> %d] = %d\n",
		fileno(src),fileno(dst),rcc);
	return rcc + simple_relayTimeout(fileno(src),fileno(dst),timeout);
}

relay_tee(arg,src,dst1,dst2,rccp,wccp1,wccp2)
	char *arg;
	int *rccp,*wccp1,*wccp2;
{	int rcc,wcc,wc1;
	char buf[0x4000];

	*wccp1 = 0;
	if( wccp2 ) *wccp2 = 0;

	rcc = read(src,buf,sizeof(buf));
	*rccp = rcc;
	if( rcc <= 0 )
		return rcc;

	if( dump_tcprelay )
		bdump(src,dst1,buf,rcc);

	wcc = 0;
	while( wcc < rcc ){
		wc1 = write(dst1,buf,rcc);
		if( wc1 <= 0 )
			break;
		wcc += wc1;
	}
	*wccp1 = wcc;
	if( dst2 < 0 || wc1 <= 0 )
		return wc1;

	wcc = 0;
	while( wcc < rcc ){
		wc1 = write(dst2,buf,rcc);
		if( wc1 <= 0 )
			break;
		wcc += wc1;
	}
	*wccp2 = wcc;
	return wc1;
}
static relay1(arg,src,dst,rccp,wccp)
	char *arg;
	int *rccp,*wccp;
{
	return relay_tee(arg,src,dst,-1,rccp,wccp,NULL);
}

typedef int (*IFUNC)();
#define IGN_EOF	1
int RELAYS_IGNEOF;

relaysx(timeout,sdc,sdv,sdx,rccs,funcv,argv)
	int sdv[][2];
	int sdx[];
	int rccs[];
	IFUNC funcv[];
	char *argv[];
{	int fi;
	int pc,pi,pfv[32],pxv[32];
	int fds[32],errv[32],rfds[32];
	int sdxb[32];
	int cntv[32];
	int rcode,rcc,wcc;
	IFUNC funcvb[32];
	char *argvb[32];
	int nready;

	syslog_ERROR("relays(%d) start: timeout=%dmsec\n",sdc,timeout);

	if( funcv == NULL ){
		funcv = funcvb;
		for( fi = 0; fi < sdc; fi++ )
			funcv[fi] = NULL;
	}
	if( argv == NULL ){
		argv = argvb;
		for( fi = 0; fi < sdc; fi++ )
			argv[fi] = NULL;
	}

	for( fi = 0; fi < sdc; fi++ ){
		fds[fi] = sdv[fi][0];
		errv[fi] = 0;
		rccs[fi] = 0;
		cntv[fi] = 0;
		if( funcv[fi] == NULL )
			funcv[fi] = relay1;

		if( sdx == NULL ){
			sdxb[fi] = 0;
			if( RELAYS_IGNEOF ){
				if( file_issock(sdv[fi][0]) < 0 )
					sdxb[fi] |= IGN_EOF;
			}
		}
	}
	if( sdx == NULL )
		sdx = sdxb;

	for(;;){
	    pc = 0;
	    for( fi = 0; fi < sdc; fi++ ){
		if( errv[fi] == 0 ){
			pfv[pc] = fds[fi];
			pxv[pc] = fi;
			pc++;
		}
	    }
	    if( pc == 0 )
		break;

	    errno = 0;
	    nready = PollIns(timeout,pc,pfv,rfds);
	    if( nready == 0 && errno == 0 ){
		int fi,sync;

		sync = 0;
		for( fi = 0; fi < sdc; fi++ )
			sync += relayOOB(sdv[fi][0],sdv[fi][1]);
		if( sync )
			continue;

		Usleep(1);
		nready = PollIns(1,pc,pfv,rfds);
		if( 0 < nready ){
			syslog_ERROR("## tcprelay: ignore OOB?\n");
			continue;
		}
	    }
	    if( nready <= 0 )
		break;

	    for( pi = 0; pi < pc; pi++ ){
		if( 0 < rfds[pi] ){
			fi = pxv[pi];
			rcode = (*funcv[fi])(argv[fi],sdv[fi][0],sdv[fi][1],&rcc,&wcc);
			rccs[fi] += wcc;
			cntv[fi] += 1;
			if( rcode <= 0 ){
				syslog_ERROR(
					"relays[%d]: [%d->EOF] %d(%di+%do)\n",
					fi,fds[fi],rcode,rcc,wcc);
				if( sdx == NULL || (sdx[fi] & IGN_EOF) == 0 )
					goto EXIT;
				else	errv[fi] = 1;
			}
		}
	    }
	}
EXIT:
	for( fi = 0; fi < sdc; fi++ )
		syslog_ERROR("relays[%d]: [%d->%d] %d bytes / %d\n",fi,
			sdv[fi][0],sdv[fi][1],rccs[fi],cntv[fi]);
}
relays(timeout,sdc,sdv,rccs)
	int sdv[][2];
	int rccs[];
{
	relaysx(timeout,sdc,sdv,NULL,rccs,NULL,NULL);
}
tcp_relay2(timeout,s1,d1,s2,d2)
{	int sdv[2][2];
	int rccs[2];

	sdv[0][0] = s1;
	sdv[0][1] = d1;
	sdv[1][0] = s2;
	sdv[1][1] = d2;
	relays(timeout,2,sdv,rccs);
}
relay2_cntl(timeout,s1,d1,s2,d2,s3,d3,cntlfunc,arg)
	IFUNC cntlfunc;
	char *arg;
{	int sdv[3][2];
	int rccs[3];
	IFUNC fnv[3];
	char *agv[3];

	sdv[0][0] = s1;
	sdv[0][1] = d1;
	fnv[0] = 0;
	agv[0] = 0;

	sdv[1][0] = s2;
	sdv[1][1] = d2;
	fnv[1] = 0;
	agv[1] = 0;

	sdv[2][0] = s3;
	sdv[2][1] = d3;
	fnv[2] = cntlfunc;
	agv[2] = arg;

	relaysx(timeout,3,sdv,NULL,rccs,fnv,agv);
}



#if defined(sun) && !defined(NC_TPI_CLTS)
#define SunOS4bin 1 /* this binary is compiled on SunOS4.X */
#else
#define SunOS4bin 0
#endif
Getsockopt(s,level,optname,optval,optlen)
	char *optval;
	int *optlen;
{
	int rcode;

	if( IsBOW1_5() ){
		syslog_DEBUG("BOW1.5: ignore getsockopt(%d,%x)...\n",s,optname);
		return -1; /* avoid a bug of BOW1.5 ... */
	}
	rcode = getsockopt(s,level,optname,optval,optlen);
	if( rcode == 0 && optname == SO_TYPE && SunOS4bin && IsSolaris() ){
		switch( *(int*)optval ){
			case SOCK_DGRAM:  *(int*)optval = SOCK_STREAM; break;
			case SOCK_STREAM: *(int*)optval = SOCK_DGRAM;  break;
		}
	}
	return rcode;
}
Setsockopt(s,level,optname,optval,optlen)
	char *optval;
{
	return setsockopt(s,level,optname,optval,optlen);
}
getsocktype(sock)
{	int type,len;

	len = sizeof(type);
	if( Getsockopt(sock,SOL_SOCKET,SO_TYPE,&type,&len) == 0 )
		return type;
	return -1;
}
isUDPsock(sock)
{	int type;

	type = getsocktype(sock);
	return type == SOCK_DGRAM;
}
file_ISSOCK(fd)
{
	return 0 <= getsocktype(fd);
}
file_issock(fd)
{	int ISSOCK;

	if( isatty(fd) || file_isreg(fd) )
		return -1;

	ISSOCK = file_ISSOCK(fd);
	if( 0 < ISSOCK )
		return ISSOCK;
	if( 0 < getsocktype(fd) )
		return 1;
	return -1;
}

set_nodelay(sock,onoff)
{	int ooo,oon,len;

	len = sizeof(ooo);
	Getsockopt(sock,IPPROTO_TCP,TCP_NODELAY,&ooo,&len);
	Setsockopt(sock,IPPROTO_TCP,TCP_NODELAY,&onoff,sizeof(onoff));
	len = sizeof(oon);
	Getsockopt(sock,IPPROTO_TCP,TCP_NODELAY,&oon,&len);
	syslog_DEBUG("TCP_NODELAY[%d] %d -> %d\n",sock,ooo,oon);
}
setsockSHARE(sock,onoff)
{
#ifdef SO_REUSEPORT
	return Setsockopt(sock,SOL_SOCKET,SO_REUSEPORT,&onoff,sizeof(onoff));
#else
	return -1;
#endif
}
setsockREUSE(sock,onoff)
{
	Setsockopt(sock,SOL_SOCKET,SO_REUSEADDR,&onoff,sizeof(onoff));
}
set_keepalive(sock,on)
{	int On = 1, No = 0;	
	int Ov = -1, len = sizeof(Ov);

	if( on)
		Setsockopt(sock, SOL_SOCKET, SO_KEEPALIVE, &On, sizeof(On));
	else	Setsockopt(sock, SOL_SOCKET, SO_KEEPALIVE, &No, sizeof(No));
	Getsockopt(sock, SOL_SOCKET, SO_KEEPALIVE, &Ov, &len);
	syslog_DEBUG("KeepAlive[%d] = %d\n",sock,Ov);
	return Ov;
}
getsockbuf(sock,in,out)
	int *in,*out;
{	int len;
	int rcode;

	*in = 0;
	*out = 0;

	len = sizeof(int);
	rcode = Getsockopt(sock, SOL_SOCKET, SO_RCVBUF, in,&len);
	len = sizeof(int);
	rcode = Getsockopt(sock, SOL_SOCKET, SO_SNDBUF, out,&len);
	return rcode;
}
setsockbuf(sock,in,out)
{	int ois,is,oos,os;
	int len;

	if( 0 < in ){
		len = sizeof(ois);
		Getsockopt(sock, SOL_SOCKET, SO_RCVBUF, &ois,&len);
		is = in;
		Setsockopt(sock, SOL_SOCKET, SO_RCVBUF, &is,sizeof(is));
	}else	ois = is = 0;

	if( 0 < out ){
		len = sizeof(oos);
		Getsockopt(sock, SOL_SOCKET, SO_SNDBUF, &oos,&len);
		os = out;
		Setsockopt(sock, SOL_SOCKET, SO_SNDBUF, &os,sizeof(os));
	}else	oos = os = 0;
	syslog_DEBUG("setsockbuf[%d] in:%d->%d out:%d->%d\n",sock,ois,is,oos,os);
}
expsockbuf(sock,in,out)
{	int isize,osize;

	if( getsockbuf(sock,&isize,&osize) == 0 ){
		if( in  <= isize ) in = 0;
		if( out <= osize ) out = 0;
		if( in || out )
			return setsockbuf(sock,in,out);
		else	return 0;
	}
	return -1;
}
set_linger(sock,secs)
{	struct linger sl,gl;
	int len,rcode;

	if( secs ){
		sl.l_onoff = 1;	/* on */
		sl.l_linger = secs;	/* seconds */
	}else{
#ifdef hpux
		sl.l_onoff = 1;
		sl.l_linger = 0;
#else
		sl.l_onoff = 0;
		sl.l_linger = 0;
#endif
	}
	rcode = Setsockopt(sock, SOL_SOCKET, SO_LINGER, &sl, sizeof(sl));
	if( rcode != 0 ){
		syslog_DEBUG("setsockopt(%d,LINGER) faield, errno=%d\n",sock,errno);
		return;
	}

	len = sizeof(gl);
	rcode = Getsockopt(sock, SOL_SOCKET, SO_LINGER, &gl, &len);
	if( rcode != 0 )
		syslog_DEBUG("getsockopt(%d,LINGER) failed, errno=%d\n",sock,errno);
	else	syslog_DEBUG("LINGER: [%d] %d %d{%d,%d}\n",sock,secs,
			len,gl.l_onoff,gl.l_linger);
}


