/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1995 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	fpoll.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	950707	extracted from iotimeout.c
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>

readyAlways(fd)
{
	if( file_isreg(fd) )
		return 1;

	if( !FS_maybeUnix() && !file_isselectable(fd) )
		return 1;

	return 0;
}

_fPollIn(fp,msec)
	FILE *fp;
{
	if( feof(fp) )
		return -1;
	if( 0 < ready_cc(fp) )
		return 1;

	if( readyAlways(fileno(fp)) )
		return 1;

	if( 0 < _PollIn(fileno(fp),msec) )
		return 2;
	return 0;
}

fPollIn(fp,msec)
	FILE *fp;
{	int nready;

	nready = _fPollIn(fp,msec);
	if( nready == 0 ){
		if( poll_error(fileno(fp)) )
			nready = -1;
	}
	return nready;
}

PollIn(fd,msec)
{	int nready;

	nready = _PollIn(fd,msec);
	if( nready == 0 ){
		if( poll_error(fd) )
			nready = -1;
	}
	return nready;
}

_PollIn(fd,msec)
	int fd;
	int msec;
{	int nready;

	if( fd < 0 )
		return -1;

	nready = pollPipe(fd,msec);
	if( 0 <= nready )
		return nready;

	return PollIn1(fd,msec);
}
