/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:   program/C; charset=US-ASCII
Program:        ftime.c (portable strftime())
Author:         Yutaka Sato <ysato@etl.go.jp>
Description:
History:
        950203	extracted from ftime.c
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "vsocket.h"

long Gettimeofday(usec)
	int *usec;
{	struct timeval tv;

	gettimeofday(&tv, NULL);
	if( usec )
		*usec = tv.tv_usec;
	return tv.tv_sec;
}
double Time()
{	long sec;
	int usec;

	sec = Gettimeofday(&usec);
	return sec + usec / 1000000.0;
}

static double StartTime;
SetStartTime(){ StartTime = Time(); }
double GetStartTime(){ return StartTime; }
