#include "global.h"
#include "md5.h"
#include <stdio.h>

#define MD_CTX   MD5_CTX
#define MDInit   MD5Init
#define MDUpdate MD5Update
#define MDFinal  MD5Final

static char HEXCH[] = "0123456789abcdef";

MD5toa(digest,md5a)
	unsigned char *digest;
	char *md5a;
{	char *mp;
	unsigned char dg1;
	unsigned int i;

	mp = md5a;
	for (i = 0; i < 16; i++){
		dg1 = digest[i];
		*mp++ = HEXCH[dg1 >>4];
		*mp++ = HEXCH[dg1&0xF];
	}
	*mp = 0;
}
toMD5(str,md5)
	char *str,*md5;
{	MD_CTX context;
	unsigned char digest[16];
	unsigned int len = strlen (str);

	MDInit(&context);
	MDUpdate(&context, str, len);
	MDFinal(digest, &context);

	MD5toa(digest,md5);
}
ftoMD5(fp,md5)
	FILE *fp;
	char *md5;
{	MD_CTX context;
	unsigned char digest[16];
	char buf[1024];
	int rcc;

	MDInit(&context);
	while( 0 < (rcc = fread(buf,1,sizeof(buf),fp)) )
		MDUpdate(&context,buf,rcc);
	MDFinal(digest, &context);
	MD5toa(digest,md5);
}
msgMD5(fs,tc,md5a)
	FILE *fs,*tc;
	char *md5a;
{	MD_CTX context;
	unsigned char digest[16];
	char buf[1024];
	int size,len;

	size = 0;
	MDInit(&context);
	while( fgets(buf,sizeof(buf),fs) != NULL ){
		if( tc != NULL )
			fputs(buf,tc);
		if( buf[0] == '.' && buf[1] == '\r' )
			break;
		len = strlen(buf);
		size += len;
		MDUpdate(&context,buf,len);
	}
	MDFinal(digest,&context);
	MD5toa(digest,md5a);
	return size;
}
