/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1995 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	rfc822.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	941008	extracted from nntp.c
	950312	encode/decode parts in a multipart message
	951029	extracted from mime.c of DeleGate
//////////////////////////////////////////////////////////////////////#*/
#include "mime.h"
char *RFC822_fgetsHeaderField();

extern char *getFieldValue2();
#define getFieldValue(str,fld,buf,siz) getFieldValue2(str,fld,buf,siz)

char *findField(head,field,value)
	char *head,*field,**value;
{	char *nsp,*csp,*fsp,*fdp;
	int flen;

	if( field == NULL || field[0] == 0 )
		flen = 0;
	else	flen = strlen(field);

	for( csp = head; *csp; csp = nsp ){
		if( flen == 0 )
			while( *csp && *csp != ':' && *csp != ' ' )
				csp++;

		if( flen == 0 || strncasecmp(csp,field,flen) == 0 )
		if( csp[flen] == ':' || csp[flen] == ' ' ){
			if( flen == 0 )
				fsp = head;
			else{
				fsp = csp;
				csp += flen;
			}
			while( *csp == ' ' ) csp++;
			if( *csp == ':' ) csp++;
			while( *csp == ' ' ) csp++;
			if( value )
				*value = csp;
			return fsp;
		}
		if( nsp = strchr(csp,'\n') )
			nsp++;
		else	return 0;
	}
	return 0;
}

rmField(head,field)
	char *head,*field;
{	char *fp,*np;
	int nf;

	nf = 0;
	while( fp = findField(head,field,NULL) ){
		if( np = strchr(fp,'\n') )
			strcpy(fp,np+1);
		else	*fp = 0;
		nf++;
	}
	return nf;
}

char *findFieldValue(head,field)
	char *head,*field;
{	char *value;

	if( findField(head,field,&value) )
		return value;
	else	return NULL;
}

static char *RFC822_valuescan(vp,value,size)
	char *vp,*value;
{	char ch,*bp;
	int cc;

	bp = value;
	for( cc = 1; cc < size && (ch = *vp++); cc++ ){
		if( ch == '\r' )
			continue;

		if( ch == '\n' ){
			if( *vp == ' ' || *vp == '\t' )
				continue;
			break;
		}
		if( ch == '\t' )
			ch = ' ';
		*bp++ = ch;
	}
	*bp = 0;
	return vp;
}

char *getFieldValue2(head,field,value,size)
	char *head,*field,*value;
{	char *vp;

	if( vp = findFieldValue(head,field) ){
		RFC822_valuescan(vp,value,size);
		return value;
	}
	value[0] = 0;
	return NULL;
}

char *RFC822_decompField2(head,fname,value,size)
	char *head,*fname,*value;
{	char *hp,hc,*dp;

	if( fname != NULL ){
		dp = fname;
		for( hp = head; hc = *hp; hp++ ){
			if( hc == ' ' || hc == ':' ){
				hp++;
				break;
			}
			*dp++ = hc;
		}
		*dp = 0;
		RFC822_valuescan(hp,value,size);
	}else
	if( value != NULL )
		getFieldValue(head,"",value,size);
}

char *fgetsHeaderField(hfp,name,value,size)
	FILE *hfp;
	char *name,*value;
{	char line[1024],*vp;
	int len;
	int found;
	int off;

	len = strlen(name);
	found = 0;
	value[0] = 0;

	off = ftell(hfp);
	for(;;){
		if( RFC822_fgetsHeaderField(line,sizeof(line),hfp) == NULL )
			break;
		if( line[0] == '\r' || line[0] == '\n' )
			break;
		if( strncasecmp(line,name,len) == 0 ){
			vp = line + len;
			while( *vp == ' ' )
				vp++;
			if( *vp == ':' ){
				found++;
				vp++;
				RFC822_strip_lwsp(vp,value,size);
			}
		}
	}
	fseek(hfp,off,0);

	if( found )
		return value;
	else	return NULL;
}

static strsubstr(n1,n2)
	char *n1,*n2;
{
	return strstr(n1,n2) == n1 || strstr(n2,n1) == n2;
}
int (*NNTP_nodematch)() = strsubstr;

findXref(afp,matchfunc,host,xref,size)
	FILE *afp;
	int (*matchfunc)();
	char *host,*xref;
{	char line[1024],node[256];
	char *dp,dc,*ep;
	int off,found;

	if( matchfunc == NULL )
		matchfunc = strsubstr;

	xref[0] = 0;
	off = ftell(afp);
	found = 0;

	while( fgets(line,sizeof(line),afp) != NULL ){
		if( line[0] == '\r' || line[0] == '\n' )
			break;
		if( line[0] == '.' )
		if( line[1] == '\r' || line[1] == '\n' )
			break;

		if( isspace(line[0]) )
			continue;

		if( (dp = strchr(line,':')) == 0 )
			continue;
		*dp++ = 0;
		if( strcasecmp(line,"Xref") != 0 )
			continue;

		while( *dp && isspace(*dp) )
			dp++;

		wordscanX(dp,node,sizeof(node));
		if( !(*matchfunc)(host,node) ) 
			continue;

		if( ep = strpbrk(dp,"\r\n") )
			*ep = 0; /* must treat folded line ... */

		strncpy(xref,dp,size-1);
		xref[size-1] = 0;
		found = 1;
		break;
	}
	fseek(afp,off,0);
	return found;
}

selectXref(host,xref1,xref2)
	char *host,*xref1,*xref2;
{	char *sp,*dp,*xp,name[512],host1[512],ch;
	int getit;
	int len;

	len = strlen(host);
	sp = xref1;
	dp = xref2;
	getit = 0;

	while( ch = *sp ){
		if( ch != ' ' && ch != '\t' ){
			getit = 0;
			if( strncasecmp(sp,"Xref",4) == 0 )
			if( xp = strchr(sp,':') ){
				wordscanX(xp+1,host1,sizeof(host1));

				if( strncasecmp(host1,host,len) == 0 )
				if( host1[len] == 0 || host1[len] == '.' )
					getit = 1;
			}
		}
		while( ch = *sp ){
			sp++;
			if( getit )
				*dp++ = ch;
			if( ch == '\n' )
				break;
		}
	}
	*dp = 0;
}

static char *separator(field)
	char *field;
{
	if( strcasecmp(field,"To")==0 || strcasecmp(field,"Cc")==0 )
		return ", ";
	if( strcasecmp(field,"Received") == 0 )
		return "; ";
	return " ";
}

RFC821_skipheader(afp,out,field)
	FILE *afp,*out;
	char *field;
{	char line[1024],*lp,*dp,selected[1024];
	int flen,rcode,nputs;

	rcode = EOF;
	selected[0] = 0;
	nputs = 0;
	if( field != NULL )
		flen = strlen(field);
	else	flen = 0;

	while( fgets(line,sizeof(line),afp) != NULL ){
		if( line[0] == '\r' || line[0] == '\n' ){
			rcode = 0;
			break;
		}
		if( line[0] == '.' )
		if( line[1] == '\r' || line[1] == '\n' )
			break;

		if( out != NULL ){
		    if( field == NULL )
			fputs(line,out);
		    else{
			if( selected[0] == 0 ){
				if( line[flen] != ':' )
					continue;
				if( strncasecmp(line,field,flen) != 0 )
					continue;
				for( lp = line+flen+1; *lp; lp++ )
					if( !isspace(*lp) )
						break;
				if( nputs++ != 0 )
					fputs(separator(field),out);
				if( dp = strpbrk(line,"\r\n\f") )
					*dp = 0;
				fputs(lp,out);
			}else{
				if( isspace(line[0]) ){
					fputs(" ",out);
					fputs(line+1,out);
				}else	selected[0] = 0;
			}
		    }
		}
	}
	return rcode;
}
RFC821_skipbody(afp,out,line,size)
	FILE *afp,*out;
	char *line;
{	char linebuf[1024];
	int rcc;

	if( line == NULL ){
		line = linebuf;
		size = sizeof(linebuf);
	}
	*line = 0;
	rcc = 0;
	for(;;){
		if( fgets(line,size,afp) == NULL ){
			line[0] = 0;
			break;
		}
		if( line[0] == '.' )
		if( line[1] == '\r' || line[1] == '\n' )
			break;

		rcc += strlen(line);
		if( out != NULL )
			fputs(line,out);
	}
	return rcc;
}

char *RFC822_readHeader(in,seeEOR)
	FILE *in;
{	char *lp,buff[0x10000];

	lp = buff;
	for(;;){
		if( fgets(lp,1024,in) == NULL )
			break;
		if( lp[0] == '\r' || lp[0] == '\n' )
			break;

		if( seeEOR )
		if( lp[0] == '.' && (lp[1] == '\r' || lp[1] == '\n') )
			break;

		lp += strlen(lp);
	}
	return strdup(buff);
}

static charset_namelen(name)
	char *name;
{	char *np;
	int nc;

	for( np = name; nc = *np; np++ )
		if( nc != '_' )
		if( nc != '-' && !isalnum(nc) )
			break;
	return np - name;
}

myMIMEversion(ver)
	char *ver;
{
	sprintf(ver,"1.0 (generated by MimeKit/%s)",MimeKit_Version);
}

char *strSeekEOH(head)
	char *head;
{	char *hp,ch;
	int top;

	top = 1;
	for( hp = head; ch = *hp; hp++ ){
		if( top ){
			if( ch == '\r' || ch == '\n' )
				break;
			if( ch == '.' && (hp[1] == '\r' || hp[1] == '\n') )
				break;
		}
		top = (ch == '\n');
	}
	return hp;
}
insert_ctype(head,ctype)
	char *head,*ctype;
{	char *ctp;
	char EOL[4],ver[128],tmp[0x10000];

	tmp[0] = 0;
	if( strstr(head,"\r\n") )
		strcpy(EOL,"\r\n");
	else	strcpy(EOL,"\n");

	ctp = strSeekEOH(head);
	strcpy(tmp,ctp);

	if( findFieldValue(head,"MIME-Version") == NULL ){
		myMIMEversion(ver);
		sprintf(ctp,"MIME-Version: %s%s",ver,EOL);
		ctp += strlen(ctp);
	}
	sprintf(ctp,"Content-Type: %s%s",ctype,EOL);
	strcat(ctp,tmp);
}

get_charset(ctype,chset,size)
	char *ctype,*chset;
{	char *csp;
	int len;

	if( csp = strcasestr(ctype,"charset=") ){
		csp += strlen("charset=");
		if( *csp == '"' )
			csp++;
		len = charset_namelen(csp);
		if( size < len+1 )
			Strncpy(chset,csp,size);
		else	Strncpy(chset,csp,len+1);
		return len;
	}
	return 0;
}

replace_charset(head,charset)
	char *head,*charset;
{	char *ctp;

	if( charset == NULL )
		return 0;

	if( (ctp = findFieldValue(head,"Content-Type")) == NULL ){
		char ctype[1024];
		sprintf(ctype,"text/plain; charset=%s",charset);
		insert_ctype(head,ctype);
		return 0;
	}
	return replace_charset_value(ctp,charset,0);
}

replace_charset_value(ctype,charset,force)
	char *ctype,*charset;
{	char *csp,*cst;
	char tmp[0x10000];

	if( csp = strcasestr(ctype,"charset=") ){
		csp += strlen("charset=");
		if(*csp == '"')
			csp++;
		if( strncasecmp(csp,charset,strlen(charset)) == 0 )
			return 0;
		cst = csp + charset_namelen(csp);
		strcpy(tmp,cst);
		strcpy(csp,charset);
		strcat(csp,tmp);
	}else{
		if( (cst = strpbrk(ctype,";\r\n")) == 0 ){
			if( force )
				cst = ctype + strlen(ctype);
			else	return 0;
		}
		strcpy(tmp,cst);
		sprintf(cst,"; charset=%s",charset);
		strcat(cst,tmp);
	}
	return 1;
}

erase_charset_param(ctype,charset)
	char *ctype,*charset;
{	char *sp,*np,*pat,*cset,csetb[32];

	if( charset )
		cset = charset;
	else	cset = csetb;

	pat = "; charset=";
	if( sp = strcasestr(ctype,pat) ){
		np = valuescanX(sp+strlen(pat),cset,sizeof(csetb));
		strcpy(sp,np);
		return np - sp;
	}
	return 0;
}

replaceFieldValue(head,field,value)
	char *head,*field,*value;
{	char *esp;
	char tmp[0x10000];
	char ch,*np;

	if( (esp = findFieldValue(head,field)) == NULL ){
		np = strSeekEOH(head);
		strcpy(tmp,np);
		sprintf(np,"%s: %s\r\n%s",field,value,tmp);
		return 0;
	}

	if( strncasecmp(esp,value,strlen(value)) == 0 )
		return 0;

	for( np = esp; ch = *np; np++ )
		if( ch == '\r' || ch == '\n' )
			break;
	strcpy(tmp,np);
	strcpy(esp,value);
	strcat(esp,tmp);
	return 1;
}

RFC822_addHeaderField(dst,src)
	char *dst,*src;
{	char *tp;

	if( (tp = strstr(dst,"\r\n\r\n")) && tp[4] == 0  ){
		strcpy(tp+2,src);
		strcat(tp,"\r\n");
	}else{
		Strins(dst,src);
	}
}

replaceContentType(head,type)
	char *head,*type;
{	char *ctp,*cst;
	char tmp[0x10000],*tp;

	ctp = findFieldValue(head,"Content-Type");
	if( ctp == NULL ){
		tp = strdup(head);
		sprintf(head,"Content-Type: %s\r\n%s",type,tp);
		free(tp);
		return 0;
	}
	if( (cst = strpbrk(ctp,";\r\n")) == 0 )
		return -1;
	strcpy(tmp,cst);
	strcpy(ctp,type);
	strcat(ctp,tmp);
	return 1;
}

char *RFC822_fgetsHeaderField(line,size,fp)
	char *line;
	FILE *fp;
{	char *lp;
	int rcc,rem,ch;
	
	if( fgets(line,size,fp) == NULL )
		return NULL;
	lp = line;
	if( *lp == 0 || *lp == '\r' || *lp == '\n' || isEOR(lp) )
		return line;

	rcc = strlen(line);
	lp = line + rcc;
	rem = size - rcc;

	while( 80 < rem ){
		ch = getc(fp);
		if( ch == EOF )
			break;
		if( ch != ' ' && ch != '\t' && ch != '#' ){
			ungetc(ch,fp);
			break;
		}
		*lp++ = ch; *lp = 0; rem--;
		if( fgets(lp,rem,fp) == NULL )
			break;
		rcc = strlen(lp);
		lp += rcc;
		rem -= rcc;
	}
	if( lp == line )
		return NULL;
	else	return line;
}

char *nextField(field,ignEOH)
	char *field;
{	char *np,nc;
	int top;

	top = 0;
	for( np = field; nc = *np; np++ ){
		if( top ){
			if( nc == ' ' || nc == '\t' )
				top = 0;
			else
			if( !ignEOH || (nc != '\n' && nc != '\r') )
				break;
		}else{
			if( nc == '\n' )
				top = 1;
			else	top = 0;
		}
	}
	return np;
}

filterFields(spec,head)
	char *spec,*head;
{	char *sp;
	char field[1024],aval[1024];
	char *hp,*bp,*tp;
	int pass,match;
	int plen,flen;
	char *headbuf,*hbp;

	pass = 0;
	sp = spec;

	for( sp = spec; *sp; sp = nextField(sp,1) ){
		if( strncasecmp(sp,"Pass/",5) == 0 ){
			pass = 1;
			headbuf = strdup(head);
			hbp = headbuf;
			break;
		}
	}
	if( pass )
		plen = 5;
	else	plen = 7;

	for( sp = spec; *sp; sp = nextField(sp,1) ){
		if( pass ){
			if( strncasecmp(sp,"Pass/",5) != 0 )
				continue;
		}else{
			if( strncasecmp(sp,"Remove/",7) != 0 )
				continue;
		}

		field[0] = aval[0] = 0;
		sscanf(sp+plen,"%[^:]:%*[ \t]%[^\r\n]",field,aval);
		flen = strlen(field);

		for( hp = head; *hp; ){
			match = 0;
			if( strncasecmp(hp,field,flen) == 0 )
			if( hp[flen] == ':' )
			if( strstr(&hp[flen+1],aval) )
				match = 1;

			tp = nextField(hp,0);
			if( pass ){
				if( match ){
					for( bp = hp; *bp && bp != tp; bp++ )
						*hbp++ = *bp;
				}
				hp = tp;
			}else{
				if( match )
					strcpy(hp,tp);
				else	hp = tp;
			}

			if( *hp == '\r' || *hp == '\n'
			 || *hp == '.' && (hp[1] == '\r' || hp[1] == '\n') )
				break;
		}
	}
	if( pass ){
		*hbp = 0;
		strcpy(hbp,strSeekEOH(head));
		strcpy(head,headbuf);
		free(headbuf);
	}
}

removeFields(head,field,wild)
	char *head,*field;
{	char *dp,*sp,ch;
	int flen,top,skip;

	flen = strlen(field);
	top = 1;
	skip = 0;
	dp = head;
	for( sp = head; ch = *sp; sp++ ){
		if( top ){
			if( strncmp(sp,field,flen) == 0
			 && (wild || (sp[flen]==':'||sp[flen]==' ')) )
				skip = 1;
			else
			if( ch != ' ' && ch != '\t' )
				skip = 0;
		}
		if( !skip )
			*dp++ = ch;

		if( ch == '\n' )
			top = 1;
		else	top = 0;
	}
	*dp = 0;
}

/*
 *    MATCHFIELDS
 *	Returns the first "field" which match with the "spec":
 *	  [Tail/] field [*] : [ivalue]
 */
char *matchFields(spec,field,ivalue)
	char *spec,*field,*ivalue;
{	char *afield,*avalue,aval[1024];
	int tail = 0;

	afield = findField(spec,field,&avalue);
	if( afield == NULL )
		return "";
	do{
		if( tail = strncmp(afield,"Tail/",5) == 0 )
			afield += 5;

		getFieldValue(afield,field,aval,sizeof(aval));
		if( tail ){
			if( strtailstr(ivalue,aval) != NULL )
				return afield;
		}else{
			if( strstr(ivalue,aval) != NULL )
				return afield;
		}
	} while( afield = findField(afield+1,field,&avalue) );
	return NULL;
}

relayRESPBODY(fs,tc,line,size)
	FILE *fs,*tc;
	char *line;
{
	for(;;){
		line[0] = 0;
		if( fgets(line,size,fs) == NULL )
			break;
		if( isEOR(line) )
			break;
		fputs(line,tc);
	}
}

RFC822_strip_lwsp(src,dst,size)
	char *src,*dst;
{	char *sp,*dp,sc,pc,nc;
	int nonsp;

	nonsp = 0;
	pc = 0;
	dp = dst;
	for( sp = src; sc = *sp; sp++ ){
		if( sc == '\r' || sc == '\n' ){
			nonsp = 0;
		}else
		if( sc == '\t' || sc == ' ' ){
			if( dp == dst )
				continue;
			nc = sp[1];
			if( nc == '\r' || nc == '\n' || nc == '\0' )
				continue;
			if( pc != ' ' )
				*dp++ = pc = ' ';
		}else{
			nonsp++;
			*dp++ = pc = sc;
		}
	}
	*dp = 0;
}

RFC822_strip_comment(in,out)
	char *in,*out;
{	char *sp,*dp,sc;
	int lev;

	lev = 0;
	dp = out;

	for( sp = in; sc = *sp; sp++ ){
		if( sc == '(' )
			lev++;
		else
		if( sc == ')' ){
			lev--;
			if( lev == 0 && (sp[1] == ' ' || sp[1] == '\t') )
				sp++;
		}else
		if( lev == 0 ){
			*dp++ = sc;
		}
	}
	*dp = 0;
}

/*
 * any non-ASCII (7bit x multi-bytes code) strings must be ignored...
 * but such strings are expected to be encoded in MIME...
 */
RFC822_addresspart(in,out)
	char *in,*out;
{	char buff[2048],*sp,*dp,sc;
	char inx[2048];

	MIME_strHeaderEncode(in,inx,sizeof(inx)); /* non-ASCII escaped */
	RFC822_strip_comment(inx,buff);
	dp = out;

	for( sp = buff; sc = *sp; sp++ ){
		if( sc == '<' ){
			dp = out;
			for( sp += 1; sc = *sp; sp++ ){
				if( sc == '>' )
					break;
				*dp++ = sc;
			}
			break;
		}else
		if( isspace(sc) )
			continue;
		else{
			*dp++ = sc; 
		}
	}
EXIT:
	*dp = 0;
}


msg_charcount(fp,chcount)
	FILE *fp;
	int chcount[];
{	int off;
	char line[1024],xline[1024];
	int ccx[64],oc,ci,ch;
	int uu;

	off = ftell(fp);
	CCXcreate("*","E",ccx);
	for( ci = 0; ci < 256; ci++ )
		chcount[ci] = 0;

	/* skip the header if necessary... */

	uu = 0;
	while( fgets(line,sizeof(line),fp) ){
		if( skipuu(&uu,line) )
			continue;

		oc = CCXexec(ccx,line,strlen(line),xline,sizeof(xline));
		for( ci = 0; ci < oc; ci++ ){
			ch = 0xFF & xline[ci];
			if( ch == '!' ){
				/* count only '!' at the end of sentense ... */
				if( ci == 0 ) /* maybe "diff" ountput ... */
					continue;
				if( strchr("!? <\t\r\n",xline[ci+1]) == 0 )
					continue;
			}
			chcount[ch] += 1;
		}
	}
	fseek(fp,off,0);
}
