/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1997 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	pgp.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	970208	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <string.h>
extern FILE *TMPFILE();
extern FILE *NULLFP();
extern int MIME_CONV;

extern char *MimeKit_Version;

int PGP_MODE;
#define _PGP_SIGN	1
#define _PGP_ENCR	2
#define _PGP_VRFY	4
#define _PGP_DECR	8
#define _PGP_MIME	0x10	/* encode in PGP/MIME format */

PGP_SIGN(){ return PGP_MODE & _PGP_SIGN; }
PGP_ENCR(){ return PGP_MODE & _PGP_ENCR; }
PGP_VRFY(){ return PGP_MODE & _PGP_VRFY; }
PGP_DECR(){ return PGP_MODE & _PGP_DECR; }
PGP_MIME(){ return PGP_MODE & _PGP_MIME; }

#define CRLF	"\r\n"

#include <fcntl.h>
#ifdef O_BINARY
#define LEOLINE	"\r\n"  /* may be on Windows */
#else
#define LEOLINE	"\n"
#endif

static pgp1(arg)
	char *arg;
{
	if( strcasecmp(arg,"sign") == 0 ) PGP_MODE |= _PGP_SIGN; else
	if( strcasecmp(arg,"encr") == 0 ) PGP_MODE |= _PGP_ENCR; else
	if( strcasecmp(arg,"decr") == 0 ) PGP_MODE |= _PGP_DECR; else
	if( strcasecmp(arg,"vrfy") == 0 ) PGP_MODE |= _PGP_VRFY; else
	if( strcasecmp(arg,"mime") == 0 ) PGP_MODE |= _PGP_MIME; else
	syslog_ERROR(
		"Unknown parameter \"PGP=%s\". Use {sign,mime,encr,decr,vrfy}*\r\n",
		arg);
	return 0;
}
scan_PGP(_,args)
	char *_;
	char *args;
{
	scan_commaList(args,0,pgp1);
}

static FILE *xpopen(shcom,mode,dstfd)
	char *shcom,*mode;
{	int stdout_fd;
	FILE *pfp;

	stdout_fd = dup(1);
	dup2(dstfd,1);
	pfp = popen(shcom,mode);
	dup2(stdout_fd,1);
	close(stdout_fd);
	return pfp;
}

FILE *TMPFILEX();

PGPverify(src,sign,vrfy)
	FILE *src,*sign,*vrfy;
{	char datafile[1024],signfile[1024];
	FILE *pfp,*ofp,*fp;
	char shcom[1024];
	int io[2],ch,nc,unlink_err;

	fp = TMPFILEX(datafile);
	copyLEOLINE(src,fp);
	fclose(fp);

	fp = TMPFILEX(signfile);
	copyfile1(sign,fp);
	fclose(fp);

	sprintf(shcom,"pgp %s %s",signfile,datafile);
	fprintf(stderr,"\r\n==> %s [%s]\r\n","VRFY",shcom);
	pipe(io);

	pfp = xpopen(shcom,"w",io[1]);
	close(io[1]);
	ofp = fdopen(io[0],"r");

	unlink_err = 0;
	for( nc = 0; ; nc++ ){
		ch = getc(ofp);
		if( nc == 0 ){
			/* visible data files should be removed as fast as
			 * possible (but it's impossible under Windows X-)
			 */
			unlink_err |= unlink(datafile);
			unlink_err |= unlink(signfile);
		}
		if( ch == EOF )
			break;

		putc(ch,stderr);
		putc(ch,vrfy);
	}
	fclose(ofp);
	pclose(pfp);

	if( unlink_err ){
		unlink(datafile);
		unlink(signfile);
	}
}
PGPcodec(com,pass,src,sign,dst)
	char *com,*pass;
	FILE *src,*sign,*dst;
{	char shcom[1024];
	char line[1024];
	FILE *pfp,*tmp;
	char pgppassfd[128];
	int passfd[2];

	sprintf(shcom,"pgp -f");
	if( strcaseeq(com,"ENCR") )
		strcat(shcom," -ca");
	else
	if( strcaseeq(com,"SIGN") ){
		strcat(shcom," -sta");
		if( sign ){
			strcat(shcom," -b");
			dst = sign;
		}
	}

	fprintf(stderr,"\r\n==> %s [%s]\r\n",com,shcom);
	if( pass[0] ){
		pipe(passfd);
		write(passfd[1],pass,strlen(pass));
		write(passfd[1],LEOLINE,strlen(LEOLINE));
		sprintf(pgppassfd,"PGPPASSFD=%d",passfd[0]);
		putenv(pgppassfd);
	}

	if( file_isreg(fileno(dst)) ){
		tmp = NULL;
		pfp = xpopen(shcom,"w",fileno(dst));
	}else{
		tmp = TMPFILE("PGPcodec");
		pfp = xpopen(shcom,"w",tmp);
	}

	if( pass[0] ){
		close(passfd[0]);
		close(passfd[1]);
	}

	while( fgets(line,sizeof(line),src) )
		fputs(line,pfp);

	pclose(pfp);

	if( tmp != NULL ){
		fseek(tmp,0,0);
		copyfile1(tmp,dst);
		fclose(tmp);
	}
	fseek(dst,0,2);
}

/*
 * RFC 2015
 */
isPGPMIME(art)
	FILE *art;
{	char ctype[512];

	fgetsHeaderField(art,"Content-Type",ctype,sizeof(ctype));
	if( strncasecmp(ctype,"multipart/encrypted",19) == 0 )
		return 1;
	if( strncasecmp(ctype,"multipart/signed",16) == 0 )
		return 1;
	return 0;
}
static replaceCtype(src,dst,ctype,EOL,noEOH)
	FILE *src,*dst;
	char *ctype,*EOL;
{	char line[1024];
	int putit,putctype,putmmver,EOH;
	int mmver[128];

	putit = 0;
	putmmver = 0;
	putctype = 0;
	myMIMEversion(mmver);

	while( fgets(line,sizeof(line),src) ){
		if( line[0] != ' ' && line[0] != '\t' ){
			if( strncasecmp(line,"MIME-Version",12) == 0 ){
				fprintf(dst,"MIME-Version: %s%s",mmver,EOL);
				putmmver = 1;
				putit = 0;
			}else
			if( strncasecmp(line,"Content-Type",12) == 0 ){
				if( ctype[0] )
				fprintf(dst,"Content-Type: %s%s",ctype,EOL);
				putctype = 1;
				putit = 0;
			}else	putit = 1;
		}
		if( EOH = line[0] == '\r' || line[0] == '\n' ){
			if( !putmmver )
				fprintf(dst,"MIME-Version: %s%s",mmver,EOL);
			if( !putctype && ctype[0] )
				fprintf(dst,"Content-Type: %s%s",ctype,EOL);
			if( noEOH )
				break;
		}
		if( putit )
			fputs(line,dst);
		if( EOH )
			break;
	}
}

static putPGPMIME(src,dst,pcom,EOL)
	FILE *src,*dst;
	char *pcom,*EOL;
{	char ctype[512],nctype[1024];
	int off;
	char *crtyp,*proto;
	char boundary[128];
	FILE *body1,*body2;

	off = ftell(src);
	fseek(src,0,2);
	sprintf(boundary,"PGP-MIME-MimeKit%s-%x-%x-%x",
		MimeKit_Version,time(0),ftell(src),getpid());
	fseek(src,off,0);

	if( PGP_ENCR() ){
		crtyp = "multipart/encrypted";
		proto = "application/pgp-encrypted";
	}else{
		crtyp = "multipart/signed";
		proto = "application/pgp-signature";
	}

	fgetsHeaderField(src,"Content-Type",ctype,sizeof(ctype));

	sprintf(nctype,"%s; boundary=\"%s\";%s  micalg=%s; protocol=\"%s\"",
			crtyp, boundary, EOL, "pgp-md5", proto);

	replaceCtype(src,dst,nctype,EOL,0);

	body1 = TMPFILE("PGPMIME");

	/* it is safer to send Local End Of Line code to pgp ... */
	if( ctype[0] )
		fprintf(body1,"Content-Type: %s%s",ctype,LEOLINE);
	fprintf(body1,"%s",LEOLINE);
	copyLEOLINE(src,body1);
	fflush(body1);
	fseek(body1,0,0);
	body2 = TMPFILE("PGPMIME");

	if( PGP_ENCR() ){
		PGPcodec(pcom,"",body1,NULL,body2);
		fseek(body2,0,0);
		putENCRIPTED(body2,dst,boundary,EOL);
	}else{
		PGPcodec(pcom,"",body1,body2,NULL);
		fseek(body1,0,0);
		fseek(body2,0,0);
		putSIGNED(body1,body2,dst,boundary,EOL);
	}

	fclose(body2);
	fclose(body1);
}

#define BGN_PGP		"-----BEGIN PGP "
#define BGN_MSG		"-----BEGIN PGP MESSAGE-----"
#define END_MSG		"-----END PGP MESSAGE-----"
#define BGN_SIGNED	"-----BEGIN PGP SIGNED MESSAGE-----"
#define BGN_SIGN	"-----BEGIN PGP SIGNATURE-----"
#define END_SIGN	"-----END PGP SIGNATURE-----"

static putENCRIPTED(src,dst,boundary,EOL)
	FILE *src,*dst;
	char *boundary,*EOL;
{
	fprintf(dst,"--%s%s",boundary,EOL);
	fprintf(dst,"Content-Type: application/pgp-encrypted%s",EOL);
	fprintf(dst,"%s",EOL);
	fprintf(dst,"Version: 1%s",EOL);
	fprintf(dst,"%s",EOL);
	fprintf(dst,"--%s%s",boundary,EOL);
	fprintf(dst,"Content-Type: application/octet-stream%s",EOL);
	fprintf(dst,"%s",EOL);
	copyfile1(src,dst);
	fprintf(dst,"%s",EOL);
	fprintf(dst,"--%s--%s",boundary,EOL);
}

static putSIGNED(src,sign,dst,boundary,EOL)
	FILE *src,*sign,*dst;
	char *boundary,*EOL;
{
	fprintf(dst,"--%s%s",boundary,EOL);
	copyfile1(src,dst);
	fprintf(dst,"%s",EOL);

	fprintf(dst,"--%s%s",boundary,EOL);
	fprintf(dst,"Content-Type: application/pgp-signature%s",EOL);
	fprintf(dst,"%s",EOL);
	copyfile1(sign,dst);
	fprintf(dst,"%s",EOL);

	fprintf(dst,"--%s--%s",boundary,EOL);
}

static FILE *getEOR(msg,eor,size)
	FILE *msg;
	char *eor;
{	FILE *nmsg;

	nmsg = TMPFILE("PGPMIME");
	eor[0] = 0;
	RFC821_skipbody(msg,nmsg,eor,size);
	fclose(msg);
	fflush(nmsg);
	fseek(nmsg,0,0);
	return nmsg;
}
getEOLINE(msg,eol)
	FILE *msg;
	char *eol;
{	int off,ch;

	off = ftell(msg);
	strcpy(eol,CRLF);
	while( (ch = getc(msg)) != EOF ){
		if( ch == '\r' ){
			ch = getc(msg);
			if( ch == '\n' || ch == EOF )
				break;
			ungetc(ch,msg);
		}else
		if( ch == '\n' ){
			strcpy(eol,"\n");
			break;
		}
	}
	fseek(msg,off,0);
}
copyLEOLINE(src,dst)
	FILE *src,*dst;
{	char line[1024];
	char *np;

	while( fgets(line,sizeof(line),src) ){
		if( np = strpbrk(line,CRLF) )
			strcpy(np,LEOLINE);
		fputs(line,dst);
	}
}
toJISjaca(src,dst,EOL)
	FILE *src,*dst;
	char *EOL;
{	char line[1024],*np;

	RFC821_skipheader(src,dst,NULL);
	fprintf(dst,EOL);

	while( fgets(line,sizeof(line),src) ){
		TO_JIS(line,line,"text/plain");
		fputs(line,dst);
	}
}

/*
 *  RFC 1991
 */
isPGPFORMAT(art)
	FILE *art;
{	char line[1024];
	int ispgp;
	int aoff;
	char *pstr;
	int plen;

	ispgp = 0;
	aoff = ftell(art);
	pstr = BGN_PGP;
	plen = strlen(pstr);

	while( fgets(line,sizeof(line),art) ){
		if( strncmp(line,pstr,plen) == 0 ){
			ispgp = 1;
			break;
		}
	}
	fseek(art,aoff,0);
	return ispgp;
}

static isTEXT(art)
	FILE *art;
{	char ctype[1024];

	fgetsHeaderField(art,"Content-Type",ctype,sizeof(ctype));
	if( ctype[0] == 0 || strncasecmp(ctype,"text/",5) == 0 )
		return 1;
	else	return 0;
}

PGPencodeMIME(src,dst)
	FILE *src,*dst;
{	FILE *tmp1,*tmp2;
	char *pcom;
	char EOL[4],EOR[128];

	if( PGP_ENCR() == 0 && PGP_SIGN() == 0 )
		return encodeMIME(src,dst);

	tmp1 = TMPFILE("PGPMIME");
	encodeMIME(src,tmp1);
	fflush(tmp1);
	fseek(tmp1,0,0);

	if( !isTEXT(tmp1) ){
		copyfile1(tmp1,dst);
		fclose(tmp1);
		return ;
	}

	tmp1 = getEOR(tmp1,EOR,sizeof(EOR));
	getEOLINE(tmp1,EOL);

	if( PGP_SIGN() )
		pcom = "SIGN";
	else	pcom = "ENCR";

	if( PGP_MIME() ){
		putPGPMIME(tmp1,dst,pcom,EOL);
	}else{
		RFC821_skipheader(tmp1,dst,NULL);
		fprintf(dst,EOL);
		fflush(dst);

		tmp2 = TMPFILE("PGPMIME");
		copyLEOLINE(tmp1,tmp2);
		fflush(tmp2);
		fseek(tmp2,0,0);
		PGPcodec(pcom,"",tmp2,NULL,dst);
		fclose(tmp2);
	}

	fputs(EOR,dst);
	fflush(dst);
	fclose(tmp1);
}

relay_pgpSIGNED(fs,tc,boundaries,endline)
	FILE *fs,*tc;
	char *boundaries[];
	char *endline;
{	int rcode;

	rcode = relayBODYpart(fs,tc,boundaries,1,endline);
	return rcode;
}
static FILE *SIGN;
relay_pgpSIGN(fs,tc,boundaries,endline)
	FILE *fs,*tc;
	char *boundaries[];
	char *endline;
{	int rcode;
	FILE *sign;

	if( SIGN )
		sign = SIGN;
	else	sign = tc;
	rcode = relayBODYpart(fs,sign,boundaries,1,endline);
	fseek(sign,0,0);
	return rcode;
}

static copyVerify(vrfy,out,outs)
	FILE *vrfy,*out;
	char *outs;
{	char line[1024];
	int verified;

	*outs = 0;
	verified = -1;
	while( fgets(line,sizeof(line),vrfy) ){
		if( strncmp(line,"Good signature",14) == 0 ){
			strcat(outs," ");
			strcat(outs,line);
			verified = 1;
		}else
		if( strncmp(line,"Bad signature",13) == 0 ){
			strcat(outs," ");
			strcat(outs,line);
		}else
		if( strncmp(line,"Signature made",14) == 0 ){
			strcat(outs," ");
			strcat(outs,line);
		}
		fputs(line,out);
	}
	return verified;
}
static putVerify(out,vrfys,EOL)
	FILE *out;
	char *EOL;
{
	fprintf(out,"X-PGP-Verified: by MimeKit/%s;%s%s",
		MimeKit_Version,EOL,vrfys);
}

FILE *PGPMIMEverify(art,verified,EOL)
	FILE *art;
	int *verified;
	char *EOL;
{	char ctype[512];
	FILE *jaca,*tmp,*out;
	int oconv;
	FILE *vrfy;
	char vrfys[1024];

	*verified = 0;

	fgetsHeaderField(art,"Content-Type",ctype,sizeof(ctype));
	if( strncasecmp(ctype,"multipart/encrypted",19) == 0 )
		return art;

	jaca = TMPFILE("PGPMIME");
	toJISjaca(art,jaca,EOL);
	fflush(jaca);
	fseek(jaca,0,0);
	fclose(art);
	art = jaca;

	SIGN = TMPFILE("PGPMIMESIGN");

	tmp = TMPFILE("MIMEtoPGP");
	oconv = MIME_CONV;
	MIME_CONV = 0;
	decodeMIME(art,tmp,NULL,0xFF,1,0); /* data to tmp, signature to SIGN */
	MIME_CONV = oconv;
	fflush(tmp);
	fseek(tmp,0,0);

	vrfy = TMPFILE("MIMEtoPGP");
	RFC821_skipheader(tmp,NULL,NULL);
	PGPverify(tmp,SIGN,vrfy);
	fseek(vrfy,0,0);
	fseek(tmp,0,0);
	fclose(SIGN);

	fprintf(stderr,"\r\n==> VERIFICATION\n");
	*verified = copyVerify(vrfy,stderr,vrfys);
	fseek(vrfy,0,0);

	out = TMPFILE("MIMEtoPGP");

	if( PGP_DECR() ){
		RFC821_skipheader(tmp,NULL,NULL);
		fgetsHeaderField(tmp,"Content-Type",ctype,sizeof(ctype));
		fseek(tmp,0,0);

		replaceCtype(tmp,out,ctype,EOL,1);
		if( PGP_VRFY() )
			putVerify(out,vrfys,EOL);
		fprintf(out,"%s",EOL);

		RFC821_skipheader(tmp,NULL,NULL); /* skip inserted header */
		copyfile1(tmp,out);
	}else{
		fseek(art,0,0);
		RFC821_skipheader(art,out,NULL);
		putVerify(out,vrfys,EOL);
		fprintf(out,"%s",EOL);
		copyfile1(art,out);
	}
	fflush(out);
	fseek(out,0,0);

	fclose(art);
	fclose(vrfy);
	fclose(tmp);
	return out;
}

FILE *PGPdecode(art,was_mime,EOL)
	FILE *art;
	char *EOL;
{	FILE *jaca,*tmp1,*tmp2;
	char ctype[512];
	int is_mime;

	tmp1 = TMPFILE("PGPMIME");
	tmp2 = TMPFILE("PGPMIME");

	is_mime = isPGPMIME(art);

	PGPcodec("DECR","",art,NULL,tmp2);
	fflush(tmp2);
	fseek(tmp2,0,0);
	fseek(art,0,0);

	if( is_mime )
		fgetsHeaderField(tmp2,"Content-Type",ctype,sizeof(ctype));

	if( is_mime || was_mime ){
		/* Skip Content-Type of Body Part */
		RFC821_skipheader(tmp2,NULL,NULL);
	}
	if( is_mime )
		replaceCtype(art,tmp1,ctype,EOL,0);
	else{
		RFC821_skipheader(art,tmp1,NULL);
		fprintf(tmp1,EOL);
	}
	copyfile1(tmp2,tmp1);

	fflush(tmp1);
	fseek(tmp1,0,0);

	fclose(tmp2);
	return tmp1;
}

PGPdecodeMIME(src,dst,cache,filter,codeconv,enHTML)
	FILE *src,*dst,*cache;
{	FILE *tmp;
	int is_mime;
	int omode;
	int verified;
	char EOL[4],EOR[1024];

	if( !PGP_DECR() && !PGP_VRFY() )
		return decodeMIME(src,dst,cache,filter,codeconv,enHTML);

	tmp = TMPFILE("PGPMIME");
	RFC821_skipbody(src,tmp,EOR,sizeof(EOR));
	fseek(tmp,0,0);
	if( cache != NULL ){
		copyfile1(tmp,cache);
		fseek(tmp,0,0);
	}

	is_mime = isPGPMIME(tmp);
	getEOLINE(tmp,EOL);

	if( !is_mime && !isPGPFORMAT(tmp) ){
		copyfile1(tmp,dst);
		fclose(tmp);
		return;
	}

	/* verify SIGNATURE in PGP/MIME */
	verified = 0;
	if( is_mime )
		tmp = PGPMIMEverify(tmp,&verified,EOL);

	/* decrypt PGP */
	if( verified == 0 && PGP_DECR() )
		tmp = PGPdecode(tmp,is_mime,EOL);

	/* convert CHARCODE */

	omode = PGP_MODE;
	PGP_MODE = 0;
	decodeMIME(tmp,dst,NULL,filter,codeconv,enHTML);
	PGP_MODE = omode;

	fputs(EOR,dst);
	fflush(dst);
	fclose(tmp);
}
